/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.TwistSpaceTechnology;
import com.Nxer.TwistSpaceTechnology.common.GTCMItemList;
import com.Nxer.TwistSpaceTechnology.common.machine.MiscHelper;
import com.Nxer.TwistSpaceTechnology.common.machine.ValueEnum;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.WirelessEnergyMultiMachineBase;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.processingLogics.TstProcessingLogic;
import com.Nxer.TwistSpaceTechnology.common.misc.MachineShutDownReasons.SimpleShutDownReasons;
import com.Nxer.TwistSpaceTechnology.common.recipeMap.GTCMRecipe;
import com.Nxer.TwistSpaceTechnology.recipe.machineRecipe.expanded.StellarForgeRecipePool;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.api.util.ParallelHelper;
import gregtech.common.items.ItemIntegratedCircuit;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import tectech.thing.block.BlockQuantumGlass;
import tectech.thing.casing.TTCasingsContainer;

public class TST_MiracleDoor
extends WirelessEnergyMultiMachineBase<TST_MiracleDoor> {
    private int overclockParameter = 1;
    protected boolean ingotMode = false;
    private static ItemStack IngotMold;
    protected static final String STRUCTURE_PIECE_MAIN = "mainMiracleDoor";
    protected static final String STRUCTURE_PIECE_MAIN_ERR = "mainMiracleDoorErr";
    protected final int horizontalOffSet = 20;
    protected final int verticalOffSet = 52;
    protected final int depthOffSet = 8;
    protected static IStructureDefinition<TST_MiracleDoor> STRUCTURE_DEFINITION;
    protected static final String[][] shapeMain;
    protected static final String[][] shapeMainErr;

    public TST_MiracleDoor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_MiracleDoor(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_MiracleDoor(this.mName);
    }

    public static void initStatics() {
        IngotMold = GTCMItemList.WhiteDwarfMold_Ingot.get(1, new Object[0]);
    }

    @Override
    public int totalMachineMode() {
        return 2;
    }

    @Override
    public void setMachineModeIcons() {
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_LPF_FLUID);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_SINGULARITY);
    }

    @Override
    public String getMachineModeName(int mode) {
        return StatCollector.func_74838_a((String)("MiracleDoor.modeMsg." + mode));
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74767_n("isActive")) {
            currentTip.add(TstUtils.tr("tst.miracleDoor.waila.currentOverclockParameter", tag.func_74763_f("overclockParameter")));
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        IGregTechTileEntity tileEntity = this.getBaseMetaTileEntity();
        if (tileEntity != null) {
            tag.func_74768_a("overclockParameter", this.overclockParameter);
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("mode", (byte)this.machineMode);
        aNBT.func_74768_a("overclockParameter", this.overclockParameter);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.machineMode = aNBT.func_74771_c("mode");
        this.overclockParameter = aNBT.func_74762_e("overclockParameter");
    }

    public RecipeMap<?> getRecipeMap() {
        if (this.machineMode == 1) {
            return GTCMRecipe.StellarForgeRecipes;
        }
        return GTCMRecipe.StellarForgeAlloySmelterRecipes;
    }

    @NotNull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(GTCMRecipe.StellarForgeRecipes, GTCMRecipe.StellarForgeAlloySmelterRecipes);
    }

    @Override
    public boolean getDefaultWirelessMode() {
        return true;
    }

    @Override
    protected void prepareProcessing() {
        super.prepareProcessing();
        this.flushOverclockParameter();
        this.checkIngotMode();
    }

    protected void checkIngotMode() {
        this.ingotMode = false;
        for (ItemStack aStack : this.getStoredInputs()) {
            if (!aStack.func_77969_a(IngotMold)) continue;
            this.ingotMode = true;
            break;
        }
    }

    @Override
    public int getExtraEUCostMultiplier() {
        return this.overclockParameter * (this.machineMode == 1 ? ValueEnum.multiplierOfMiracleDoorEUCostEBFMode : ValueEnum.multiplierOfMiracleDoorEUCostABSMode);
    }

    @Override
    public int getWirelessModeProcessingTime() {
        return Math.max(1, (this.machineMode == 1 ? ValueEnum.ticksOfMiracleDoorProcessingTimeEBFMode : ValueEnum.ticksOfMiracleDoorProcessingTimeABSMode) / this.overclockParameter);
    }

    @Override
    @Nonnull
    public CheckRecipeResult checkProcessing() {
        CheckRecipeResult r = super.checkProcessing();
        if (!r.wasSuccessful()) {
            return r;
        }
        if (!this.isRecipeProcessing) {
            this.startRecipeProcessing();
        }
        if (!this.consumePhoton(this.overclockParameter)) {
            this.stopMachine(SimpleShutDownReasons.NoCriticalPhotonInput);
            return CheckRecipeResultRegistry.NO_FUEL_FOUND;
        }
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    private boolean consumePhoton(int amount) {
        int needAmount = amount;
        for (ItemStack items : this.getStoredInputsWithoutDualInputHatch()) {
            if (items == null || !GTUtility.areStacksEqual((ItemStack)items, (ItemStack)MiscHelper.CRITICAL_PHOTON)) continue;
            if (items.field_77994_a >= needAmount) {
                items.field_77994_a -= needAmount;
                return true;
            }
            needAmount -= items.field_77994_a;
            items.field_77994_a = 0;
        }
        return false;
    }

    private void flushOverclockParameter() {
        ItemStack items = this.getControllerSlot();
        this.overclockParameter = items != null && items.func_77973_b() instanceof ItemIntegratedCircuit && items.func_77960_j() > 0 && items.field_77994_a > 0 ? items.func_77960_j() * items.field_77994_a : 1;
    }

    protected static GTRecipe turnToIngotRecipe(GTRecipe recipe) {
        GTRecipe r = recipe.copy();
        ArrayList<FluidStack> outputFluidList = new ArrayList<FluidStack>();
        ArrayList<ItemStack> outputItemList = new ArrayList<ItemStack>(Arrays.asList(r.mOutputs));
        for (FluidStack fluidStack : r.mFluidOutputs) {
            Fluid f = fluidStack.getFluid();
            ItemStack ingot = StellarForgeRecipePool.MoltenToIngot.get(f);
            if (ingot == null || fluidStack.amount < 144) {
                outputFluidList.add(fluidStack);
                continue;
            }
            int ingotAmount = fluidStack.amount / 144;
            outputItemList.add(GTUtility.copyAmountUnsafe((int)ingotAmount, (ItemStack)ingot));
            int remainingFluidAmount = fluidStack.amount - 144 * ingotAmount;
            if (remainingFluidAmount <= 0) continue;
            TwistSpaceTechnology.LOG.info("Miracle Door : Terrible molten fluid amount in recipe output being " + f.getName());
            outputFluidList.add(new FluidStack(f, remainingFluidAmount));
        }
        r.mOutputs = outputItemList.toArray(new ItemStack[0]);
        r.mFluidOutputs = outputFluidList.toArray(new FluidStack[0]);
        return r;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new TstProcessingLogic(){

            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@Nonnull GTRecipe recipe) {
                return OverclockCalculator.ofNoOverclock((GTRecipe)recipe);
            }

            @Override
            @NotNull
            protected ParallelHelper createParallelHelper(@Nonnull GTRecipe recipe) {
                return super.createParallelHelper(TST_MiracleDoor.this.ingotMode ? TST_MiracleDoor.turnToIngotRecipe(recipe) : recipe);
            }
        }.setMaxParallel(Integer.MAX_VALUE);
    }

    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(Long.MAX_VALUE);
        logic.setAvailableAmperage(1L);
        logic.setAmperageOC(false);
    }

    public boolean onRunningTick(ItemStack aStack) {
        return true;
    }

    @Override
    public int getMaxParallelRecipes() {
        return Integer.MAX_VALUE;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.repairMachine();
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 20, 52, 8) || this.checkPiece(STRUCTURE_PIECE_MAIN_ERR, 20, 52, 8);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.repairMachine();
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 20, 52, 8);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 5);
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 20, 52, 8, realBudget, env, false, true);
    }

    public IStructureDefinition<TST_MiracleDoor> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])shapeMain)).addShape(STRUCTURE_PIECE_MAIN_ERR, StructureUtility.transpose((String[][])shapeMainErr)).addElement('A', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)13)).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSE, (int)1)).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSE, (int)2)).addElement('D', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)4)).addElement('E', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)6)).addElement('F', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)9)).addElement('G', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)10)).addElement('H', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)12)).addElement('I', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)14)).addElement('J', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsDyson, (int)9)).addElement('K', StructureUtility.ofBlock((Block)BlockQuantumGlass.INSTANCE, (int)0)).addElement('L', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.OutputBus, HatchElement.InputHatch, HatchElement.OutputHatch}).adder(GTCM_MultiMachineBase::addToMachineList).dot(1).casingIndex(1036).buildAndChain(TTCasingsContainer.sBlockCasingsTT, 12)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextLocalization.Tooltip_MiracleDoor_MachineType).addInfo(TextLocalization.Tooltip_MiracleDoor_Controller).addInfo(TextLocalization.Tooltip_MiracleDoor_00).addInfo(TextLocalization.Tooltip_MiracleDoor_01).addInfo(TextLocalization.Tooltip_MiracleDoor_02).addInfo(TextLocalization.Tooltip_MiracleDoor_03).addInfo(TextLocalization.Tooltip_MiracleDoor_04).addInfo(TextLocalization.Tooltip_MiracleDoor_05).addInfo(TextLocalization.Tooltip_MiracleDoor_06).addInfo(TextLocalization.Tooltip_MiracleDoor_07).addInfo(TextLocalization.Tooltip_MiracleDoor_08).addSeparator().addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).addStructureInfo(TextLocalization.Tooltip_Details).addStructureInfo(TextLocalization.Tooltip_MiracleDoor_2_01).addStructureInfo(TextLocalization.Tooltip_MiracleDoor_2_02).addStructureInfo(TextLocalization.Tooltip_MiracleDoor_2_03).addStructureInfo(TextLocalization.Tooltip_MiracleDoor_2_04).addStructureInfo(TextLocalization.Tooltip_MiracleDoor_2_05).addStructureInfo(TextLocalization.Text_SeparatingLine).addStructureInfo(TextLocalization.Tooltip_DoNotNeedMaintenance).addStructureInfo(TextLocalization.Tooltip_DoNotNeedEnergyHatch).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][12], TextureFactory.builder().addIcon((IIconContainer)TexturesGtBlock.Overlay_Machine_Controller_Advanced).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][12], TextureFactory.builder().addIcon((IIconContainer)TexturesGtBlock.Overlay_Machine_Controller_Advanced).extFacing().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][12]};
    }

    /*
     * Opcode count of 19952 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        STRUCTURE_DEFINITION = null;
        shapeMain = new String[][]{{"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "               A         A               ", "             AA           AA             ", "            AAA           AAA            ", "           AAA             AAA           ", "          AAA               AAA          ", "          AA                 AA          ", "         A                     A         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "         A                     A         ", "          AA                 AA          ", "          AAA               AAA          ", "           AAA             AAA           ", "            AAA           AAA            ", "             AA           AA             ", "               A         A               ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                A       A                ", "              AA         AA              ", "            AAA           AAA            ", "           AA               AA           ", "          AA                 AA          ", "         AA                   AA         ", "         A                     A         ", "        AA                     AA        ", "        A                       A        ", "       A                         A       ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "       A                         A       ", "        A                       A        ", "        AA                     AA        ", "         A                     A         ", "         AA                   AA         ", "          AA                 AA          ", "           AA               AA           ", "            AAA           AAA            ", "              AA         AA              ", "                A       A                ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "               AA       AA               ", "             AAA         AAA             ", "           AAA             AAA           ", "          AA                 AA          ", "         AA                   AA         ", "        AA                     AA        ", "        A                       A        ", "       AA                       AA       ", "       A                         A       ", "      AA                         AA      ", "      A                           A      ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "      A                           A      ", "      AA                         AA      ", "       A                         A       ", "       AA                       AA       ", "        A                       A        ", "        AA                     AA        ", "         AA                   AA         ", "          AA                 AA          ", "           AAA             AAA           ", "             AAA         AAA             ", "               AA       AA               ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "              AAAA     AAAA              ", "            AAA           AAA            ", "           AA               AA           ", "          H                   H          ", "         H                     H         ", "        H                       H        ", "       A                         A       ", "      AA                         AA      ", "      A                           A      ", "     AA                           AA     ", "     A                             A     ", "     A                             A     ", "     A                             A     ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "     A                             A     ", "     A                             A     ", "     A                             A     ", "     AA                           AA     ", "      A                           A      ", "      AA                         AA      ", "       A                         A       ", "        H                       H        ", "         H                     H         ", "          H                   H          ", "           AA               AA           ", "            AAA           AAA            ", "              AAAA     AAAA              ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "              AAAA     AAAA              ", "            AA             AA            ", "          HH                 HH          ", "         HH                   HH         ", "        HH                     HH        ", "       HH                       HH       ", "      HH                         HH      ", "      H                           H      ", "     A                             A     ", "     A                             A     ", "    A                               A    ", "    A                               A    ", "    A                               A    ", "    A                               A    ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "    A                               A    ", "    A                               A    ", "    A                               A    ", "    A                               A    ", "     A                             A     ", "     A                             A     ", "      H                           H      ", "      HH                         HH      ", "       HH                       HH       ", "        HH                     HH        ", "         HH                   HH         ", "          HH                 HH          ", "            AA             AA            ", "              AAAA     AAAA              ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "              AAAA     AAAA              ", "            AA             AA            ", "          HH                 HH          ", "         H                     H         ", "        H                       H        ", "       H                         H       ", "      H                           H      ", "     H                             H     ", "     H                             H     ", "    A                               A    ", "    A                               A    ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "    A                               A    ", "    A                               A    ", "     H                             H     ", "     H                             H     ", "      H                           H      ", "       H                         H       ", "        H                       H        ", "         H                     H         ", "          HH                 HH          ", "            AA             AA            ", "              AAAA     AAAA              ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "               AA       AA               ", "            AAA           AAA            ", "          HH                 HH          ", "         H                     H         ", "        H                       H        ", "       IK                       KI       ", "      HK                         KH      ", "     H                             H     ", "    H                               H    ", "    H                               H    ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "  A                                   A  ", "  A                                   A  ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "  A                                   A  ", "  A                                   A  ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "    H                               H    ", "    H                               H    ", "     H                             H     ", "      HK                         KH      ", "       IK                       KI       ", "        H                       H        ", "         H                     H         ", "          HH                 HH          ", "            AAA           AAA            ", "               AA       AA               ", "                                         ", "                                         "}, {"                                         ", "                A       A                ", "             AAA         AAA             ", "           AA               AA           ", "         HH                   HH         ", "        H                       H        ", "       IK                       KI       ", "      IFK                       KFI      ", "     HKKK                       KKKH     ", "    H                               H    ", "    H                               H    ", "   A                                 A   ", "   A                                 A   ", "  A                                   A  ", "  A                                   A  ", "  A                                   A  ", " A                                     A ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", " A                                     A ", "  A                                   A  ", "  A                                   A  ", "  A                                   A  ", "   A                                 A   ", "   A                                 A   ", "    H                               H    ", "    H                               H    ", "     HKKK                       KKKH     ", "      IFK                       KFI      ", "       IK                       KI       ", "        H                       H        ", "         HH                   HH         ", "           AA               AA           ", "             AAA         AAA             ", "                A       A                ", "                                         "}, {"                                         ", "              AA         AA              ", "           AAA             AAA           ", "          H                   H          ", "        HH                     HH        ", "       H                         H       ", "      HK                         KH      ", "     HKKK                       KKKH     ", "    H  KFK                     KFK  H    ", "    H   KK                     KK   H    ", "   H                                 H   ", "  A                                   A  ", "  A                                   A  ", "  A                                   A  ", " A                                     A ", " A                                     A ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", " A                                     A ", " A                                     A ", "  A                                   A  ", "  A                                   A  ", "  A                                   A  ", "   H                                 H   ", "    H   KK                     KK   H    ", "    H  KFK                     KFK  H    ", "     HKKK                       KKKH     ", "      HK                         KH      ", "       H                         H       ", "        HH                     HH        ", "          H                   H          ", "           AAA             AAA           ", "              AA         AA              ", "                                         "}, {"               A         A               ", "            AAA           AAA            ", "          AA                 AA          ", "         H                     H         ", "       HH                       HH       ", "      H                           H      ", "     H                             H     ", "    H                               H    ", "    H   KK                     KK   H    ", "   H    KFK                   KFK    H   ", "  A      KK                   KK      A  ", "  A                                   A  ", " A                                     A ", " A                                     A ", " A                                     A ", "A                                       A", "                                         ", "                   KKK                   ", "                  KKKKK                  ", "                 KKKKKKK                 ", "                 KKKKKKK                 ", "                 KKKKKKK                 ", "                  KKKKK                  ", "                   KKK                   ", "                                         ", "A                                       A", " A                                     A ", " A                                     A ", " A                                     A ", "  A                                   A  ", "  A      KK                   KK      A  ", "   H    KFK                   KFK    H   ", "    H   KK                     KK   H    ", "    H                               H    ", "     H                             H     ", "      H                           H      ", "       HH                       HH       ", "         H                     H         ", "          AA                 AA          ", "            AAA           AAA            ", "               A         A               "}, {"             AA           AA             ", "           AA               AA           ", "         AA                   AA         ", "        H                       H        ", "      HH                         HH      ", "     H                             H     ", "    H                               H    ", "    H                               H    ", "   H                                 H   ", "  A      KK                   KK      A  ", "  A      KFK                 KFK      A  ", " A        K                   K        A ", " A                                     A ", "A                                       A", "A                                       A", "                  KKKKK                  ", "                KKKKKKKKK                ", "                KKK   KKK                ", "               KKK     KKK               ", "               KK       KK               ", "               KK       KK               ", "               KK       KK               ", "               KKK     KKK               ", "                KKK   KKK                ", "                KKKKKKKKK                ", "                  KKKKK                  ", "A                                       A", "A                                       A", " A                                     A ", " A        K                   K        A ", "  A      KFK                 KFK      A  ", "  A      KK                   KK      A  ", "   H                                 H   ", "    H                               H    ", "    H                               H    ", "     H                             H     ", "      HH                         HH      ", "        H                       H        ", "         AA                   AA         ", "           AA               AA           ", "             AA           AA             "}, {"            AAA           AAA            ", "          AA                 AA          ", "        AA                     AA        ", "       A                         A       ", "      H                           H      ", "     H                             H     ", "    H                               H    ", "   A                                 A   ", "  A                                   A  ", "  A                                   A  ", " A        K                   K        A ", " A         K                 K         A ", "A                                       A", "A                  KKK                  A", "A                KKKKKKK                A", "               KKK     KKK               ", "               K         K               ", "              KK         KK              ", "              K           K              ", "             KK           KK             ", "             KK           KK             ", "             KK           KK             ", "              K           K              ", "              KK         KK              ", "               K         K               ", "               KKK     KKK               ", "A                KKKKKKK                A", "A                  KKK                  A", "A                                       A", " A         K                 K         A ", " A        K                   K        A ", "  A                                   A  ", "  A                                   A  ", "   A                                 A   ", "    H                               H    ", "     H                             H     ", "      H                           H      ", "       A                         A       ", "        AA                     AA        ", "          AA                 AA          ", "            AAA           AAA            "}, {"           AAA             AAA           ", "         AA                   AA         ", "        A                       A        ", "      AA                         AA      ", "     A                             A     ", "    A                               A    ", "   A                                 A   ", "   A                                 A   ", "  A                                   A  ", " A                                     A ", " A                                     A ", "A                                       A", "A                 KKKKK                 A", "A               KKK   KKK               A", "               KK       KK               ", "              K           K              ", "             KK           KK             ", "             K             K             ", "            KK             KK            ", "            K               K            ", "            K               K            ", "            K               K            ", "            KK             KK            ", "             K             K             ", "             KK           KK             ", "              K           K              ", "               KK       KK               ", "A               KKK   KKK               A", "A                 KKKKK                 A", "A                                       A", " A                                     A ", " A                                     A ", "  A                                   A  ", "   A                                 A   ", "   A                                 A   ", "    A                               A    ", "     A                             A     ", "      AA                         AA      ", "        A                       A        ", "         AA                   AA         ", "           AAA             AAA           "}, {"          AAA               AAA          ", "         A                     A         ", "       AA                       AA       ", "      A                           A      ", "     A                             A     ", "    A                               A    ", "   A                                 A   ", "  A                                   A  ", "  A                                   A  ", " A                                     A ", "A                                       A", "A                  KKK                  A", "A               KKK   KKK               A", "               K         K               ", "              K           K              ", "             K             K             ", "            K               K            ", "            K               K            ", "            K               K            ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "            K               K            ", "            K               K            ", "            K               K            ", "             K             K             ", "              K           K              ", "               K         K               ", "A               KKK   KKK               A", "A                  KKK                  A", "A                                       A", " A                                     A ", "  A                                   A  ", "  A                                   A  ", "   A                                 A   ", "    A                               A    ", "     A                             A     ", "      A                           A      ", "       AA                       AA       ", "         A                     A         ", "          AAA               AAA          "}, {"          AA                 AA          ", "        AA                     AA        ", "       A                         A       ", "     AA                           AA     ", "    A                               A    ", "   A                                 A   ", "   A                                 A   ", "  A                                   A  ", " A                                     A ", " A                                     A ", "A                                       A", "A                KKKKKKK                A", "               KK       KK               ", "              K           K              ", "             K             K             ", "            K               K            ", "            K               K            ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "            K               K            ", "            K               K            ", "             K             K             ", "              K           K              ", "               KK       KK               ", "A                KKKKKKK                A", "A                                       A", " A                                     A ", " A                                     A ", "  A                                   A  ", "   A                                 A   ", "   A                                 A   ", "    A                               A    ", "     AA                           AA     ", "       A                         A       ", "        AA                     AA        ", "          AA                 AA          "}, {"         A                     A         ", "        A                       A        ", "      AA                         AA      ", "     A                             A     ", "    A                               A    ", "   A                                 A   ", "  A                                   A  ", "  A                                   A  ", " A                                     A ", "A                                       A", "                  KKKKK                  ", "               KKK     KKK               ", "              K           K              ", "             K             K             ", "            K               K            ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "            K               K            ", "             K             K             ", "              K           K              ", "               KKK     KKK               ", "                  KKKKK                  ", "A                                       A", " A                                     A ", "  A                                   A  ", "  A                                   A  ", "   A                                 A   ", "    A                               A    ", "     A                             A     ", "      AA                         AA      ", "        A                       A        ", "         A                     A         "}, {"                                         ", "       A                         A       ", "      A                           A      ", "     A                             A     ", "    A                               A    ", "   A                                 A   ", "  A                                   A  ", " A                                     A ", "                                         ", "                                         ", "                KKKKKKKKK                ", "               K         K               ", "             KK           KK             ", "            K               K            ", "            K               K            ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "            K               K            ", "            K               K            ", "             KK           KK             ", "               K         K               ", "                KKKKKKKKK                ", "                                         ", "                                         ", " A                                     A ", "  A                                   A  ", "   A                                 A   ", "    A                               A    ", "     A                             A     ", "      A                           A      ", "       A                         A       ", "                                         "}, {"                                         ", "                                         ", "                                         ", "     A                             A     ", "    A                               A    ", "   A                                 A   ", "                                         ", "                                         ", "                                         ", "                   KKK                   ", "                KKK   KKK                ", "              KK         KK              ", "             K             K             ", "            K               K            ", "           K                 K           ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "           K                 K           ", "            K               K            ", "             K             K             ", "              KK         KK              ", "                KKK   KKK                ", "                   KKK                   ", "                                         ", "                                         ", "                                         ", "   A                                 A   ", "    A                               A    ", "     A                             A     ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                  KKKKK                  ", "               KKK     KKK               ", "              K           K              ", "            KK             KK            ", "            K               K            ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "            K               K            ", "            KK             KK            ", "              K           K              ", "               KKK     KKK               ", "                  KKKKK                  ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                 KKKKKKK                 ", "               KK       KK               ", "             KK           KK             ", "            K               K            ", "           K                 K           ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "           K                 K           ", "            K               K            ", "             KK           KK             ", "               KK       KK               ", "                 KKKKKKK                 ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                 KKKKKKK                 ", "               KK       KK               ", "             KK           KK             ", "            K               K            ", "           K                 K           ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K          G          K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "           K                 K           ", "            K               K            ", "             KK           KK             ", "               KK       KK               ", "                 KKKKKKK                 ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                 KKKKKKK                 ", "               KK       KK               ", "             KK           KK             ", "            K               K            ", "           K                 K           ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "           K                 K           ", "            K               K            ", "             KK           KK             ", "               KK       KK               ", "                 KKKKKKK                 ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                  KKKKK                  ", "               KKK     KKK               ", "              K           K              ", "            KK             KK            ", "            K               K            ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "            K               K            ", "            KK             KK            ", "              K           K              ", "               KKK     KKK               ", "                  KKKKK                  ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "     A                             A     ", "    A                               A    ", "   A                                 A   ", "                                         ", "                                         ", "                                         ", "                   KKK                   ", "                KKK   KKK                ", "              KK         KK              ", "             K             K             ", "            K               K            ", "           K                 K           ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "           K                 K           ", "            K               K            ", "             K             K             ", "              KK         KK              ", "                KKK   KKK                ", "                   KKK                   ", "                                         ", "                                         ", "                                         ", "   A                                 A   ", "    A                               A    ", "     A                             A     ", "                                         ", "                                         ", "                                         "}, {"                                         ", "       A                         A       ", "      A                           A      ", "     A                             A     ", "    A                               A    ", "   A                                 A   ", "  A                                   A  ", " A                                     A ", "                                         ", "                                         ", "                KKKKKKKKK                ", "               K         K               ", "             KK           KK             ", "            K               K            ", "            K               K            ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "            K               K            ", "            K               K            ", "             KK           KK             ", "               K         K               ", "                KKKKKKKKK                ", "                                         ", "                                         ", " A                                     A ", "  A                                   A  ", "   A                                 A   ", "    A                               A    ", "     A                             A     ", "      A                           A      ", "       A                         A       ", "                                         "}, {"         A                     A         ", "        A                       A        ", "      AA                         AA      ", "     A                             A     ", "    A                               A    ", "   A                                 A   ", "  A                                   A  ", "  A                                   A  ", " A                                     A ", "A                                       A", "                  KKKKK                  ", "               KKK     KKK               ", "              K           K              ", "             K             K             ", "            K               K            ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "            K               K            ", "             K             K             ", "              K           K              ", "               KKK     KKK               ", "                  KKKKK                  ", "A                                       A", " A                                     A ", "  A                                   A  ", "  A                                   A  ", "   A                                 A   ", "    A                               A    ", "     A                             A     ", "      AA                         AA      ", "        A                       A        ", "         A                     A         "}, {"          AA                 AA          ", "        AA                     AA        ", "       A                         A       ", "     AA                           AA     ", "    A                               A    ", "   A                                 A   ", "   A                                 A   ", "  A                                   A  ", " A                                     A ", " A                                     A ", "A                                       A", "A                KKKKKKK                A", "               KK       KK               ", "              K           K              ", "             K             K             ", "            K               K            ", "            K               K            ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "            K               K            ", "            K               K            ", "             K             K             ", "              K           K              ", "               KK       KK               ", "A                KKKKKKK                A", "A                                       A", " A                                     A ", " A                                     A ", "  A                                   A  ", "   A                                 A   ", "   A                                 A   ", "    A                               A    ", "     AA                           AA     ", "       A                         A       ", "        AA                     AA        ", "          AA                 AA          "}, {"          AAA               AAA          ", "         A                     A         ", "       AA                       AA       ", "      A                           A      ", "     A                             A     ", "    A                               A    ", "   A                                 A   ", "  A                                   A  ", "  A                                   A  ", " A                                     A ", "A                                       A", "A                  KKK                  A", "A               KKK   KKK               A", "               K         K               ", "              K           K              ", "             K             K             ", "            K               K            ", "            K               K            ", "            K               K            ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "            K               K            ", "            K               K            ", "            K               K            ", "             K             K             ", "              K           K              ", "               K         K               ", "A               KKK   KKK               A", "A                  KKK                  A", "A                                       A", " A                                     A ", "  A                                   A  ", "  A                                   A  ", "   A                                 A   ", "    A                               A    ", "     A                             A     ", "      A                           A      ", "       AA                       AA       ", "         A                     A         ", "          AAA               AAA          "}, {"           AAA             AAA           ", "         AA                   AA         ", "        A                       A        ", "      AA                         AA      ", "     A                             A     ", "    A                               A    ", "   A                                 A   ", "   A                                 A   ", "  A                                   A  ", " A                                     A ", " A                                     A ", "A                                       A", "A                 KKKKK                 A", "A               KKK   KKK               A", "               KK       KK               ", "              K           K              ", "             KK           KK             ", "             K             K             ", "            KK             KK            ", "            K               K            ", "            K               K            ", "            K               K            ", "            KK             KK            ", "             K             K             ", "             KK           KK             ", "              K           K              ", "               KK       KK               ", "A               KKK   KKK               A", "A                 KKKKK                 A", "A                                       A", " A                                     A ", " A                                     A ", "  A                                   A  ", "   A                                 A   ", "   A                                 A   ", "    A                               A    ", "     A                             A     ", "      AA                         AA      ", "        A                       A        ", "         AA                   AA         ", "           AAA             AAA           "}, {"            AAA           AAA            ", "          AA                 AA          ", "        AA                     AA        ", "       A                         A       ", "      H                           H      ", "     H                             H     ", "    H                               H    ", "   A                                 A   ", "  A                                   A  ", "  A                                   A  ", " A        K                   K        A ", " A         K                 K         A ", "A                                       A", "A                  KKK                  A", "A                KKKKKKK                A", "               KKK     KKK               ", "               K         K               ", "              KK         KK              ", "              K           K              ", "             KK           KK             ", "             KK           KK             ", "             KK           KK             ", "              K           K              ", "              KK         KK              ", "               K         K               ", "               KKK     KKK               ", "A                KKKKKKK                A", "A                  KKK                  A", "A                                       A", " A         K                 K         A ", " A        K                   K        A ", "  A                                   A  ", "  A                                   A  ", "   A                                 A   ", "    H                               H    ", "     H                             H     ", "      H                           H      ", "       A                         A       ", "        AA                     AA        ", "          AA                 AA          ", "            AAA           AAA            "}, {"             AA           AA             ", "           AA               AA           ", "         AA                   AA         ", "        H                       H        ", "      HH                         HH      ", "     H                             H     ", "    H                               H    ", "    H                               H    ", "   H                                 H   ", "  A      KK                   KK      A  ", "  A      KFK                 KFK      A  ", " A        K                   K        A ", " A                                     A ", "A                                       A", "A                                       A", "                  KKKKK                  ", "                KKKKKKKKK                ", "                KKK   KKK                ", "               KKK     KKK               ", "               KK       KK               ", "               KK       KK               ", "               KK       KK               ", "               KKK     KKK               ", "                KKK   KKK                ", "                KKKKKKKKK                ", "                  KKKKK                  ", "A                                       A", "A                                       A", " A                                     A ", " A        K                   K        A ", "  A      KFK                 KFK      A  ", "  A      KK                   KK      A  ", "   H                                 H   ", "    H                               H    ", "    H                               H    ", "     H                             H     ", "      HH                         HH      ", "        H                       H        ", "         AA                   AA         ", "           AA               AA           ", "             AA           AA             "}, {"               A         A               ", "            AAA           AAA            ", "          AA                 AA          ", "         H                     H         ", "       HH                       HH       ", "      H                           H      ", "     H                             H     ", "    H                               H    ", "    H   KK                     KK   H    ", "   H    KFK                   KFK    H   ", "  A      KK                   KK      A  ", "  A                                   A  ", " A                                     A ", " A                                     A ", " A                                     A ", "A                                       A", "                                         ", "                   KKK                   ", "                  KKKKK                  ", "                 KKKKKKK                 ", "                 KKKKKKK                 ", "                 KKKKKKK                 ", "                  KKKKK                  ", "                   KKK                   ", "                                         ", "A                                       A", " A                                     A ", " A                                     A ", " A                                     A ", "  A                                   A  ", "  A      KK                   KK      A  ", "   H    KFK                   KFK    H   ", "    H   KK                     KK   H    ", "    H                               H    ", "     H                             H     ", "      H                           H      ", "       HH                       HH       ", "         H                     H         ", "          AA                 AA          ", "            AAA           AAA            ", "               A         A               "}, {"                                         ", "              AA         AA              ", "           AAA             AAA           ", "          H                   H          ", "        HH                     HH        ", "       H                         H       ", "      HK                         KH      ", "     HKKK                       KKKH     ", "    H  KFK                     KFK  H    ", "    H   KK                     KK   H    ", "   H                                 H   ", "  A                                   A  ", "  A                                   A  ", "  A                                   A  ", " A                                     A ", " A                                     A ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", " A                                     A ", " A                                     A ", "  A                                   A  ", "  A                                   A  ", "  A                                   A  ", "   H                                 H   ", "    H   KK                     KK   H    ", "    H  KFK                     KFK  H    ", "     HKKK                       KKKH     ", "      HK                         KH      ", "       H                         H       ", "        HH                     HH        ", "          H                   H          ", "           AAA             AAA           ", "              AA         AA              ", "                                         "}, {"                                         ", "                A       A                ", "             AAA         AAA             ", "           AA               AA           ", "         HH                   HH         ", "        H                       H        ", "       IK                       KI       ", "      IFK                       KFI      ", "     HKKK                       KKKH     ", "    H                               H    ", "    H                               H    ", "   A                                 A   ", "   A                                 A   ", "  A                                   A  ", "  A                                   A  ", "  A                                   A  ", " A                                     A ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", " A                                     A ", "  A                                   A  ", "  A                                   A  ", "  A                                   A  ", "   A                                 A   ", "   A                                 A   ", "    H                               H    ", "    H                               H    ", "     HKKK                       KKKH     ", "      IFK                       KFI      ", "       IK                       KI       ", "        H                       H        ", "         HH                   HH         ", "           AA               AA           ", "             AAA         AAA             ", "                A       A                ", "                                         "}, {"                                         ", "                                         ", "               AA       AA               ", "            AAA           AAA            ", "          HH                 HH          ", "         H                     H         ", "        H                       H        ", "       IK                       KI       ", "      HK                         KH      ", "     H                             H     ", "    H                               H    ", "    H                               H    ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "  A                                   A  ", "  A                                   A  ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "  A                                   A  ", "  A                                   A  ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "    H                               H    ", "    H                               H    ", "     H                             H     ", "      HK                         KH      ", "       IK                       KI       ", "        H                       H        ", "         H                     H         ", "          HH                 HH          ", "            AAA           AAA            ", "               AA       AA               ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "              AAAA     AAAA              ", "            AA             AA            ", "          HH                 HH          ", "         H                     H         ", "        H                       H        ", "       H                         H       ", "      H                           H      ", "     H                             H     ", "     H                             H     ", "    A                               A    ", "    A                               A    ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "    A                               A    ", "    A                               A    ", "     H                             H     ", "     H                             H     ", "      H                           H      ", "       H                         H       ", "        H                       H        ", "         H                     H         ", "          HH                 HH          ", "            AA             AA            ", "              AAAA     AAAA              ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "              AAAA     AAAA              ", "            AA             AA            ", "          HH                 HH          ", "         HH                   HH         ", "        HH                     HH        ", "       HH                       HH       ", "      HH                         HH      ", "      H                           H      ", "     A                             A     ", "     A                             A     ", "    A                               A    ", "    A                               A    ", "    A                               A    ", "    A                               A    ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "    A                               A    ", "    A                               A    ", "    A                               A    ", "    A                               A    ", "     A                             A     ", "     A                             A     ", "      H                           H      ", "      HH                         HH      ", "       HH                       HH       ", "        HH                     HH        ", "         HH                   HH         ", "          HH                 HH          ", "            AA             AA            ", "              AAAA     AAAA              ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "              AAAA     AAAA              ", "            AAA           AAA            ", "           AA               AA           ", "          H                   H          ", "         H                     H         ", "        H                       H        ", "       A                         A       ", "      AA                         AA      ", "      A                           A      ", "     AA                           AA     ", "     A                             A     ", "     A                             A     ", "     A                             A     ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "     A                             A     ", "     A                             A     ", "     A                             A     ", "     AA                           AA     ", "      A                           A      ", "      AA                         AA      ", "       A                         A       ", "        H                       H        ", "         H                     H         ", "          H                   H          ", "           AA               AA           ", "            AAA           AAA            ", "              AAAA     AAAA              ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "               AA       AA               ", "             AAA         AAA             ", "           AAA             AAA           ", "          AA                 AA          ", "         AA                   AA         ", "        AA                     AA        ", "        A                       A        ", "       AA                       AA       ", "       A                         A       ", "      AA                         AA      ", "      A                           A      ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "      A                           A      ", "      AA                         AA      ", "       A                         A       ", "       AA                       AA       ", "        A                       A        ", "        AA                     AA        ", "         AA                   AA         ", "          AA                 AA          ", "           AAA             AAA           ", "             AAA         AAA             ", "               AA       AA               ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                A       A                ", "              AA         AA              ", "            AAA           AAA            ", "           AA               AA           ", "          AA                 AA          ", "         AA                   AA         ", "         A                     A         ", "        AA                     AA        ", "        A                       A        ", "       A                         A       ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "       A                         A       ", "        A                       A        ", "        AA                     AA        ", "         A                     A         ", "         AA                   AA         ", "          AA                 AA          ", "           AA               AA           ", "            AAA           AAA            ", "              AA         AA              ", "                A       A                ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "               A         A               ", "             AA           AA             ", "            AAA           AAA            ", "           AAA             AAA           ", "          AAA               AAA          ", "          AA                 AA          ", "         A                     A         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "         A                     A         ", "          AA                 AA          ", "          AAA               AAA          ", "           AAA             AAA           ", "            AAA           AAA            ", "             AA           AA             ", "               A         A               ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                   GGG                   ", "                  GGGGG                  ", "                  GGGGG                  ", "                  GGGGG                  ", "                   GGG                   ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                  GGGGG                  ", "                 GG   GG                 ", "                 G     G                 ", "                 G     G                 ", "                 G     G                 ", "                 GG   GG                 ", "                  GGGGG                  ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                  GGGGG                  ", "                 G     G                 ", "                G       G                ", "                G       G                ", "                G       G                ", "                G       G                ", "                G       G                ", "                 G     G                 ", "                  GGGGG                  ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                   GGG                   ", "                 GG   GG                 ", "                G       G                ", "                G       G                ", "               G         G               ", "               G         G               ", "               G         G               ", "                G       G                ", "                G       G                ", "                 GG   GG                 ", "                   GGG                   ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                   LLL                   ", "                   LLL                   ", "                   III                   ", "                   KKK                   ", "                   KKK                   ", "                   KKK                   ", "                   KKK                   ", "                  GGGGG                  ", "                 G     G                 ", "                G       G                ", "               G         G               ", "               G         G               ", "               G         G               ", "               G         G               ", "               G         G               ", "                G       G                ", "                 G     G                 ", "                  GGGGG                  ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                   L~L                   ", "                   LFL                   ", "                   IGI                   ", "                   KGK                   ", "                   KGK                   ", "                   KGK                   ", "                   KGK                   ", "                  GGGGG                  ", "                 G     G                 ", "                G       G                ", "               G         G               ", "               G         G               ", "               G         G               ", "               G         G               ", "               G         G               ", "                G       G                ", "                 G     G                 ", "                  GGGGG                  ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                   LLL                   ", "                   LLL                   ", "                   III                   ", "                 HHHHHHH                 ", "               HHEEEEEEEHH               ", "              HEEEEEEEEEEEH              ", "             HEEEEEEEEEEEEEH             ", "            HEEEEEEEEEEEEEEEH            ", "            HEEEEEEEEEEEEEEEH            ", "           HEEEEEEEEEEEEEEEEEH           ", "           HEEEEEEEEEEEEEEEEEH           ", "           HEEEEEEEEEEEEEEEEEH           ", "           HEEEEEEEEEEEEEEEEEH           ", "           HEEEEEEEEEEEEEEEEEH           ", "           HEEEEEEEEEEEEEEEEEH           ", "           HEEEEEEEEEEEEEEEEEH           ", "            HEEEEEEEEEEEEEEEH            ", "            HEEEEEEEEEEEEEEEH            ", "             HEEEEEEEEEEEEEH             ", "              HEEEEEEEEEEEH              ", "               HHEEEEEEEHH               ", "                 HHHHHHH                 ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                 HHHHHHH                 ", "               HHDDDDDDDHH               ", "             HHDDDDDDDDDDDHH             ", "            HDDDDDDDDDDDDDDDH            ", "           HDDDDDDDDDDDDDDDDDH           ", "          HDDDDDDDDDDDDDDDDDDDH          ", "          HDDDDDDDDDDDDDDDDDDDH          ", "         HDDDDDDDDDDDDDDDDDDDDDH         ", "         HDDDDDDDDDDDDDDDDDDDDDH         ", "        HDDDDDDDDDDDDDDDDDDDDDDDH        ", "        HDDDDDDDDDDDDDDDDDDDDDDDH        ", "        HDDDDDDDDDDDDDDDDDDDDDDDH        ", "        HDDDDDDDDDDDDDDDDDDDDDDDH        ", "        HDDDDDDDDDDDDDDDDDDDDDDDH        ", "        HDDDDDDDDDDDDDDDDDDDDDDDH        ", "        HDDDDDDDDDDDDDDDDDDDDDDDH        ", "         HDDDDDDDDDDDDDDDDDDDDDH         ", "         HDDDDDDDDDDDDDDDDDDDDDH         ", "          HDDDDDDDDDDDDDDDDDDDH          ", "          HDDDDDDDDDDDDDDDDDDDH          ", "           HDDDDDDDDDDDDDDDDDH           ", "            HDDDDDDDDDDDDDDDH            ", "             HHDDDDDDDDDDDHH             ", "               HHDDDDDDDHH               ", "                 HHHHHHH                 ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                 CCCCCCC                 ", "              CCCBBBBBBBCCC              ", "             CBBBBBBBBBBBBBC             ", "           CCBBBBBBBBBBBBBBBCC           ", "          CBBBBBBBBBBBBBBBBBBBC          ", "          CBBBBBBBBBBBBBBBBBBBC          ", "         CBBBBBBBBBBBBBBBBBBBBBC         ", "        CBBBBBBBBBBBBBBBBBBBBBBBC        ", "        CBBBBBBBBBBBBBBBBBBBBBBBC        ", "        CBBBBBBBBBBBBBBBBBBBBBBBC        ", "       CBBBBBBBBBBBBBBBBBBBBBBBBBC       ", "       CBBBBBBBBBBBBBBBBBBBBBBBBBC       ", "       CBBBBBBBBBBBBBBBBBBBBBBBBBC       ", "       CBBBBBBBBBBBBBBBBBBBBBBBBBC       ", "       CBBBBBBBBBBBBBBBBBBBBBBBBBC       ", "       CBBBBBBBBBBBBBBBBBBBBBBBBBC       ", "       CBBBBBBBBBBBBBBBBBBBBBBBBBC       ", "        CBBBBBBBBBBBBBBBBBBBBBBBC        ", "        CBBBBBBBBBBBBBBBBBBBBBBBC        ", "        CBBBBBBBBBBBBBBBBBBBBBBBC        ", "         CBBBBBBBBBBBBBBBBBBBBBC         ", "          CBBBBBBBBBBBBBBBBBBBC          ", "          CBBBBBBBBBBBBBBBBBBBC          ", "           CCBBBBBBBBBBBBBBBCC           ", "             CBBBBBBBBBBBBBC             ", "              CCCBBBBBBBCCC              ", "                 CCCCCCC                 ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                 JJJJJJJ                 ", "              JJJJJJJJJJJJJ              ", "            JJJJJJJJJJJJJJJJJ            ", "           JJJJJJJJJJJJJJJJJJJ           ", "          JJJJJJJJJJJJJJJJJJJJJ          ", "         JJJJJJJJJJJJJJJJJJJJJJJ         ", "        JJJJJJJJJJJJJJJJJJJJJJJJJ        ", "        JJJJJJJJJJJJJJJJJJJJJJJJJ        ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "        JJJJJJJJJJJJJJJJJJJJJJJJJ        ", "        JJJJJJJJJJJJJJJJJJJJJJJJJ        ", "         JJJJJJJJJJJJJJJJJJJJJJJ         ", "          JJJJJJJJJJJJJJJJJJJJJ          ", "           JJJJJJJJJJJJJJJJJJJ           ", "            JJJJJJJJJJJJJJJJJ            ", "              JJJJJJJJJJJJJ              ", "                 JJJJJJJ                 ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                 JJJJJJJ                 ", "              JJJJJJJJJJJJJ              ", "            JJJJJJJJJJJJJJJJJ            ", "           JJJJJJJJJJJJJJJJJJJ           ", "          JJJJJJJJJJJJJJJJJJJJJ          ", "         JJJJJJJJJJJJJJJJJJJJJJJ         ", "        JJJJJJJJJJJJJJJJJJJJJJJJJ        ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "        JJJJJJJJJJJJJJJJJJJJJJJJJ        ", "         JJJJJJJJJJJJJJJJJJJJJJJ         ", "          JJJJJJJJJJJJJJJJJJJJJ          ", "           JJJJJJJJJJJJJJJJJJJ           ", "            JJJJJJJJJJJJJJJJJ            ", "              JJJJJJJJJJJJJ              ", "                 JJJJJJJ                 ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                 JJJJJJJ                 ", "              JJJJJJJJJJJJJ              ", "            JJJJJJJJJJJJJJJJJ            ", "           JJJJJJJJJJJJJJJJJJJ           ", "          JJJJJJJJJJJJJJJJJJJJJ          ", "         JJJJJJJJJJJJJJJJJJJJJJJ         ", "        JJJJJJJJJJJJJJJJJJJJJJJJJ        ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "        JJJJJJJJJJJJJJJJJJJJJJJJJ        ", "         JJJJJJJJJJJJJJJJJJJJJJJ         ", "          JJJJJJJJJJJJJJJJJJJJJ          ", "           JJJJJJJJJJJJJJJJJJJ           ", "            JJJJJJJJJJJJJJJJJ            ", "              JJJJJJJJJJJJJ              ", "                 JJJJJJJ                 ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}};
        shapeMainErr = new String[][]{{"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "               A         A               ", "             AA           AA             ", "            AAA           AAA            ", "           AAA             AAA           ", "          AAA               AAA          ", "          AA                 AA          ", "         A                     A         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "         A                     A         ", "          AA                 AA          ", "          AAA               AAA          ", "           AAA             AAA           ", "            AAA           AAA            ", "             AA           AA             ", "               A         A               ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                A       A                ", "              AA         AA              ", "            AAA           AAA            ", "           AA               AA           ", "          AA                 AA          ", "         AA                   AA         ", "         A                     A         ", "        AA                     AA        ", "        A                       A        ", "       A                         A       ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "       A                         A       ", "        A                       A        ", "        AA                     AA        ", "         A                     A         ", "         AA                   AA         ", "          AA                 AA          ", "           AA               AA           ", "            AAA           AAA            ", "              AA         AA              ", "                A       A                ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "               AA       AA               ", "             AAA         AAA             ", "           AAA             AAA           ", "          AA                 AA          ", "         AA                   AA         ", "        AA                     AA        ", "        A                       A        ", "       AA                       AA       ", "       A                         A       ", "      AA                         AA      ", "      A                           A      ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "      A                           A      ", "      AA                         AA      ", "       A                         A       ", "       AA                       AA       ", "        A                       A        ", "        AA                     AA        ", "         AA                   AA         ", "          AA                 AA          ", "           AAA             AAA           ", "             AAA         AAA             ", "               AA       AA               ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "              AAAA     AAAA              ", "            AAA           AAA            ", "           AA               AA           ", "          H                   H          ", "         H                     H         ", "        H                       H        ", "       A                         A       ", "      AA                         AA      ", "      A                           A      ", "     AA                           AA     ", "     A                             A     ", "     A                             A     ", "     A                             A     ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "     A                             A     ", "     A                             A     ", "     A                             A     ", "     AA                           AA     ", "      A                           A      ", "      AA                         AA      ", "       A                         A       ", "        H                       H        ", "         H                     H         ", "          H                   H          ", "           AA               AA           ", "            AAA           AAA            ", "              AAAA     AAAA              ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "              AAAA     AAAA              ", "            AA             AA            ", "          HH                 HH          ", "         HH                   HH         ", "        HH                     HH        ", "       HH                       HH       ", "      HH                         HH      ", "      H                           H      ", "     A                             A     ", "     A                             A     ", "    A                               A    ", "    A                               A    ", "    A                               A    ", "    A                               A    ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "    A                               A    ", "    A                               A    ", "    A                               A    ", "    A                               A    ", "     A                             A     ", "     A                             A     ", "      H                           H      ", "      HH                         HH      ", "       HH                       HH       ", "        HH                     HH        ", "         HH                   HH         ", "          HH                 HH          ", "            AA             AA            ", "              AAAA     AAAA              ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "              AAAA     AAAA              ", "            AA             AA            ", "          HH                 HH          ", "         H                     H         ", "        H                       H        ", "       H                         H       ", "      H                           H      ", "     H                             H     ", "     H                             H     ", "    A                               A    ", "    A                               A    ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "    A                               A    ", "    A                               A    ", "     H                             H     ", "     H                             H     ", "      H                           H      ", "       H                         H       ", "        H                       H        ", "         H                     H         ", "          HH                 HH          ", "            AA             AA            ", "              AAAA     AAAA              ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "               AA       AA               ", "            AAA           AAA            ", "          HH                 HH          ", "         H                     H         ", "        H                       H        ", "       IK                       KI       ", "      HK                         KH      ", "     H                             H     ", "    H                               H    ", "    H                               H    ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "  A                                   A  ", "  A                                   A  ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "  A                                   A  ", "  A                                   A  ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "    H                               H    ", "    H                               H    ", "     H                             H     ", "      HK                         KH      ", "       IK                       KI       ", "        H                       H        ", "         H                     H         ", "          HH                 HH          ", "            AAA           AAA            ", "               AA       AA               ", "                                         ", "                                         "}, {"                                         ", "                A       A                ", "             AAA         AAA             ", "           AA               AA           ", "         HH                   HH         ", "        H                       H        ", "       IK                       KI       ", "      IFK                       KFI      ", "     HKKK                       KKKH     ", "    H                               H    ", "    H                               H    ", "   A                                 A   ", "   A                                 A   ", "  A                                   A  ", "  A                                   A  ", "  A                                   A  ", " A                                     A ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", " A                                     A ", "  A                                   A  ", "  A                                   A  ", "  A                                   A  ", "   A                                 A   ", "   A                                 A   ", "    H                               H    ", "    H                               H    ", "     HKKK                       KKKH     ", "      IFK                       KFI      ", "       IK                       KI       ", "        H                       H        ", "         HH                   HH         ", "           AA               AA           ", "             AAA         AAA             ", "                A       A                ", "                                         "}, {"                                         ", "              AA         AA              ", "           AAA             AAA           ", "          H                   H          ", "        HH                     HH        ", "       H                         H       ", "      HK                         KH      ", "     HKKK                       KKKH     ", "    H  KFK                     KFK  H    ", "    H   KK                     KK   H    ", "   H                                 H   ", "  A                                   A  ", "  A                                   A  ", "  A                                   A  ", " A                                     A ", " A                                     A ", "                                         ", "                   KKK                   ", "                  KKKKK                  ", "                 KKKKKKK                 ", "                 KKKKKKK                 ", "                 KKKKKKK                 ", "                  KKKKK                  ", "                   KKK                   ", "                                         ", " A                                     A ", " A                                     A ", "  A                                   A  ", "  A                                   A  ", "  A                                   A  ", "   H                                 H   ", "    H   KK                     KK   H    ", "    H  KFK                     KFK  H    ", "     HKKK                       KKKH     ", "      HK                         KH      ", "       H                         H       ", "        HH                     HH        ", "          H                   H          ", "           AAA             AAA           ", "              AA         AA              ", "                                         "}, {"               A         A               ", "            AAA           AAA            ", "          AA                 AA          ", "         H                     H         ", "       HH                       HH       ", "      H                           H      ", "     H                             H     ", "    H                               H    ", "    H   KK                     KK   H    ", "   H    KFK                   KFK    H   ", "  A      KK                   KK      A  ", "  A                                   A  ", " A                                     A ", " A                                     A ", " A                                     A ", "A                 KKKKK                 A", "                KKKKKKKKK                ", "                KKK   KKK                ", "               KKK     KKK               ", "               KK       KK               ", "               KK       KK               ", "               KK       KK               ", "               KKK     KKK               ", "                KKK   KKK                ", "                KKKKKKKKK                ", "A                 KKKKK                 A", " A                                     A ", " A                                     A ", " A                                     A ", "  A                                   A  ", "  A      KK                   KK      A  ", "   H    KFK                   KFK    H   ", "    H   KK                     KK   H    ", "    H                               H    ", "     H                             H     ", "      H                           H      ", "       HH                       HH       ", "         H                     H         ", "          AA                 AA          ", "            AAA           AAA            ", "               A         A               "}, {"             AA           AA             ", "           AA               AA           ", "         AA                   AA         ", "        H                       H        ", "      HH                         HH      ", "     H                             H     ", "    H                               H    ", "    H                               H    ", "   H                                 H   ", "  A      KK                   KK      A  ", "  A      KFK                 KFK      A  ", " A        K                   K        A ", " A                                     A ", "A                  KKK                  A", "A                KKKKKKK                A", "               KKK     KKK               ", "               K         K               ", "              KK         KK              ", "              K           K              ", "             KK           KK             ", "             KK           KK             ", "             KK           KK             ", "              K           K              ", "              KK         KK              ", "               K         K               ", "               KKK     KKK               ", "A                KKKKKKK                A", "A                  KKK                  A", " A                                     A ", " A        K                   K        A ", "  A      KFK                 KFK      A  ", "  A      KK                   KK      A  ", "   H                                 H   ", "    H                               H    ", "    H                               H    ", "     H                             H     ", "      HH                         HH      ", "        H                       H        ", "         AA                   AA         ", "           AA               AA           ", "             AA           AA             "}, {"            AAA           AAA            ", "          AA                 AA          ", "        AA                     AA        ", "       A                         A       ", "      H                           H      ", "     H                             H     ", "    H                               H    ", "   A                                 A   ", "  A                                   A  ", "  A                                   A  ", " A        K                   K        A ", " A         K                 K         A ", "A                 KKKKK                 A", "A               KKK   KKK               A", "A              KK       KK              A", "              K           K              ", "             KK           KK             ", "             K             K             ", "            KK             KK            ", "            K               K            ", "            K               K            ", "            K               K            ", "            KK             KK            ", "             K             K             ", "             KK           KK             ", "              K           K              ", "A              KK       KK              A", "A               KKK   KKK               A", "A                 KKKKK                 A", " A         K                 K         A ", " A        K                   K        A ", "  A                                   A  ", "  A                                   A  ", "   A                                 A   ", "    H                               H    ", "     H                             H     ", "      H                           H      ", "       A                         A       ", "        AA                     AA        ", "          AA                 AA          ", "            AAA           AAA            "}, {"           AAA             AAA           ", "         AA                   AA         ", "        A                       A        ", "      AA                         AA      ", "     A                             A     ", "    A                               A    ", "   A                                 A   ", "   A                                 A   ", "  A                                   A  ", " A                                     A ", " A                                     A ", "A                  KKK                  A", "A               KKK   KKK               A", "A              K         K              A", "              K           K              ", "             K             K             ", "            K               K            ", "            K               K            ", "            K               K            ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "            K               K            ", "            K               K            ", "            K               K            ", "             K             K             ", "              K           K              ", "A              K         K              A", "A               KKK   KKK               A", "A                  KKK                  A", " A                                     A ", " A                                     A ", "  A                                   A  ", "   A                                 A   ", "   A                                 A   ", "    A                               A    ", "     A                             A     ", "      AA                         AA      ", "        A                       A        ", "         AA                   AA         ", "           AAA             AAA           "}, {"          AAA               AAA          ", "         A                     A         ", "       AA                       AA       ", "      A                           A      ", "     A                             A     ", "    A                               A    ", "   A                                 A   ", "  A                                   A  ", "  A                                   A  ", " A                                     A ", "A                                       A", "A                KKKKKKK                A", "A              KK       KK              A", "              K           K              ", "             K             K             ", "            K               K            ", "            K               K            ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "            K               K            ", "            K               K            ", "             K             K             ", "              K           K              ", "A              KK       KK              A", "A                KKKKKKK                A", "A                                       A", " A                                     A ", "  A                                   A  ", "  A                                   A  ", "   A                                 A   ", "    A                               A    ", "     A                             A     ", "      A                           A      ", "       AA                       AA       ", "         A                     A         ", "          AAA               AAA          "}, {"          AA                 AA          ", "        AA                     AA        ", "       A                         A       ", "     AA                           AA     ", "    A                               A    ", "   A                                 A   ", "   A                                 A   ", "  A                                   A  ", " A                                     A ", " A                                     A ", "A                 KKKKK                 A", "A              KKK     KKK              A", "              K           K              ", "             K             K             ", "            K               K            ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "            K               K            ", "             K             K             ", "              K           K              ", "A              KKK     KKK              A", "A                 KKKKK                 A", " A                                     A ", " A                                     A ", "  A                                   A  ", "   A                                 A   ", "   A                                 A   ", "    A                               A    ", "     AA                           AA     ", "       A                         A       ", "        AA                     AA        ", "          AA                 AA          "}, {"         A                     A         ", "        A                       A        ", "      AA                         AA      ", "     A                             A     ", "    A                               A    ", "   A                                 A   ", "  A                                   A  ", "  A                                   A  ", " A                                     A ", "A                                       A", "                KKKKKKKKK                ", "               K         K               ", "             KK           KK             ", "            K               K            ", "            K               K            ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "            K               K            ", "            K               K            ", "             KK           KK             ", "               K         K               ", "                KKKKKKKKK                ", "A                                       A", " A                                     A ", "  A                                   A  ", "  A                                   A  ", "   A                                 A   ", "    A                               A    ", "     A                             A     ", "      AA                         AA      ", "        A                       A        ", "         A                     A         "}, {"                                         ", "       A                         A       ", "      A                           A      ", "     A                             A     ", "    A                               A    ", "   A                                 A   ", "  A                                   A  ", " A                                     A ", "                                         ", "                   KKK                   ", "                KKK   KKK                ", "              KK         KK              ", "             K             K             ", "            K               K            ", "           K                 K           ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "           K                 K           ", "            K               K            ", "             K             K             ", "              KK         KK              ", "                KKK   KKK                ", "                   KKK                   ", "                                         ", " A                                     A ", "  A                                   A  ", "   A                                 A   ", "    A                               A    ", "     A                             A     ", "      A                           A      ", "       A                         A       ", "                                         "}, {"                                         ", "                                         ", "                                         ", "     A                             A     ", "    A                               A    ", "   A                                 A   ", "                                         ", "                                         ", "                                         ", "                  KKKKK                  ", "               KKK     KKK               ", "              K           K              ", "            KK             KK            ", "            K               K            ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "            K               K            ", "            KK             KK            ", "              K           K              ", "               KKK     KKK               ", "                  KKKKK                  ", "                                         ", "                                         ", "                                         ", "   A                                 A   ", "    A                               A    ", "     A                             A     ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                 KKKKKKK                 ", "               KK       KK               ", "             KK           KK             ", "            K               K            ", "           K                 K           ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "           K                 K           ", "            K               K            ", "             KK           KK             ", "               KK       KK               ", "                 KKKKKKK                 ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                 KKKKKKK                 ", "               KK       KK               ", "             KK           KK             ", "            K               K            ", "           K                 K           ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K          G          K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "           K                 K           ", "            K               K            ", "             KK           KK             ", "               KK       KK               ", "                 KKKKKKK                 ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                 KKKKKKK                 ", "               KK       KK               ", "             KK           KK             ", "            K               K            ", "           K                 K           ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "           K                 K           ", "            K               K            ", "             KK           KK             ", "               KK       KK               ", "                 KKKKKKK                 ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                  KKKKK                  ", "               KKK     KKK               ", "              K           K              ", "            KK             KK            ", "            K               K            ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "            K               K            ", "            KK             KK            ", "              K           K              ", "               KKK     KKK               ", "                  KKKKK                  ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                   KKK                   ", "                KKK   KKK                ", "              KK         KK              ", "             K             K             ", "            K               K            ", "           K                 K           ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "         K                     K         ", "         K                     K         ", "         K                     K         ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "           K                 K           ", "            K               K            ", "             K             K             ", "              KK         KK              ", "                KKK   KKK                ", "                   KKK                   ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "     A                             A     ", "    A                               A    ", "   A                                 A   ", "                                         ", "                                         ", "                                         ", "                                         ", "                KKKKKKKKK                ", "               K         K               ", "             KK           KK             ", "            K               K            ", "            K               K            ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "            K               K            ", "            K               K            ", "             KK           KK             ", "               K         K               ", "                KKKKKKKKK                ", "                                         ", "                                         ", "                                         ", "                                         ", "   A                                 A   ", "    A                               A    ", "     A                             A     ", "                                         ", "                                         ", "                                         "}, {"                                         ", "       A                         A       ", "      A                           A      ", "     A                             A     ", "    A                               A    ", "   A                                 A   ", "  A                                   A  ", " A                                     A ", "                                         ", "                                         ", "                  KKKKK                  ", "               KKK     KKK               ", "              K           K              ", "             K             K             ", "            K               K            ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "          K                   K          ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "            K               K            ", "             K             K             ", "              K           K              ", "               KKK     KKK               ", "                  KKKKK                  ", "                                         ", "                                         ", " A                                     A ", "  A                                   A  ", "   A                                 A   ", "    A                               A    ", "     A                             A     ", "      A                           A      ", "       A                         A       ", "                                         "}, {"         A                     A         ", "        A                       A        ", "      AA                         AA      ", "     A                             A     ", "    A                               A    ", "   A                                 A   ", "  A                                   A  ", "  A                                   A  ", " A                                     A ", "A                                       A", "                                         ", "                 KKKKKKK                 ", "               KK       KK               ", "              K           K              ", "             K             K             ", "            K               K            ", "            K               K            ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "            K               K            ", "            K               K            ", "             K             K             ", "              K           K              ", "               KK       KK               ", "                 KKKKKKK                 ", "                                         ", "A                                       A", " A                                     A ", "  A                                   A  ", "  A                                   A  ", "   A                                 A   ", "    A                               A    ", "     A                             A     ", "      AA                         AA      ", "        A                       A        ", "         A                     A         "}, {"          AA                 AA          ", "        AA                     AA        ", "       A                         A       ", "     AA                           AA     ", "    A                               A    ", "   A                                 A   ", "   A                                 A   ", "  A                                   A  ", " A                                     A ", " A                                     A ", "A                                       A", "A                  KKK                  A", "                KKK   KKK                ", "               K         K               ", "              K           K              ", "             K             K             ", "            K               K            ", "            K               K            ", "            K               K            ", "           K                 K           ", "           K                 K           ", "           K                 K           ", "            K               K            ", "            K               K            ", "            K               K            ", "             K             K             ", "              K           K              ", "               K         K               ", "                KKK   KKK                ", "A                  KKK                  A", "A                                       A", " A                                     A ", " A                                     A ", "  A                                   A  ", "   A                                 A   ", "   A                                 A   ", "    A                               A    ", "     AA                           AA     ", "       A                         A       ", "        AA                     AA        ", "          AA                 AA          "}, {"          AAA               AAA          ", "         A                     A         ", "       AA                       AA       ", "      A                           A      ", "     A                             A     ", "    A                               A    ", "   A                                 A   ", "  A                                   A  ", "  A                                   A  ", " A                                     A ", "A                                       A", "A                                       A", "A                 KKKKK                 A", "                KKK   KKK                ", "               KK       KK               ", "              K           K              ", "             KK           KK             ", "             K             K             ", "            KK             KK            ", "            K               K            ", "            K               K            ", "            K               K            ", "            KK             KK            ", "             K             K             ", "             KK           KK             ", "              K           K              ", "               KK       KK               ", "                KKK   KKK                ", "A                 KKKKK                 A", "A                                       A", "A                                       A", " A                                     A ", "  A                                   A  ", "  A                                   A  ", "   A                                 A   ", "    A                               A    ", "     A                             A     ", "      A                           A      ", "       AA                       AA       ", "         A                     A         ", "          AAA               AAA          "}, {"           AAA             AAA           ", "         AA                   AA         ", "        A                       A        ", "      AA                         AA      ", "     A                             A     ", "    A                               A    ", "   A                                 A   ", "   A                                 A   ", "  A                                   A  ", " A                                     A ", " A                                     A ", "A                                       A", "A                                       A", "A                  KKK                  A", "                 KKKKKKK                 ", "               KKK     KKK               ", "               K         K               ", "              KK         KK              ", "              K           K              ", "             KK           KK             ", "             KK           KK             ", "             KK           KK             ", "              K           K              ", "              KK         KK              ", "               K         K               ", "               KKK     KKK               ", "                 KKKKKKK                 ", "A                  KKK                  A", "A                                       A", "A                                       A", " A                                     A ", " A                                     A ", "  A                                   A  ", "   A                                 A   ", "   A                                 A   ", "    A                               A    ", "     A                             A     ", "      AA                         AA      ", "        A                       A        ", "         AA                   AA         ", "           AAA             AAA           "}, {"            AAA           AAA            ", "          AA                 AA          ", "        AA                     AA        ", "       A                         A       ", "      H                           H      ", "     H                             H     ", "    H                               H    ", "   A                                 A   ", "  A                                   A  ", "  A                                   A  ", " A        K                   K        A ", " A         K                 K         A ", "A                                       A", "A                                       A", "A                                       A", "                  KKKKK                  ", "                KKKKKKKKK                ", "                KKK   KKK                ", "               KKK     KKK               ", "               KK       KK               ", "               KK       KK               ", "               KK       KK               ", "               KKK     KKK               ", "                KKK   KKK                ", "                KKKKKKKKK                ", "                  KKKKK                  ", "A                                       A", "A                                       A", "A                                       A", " A         K                 K         A ", " A        K                   K        A ", "  A                                   A  ", "  A                                   A  ", "   A                                 A   ", "    H                               H    ", "     H                             H     ", "      H                           H      ", "       A                         A       ", "        AA                     AA        ", "          AA                 AA          ", "            AAA           AAA            "}, {"             AA           AA             ", "           AA               AA           ", "         AA                   AA         ", "        H                       H        ", "      HH                         HH      ", "     H                             H     ", "    H                               H    ", "    H                               H    ", "   H                                 H   ", "  A      KK                   KK      A  ", "  A      KFK                 KFK      A  ", " A        K                   K        A ", " A                                     A ", "A                                       A", "A                                       A", "                                         ", "                                         ", "                   KKK                   ", "                  KKKKK                  ", "                 KKKKKKK                 ", "                 KKKKKKK                 ", "                 KKKKKKK                 ", "                  KKKKK                  ", "                   KKK                   ", "                                         ", "                                         ", "A                                       A", "A                                       A", " A                                     A ", " A        K                   K        A ", "  A      KFK                 KFK      A  ", "  A      KK                   KK      A  ", "   H                                 H   ", "    H                               H    ", "    H                               H    ", "     H                             H     ", "      HH                         HH      ", "        H                       H        ", "         AA                   AA         ", "           AA               AA           ", "             AA           AA             "}, {"               A         A               ", "            AAA           AAA            ", "          AA                 AA          ", "         H                     H         ", "       HH                       HH       ", "      H                           H      ", "     H                             H     ", "    H                               H    ", "    H   KK                     KK   H    ", "   H    KFK                   KFK    H   ", "  A      KK                   KK      A  ", "  A                                   A  ", " A                                     A ", " A                                     A ", " A                                     A ", "A                                       A", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "A                                       A", " A                                     A ", " A                                     A ", " A                                     A ", "  A                                   A  ", "  A      KK                   KK      A  ", "   H    KFK                   KFK    H   ", "    H   KK                     KK   H    ", "    H                               H    ", "     H                             H     ", "      H                           H      ", "       HH                       HH       ", "         H                     H         ", "          AA                 AA          ", "            AAA           AAA            ", "               A         A               "}, {"                                         ", "              AA         AA              ", "           AAA             AAA           ", "          H                   H          ", "        HH                     HH        ", "       H                         H       ", "      HK                         KH      ", "     HKKK                       KKKH     ", "    H  KFK                     KFK  H    ", "    H   KK                     KK   H    ", "   H                                 H   ", "  A                                   A  ", "  A                                   A  ", "  A                                   A  ", " A                                     A ", " A                                     A ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", " A                                     A ", " A                                     A ", "  A                                   A  ", "  A                                   A  ", "  A                                   A  ", "   H                                 H   ", "    H   KK                     KK   H    ", "    H  KFK                     KFK  H    ", "     HKKK                       KKKH     ", "      HK                         KH      ", "       H                         H       ", "        HH                     HH        ", "          H                   H          ", "           AAA             AAA           ", "              AA         AA              ", "                                         "}, {"                                         ", "                A       A                ", "             AAA         AAA             ", "           AA               AA           ", "         HH                   HH         ", "        H                       H        ", "       IK                       KI       ", "      IFK                       KFI      ", "     HKKK                       KKKH     ", "    H                               H    ", "    H                               H    ", "   A                                 A   ", "   A                                 A   ", "  A                                   A  ", "  A                                   A  ", "  A                                   A  ", " A                                     A ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", " A                                     A ", "  A                                   A  ", "  A                                   A  ", "  A                                   A  ", "   A                                 A   ", "   A                                 A   ", "    H                               H    ", "    H                               H    ", "     HKKK                       KKKH     ", "      IFK                       KFI      ", "       IK                       KI       ", "        H                       H        ", "         HH                   HH         ", "           AA               AA           ", "             AAA         AAA             ", "                A       A                ", "                                         "}, {"                                         ", "                                         ", "               AA       AA               ", "            AAA           AAA            ", "          HH                 HH          ", "         H                     H         ", "        H                       H        ", "       IK                       KI       ", "      HK                         KH      ", "     H                             H     ", "    H                               H    ", "    H                               H    ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "  A                                   A  ", "  A                                   A  ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "  A                                   A  ", "  A                                   A  ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "    H                               H    ", "    H                               H    ", "     H                             H     ", "      HK                         KH      ", "       IK                       KI       ", "        H                       H        ", "         H                     H         ", "          HH                 HH          ", "            AAA           AAA            ", "               AA       AA               ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "              AAAA     AAAA              ", "            AA             AA            ", "          HH                 HH          ", "         H                     H         ", "        H                       H        ", "       H                         H       ", "      H                           H      ", "     H                             H     ", "     H                             H     ", "    A                               A    ", "    A                               A    ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "   A                                 A   ", "    A                               A    ", "    A                               A    ", "     H                             H     ", "     H                             H     ", "      H                           H      ", "       H                         H       ", "        H                       H        ", "         H                     H         ", "          HH                 HH          ", "            AA             AA            ", "              AAAA     AAAA              ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "              AAAA     AAAA              ", "            AA             AA            ", "          HH                 HH          ", "         HH                   HH         ", "        HH                     HH        ", "       HH                       HH       ", "      HH                         HH      ", "      H                           H      ", "     A                             A     ", "     A                             A     ", "    A                               A    ", "    A                               A    ", "    A                               A    ", "    A                               A    ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "    A                               A    ", "    A                               A    ", "    A                               A    ", "    A                               A    ", "     A                             A     ", "     A                             A     ", "      H                           H      ", "      HH                         HH      ", "       HH                       HH       ", "        HH                     HH        ", "         HH                   HH         ", "          HH                 HH          ", "            AA             AA            ", "              AAAA     AAAA              ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "              AAAA     AAAA              ", "            AAA           AAA            ", "           AA               AA           ", "          H                   H          ", "         H                     H         ", "        H                       H        ", "       A                         A       ", "      AA                         AA      ", "      A                           A      ", "     AA                           AA     ", "     A                             A     ", "     A                             A     ", "     A                             A     ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "     A                             A     ", "     A                             A     ", "     A                             A     ", "     AA                           AA     ", "      A                           A      ", "      AA                         AA      ", "       A                         A       ", "        H                       H        ", "         H                     H         ", "          H                   H          ", "           AA               AA           ", "            AAA           AAA            ", "              AAAA     AAAA              ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "               AA       AA               ", "             AAA         AAA             ", "           AAA             AAA           ", "          AA                 AA          ", "         AA                   AA         ", "        AA                     AA        ", "        A                       A        ", "       AA                       AA       ", "       A                         A       ", "      AA                         AA      ", "      A                           A      ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "      A                           A      ", "      AA                         AA      ", "       A                         A       ", "       AA                       AA       ", "        A                       A        ", "        AA                     AA        ", "         AA                   AA         ", "          AA                 AA          ", "           AAA             AAA           ", "             AAA         AAA             ", "               AA       AA               ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                A       A                ", "              AA         AA              ", "            AAA           AAA            ", "           AA               AA           ", "          AA                 AA          ", "         AA                   AA         ", "         A                     A         ", "        AA                     AA        ", "        A                       A        ", "       A                         A       ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "       A                         A       ", "        A                       A        ", "        AA                     AA        ", "         A                     A         ", "         AA                   AA         ", "          AA                 AA          ", "           AA               AA           ", "            AAA           AAA            ", "              AA         AA              ", "                A       A                ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "               A         A               ", "             AA           AA             ", "            AAA           AAA            ", "           AAA             AAA           ", "          AAA               AAA          ", "          AA                 AA          ", "         A                     A         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "         A                     A         ", "          AA                 AA          ", "          AAA               AAA          ", "           AAA             AAA           ", "            AAA           AAA            ", "             AA           AA             ", "               A         A               ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                   GGG                   ", "                  GGGGG                  ", "                  GGGGG                  ", "                  GGGGG                  ", "                   GGG                   ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                  GGGGG                  ", "                 GG   GG                 ", "                 G     G                 ", "                 G     G                 ", "                 G     G                 ", "                 GG   GG                 ", "                  GGGGG                  ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                  GGGGG                  ", "                 G     G                 ", "                G       G                ", "                G       G                ", "                G       G                ", "                G       G                ", "                G       G                ", "                 G     G                 ", "                  GGGGG                  ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                   GGG                   ", "                 GG   GG                 ", "                G       G                ", "                G       G                ", "               G         G               ", "               G         G               ", "               G         G               ", "                G       G                ", "                G       G                ", "                 GG   GG                 ", "                   GGG                   ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                   LLL                   ", "                   LLL                   ", "                   III                   ", "                   KKK                   ", "                   KKK                   ", "                   KKK                   ", "                   KKK                   ", "                  GGGGG                  ", "                 G     G                 ", "                G       G                ", "               G         G               ", "               G         G               ", "               G         G               ", "               G         G               ", "               G         G               ", "                G       G                ", "                 G     G                 ", "                  GGGGG                  ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                   L~L                   ", "                   LFL                   ", "                   IGI                   ", "                   KGK                   ", "                   KGK                   ", "                   KGK                   ", "                   KGK                   ", "                  GGGGG                  ", "                 G     G                 ", "                G       G                ", "               G         G               ", "               G         G               ", "               G         G               ", "               G         G               ", "               G         G               ", "                G       G                ", "                 G     G                 ", "                  GGGGG                  ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                   LLL                   ", "                   LLL                   ", "                   III                   ", "                 HHHHHHH                 ", "               HHEEEEEEEHH               ", "              HEEEEEEEEEEEH              ", "             HEEEEEEEEEEEEEH             ", "            HEEEEEEEEEEEEEEEH            ", "            HEEEEEEEEEEEEEEEH            ", "           HEEEEEEEEEEEEEEEEEH           ", "           HEEEEEEEEEEEEEEEEEH           ", "           HEEEEEEEEEEEEEEEEEH           ", "           HEEEEEEEEEEEEEEEEEH           ", "           HEEEEEEEEEEEEEEEEEH           ", "           HEEEEEEEEEEEEEEEEEH           ", "           HEEEEEEEEEEEEEEEEEH           ", "            HEEEEEEEEEEEEEEEH            ", "            HEEEEEEEEEEEEEEEH            ", "             HEEEEEEEEEEEEEH             ", "              HEEEEEEEEEEEH              ", "               HHEEEEEEEHH               ", "                 HHHHHHH                 ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                 HHHHHHH                 ", "               HHDDDDDDDHH               ", "             HHDDDDDDDDDDDHH             ", "            HDDDDDDDDDDDDDDDH            ", "           HDDDDDDDDDDDDDDDDDH           ", "          HDDDDDDDDDDDDDDDDDDDH          ", "          HDDDDDDDDDDDDDDDDDDDH          ", "         HDDDDDDDDDDDDDDDDDDDDDH         ", "         HDDDDDDDDDDDDDDDDDDDDDH         ", "        HDDDDDDDDDDDDDDDDDDDDDDDH        ", "        HDDDDDDDDDDDDDDDDDDDDDDDH        ", "        HDDDDDDDDDDDDDDDDDDDDDDDH        ", "        HDDDDDDDDDDDDDDDDDDDDDDDH        ", "        HDDDDDDDDDDDDDDDDDDDDDDDH        ", "        HDDDDDDDDDDDDDDDDDDDDDDDH        ", "        HDDDDDDDDDDDDDDDDDDDDDDDH        ", "         HDDDDDDDDDDDDDDDDDDDDDH         ", "         HDDDDDDDDDDDDDDDDDDDDDH         ", "          HDDDDDDDDDDDDDDDDDDDH          ", "          HDDDDDDDDDDDDDDDDDDDH          ", "           HDDDDDDDDDDDDDDDDDH           ", "            HDDDDDDDDDDDDDDDH            ", "             HHDDDDDDDDDDDHH             ", "               HHDDDDDDDHH               ", "                 HHHHHHH                 ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                 CCCCCCC                 ", "              CCCBBBBBBBCCC              ", "             CBBBBBBBBBBBBBC             ", "           CCBBBBBBBBBBBBBBBCC           ", "          CBBBBBBBBBBBBBBBBBBBC          ", "          CBBBBBBBBBBBBBBBBBBBC          ", "         CBBBBBBBBBBBBBBBBBBBBBC         ", "        CBBBBBBBBBBBBBBBBBBBBBBBC        ", "        CBBBBBBBBBBBBBBBBBBBBBBBC        ", "        CBBBBBBBBBBBBBBBBBBBBBBBC        ", "       CBBBBBBBBBBBBBBBBBBBBBBBBBC       ", "       CBBBBBBBBBBBBBBBBBBBBBBBBBC       ", "       CBBBBBBBBBBBBBBBBBBBBBBBBBC       ", "       CBBBBBBBBBBBBBBBBBBBBBBBBBC       ", "       CBBBBBBBBBBBBBBBBBBBBBBBBBC       ", "       CBBBBBBBBBBBBBBBBBBBBBBBBBC       ", "       CBBBBBBBBBBBBBBBBBBBBBBBBBC       ", "        CBBBBBBBBBBBBBBBBBBBBBBBC        ", "        CBBBBBBBBBBBBBBBBBBBBBBBC        ", "        CBBBBBBBBBBBBBBBBBBBBBBBC        ", "         CBBBBBBBBBBBBBBBBBBBBBC         ", "          CBBBBBBBBBBBBBBBBBBBC          ", "          CBBBBBBBBBBBBBBBBBBBC          ", "           CCBBBBBBBBBBBBBBBCC           ", "             CBBBBBBBBBBBBBC             ", "              CCCBBBBBBBCCC              ", "                 CCCCCCC                 ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                 JJJJJJJ                 ", "              JJJJJJJJJJJJJ              ", "            JJJJJJJJJJJJJJJJJ            ", "           JJJJJJJJJJJJJJJJJJJ           ", "          JJJJJJJJJJJJJJJJJJJJJ          ", "         JJJJJJJJJJJJJJJJJJJJJJJ         ", "        JJJJJJJJJJJJJJJJJJJJJJJJJ        ", "        JJJJJJJJJJJJJJJJJJJJJJJJJ        ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "        JJJJJJJJJJJJJJJJJJJJJJJJJ        ", "        JJJJJJJJJJJJJJJJJJJJJJJJJ        ", "         JJJJJJJJJJJJJJJJJJJJJJJ         ", "          JJJJJJJJJJJJJJJJJJJJJ          ", "           JJJJJJJJJJJJJJJJJJJ           ", "            JJJJJJJJJJJJJJJJJ            ", "              JJJJJJJJJJJJJ              ", "                 JJJJJJJ                 ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                 JJJJJJJ                 ", "              JJJJJJJJJJJJJ              ", "            JJJJJJJJJJJJJJJJJ            ", "           JJJJJJJJJJJJJJJJJJJ           ", "          JJJJJJJJJJJJJJJJJJJJJ          ", "         JJJJJJJJJJJJJJJJJJJJJJJ         ", "        JJJJJJJJJJJJJJJJJJJJJJJJJ        ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "        JJJJJJJJJJJJJJJJJJJJJJJJJ        ", "         JJJJJJJJJJJJJJJJJJJJJJJ         ", "          JJJJJJJJJJJJJJJJJJJJJ          ", "           JJJJJJJJJJJJJJJJJJJ           ", "            JJJJJJJJJJJJJJJJJ            ", "              JJJJJJJJJJJJJ              ", "                 JJJJJJJ                 ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}, {"                                         ", "                                         ", "                                         ", "                                         ", "                                         ", "                 JJJJJJJ                 ", "              JJJJJJJJJJJJJ              ", "            JJJJJJJJJJJJJJJJJ            ", "           JJJJJJJJJJJJJJJJJJJ           ", "          JJJJJJJJJJJJJJJJJJJJJ          ", "         JJJJJJJJJJJJJJJJJJJJJJJ         ", "        JJJJJJJJJJJJJJJJJJJJJJJJJ        ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "     JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ     ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "      JJJJJJJJJJJJJJJJJJJJJJJJJJJJJ      ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "       JJJJJJJJJJJJJJJJJJJJJJJJJJJ       ", "        JJJJJJJJJJJJJJJJJJJJJJJJJ        ", "         JJJJJJJJJJJJJJJJJJJJJJJ         ", "          JJJJJJJJJJJJJJJJJJJJJ          ", "           JJJJJJJJJJJJJJJJJJJ           ", "            JJJJJJJJJJJJJJJJJ            ", "              JJJJJJJJJJJJJ              ", "                 JJJJJJJ                 ", "                                         ", "                                         ", "                                         ", "                                         ", "                                         "}};
    }
}

