/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.IActionHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.util.item.AEItemStack;
import com.Nxer.TwistSpaceTechnology.common.GTCMItemList;
import com.Nxer.TwistSpaceTechnology.common.api.IAlternativeItem;
import com.Nxer.TwistSpaceTechnology.common.item.ItemActualPattern;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.TT_MultiMachineBase_EM;
import com.Nxer.TwistSpaceTechnology.common.machine.singleBlock.hatch.TST_PatternAccessHatch;
import com.Nxer.TwistSpaceTechnology.config.Config;
import com.Nxer.TwistSpaceTechnology.system.ExtremeCrafting.ExtremeCraftRecipe;
import com.Nxer.TwistSpaceTechnology.system.ExtremeCrafting.ExtremeCraftRecipeHandler;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import com.Nxer.TwistSpaceTechnology.util.rewrites.TST_ItemID;
import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tectech.thing.block.BlockQuantumGlass;
import tectech.thing.casing.TTCasingsContainer;

public class TST_MegaCraftingCenter
extends TT_MultiMachineBase_EM
implements ICraftingProvider,
IActionHost,
IGridProxyable,
ISurvivalConstructable {
    protected Collection<ItemStack> internalPatterns = new ArrayList<ItemStack>();
    protected Collection<ICraftingPatternDetails> patternDetails = new HashSet<ICraftingPatternDetails>();
    protected Collection<ICraftingPatternDetails> actualPatternDetails = new HashSet<ICraftingPatternDetails>();
    private final HashMap<ICraftingPatternDetails, Long> cachedOutput = new HashMap();
    protected int magnification = 1;
    @Nullable
    private AENetworkProxy gridProxy;
    protected boolean toReturnPatterns = false;
    protected static IStructureDefinition<TST_MegaCraftingCenter> STRUCTURE_DEFINITION;
    private static IHatchElement<TST_MegaCraftingCenter> AccessHatchElement;
    public ArrayList<TST_PatternAccessHatch> mPatternAccessHatch = new ArrayList();
    protected static final int SYNC_WINDOW_MAGNIFICATION_ID = 10114;

    public TST_MegaCraftingCenter(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    protected TST_MegaCraftingCenter(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_MegaCraftingCenter(this.mName);
    }

    public static ItemStack[] convertAEToMC(IAEItemStack ... STACK) {
        return (ItemStack[])Arrays.stream(STACK).filter(Objects::nonNull).map(IAEItemStack::getItemStack).toArray(ItemStack[]::new);
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean checkPatternRecipe(ExtremeCraftRecipe r, ItemStack[] in, ItemStack out) {
        if (!r.outputItem.func_77969_a(out)) {
            return false;
        }
        int magnification = out.field_77994_a / r.outputItem.field_77994_a;
        if (magnification * r.outputItem.field_77994_a != out.field_77994_a) {
            return false;
        }
        if (r.useAlternativeItem()) {
            HashMap<TST_ItemID, Long> itemCollecting = new HashMap<TST_ItemID, Long>();
            HashMap<IAlternativeItem, Long> oreDictCollecting = new HashMap<IAlternativeItem, Long>();
            block0: for (ItemStack itemStack : in) {
                for (TST_ItemID id : r.inputItemsGeneral.keySet()) {
                    if (!id.equalItemStack(itemStack)) continue;
                    itemCollecting.merge(id, Long.valueOf(itemStack.field_77994_a), Long::sum);
                    continue block0;
                }
                for (IAlternativeItem od : r.inputItemsAlts.keySet()) {
                    if (!od.containsItem(itemStack)) continue;
                    oreDictCollecting.merge(od, Long.valueOf(itemStack.field_77994_a), Long::sum);
                    continue block0;
                }
                return false;
            }
            for (Map.Entry<TST_ItemID, Integer> entry : r.inputItemsGeneral.entrySet()) {
                if ((long)magnification == (Long)itemCollecting.get((Object)entry.getKey()) / (long)entry.getValue().intValue()) continue;
                return false;
            }
            for (Map.Entry<IAlternativeItem, Integer> entry : r.inputItemsAlts.entrySet()) {
                if ((long)magnification == (Long)oreDictCollecting.get(entry.getKey()) / (long)entry.getValue().intValue()) continue;
                return false;
            }
        } else {
            void var7_17;
            HashMap<TST_ItemID, Long> patternCollecting = new HashMap<TST_ItemID, Long>();
            ItemStack[] itemStackArray = in;
            int n = itemStackArray.length;
            boolean bl = false;
            while (var7_17 < n) {
                TST_ItemID id22;
                ItemStack itemStack;
                block12: {
                    itemStack = itemStackArray[var7_17];
                    for (TST_ItemID id22 : r.inputItemsGeneral.keySet()) {
                        if (!id22.equalItemStack(itemStack)) continue;
                        break block12;
                    }
                    return false;
                }
                patternCollecting.merge(id22, Long.valueOf(itemStack.field_77994_a), Long::sum);
                ++var7_17;
            }
            for (Map.Entry entry : r.inputItemsGeneral.entrySet()) {
                if ((long)magnification == (Long)patternCollecting.get(entry.getKey()) / (long)((Integer)entry.getValue()).intValue()) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static ICraftingPatternDetails checkPattern(ItemStack pattern) {
        if (pattern == null || pattern.field_77994_a < 1) {
            return null;
        }
        Item item = pattern.func_77973_b();
        if (item instanceof ICraftingPatternItem) {
            ICraftingPatternItem patternItem = (ICraftingPatternItem)item;
            ICraftingPatternDetails d = patternItem.getPatternForItem(pattern, null);
            if (d == null) {
                return null;
            }
            if (d.isCraftable()) {
                return d;
            }
            IAEItemStack[] dOutputs = d.getOutputs();
            if (dOutputs == null || dOutputs.length != 1 || dOutputs[0] == null) {
                return null;
            }
            Collection<ExtremeCraftRecipe> possibleRecipes = ExtremeCraftRecipeHandler.extremeCraftRecipesMap.get((Object)TST_ItemID.create(dOutputs[0]));
            if (possibleRecipes == null || possibleRecipes.isEmpty()) {
                return null;
            }
            ItemStack[] dInputs = TST_MegaCraftingCenter.convertAEToMC(d.getInputs());
            if (!TstUtils.areItemsValid(dInputs)) {
                return null;
            }
            ItemStack oItems = dOutputs[0].getItemStack();
            if (oItems == null || oItems.func_77973_b() == null || oItems.field_77994_a < 1) {
                return null;
            }
            for (ExtremeCraftRecipe r : possibleRecipes) {
                if (!TST_MegaCraftingCenter.checkPatternRecipe(r, dInputs, oItems)) continue;
                return d;
            }
            return null;
        }
        return null;
    }

    public void recalculatePatterns() {
        this.actualPatternDetails.clear();
        for (ICraftingPatternDetails origin : this.patternDetails) {
            this.actualPatternDetails.add(new ActualPattern(origin, this.magnification));
        }
    }

    public Collection<ItemStack> getInternalPatterns() {
        return ImmutableList.copyOf(this.internalPatterns);
    }

    public ItemStack extractPattern(@Nonnull AEItemStack request) {
        if (this.mMaxProgresstime > 0) {
            return null;
        }
        if (request.getStackSize() > 1L) {
            return null;
        }
        if (this.internalPatterns.removeIf(arg_0 -> ((AEItemStack)request).isSameType(arg_0))) {
            ItemStack stack = request.getItemStack();
            Item item = stack.func_77973_b();
            if (item instanceof ICraftingPatternItem) {
                ICraftingPatternItem pattern = (ICraftingPatternItem)item;
                this.patternDetails.remove(pattern.getPatternForItem(stack, this.getBaseMetaTileEntity().getWorld()));
            }
            this.flush();
            return request.getItemStack();
        }
        return null;
    }

    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("magnification", this.magnification);
        tag.func_74768_a("patternAmount", this.patternDetails.size());
    }

    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currentTip.add(TextEnums.tr("MegaCraftingCenter.waila.ForceRunningMagnification") + " : " + tag.func_74762_e("magnification"));
        currentTip.add(TextEnums.tr("MegaCraftingCenter.waila.PatternAmount") + " : " + tag.func_74762_e("patternAmount"));
    }

    public String[] getInfoData() {
        if (this.patternDetails.isEmpty()) {
            return super.getInfoData();
        }
        ArrayList<String> items = new ArrayList<String>();
        for (ICraftingPatternDetails d : this.patternDetails) {
            items.add(d.getOutputs()[0].getItemStack().func_82833_r());
        }
        int rows = (int)Math.ceil((double)items.size() / 4.0);
        String[] origin = super.getInfoData();
        String[] ret = new String[origin.length + rows + 1];
        System.arraycopy(origin, 0, ret, 0, origin.length);
        ret[origin.length] = TextEnums.tr("MegaCraftingCenter.info.InternalPatterns");
        StringBuilder t = new StringBuilder();
        int signal = 0;
        int row = origin.length + 1;
        for (String s : items) {
            t.append(s).append("; ");
            if (++signal != 4) continue;
            signal = 0;
            ret[row] = t.toString();
            t = new StringBuilder();
            ++row;
        }
        if (signal != 0) {
            ret[row] = t.toString();
        }
        return ret;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("toReturnPatterns", this.toReturnPatterns);
        aNBT.func_74768_a("magnification", this.magnification);
        if (!this.internalPatterns.isEmpty()) {
            NBTTagList l = new NBTTagList();
            for (ItemStack i : this.internalPatterns) {
                l.func_74742_a((NBTBase)i.func_77955_b(new NBTTagCompound()));
            }
            aNBT.func_74782_a("internalPatterns", (NBTBase)l);
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        NBTTagList l;
        super.loadNBTData(aNBT);
        this.toReturnPatterns = aNBT.func_74767_n("toReturnPatterns");
        this.magnification = aNBT.func_74762_e("magnification");
        if (this.magnification < 1) {
            this.magnification = 1;
        }
        if ((l = aNBT.func_150295_c("internalPatterns", 10)) != null && l.func_74745_c() > 0) {
            this.internalPatterns.clear();
            this.patternDetails.clear();
            for (int i = 0; i < l.func_74745_c(); ++i) {
                ItemStack pattern = ItemStack.func_77949_a((NBTTagCompound)l.func_150305_b(i));
                ICraftingPatternDetails d = TST_MegaCraftingCenter.checkPattern(pattern);
                if (d == null || this.patternDetails.contains(d)) continue;
                this.patternDetails.add(d);
                this.internalPatterns.add(pattern);
            }
        }
        this.flush();
    }

    protected ArrayList<ItemStack> checkPatternInput() {
        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
        ArrayList inputs = this.getStoredInputs();
        if (inputs.isEmpty()) {
            return l;
        }
        for (ItemStack in : inputs) {
            ItemStack refund = this.tryInjectPattern(in);
            if (refund == null) continue;
            l.add(refund);
        }
        this.updateSlots();
        return l;
    }

    @Nullable
    public ItemStack tryInjectPattern(ItemStack in) {
        ItemStack refund = null;
        ICraftingPatternDetails d = TST_MegaCraftingCenter.checkPattern(in);
        if (d != null && !this.patternDetails.contains(d)) {
            this.patternDetails.add(d);
            if (in.field_77994_a > 1) {
                refund = GTUtility.copyAmountUnsafe((int)(in.field_77994_a - 1), (ItemStack)in);
                in.field_77994_a = 1;
            }
            this.internalPatterns.add(in.func_77946_l());
            this.flush();
            in.field_77994_a = 0;
            return refund;
        }
        refund = in.func_77946_l();
        in.field_77994_a = 0;
        return refund;
    }

    protected void flush() {
        this.recalculatePatterns();
        if (this.getProxy().isActive()) {
            try {
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getProxy().getNode()));
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        this.notifyAccessHatch();
    }

    @NotNull
    protected CheckRecipeResult checkProcessing_EM() {
        if (this.toReturnPatterns) {
            this.toReturnPatterns = false;
            this.mOutputItems = this.internalPatterns.toArray(new ItemStack[0]);
            this.internalPatterns.clear();
            this.patternDetails.clear();
            this.flush();
            this.mMaxProgresstime = Config.TickEveryProcess_MegaCraftingCenter;
            return CheckRecipeResultRegistry.SUCCESSFUL;
        }
        ArrayList<ItemStack> additionalOutput = this.checkPatternInput();
        for (Map.Entry<ICraftingPatternDetails, Long> pair : this.cachedOutput.entrySet()) {
            ICraftingPatternDetails pattern = pair.getKey();
            ItemStack outputStack = pattern.getOutputs()[0].getItemStack().func_77946_l();
            long scale = pair.getValue();
            TstUtils.addStacksToList(additionalOutput, outputStack, (long)outputStack.field_77994_a * scale);
            Arrays.stream(pattern.getInputs()).map(IAEItemStack::getItemStack).filter(stack -> stack.func_77973_b() != null && stack.func_77973_b().hasContainerItem(stack)).map(stack -> stack.func_77973_b().getContainerItem(stack)).filter(Objects::nonNull).forEach(stack -> TstUtils.addStacksToList(additionalOutput, stack, (long)stack.field_77994_a * scale));
        }
        if (additionalOutput.isEmpty()) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        this.mOutputItems = additionalOutput.toArray(new ItemStack[0]);
        this.mMaxProgresstime = Config.TickEveryProcess_MegaCraftingCenter;
        this.mProgresstime = 0;
        this.cachedOutput.clear();
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aStack) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (this.mMaxProgresstime > 0) {
                GTUtility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)"MegaCraftingCenter.onScrewdriverRightClick.failed"));
                return;
            }
            this.toReturnPatterns = true;
            GTUtility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)"MegaCraftingCenter.onScrewdriverRightClick.success"));
        }
    }

    public void provideCrafting(@NotNull ICraftingProviderHelper craftingTracker) {
        AENetworkProxy proxy = this.getProxy();
        if (proxy != null && proxy.isReady()) {
            for (ICraftingPatternDetails details : this.actualPatternDetails) {
                craftingTracker.addCraftingOption((ICraftingMedium)this, details);
            }
        }
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        return this.cachedOutput.merge(patternDetails, 1L, Long::sum) >= 1L;
    }

    public RecipeMap<?> getRecipeMap() {
        return ExtremeCraftRecipeHandler.visualExtremeCraftRecipes;
    }

    public void onFirstTick_EM(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick_EM(aBaseMetaTileEntity);
        this.getProxy().onReady();
    }

    public AENetworkProxy getProxy() {
        IGregTechTileEntity mte;
        if (this.gridProxy == null && (mte = this.getBaseMetaTileEntity()) instanceof IGridProxyable) {
            this.gridProxy = new AENetworkProxy((IGridProxyable)this, "proxy", GTCMItemList.ExtremeCraftCenter.get(1, new Object[0]), true);
            this.gridProxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            if (mte.getWorld() != null) {
                this.gridProxy.setOwner(mte.getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName()));
            }
        }
        return this.gridProxy;
    }

    @Nullable
    public IGridNode getGridNode(@Nullable ForgeDirection dir) {
        AENetworkProxy proxy = this.getProxy();
        return proxy != null ? proxy.getNode() : null;
    }

    public void securityBreak() {
        this.getBaseMetaTileEntity().disableWorking();
    }

    protected boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        this.mPatternAccessHatch.clear();
        this.maintenance_EM();
        if (this.structureCheck_EM("MAIN", 3, 3, 0)) {
            if (this.mPatternAccessHatch.size() > 1) {
                this.mPatternAccessHatch.clear();
                return false;
            }
            return !this.mOutputBusses.isEmpty();
        }
        return false;
    }

    protected void maintenance_EM() {
        this.mWrench = true;
        this.mScrewdriver = true;
        this.mSoftMallet = true;
        this.mHardHammer = true;
        this.mSolderingTool = true;
        this.mCrowbar = true;
    }

    @NotNull
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this.getBaseMetaTileEntity().getWorld(), this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord());
    }

    @Nullable
    public IGridNode getActionableNode() {
        AENetworkProxy proxy = this.getProxy();
        return proxy != null ? proxy.getNode() : null;
    }

    public boolean isBusy() {
        return false;
    }

    public IStructureDefinition<TST_MegaCraftingCenter> getStructure_EM() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("MAIN", StructureUtility.transpose((String[][])new String[][]{{"BBBBBBB", "BEEEEEB", "BEEEEEB", "BEEEEEB", "BEEEEEB", "BEEEEEB", "BBBBBBB"}, {"BEEEEEB", "E     E", "E     E", "E     E", "E     E", "E     E", "BEEEEEB"}, {"BEEEEEB", "E     E", "E     E", "E     E", "E     E", "E     E", "BEEEEEB"}, {"BEE~EEB", "E     E", "E     E", "E     E", "E     E", "E     E", "BEEEEEB"}, {"BEEEEEB", "E     E", "E     E", "E     E", "E     E", "E     E", "BEEEEEB"}, {"BEEEEEB", "E     E", "E     E", "E     E", "E     E", "E     E", "BEEEEEB"}, {"BBBBBBB", "BEEEEEB", "BEEEEEB", "BEEEEEB", "BEEEEEB", "BEEEEEB", "BBBBBBB"}})).addElement('B', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.OutputBus, AccessHatchElement}).adder(TST_MegaCraftingCenter::superAddToMachineList).casingIndex(1036).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)4)})).addElement('E', StructureUtility.ofBlock((Block)BlockQuantumGlass.INSTANCE, (int)0)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece("MAIN", stackSize, hintsOnly, 3, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivialBuildPiece("MAIN", stackSize, 3, 3, 0, elementBudget, env, true);
    }

    protected boolean supportsCraftingMEBuffer() {
        return false;
    }

    public final boolean superAddToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (this.addAccessHatchToMachineList(aTileEntity, aBaseCasingIndex)) {
            return true;
        }
        return super.addToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public final boolean addAccessHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof TST_PatternAccessHatch) {
            TST_PatternAccessHatch pa = (TST_PatternAccessHatch)aMetaTileEntity;
            this.mPatternAccessHatch.add(pa);
            pa.bind(this);
            pa.updateTexture(aBaseCasingIndex);
            return true;
        }
        return false;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        buildContext.addSyncedWindow(10114, this::createMagnificationConfigurationWindow);
        builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(10114);
            }
        }).setSize(16, 16).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GTUITextures.BUTTON_STANDARD);
            ret.add(GTUITextures.OVERLAY_BUTTON_CYCLIC);
            return ret.toArray(new IDrawable[0]);
        }).addTooltip(TextEnums.tr("MegaCraftingCenter.UI.MagnificationInfoMenuButton.name")).setPos(174, 97));
    }

    protected ModularWindow createMagnificationConfigurationWindow(EntityPlayer player) {
        ModularWindow.Builder builder = ModularWindow.builder((int)240, (int)80);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        ((ModularWindow.Builder)builder.widget(TextWidget.localised((String)"MegaCraftingCenter.UI.Magnification.ConfigurationDescription.text", (Object[])new Object[0]).setPos(20, 10).setSize(200, 14))).widget(new TextFieldWidget().setSetterInt(val -> {
            this.magnification = val;
            this.flush();
        }).setGetterInt(() -> this.magnification).setNumbers(1, Config.MaxMagnification_MegaCraftingCenter).setOnScrollNumbers(1, 64, 2048).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(60, 18).setPos(100, 36).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}));
        return builder.build();
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][12], TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_DTPF_ON).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FUSION1_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][12], TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_DTPF_OFF).extFacing().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][12]};
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextEnums.tr("tst.megacraftingcenter.machinetype")).addInfo(TextEnums.tr("tst.megacraftingcenter.desc.firstWords")).addInfo(TextEnums.tr("tst.megacraftingcenter.desc.0")).addInfo(TextEnums.tr("tst.megacraftingcenter.desc.1")).addInfo(TextEnums.tr("tst.megacraftingcenter.desc.2")).addInfo(TextEnums.tr("tst.megacraftingcenter.desc.3")).addInfo(TextEnums.tr("tst.megacraftingcenter.desc.4")).addInfo(TextEnums.tr("tst.megacraftingcenter.desc.5")).addInfo(TextEnums.tr("tst.megacraftingcenter.desc.6")).addInfo(TextEnums.tr("tst.megacraftingcenter.desc.7")).addInfo(TextEnums.tr("tst.megacraftingcenter.desc.onScrewDriverRightClick")).addInfo(TextLocalization.Text_SeparatingLine).addInfo(TextEnums.MoreInfoCheckingInScanner.getText()).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    public void notifyAccessHatch() {
        this.mPatternAccessHatch.forEach(TST_PatternAccessHatch::onChange);
    }

    static {
        AccessHatchElement = new IHatchElement<TST_MegaCraftingCenter>(){

            public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
                return ImmutableList.of(TST_PatternAccessHatch.class);
            }

            public IGTHatchAdder<? super TST_MegaCraftingCenter> adder() {
                return TST_MegaCraftingCenter::addAccessHatchToMachineList;
            }

            public String name() {
                return "PatternAccessHatch";
            }

            public long count(TST_MegaCraftingCenter t) {
                return t.mPatternAccessHatch.size();
            }
        };
    }

    public static class ActualPattern
    implements ICraftingPatternDetails {
        protected ItemStack patternItem = new ItemStack((Block)Blocks.field_150480_ab);
        protected IAEItemStack[] inputs = new IAEItemStack[0];
        protected IAEItemStack[] outputs = new IAEItemStack[0];
        protected boolean canSubstitute = false;
        protected int priority = 0;
        public ICraftingPatternDetails originPattern;
        public int multiplier;

        private ActualPattern() {
        }

        public ActualPattern(ICraftingPatternDetails origin, int multiplier) {
            TST_ItemID itemID;
            long amount;
            this.originPattern = origin;
            this.multiplier = multiplier;
            this.patternItem = origin.getPattern();
            this.canSubstitute = origin.canSubstitute();
            this.priority = origin.getPriority();
            ItemStack[] originInputs = TST_MegaCraftingCenter.convertAEToMC(origin.getCondensedInputs());
            ItemStack[] originOutputs = TST_MegaCraftingCenter.convertAEToMC(origin.getCondensedOutputs());
            HashMap<TST_ItemID, Long> inputs = new HashMap<TST_ItemID, Long>();
            HashMap<TST_ItemID, Long> outputs = new HashMap<TST_ItemID, Long>();
            for (ItemStack itemStack : originInputs) {
                inputs.merge(TST_ItemID.create(itemStack), Long.valueOf(itemStack.field_77994_a), Long::sum);
            }
            for (ItemStack itemStack : originOutputs) {
                outputs.merge(TST_ItemID.create(itemStack), Long.valueOf(itemStack.field_77994_a), Long::sum);
            }
            ArrayList<AEItemStack> actualInputs = new ArrayList<AEItemStack>();
            ArrayList<AEItemStack> actualOutputs = new ArrayList<AEItemStack>();
            for (Map.Entry entry : inputs.entrySet()) {
                amount = (Long)entry.getValue() * (long)multiplier;
                if (amount <= Integer.MAX_VALUE) {
                    actualInputs.add(AEItemStack.create((ItemStack)((TST_ItemID)((Object)entry.getKey())).getItemStack((int)amount)));
                    continue;
                }
                itemID = (TST_ItemID)((Object)entry.getKey());
                while (amount > Integer.MAX_VALUE) {
                    actualInputs.add(AEItemStack.create((ItemStack)itemID.getItemStack(Integer.MAX_VALUE)));
                    amount -= Integer.MAX_VALUE;
                }
                if (amount < 1L) continue;
                actualInputs.add(AEItemStack.create((ItemStack)itemID.getItemStack((int)amount)));
            }
            for (Map.Entry entry : outputs.entrySet()) {
                amount = (Long)entry.getValue() * (long)multiplier;
                if (amount <= Integer.MAX_VALUE) {
                    actualOutputs.add(AEItemStack.create((ItemStack)((TST_ItemID)((Object)entry.getKey())).getItemStack((int)amount)));
                    continue;
                }
                itemID = (TST_ItemID)((Object)entry.getKey());
                while (amount > Integer.MAX_VALUE) {
                    actualOutputs.add(AEItemStack.create((ItemStack)itemID.getItemStack(Integer.MAX_VALUE)));
                    amount -= Integer.MAX_VALUE;
                }
                if (amount < 1L) continue;
                actualOutputs.add(AEItemStack.create((ItemStack)itemID.getItemStack((int)amount)));
            }
            this.inputs = actualInputs.toArray(new IAEItemStack[0]);
            this.outputs = actualOutputs.toArray(new IAEItemStack[0]);
        }

        public ItemStack getPattern() {
            return ItemActualPattern.getStackFromPattern(this);
        }

        public IAEItemStack[] getInputs() {
            return this.inputs;
        }

        public IAEItemStack[] getCondensedInputs() {
            return this.inputs;
        }

        public IAEItemStack[] getCondensedOutputs() {
            return this.outputs;
        }

        public IAEItemStack[] getOutputs() {
            return this.outputs;
        }

        public boolean canSubstitute() {
            return this.canSubstitute;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ActualPattern other = (ActualPattern)obj;
            if (this.originPattern != null && other.originPattern != null) {
                return this.originPattern.equals(other.originPattern) && this.multiplier == other.multiplier;
            }
            return false;
        }

        public int hashCode() {
            if (this.originPattern == null) {
                return 0;
            }
            return this.originPattern.hashCode() * 31 + this.multiplier;
        }

        public boolean isCraftable() {
            return false;
        }

        public ItemStack getOutput(InventoryCrafting craftingInv, World world) {
            return null;
        }

        public boolean isValidItemForSlot(int slotIndex, ItemStack itemStack, World world) {
            return false;
        }
    }
}

