/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.common.machine.ValueEnum;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.processingLogics.TstProcessingLogic;
import com.Nxer.TwistSpaceTechnology.config.Config;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.TstSharedLocalization;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IRecipeLockable;
import gregtech.api.interfaces.tileentity.IVoidable;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.misc.WirelessNetworkManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import tectech.thing.block.BlockQuantumGlass;
import tectech.thing.casing.TTCasingsContainer;

public class TST_HephaestusAtelier
extends GTCM_MultiMachineBase<TST_HephaestusAtelier> {
    protected static final BigInteger CONSUME_EU_PER_SMELTING = BigInteger.valueOf(Config.ConsumeEuPerSmelting_HephaestusAtelier);
    protected int coilTier = 0;
    protected int maxProcessNormalModeFurnace = 0;
    protected long maxEut = 0L;
    protected UUID ownerUUID;
    protected boolean startRecipeProcessing = false;
    private final int horizontalOffSet = 16;
    private final int verticalOffSet = 5;
    private final int depthOffSet = 0;
    private static final String STRUCTURE_PIECE_MAIN = "mainHephaestusAtelier";
    private static IStructureDefinition<TST_HephaestusAtelier> STRUCTURE_DEFINITION = null;

    public TST_HephaestusAtelier(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_HephaestusAtelier(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_HephaestusAtelier(this.mName);
    }

    @Override
    public int totalMachineMode() {
        return 2;
    }

    @Override
    public void setMachineModeIcons() {
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_LPF_METAL);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_STEAM);
    }

    @Override
    public String getMachineModeName(int mode) {
        return StatCollector.func_74838_a((String)("HephaestusAtelier.modeMsg." + mode));
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("mode", (byte)this.machineMode);
        aNBT.func_74768_a("coilTier", this.coilTier);
        aNBT.func_74768_a("maxProcessNormalModeFurnace", this.maxProcessNormalModeFurnace);
        aNBT.func_74772_a("maxEut", this.maxEut);
        aNBT.func_74757_a("startRecipeProcessing", this.startRecipeProcessing);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.machineMode = aNBT.func_74771_c("mode");
        this.coilTier = aNBT.func_74762_e("coilTier");
        this.maxProcessNormalModeFurnace = aNBT.func_74762_e("maxProcessNormalModeFurnace");
        this.maxEut = aNBT.func_74763_f("maxEut");
        this.startRecipeProcessing = aNBT.func_74767_n("startRecipeProcessing");
    }

    @Override
    public String[] getInfoData() {
        String[] ret;
        String[] origin = super.getInfoData();
        if (this.coilTier > 1) {
            ret = new String[origin.length + 2];
            System.arraycopy(origin, 0, ret, 0, origin.length);
            ret[origin.length - 1] = TstSharedLocalization.MachineInfo.coilTier(this.coilTier);
            ret[origin.length] = "" + EnumChatFormatting.RED + EnumChatFormatting.BOLD + TextLocalization.Info_Wireless_mode_enabled;
        } else {
            ret = new String[origin.length + 1];
            System.arraycopy(origin, 0, ret, 0, origin.length);
            ret[origin.length] = TstSharedLocalization.MachineInfo.coilTier(this.coilTier);
        }
        return ret;
    }

    protected boolean isWirelessMode() {
        return this.coilTier > 1;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new TstProcessingLogic(){

            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@Nonnull GTRecipe recipe) {
                return TST_HephaestusAtelier.this.isWirelessMode() ? OverclockCalculator.ofNoOverclock((GTRecipe)recipe) : super.createOverclockCalculator(recipe);
            }
        }.setMaxParallelSupplier(() -> this.getLimitedMaxParallel()).enablePerfectOverclock();
    }

    @Override
    protected void setupProcessingLogic(ProcessingLogic logic) {
        logic.clear();
        logic.setMachine((IVoidable)this);
        logic.setRecipeMapSupplier(this::getRecipeMap);
        logic.setVoidProtection(this.protectsExcessItem(), this.protectsExcessFluid());
        logic.setBatchSize(this.isBatchModeEnabled() ? this.getMaxBatchSize() : 1);
        logic.setRecipeLocking((IRecipeLockable)this, this.isRecipeLockingEnabled());
        logic.setAvailableVoltage(this.isWirelessMode() ? Long.MAX_VALUE : this.getMaxInputEu());
        logic.setAvailableAmperage(1L);
        logic.setAmperageOC(true);
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        this.lEUt = 0L;
        return this.machineMode == 1 ? this.checkProcessingAlloySmelter() : this.checkProcessingFurnace();
    }

    public CheckRecipeResult checkProcessingAlloySmelter() {
        this.setupProcessingLogic(this.processingLogic);
        return this.isWirelessMode() ? this.wirelessAlloySmelter() : this.normalAlloySmelter();
    }

    public CheckRecipeResult normalAlloySmelter() {
        CheckRecipeResult result = this.doCheckRecipe();
        this.updateSlots();
        if (!result.wasSuccessful()) {
            return result;
        }
        this.mEfficiency = 10000;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = this.processingLogic.getDuration();
        this.setEnergyUsage(this.processingLogic);
        this.mOutputItems = this.processingLogic.getOutputItems();
        this.mOutputFluids = this.processingLogic.getOutputFluids();
        return result;
    }

    public CheckRecipeResult wirelessAlloySmelter() {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        long usedEU = 0L;
        CheckRecipeResult powerOff = CheckRecipeResultRegistry.SUCCESSFUL;
        while (true) {
            this.tryStartRecipeProcessing();
            CheckRecipeResult r = this.doCheckRecipe();
            if (!r.wasSuccessful()) break;
            if (Long.MAX_VALUE / this.processingLogic.getCalculatedEut() <= (long)this.processingLogic.getDuration()) {
                BigInteger consumeEU = BigInteger.valueOf(this.processingLogic.getCalculatedEut()).multiply(BigInteger.valueOf(this.processingLogic.getDuration()));
                if (!WirelessNetworkManager.addEUToGlobalEnergyMap((UUID)this.ownerUUID, (BigInteger)consumeEU.multiply(TstUtils.NEGATIVE_ONE))) {
                    powerOff = CheckRecipeResultRegistry.insufficientPower((long)consumeEU.longValue());
                    break;
                }
            } else {
                long costEU = this.processingLogic.getCalculatedEut() * (long)this.processingLogic.getDuration();
                if (Long.MAX_VALUE - costEU <= usedEU) {
                    BigInteger consumeEU = BigInteger.valueOf(costEU).add(BigInteger.valueOf(usedEU));
                    usedEU = 0L;
                    if (!WirelessNetworkManager.addEUToGlobalEnergyMap((UUID)this.ownerUUID, (BigInteger)consumeEU.multiply(TstUtils.NEGATIVE_ONE))) {
                        powerOff = CheckRecipeResultRegistry.insufficientPower((long)consumeEU.longValue());
                        break;
                    }
                } else {
                    usedEU += costEU;
                }
            }
            outputs.addAll(Arrays.asList(this.processingLogic.getOutputItems()));
            this.endRecipeProcessing();
        }
        this.updateSlots();
        if (outputs.isEmpty()) {
            return powerOff.wasSuccessful() ? CheckRecipeResultRegistry.NO_RECIPE : powerOff;
        }
        if (usedEU > 0L && !WirelessNetworkManager.addEUToGlobalEnergyMap((UUID)this.ownerUUID, (long)(-usedEU))) {
            return CheckRecipeResultRegistry.insufficientPower((long)usedEU);
        }
        this.mOutputItems = outputs.toArray(new ItemStack[0]);
        this.mEfficiency = 10000;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = this.coilTier > 2 ? ValueEnum.DurationPerProcessing_T3Coil_Wireless_HephaestusAtelier : ValueEnum.DurationPerProcessing_T2Coil_Wireless_HephaestusAtelier;
        return powerOff;
    }

    protected void tryStartRecipeProcessing() {
        if (!this.startRecipeProcessing) {
            this.startRecipeProcessing();
        }
    }

    public void startRecipeProcessing() {
        this.startRecipeProcessing = true;
        super.startRecipeProcessing();
    }

    public void endRecipeProcessing() {
        this.startRecipeProcessing = false;
        super.endRecipeProcessing();
    }

    public CheckRecipeResult checkProcessingFurnace() {
        ArrayList<ItemStack> inputItems = this.getStoredInputsNoSeparation();
        if (inputItems.isEmpty()) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        this.setupProcessingLogic(this.processingLogic);
        if (this.isWirelessMode()) {
            return this.wirelessFurnace(inputItems);
        }
        return this.normalFurnace(inputItems);
    }

    public CheckRecipeResult wirelessFurnace(ArrayList<ItemStack> inputItems) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        long smeltedAmount = 0L;
        for (ItemStack items : inputItems) {
            ItemStack smeltedOutput = GTModHandler.getSmeltingOutput((ItemStack)items, (boolean)false, null);
            if (smeltedOutput == null) {
                outputs.add(items.func_77946_l());
                items.field_77994_a = 0;
                continue;
            }
            TstUtils.addStacksToList(outputs, smeltedOutput, (long)items.field_77994_a * (long)smeltedOutput.field_77994_a);
            smeltedAmount += (long)items.field_77994_a;
            items.field_77994_a = 0;
        }
        this.mOutputItems = outputs.toArray(new ItemStack[0]);
        this.updateSlots();
        if (smeltedAmount == 0L) {
            this.mMaxProgresstime = 20;
            return CheckRecipeResultRegistry.SUCCESSFUL;
        }
        BigInteger consumeEU = BigInteger.valueOf(smeltedAmount).multiply(CONSUME_EU_PER_SMELTING);
        if (!WirelessNetworkManager.addEUToGlobalEnergyMap((UUID)this.ownerUUID, (BigInteger)consumeEU.multiply(TstUtils.NEGATIVE_ONE))) {
            return CheckRecipeResultRegistry.insufficientPower((long)consumeEU.longValue());
        }
        this.mMaxProgresstime = this.coilTier > 2 ? ValueEnum.DurationPerProcessing_T3Coil_Wireless_HephaestusAtelier : ValueEnum.DurationPerProcessing_T2Coil_Wireless_HephaestusAtelier;
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    public CheckRecipeResult normalFurnace(ArrayList<ItemStack> inputItems) {
        int canProcess = this.maxProcessNormalModeFurnace;
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (ItemStack items : inputItems) {
            if (canProcess <= 0) break;
            ItemStack smeltedOutput = GTModHandler.getSmeltingOutput((ItemStack)items, (boolean)false, null);
            if (smeltedOutput == null) {
                outputs.add(items.func_77946_l());
                items.field_77994_a = 0;
                continue;
            }
            if (canProcess >= items.field_77994_a) {
                TstUtils.addStacksToList(outputs, smeltedOutput, (long)items.field_77994_a * (long)smeltedOutput.field_77994_a);
                canProcess -= items.field_77994_a;
                items.field_77994_a = 0;
                continue;
            }
            TstUtils.addStacksToList(outputs, smeltedOutput, (long)canProcess * (long)smeltedOutput.field_77994_a);
            items.field_77994_a -= canProcess;
            canProcess = 0;
            break;
        }
        this.mOutputItems = outputs.toArray(new ItemStack[0]);
        this.updateSlots();
        if (canProcess == this.maxProcessNormalModeFurnace) {
            this.mMaxProgresstime = 20;
            return CheckRecipeResultRegistry.SUCCESSFUL;
        }
        long maxEut = this.getMaxInputEu();
        OverclockCalculator calculator = new OverclockCalculator().setRecipeEUt((long)ValueEnum.ConsumeEutPerParallel_HephaestusAtelier * (long)(this.maxProcessNormalModeFurnace - canProcess)).setEUt(maxEut).setDuration(ValueEnum.ConsumeDuration_HephaestusAtelier).setDurationDecreasePerOC(4.0).calculate();
        this.lEUt = -calculator.getConsumption();
        this.mMaxProgresstime = calculator.getDuration();
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Override
    protected long getActualEnergyUsage() {
        return -this.lEUt;
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.ownerUUID = aBaseMetaTileEntity.getOwnerUuid();
    }

    public RecipeMap<?> getRecipeMap() {
        return this.machineMode == 1 ? RecipeMaps.alloySmelterRecipes : RecipeMaps.furnaceRecipes;
    }

    @NotNull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(RecipeMaps.alloySmelterRecipes, RecipeMaps.furnaceRecipes);
    }

    @Override
    protected boolean isEnablePerfectOverclock() {
        return true;
    }

    @Override
    protected float getSpeedBonus() {
        return 1.0f;
    }

    @Override
    public int getMaxParallelRecipes() {
        return Integer.MAX_VALUE;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.repairMachine();
        this.coilTier = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 16, 5, 0)) {
            return false;
        }
        if (this.coilTier == 0) {
            return false;
        }
        if (this.coilTier == 1 && this.mEnergyHatches.isEmpty() && this.mExoticEnergyHatches.isEmpty()) {
            return false;
        }
        this.maxEut = (long)(0.9375 * (double)this.getMaxInputEu());
        this.maxProcessNormalModeFurnace = (int)Math.min(Integer.MAX_VALUE, this.maxEut / (long)ValueEnum.ConsumeEutPerParallel_HephaestusAtelier);
        return true;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 16, 5, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 16, 5, 0, elementBudget, env, false, true);
    }

    public IStructureDefinition<TST_HephaestusAtelier> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               DDD               ", "              DDDDD              ", "              DDDDD              ", "              DDDDD              ", "               DDD               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "              DDDDD              ", "             DD B DD             ", "             D BBB D             ", "             DBBBBBD             ", "             D BBB D             ", "             DD B DD             ", "              DDDDD              ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "              DDDDD              ", "             D BBB D             ", "            D BB BB D            ", "            DBBCCCBBD            ", "            DB CCC BD            ", "            DBBCCCBBD            ", "            D BB BB D            ", "             D BBB D             ", "              DDDDD              ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               DDD               ", "             DD B DD             ", "            D BB BB D            ", "            DBCCCCCBD            ", "           D BC   CB D           ", "           DB C   C BD           ", "           D BC   CB D           ", "            DBCCCCCBD            ", "            D BB BB D            ", "             DD B DD             ", "               DDD               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "             AAAAAAA             ", "          AAA       AAA          ", "        AA             AA        ", "       A                 A       ", "      A                   A      ", "     A                     A     ", "    A                       A    ", "   A                         A   ", "   A                         A   ", "  A                           A  ", "  A           DDDDD           A  ", "  A          D BBB D          A  ", " A          DBBCCCBBD          A ", " A         D BC   CB D         A ", " A         DBC     CBD         A ", " A         DBC     CBD         A ", " A         DBC     CBD         A ", " A         D BC   CB D         A ", " A          DBBCCCBBD          A ", "  A          D BBB D          A  ", "  A           DDDDD           A  ", "  A                           A  ", "   A                         A   ", "   A                         A   ", "    A                       A    ", "     A                     A     ", "      A                   A      ", "       A                 A       ", "        AA             AA        ", "          AAA       AAA          ", "             AAAAAAA             ", "                                 "}, {"             AAA~AAA             ", "          AAAEEEEEEEAAA          ", "        AAEEE       EEEAA        ", "       AEE             EEA       ", "      AE                 EA      ", "     AE                   EA     ", "    AE                     EA    ", "   AE                       EA   ", "  AE                         EA  ", "  AE                         EA  ", " AE                           EA ", " AE           DDDDD           EA ", " AE          DBBBBBD          EA ", "AE          DB CCC BD          EA", "AE         DB C   C BD         EA", "AE         DBC     CBD         EA", "AE         DBC     CBD         EA", "AE         DBC     CBD         EA", "AE         DB C   C BD         EA", "AE          DB CCC BD          EA", " AE          DBBBBBD          EA ", " AE           DDDDD           EA ", " AE                           EA ", "  AE                         EA  ", "  AE                         EA  ", "   AE                       EA   ", "    AE                     EA    ", "     AE                   EA     ", "      AE                 EA      ", "       AEE             EEA       ", "        AAEEE       EEEAA        ", "          AAAEEEEEEEAAA          ", "             AAAAAAA             "}, {"                                 ", "             AAAAAAA             ", "          AAA       AAA          ", "        AA             AA        ", "       A                 A       ", "      A                   A      ", "     A                     A     ", "    A                       A    ", "   A                         A   ", "   A                         A   ", "  A                           A  ", "  A           DDDDD           A  ", "  A          D BBB D          A  ", " A          DBBCCCBBD          A ", " A         D BC   CB D         A ", " A         DBC     CBD         A ", " A         DBC     CBD         A ", " A         DBC     CBD         A ", " A         D BC   CB D         A ", " A          DBBCCCBBD          A ", "  A          D BBB D          A  ", "  A           DDDDD           A  ", "  A                           A  ", "   A                         A   ", "   A                         A   ", "    A                       A    ", "     A                     A     ", "      A                   A      ", "       A                 A       ", "        AA             AA        ", "          AAA       AAA          ", "             AAAAAAA             ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               DDD               ", "             DD B DD             ", "            D BB BB D            ", "            DBCCCCCBD            ", "           D BC   CB D           ", "           DB C   C BD           ", "           D BC   CB D           ", "            DBCCCCCBD            ", "            D BB BB D            ", "             DD B DD             ", "               DDD               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "              DDDDD              ", "             D BBB D             ", "            D BB BB D            ", "            DBBCCCBBD            ", "            DB CCC BD            ", "            DBBCCCBBD            ", "            D BB BB D            ", "             D BBB D             ", "              DDDDD              ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "              DDDDD              ", "             DD B DD             ", "             D BBB D             ", "             DBBBBBD             ", "             D BBB D             ", "             DD B DD             ", "              DDDDD              ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               DDD               ", "              DDDDD              ", "              DDDDD              ", "              DDDDD              ", "               DDD               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}})).addElement('A', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Energy.or((IHatchElement)HatchElement.ExoticEnergy)}).adder(GTCM_MultiMachineBase::addToMachineList).dot(1).casingIndex(11).buildAndChain(GregTechAPI.sBlockCasings1, 11)).addElement('B', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)4)).addElement('C', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)7)).addElement('D', StructureUtility.ofBlock((Block)BlockQuantumGlass.INSTANCE, (int)0)).addElement('E', StructureUtility.withChannel((String)"fieldcoil", (IStructureElement)StructureUtility.ofBlocksTiered(TST_HephaestusAtelier::getBlockTier, (List)ImmutableList.of((Object)Pair.of((Object)TTCasingsContainer.sBlockCasingsTT, (Object)7), (Object)Pair.of((Object)TTCasingsContainer.sBlockCasingsTT, (Object)14), (Object)Pair.of((Object)TTCasingsContainer.sBlockCasingsTT, (Object)10)), (Object)0, (m, t) -> {
                m.coilTier = t;
            }, m -> m.coilTier))).build();
        }
        return STRUCTURE_DEFINITION;
    }

    private static int getBlockTier(Block block, int meta) {
        if (TTCasingsContainer.sBlockCasingsTT == block) {
            int n;
            switch (meta) {
                case 7: {
                    n = 1;
                    break;
                }
                case 14: {
                    n = 2;
                    break;
                }
                case 10: {
                    n = 3;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }
        return 0;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return false;
    }

    @Override
    public boolean supportsBatchMode() {
        return false;
    }

    @Override
    public boolean supportsVoidProtection() {
        return false;
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextLocalization.Tooltip_HephaestusAtelier_MachineType).addInfo(TextLocalization.Tooltip_HephaestusAtelier_Controller).addInfo(TextLocalization.Tooltip_HephaestusAtelier_01).addInfo(TextLocalization.Tooltip_HephaestusAtelier_02).addInfo(TextLocalization.Tooltip_HephaestusAtelier_03).addInfo(TextLocalization.Tooltip_HephaestusAtelier_04).addInfo(TextLocalization.Tooltip_HephaestusAtelier_05).addInfo(TextLocalization.textScrewdriverChangeMode).addInfo(TextLocalization.Tooltip_HephaestusAtelier_06).addInfo(TextLocalization.Tooltip_HephaestusAtelier_07).addInfo(TextLocalization.Tooltip_HephaestusAtelier_08).addInfo(TextLocalization.Tooltip_HephaestusAtelier_09).addInfo(TextLocalization.Tooltip_HephaestusAtelier_10).addInfo(TextLocalization.Tooltip_HephaestusAtelier_11).addInfo(TextLocalization.Tooltip_HephaestusAtelier_12).addInfo(TextLocalization.Tooltip_HephaestusAtelier_13).addInfo(TextLocalization.Tooltip_HephaestusAtelier_14).addInfo(TextLocalization.Tooltip_HephaestusAtelier_15).addSeparator().addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).addStructureInfo(TextLocalization.Tooltip_HephaestusAtelier_2_01).addStructureInfo(TextLocalization.Tooltip_DoNotNeedMaintenance).beginStructureBlock(33, 11, 33, false).addController(TextLocalization.textFrontCenter).addInputBus(TextLocalization.textAnyCasing, new int[]{1}).addOutputBus(TextLocalization.textAnyCasing, new int[]{1}).addEnergyHatch(TextLocalization.textAnyCasing, new int[]{1}).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11]};
    }
}

