/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.common.GTCMItemList;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.TT_MultiMachineBase_EM;
import com.Nxer.TwistSpaceTechnology.common.machine.singleBlock.hatch.GT_Hatch_RackComputationMonitor;
import com.Nxer.TwistSpaceTechnology.system.WirelessDataNetWork.WirelessDataPacket;
import com.Nxer.TwistSpaceTechnology.util.TstSharedLocalization;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import goodgenerator.loader.Loaders;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gtPlusPlus.core.block.ModBlocks;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import tectech.mechanics.dataTransport.QuantumDataPacket;
import tectech.thing.block.BlockQuantumGlass;
import tectech.thing.casing.TTCasingsContainer;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataInput;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataOutput;
import tectech.thing.metaTileEntity.multi.base.INameFunction;
import tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import tectech.thing.metaTileEntity.multi.base.LedStatus;
import tectech.thing.metaTileEntity.multi.base.Parameters;
import tectech.thing.metaTileEntity.multi.base.render.TTRenderedExtendedFacingTexture;

public class TST_Computer
extends TT_MultiMachineBase_EM
implements ISurvivalConstructable {
    private GT_Hatch_RackComputationMonitor realMonitor;
    private double multiplier = 1.0;
    private static boolean localWirelessTag = false;
    private static Textures.BlockIcons.CustomIcon ScreenOFF;
    private static Textures.BlockIcons.CustomIcon ScreenON;
    private static final String[] description;
    private static Vec3Impl controllerPosition;
    public static final int offsetX = 23;
    public static final int offsetY = 34;
    public static final int offsetZ = 0;
    public static final String[][] shape;
    private static final String MAIN = "main";
    protected Parameters.Group.ParameterIn overclock;
    protected Parameters.Group.ParameterIn overvolt;
    protected Parameters.Group.ParameterOut maxCurrentTemp;
    protected Parameters.Group.ParameterOut availableData;
    private static final INameFunction<TST_Computer> OC_NAME;
    private static final INameFunction<TST_Computer> OV_NAME;
    private static final INameFunction<TST_Computer> MAX_TEMP_NAME;
    private static final INameFunction<TST_Computer> COMPUTE_NAME;
    private static final IStatusFunction<TST_Computer> OC_STATUS;
    private static final IStatusFunction<TST_Computer> OV_STATUS;
    private static final IStatusFunction<TST_Computer> MAX_TEMP_STATUS;
    private static final IStatusFunction<TST_Computer> COMPUTE_STATUS;
    private static IStructureDefinition<TST_Computer> STRUCTURE_DEFINITION;

    public TST_Computer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.eCertainMode = 0;
        this.useLongPower = true;
    }

    public TST_Computer(String aName) {
        super(aName);
        this.eCertainMode = 0;
        this.useLongPower = true;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_Computer(this.mName);
    }

    protected void parametersInstantiation_EM() {
        Parameters.Group hatch_0 = this.parametrization.getGroup(0);
        this.overclock = hatch_0.makeInParameter(0, 1.0, OC_NAME, OC_STATUS);
        this.overvolt = hatch_0.makeInParameter(1, 1.0, OV_NAME, OV_STATUS);
        this.maxCurrentTemp = hatch_0.makeOutParameter(0, 0.0, MAX_TEMP_NAME, MAX_TEMP_STATUS);
        this.availableData = hatch_0.makeOutParameter(1, 0.0, COMPUTE_NAME, COMPUTE_STATUS);
    }

    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        this.realMonitor = null;
        if (!this.structureCheck_EM(MAIN, 23, 34, 0)) {
            return false;
        }
        return !this.mInputHatches.isEmpty() && this.mMaintenanceHatches.size() == 1 && this.realMonitor != null && !this.eOutputData.isEmpty() && this.eInputData.isEmpty();
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74780_a("computation", this.availableData.get());
        aNBT.func_74757_a("localWirelessTag", localWirelessTag);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (this.availableData != null) {
            this.availableData.set(aNBT.func_74769_h("computation"));
            this.eAvailableData = (long)this.availableData.get();
        }
        localWirelessTag = aNBT.func_74767_n("localWirelessTag");
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && localWirelessTag) {
            WirelessDataPacket.updatePacket(aBaseMetaTileEntity, aTick);
        }
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aTick % 20L == 0L && aBaseMetaTileEntity.isServerSide()) {
            ItemStack stack = this.getControllerSlot();
            if (stack != null && stack.func_77973_b() != null && stack.func_77973_b().equals(GTCMItemList.WirelessUpdateItem.getItem()) && stack.field_77994_a > 0) {
                if (WirelessDataPacket.enableWirelessNetWork(aBaseMetaTileEntity)) {
                    localWirelessTag = true;
                }
            } else {
                WirelessDataPacket.disableWirelessNetWork(aBaseMetaTileEntity);
                localWirelessTag = false;
            }
        }
        if (aBaseMetaTileEntity.isServerSide() && this.mMachine && !aBaseMetaTileEntity.isActive() && aTick % 20L == 12L) {
            double maxTemp = 0.0;
            this.maxCurrentTemp.set(maxTemp);
        }
    }

    @NotNull
    protected CheckRecipeResult checkProcessing_EM() {
        this.parametrization.setToDefaults(false, true);
        this.eAvailableData = 0L;
        double maxTemp = 0.0;
        double overClockRatio = this.overclock.get();
        double overVoltageRatio = this.overvolt.get();
        if (Double.isNaN(overClockRatio) || Double.isNaN(overVoltageRatio)) {
            return SimpleCheckRecipeResult.ofFailure((String)"no_computing");
        }
        if (this.overclock.getStatus((boolean)true).isOk && this.overvolt.getStatus((boolean)true).isOk) {
            float eut = (float)GTValues.V[8] * (float)overVoltageRatio * (float)overClockRatio;
            if (!(eut < 2.1474836E9f)) {
                this.lEUt = -GTValues.V[8];
                return CheckRecipeResultRegistry.POWER_OVERFLOW;
            }
            this.lEUt = (long)(-eut);
            long thingsActive = 0L;
            if (this.realMonitor != null) {
                if ((double)this.realMonitor.heat > maxTemp) {
                    maxTemp = this.realMonitor.heat;
                }
                long rackComputation = this.realMonitor.tickComponents((float)overClockRatio, (float)overVoltageRatio);
                this.realMonitor.heat = this.coolTheRackHatchByAnyCoolant(this.realMonitor.heat);
                this.realMonitor.postProcessAfterCoolant();
                if ((rackComputation *= (long)(this.multiplier * this.multiplier)) > 0L) {
                    this.eAvailableData += rackComputation;
                    thingsActive += (long)(4.0 * this.multiplier * this.multiplier);
                }
                this.realMonitor.getBaseMetaTileEntity().setActive(true);
            }
            for (MTEHatchDataInput di : this.eInputData) {
                if (di.q == null) continue;
                ++thingsActive;
            }
            if (localWirelessTag) {
                thingsActive *= 4L;
            }
            if (thingsActive > 0L) {
                this.eAmpereFlow = 1L + ((thingsActive += (long)this.eOutputData.size()) >> 2);
                this.eAmpereFlow *= (long)(this.multiplier * this.multiplier);
                this.mMaxProgresstime = 20;
                this.mEfficiencyIncrease = 10000;
                this.maxCurrentTemp.set(maxTemp);
                this.availableData.set((double)this.eAvailableData);
                return SimpleCheckRecipeResult.ofSuccess((String)"computing");
            }
            this.eAvailableData = 0L;
            this.lEUt = -GTValues.V[8];
            this.eAmpereFlow = 1L;
            this.mMaxProgresstime = 20;
            this.mEfficiencyIncrease = 10000;
            this.maxCurrentTemp.set(maxTemp);
            this.availableData.set((double)this.eAvailableData);
            return SimpleCheckRecipeResult.ofSuccess((String)"no_computing");
        }
        return SimpleCheckRecipeResult.ofFailure((String)"no_computing");
    }

    public int coolTheRackHatchByAnyCoolant(int prevHeat) {
        FluidStack coolant = null;
        for (MTEHatchInput input : (ArrayList)GTUtility.filterValidMTEs((Collection)this.mInputHatches)) {
            FluidStack fluid = input.getFluid();
            if (fluid == null) continue;
            if (coolant == null && TST_Computer.validCoolant(fluid) > -1.0) {
                coolant = fluid.copy();
                continue;
            }
            if (coolant == null || coolant.getFluid() != fluid.getFluid()) continue;
            coolant.amount += fluid.amount;
        }
        if (coolant == null) {
            return prevHeat;
        }
        double maxHeatCanCool = TST_Computer.validCoolant(coolant) * (double)coolant.amount;
        this.multiplier = 1.0 + Math.log10(1.0 + maxHeatCanCool * (double)prevHeat);
        long realHeatCanCool = (int)Math.min(maxHeatCanCool, (double)prevHeat - (double)prevHeat / (this.multiplier * this.multiplier));
        long requiredAmount = (long)((double)realHeatCanCool / TST_Computer.validCoolant(coolant));
        for (MTEHatchInput input : (ArrayList)GTUtility.filterValidMTEs((Collection)this.mInputHatches)) {
            FluidStack fluid = input.getFluid();
            if (fluid == null || fluid.amount < 1) continue;
            if (requiredAmount == 0L) break;
            if (coolant.getFluid() != fluid.getFluid()) continue;
            int mx = (int)Math.min(requiredAmount, (long)fluid.amount);
            fluid.amount -= mx;
            requiredAmount -= (long)mx;
        }
        return (int)((long)prevHeat - realHeatCanCool);
    }

    public static double validCoolant(FluidStack fluid) {
        if (fluid.getFluid() == BlocksItems.getFluid((InternalName)InternalName.fluidCoolant)) {
            return 0.001;
        }
        if (fluid.getFluid() == Materials.SuperCoolant.mFluid) {
            return 0.01;
        }
        return -100.0;
    }

    public void outputAfterRecipe_EM() {
        if (!this.eOutputData.isEmpty()) {
            Vec3Impl pos = new Vec3Impl(this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord());
            QuantumDataPacket pack = new QuantumDataPacket(Long.valueOf(this.eAvailableData / (long)this.eOutputData.size())).unifyTraceWith(new Vec3Impl[]{pos});
            if (pack == null) {
                return;
            }
            for (MTEHatchDataInput hatch : this.eInputData) {
                if (hatch.q == null || ((QuantumDataPacket)hatch.q).contains(pos) || (pack = pack.unifyPacketWith((QuantumDataPacket)hatch.q)) != null) continue;
                return;
            }
            for (MTEHatchDataOutput o : this.eOutputData) {
                o.q = pack;
            }
        }
    }

    public MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.name")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.desc.0")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.desc.1")).addInfo(TstSharedLocalization.MachineTooltip.tooComplex()).addSeparator().addInfo(StatCollector.func_74838_a((String)"tst.computer.desc.0")).addInfo(StatCollector.func_74838_a((String)"tst.computer.desc.1")).addInfo(StatCollector.func_74838_a((String)"tst.computer.desc.2")).addInfo(StatCollector.func_74838_a((String)"tst.computer.desc.3")).addInfo(StatCollector.func_74838_a((String)"tst.computer.desc.4")).addInfo(StatCollector.func_74838_a((String)"tst.computer.desc.5")).addInfo(StatCollector.func_74838_a((String)"tst.computer.desc.6")).addInfo(StatCollector.func_74838_a((String)"tst.computer.desc.7")).addInfo(StatCollector.func_74838_a((String)"tst.computer.desc.8")).addInfo(StatCollector.func_74838_a((String)"tst.computer.desc.9")).addInfo(StatCollector.func_74838_a((String)"tst.computer.desc.10")).addInfo(StatCollector.func_74838_a((String)"tst.computer.desc.11")).addInfo(StatCollector.func_74838_a((String)"tst.computer.desc.12")).addOtherStructurePart(StatCollector.func_74838_a((String)"gt.blockmachines.hatch.certain.tier.07.name"), "no need uncertain hatch!", new int[]{1}).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        ScreenOFF = new Textures.BlockIcons.CustomIcon("iconsets/EM_COMPUTER");
        ScreenON = new Textures.BlockIcons.CustomIcon("iconsets/EM_COMPUTER_ACTIVE");
        super.registerIcons(aBlockIconRegister);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][3], new TTRenderedExtendedFacingTexture((IIconContainer)(aActive ? ScreenON : ScreenOFF))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][3]};
    }

    public void onRemoval() {
        super.onRemoval();
        if (this.realMonitor != null) {
            this.realMonitor.getBaseMetaTileEntity().setActive(false);
        }
    }

    protected void extraExplosions_EM() {
        this.realMonitor.getBaseMetaTileEntity().doExplosion(GTValues.V[9]);
    }

    protected long getAvailableData_EM() {
        return this.eAvailableData;
    }

    public void stopMachine() {
        super.stopMachine();
        this.eAvailableData = 0L;
        if (this.realMonitor != null) {
            this.realMonitor.getBaseMetaTileEntity().setActive(false);
        }
    }

    protected void afterRecipeCheckFailed() {
        super.afterRecipeCheckFailed();
        if (this.realMonitor != null) {
            this.realMonitor.getBaseMetaTileEntity().setActive(false);
        }
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(MAIN, 23, 34, 0, stackSize, hintsOnly);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(MAIN, stackSize, 23, 34, 0, elementBudget, env, false, true);
    }

    public IStructureDefinition<TST_Computer> getStructure_EM() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape(MAIN, shape).addElement('A', StructureUtility.ofBlock((Block)Loaders.FRF_Coil_1, (int)0)).addElement('B', StructureUtility.ofBlock((Block)Loaders.compactFusionCoil, (int)0)).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSE, (int)0)).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSE, (int)1)).addElement('F', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)0)).addElement('G', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)1)).addElement('H', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)2)).addElement('I', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)3)).addElement('J', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)7)).addElement('L', StructureUtility.ofBlock((Block)Loaders.radiationProtectionSteelFrame, (int)0)).addElement('K', StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)15)).addElement('M', StructureUtility.ofBlock((Block)BlockQuantumGlass.INSTANCE, (int)0)).addElement('O', StructureUtility.ofBlock((Block)vazkii.botania.common.block.ModBlocks.pylon, (int)1)).addElement('P', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)2)).addElement('E', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.ofHatchAdder(TST_Computer::superAddToMachineList, (int)1026, (int)1), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSE, (int)2)})).addElement('Q', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)3)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return description;
    }

    public final boolean superAddToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        GT_Hatch_RackComputationMonitor monitor;
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        IMetaTileEntity iMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (iMetaTileEntity instanceof GT_Hatch_RackComputationMonitor && (monitor = (GT_Hatch_RackComputationMonitor)iMetaTileEntity).isMeanHatch()) {
            this.realMonitor = monitor;
            this.realMonitor.updateTexture(aBaseCasingIndex);
            return true;
        }
        return super.addToMachineList(aTileEntity, aBaseCasingIndex);
    }

    static {
        description = new String[]{EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"tt.keyphrase.Hint_Details") + ":", StatCollector.func_74838_a((String)"tst.computer.hint.0"), StatCollector.func_74838_a((String)"tst.computer.hint.1")};
        shape = new String[][]{{"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "EEEEEEEEEEEEEEEEEEEEEEE~EEEEEEEEEEEEEEEEEEEEEEE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "EFFFFFIFIFFFFFFFFFFFIFIFIFIFFFFFFFFFFFIFIFFFFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "EFFFFFIFIFFFFFFFFFFFIFIFIFIFFFFFFFFFFFIFIFFFFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                       M                       ", "                       M                       ", "                      MMM                      ", "                     MMMMM                     ", "                      MMM                      ", "                       M                       ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                     CCCCC                     ", "EFFGGGIGIGGGGGGGGGGGIGGGGGIGGGGGGGGGGGIGIGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                     MM MM                     ", "                    MM   MM                    ", "                    M     M                    ", "                    MM   MM                    ", "                     MM MM                     ", "                      MMM                      ", "                                               ", "                                               ", "                                               ", "                                               ", "                      CCC                      ", "    PPEEEPPPPPPPPPPPCCCCCCCPPPPPPPPPPPEEEPP    ", "EFFGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "      JJJ                             JJJ      ", "      JJJ                             JJJ      ", "      JJJ                             JJJ      ", "                                               ", "                    M     M                    ", "      JJJ           M     M           JJJ      ", "                   M       M                   ", "      JJJ           M     M           JJJ      ", "                    M     M                    ", "      JJJ            MM MM            JJJ      ", "                       M                       ", "      JJJ                             JJJ      ", "                                               ", "                      CCC                      ", "      BBB            C   C            BBB      ", "    PEEEEE         CCCCCCCCC         EEEEEP    ", "EFFGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "      JJJ                             JJJ      ", "     JJJJJ                           JJJJJ     ", "     JJJJJ                           JJJJJ     ", "     JJJJJ                           JJJJJ     ", "      JJJ                             JJJ      ", "                                               ", "     J L J         M       M         J L J     ", "                   M       M                   ", "     J L J         M       M         J L J     ", "                    M     M                    ", "     J L J          MM   MM          J L J     ", "                      MMM                      ", "     J L J                           J L J     ", "                      CCC                      ", "                     C   C                     ", "     B   B          C     C          B   B     ", "    EEBBBEEPPPPPPPPCCCCCCCCCPPPPPPPPEEBBBEE    ", "EIIIGGGGGGGIIIIIIIIGGGGGGGGGIIIIIIIIGGGGGGGIIIE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "      JJJ                             JJJ      ", "     JJJJJ                           JJJJJ     ", "     JJJJJ                           JJJJJ     ", "     JJJJJ                           JJJJJ     ", "      JJJ                             JJJ      ", "       A                               A       ", "     JLALJ                           JLALJ     ", "       A           M       M           A       ", "     JLALJ         M   O   M         JLALJ     ", "       A           M       M           A       ", "     JLALJ          M     M          JLALJ     ", "       A             MMMMM             A       ", "     JLALJ             C             JLALJ     ", "       A              CCC              A       ", "       A             C C C             A       ", "     B A B          C  C  C          B A B     ", "    EEBABEE       PCCCCCCCCCP       EEBABEE    ", "EFFGGGGGGGGGGGGGGGIGGGGGGGGGIGGGGGGGGGGGGGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "      JJJ                             JJJ      ", "     JJJJJ                           JJJJJ     ", "     JJJJJ                           JJJJJ     ", "     JJJJJ                           JJJJJ     ", "      JJJ                             JJJ      ", "                                               ", "     J L J                           J L J     ", "                                               ", "     J L J         M       M         J L J     ", "                    M     M                    ", "     J L J          MM   MM          J L J     ", "                      MMM                      ", "     J L J                           J L J     ", "                      CCC                      ", "                     C   C                     ", "     B   B          C     C          B   B     ", "    EEBBBEEPPPPPP PCCCCCCCCCP PPPPPPEEBBBEE    ", "EIIIGGGGGGGIIIIIIGIGGGGGGGGGIGIIIIIIGGGGGGGIIIE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "      JJJ                             JJJ      ", "      JJJ                             JJJ      ", "      JJJ                             JJJ      ", "                                               ", "                                               ", "      JJJ                             JJJ      ", "                                               ", "      JJJ                             JJJ      ", "                    M     M                    ", "      JJJ            MM MM            JJJ      ", "                       M                       ", "      JJJ                             JJJ      ", "                                               ", "                      CCC                      ", "      BBB            C   C            BBB      ", "    PEEEEE      P PCCCCCCCCCP P      EEEEEP    ", "EFFGGGGGGGGGGGGGIGIGGGGGGGGGIGIGGGGGGGGGGGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                      MMM                      ", "                                               ", "                                               ", "                                               ", "                                               ", "                      CCC                      ", "    P EEE       P P CCCCCCC P P       EEE P    ", "EFFGGGGGGGIIIIIGIGIGGGGGGGGGIGIGIIIIIGGGGGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "    P P P       P P PCCCCCP P P       P P P    ", "EFFGGGIGIGIGGGIGIGIGIGGGGGIGIGIGIGGGIGIGIGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "    P P P       P P P P P P P P       P P P    ", "EFFGGGIGIGIGIGIGIGIGIGIGIGIGIGIGIGIGIGIGIGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "    P P P       P P P P P P P P       P P P    ", "EFFGGGIGIGIGGGIGIGIGIGIGIGIGIGIGIGGGIGIGIGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "    P P P       P P P P P P P P       P P P    ", "EFFGGGIGIGIIIIIGIGIGIGIGIGIGIGIGIIIIIGIGIGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "    P P P       P P P P P P P P       P P P    ", "EFFGGGIGIGGGGGGGIGIGIGIGIGIGIGIGGGGGGGIGIGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                KKKKKKKKKKKKKKK                ", "                KKKKKKKKKKKKKKK                ", "    P P PPPPPPPPPKPKPKPKPKPKPKPPPPPPPPP P P    ", "EFFGGGIGIIIIIIIIGGGGGGGGGGGGGGGIIIIIIIIGIGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                     MMMMM                     ", "                KKKKKKKKKKKKKKK                ", "                KIHHHHHHHHHHHIK                ", "    P P         KHQQQQQQQQQQQHK         P P    ", "EFFGGGIGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGIGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                     MMMMM                     ", "                     MMMMM                     ", "                      MMM                      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                     MMMMM                     ", "                   MM     MM                   ", "                KKKKKKKKKKKKKKK                ", "                KHIHHHHHHHHHIHK                ", "    P PPPPPPPPPPPQHQQQQQQQQQHQPPPPPPPPPPP P    ", "EFFGGGIIIIIIIIIIGGGGGGGGGGGGGGGIIIIIIIIIIGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                    M     M                    ", "                    M     M                    ", "                    MM   MM                    ", "                     MMMMM                     ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "      M                                 M      ", "     MMM                               MMM     ", "      MMM                             MMM      ", "       M                               M       ", "                     MMMMM                     ", "                     MMMMM                     ", "                    M     M                    ", "                  M         M                  ", "                KKKKKKKKKKKKKKK                ", "                KHHIHHHHHHHIHHK                ", "    PCCCCC      KQQHQQQQQQQHQQK      CCCCCP    ", "EFFGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGFFE"}, {"                                               ", "                                               ", "                      III                      ", "                   M  III  M                   ", "                   M  III  M                   ", "                   M       M                   ", "                    M     M                    ", "                     MMMMM                     ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "     M                                   M     ", "    MM                                   MM    ", "    M                 MMM                 M    ", "    MM                MMM                MM    ", "     MM MM            MMM            MM MM     ", "      MMM           M     M           MMM      ", "                    M     M                    ", "                   M       M                   ", "                  M         M                  ", "                KKKKKKKKKKKKKKK                ", "      CCC       KHHHIHHHHHIHHHK       CCC      ", "    CCCCCCCPPPPPPQQQHQQQQQHQQQPPPPPPCCCCCCC    ", "EIIIGGGGGGGIIIIIGGGGGGGGGGGGGGGIIIIIGGGGGGGIIIE"}, {"                                               ", "                     IIIII                     ", "                     IIIII                     ", "                  M  IIIII  M                  ", "                  M  IIIII  M                  ", "                   M IIIII M                   ", "                   M       M                   ", "                    MM   MM                    ", "                      MMM                      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                      MMM                      ", "                      MMM                      ", "                      MMM                      ", "    M                 MMM                 M    ", "    M                 MMM                 M    ", "   M                 M   M                 M   ", "    M                M   M                M    ", "    M                M   M                M    ", "     MM MM         M       M         MM MM     ", "       M           M       M           M       ", "                  M         M                  ", "                 M           M                 ", "      CCC       KKKKKKKKKKKKKKK       CCC      ", "     C   C      KHHHHIHHHIHHHHK      C   C     ", "   CCCCCCCCC    KQQQQHQQQHQQQQK    CCCCCCCCC   ", "EFFGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGFFE"}, {"                      III                      ", "                     IIIII                     ", "                    IIIIIII                    ", "                  M IIIIIII M                  ", "                  M IIIIIII M                  ", "                  M  IIIII  M                  ", "                   M  III  M                   ", "                    M     M                    ", "                     MMMMM                     ", "                       M                       ", "                       M                       ", "                       M                       ", "                       M                       ", "                       M                       ", "                       M                       ", "                       M                       ", "                      MMM                      ", "                      MMM                      ", "                      MMM                      ", "                     M   M                     ", "                     M   M                     ", "                     M   M                     ", "    M                M   M                M    ", "   M                 M   M                 M   ", "   M                M     M                M   ", "   M                M     M                M   ", "    M               M     M               M    ", "    MM   MM        M       M        MM   MM    ", "      MMM          M       M          MMM      ", "                  M         M                  ", "      CCC        M           M        CCC      ", "     C   C      KKKKKKKKKKKKKKK      C   C     ", "    C     C     KHHHHHIHIHHHHHK     C     C    ", "   CCCCCCCCCPPPPPQQQQQHQHQQQQQPPPPPCCCCCCCCC   ", "EIIGGGGGGGGGIIIIGGGGGGGGGGGGGGGIIIIGGGGGGGGGIIE"}, {"                      III                      ", "                     IIIII                     ", "                    IIIIIII                    ", "                  M IIIIIII M                  ", "                  M IIIIIII M                  ", "                  M  IIIII  M                  ", "                   M  III  M                   ", "                    M     M                    ", "                     MMMMM                     ", "                      MDM                      ", "                      MDM                      ", "                      MDM                      ", "                      MDM                      ", "                      MDM                      ", "                      MDM                      ", "                      MDM                      ", "                      MDM                      ", "                      MDM                      ", "                      MDM                      ", "                     M D M                     ", "                     M D M                     ", "   M                 M D M                 M   ", "   M                 M D M                 M   ", "   M                 M D M                 M   ", "   M                M  D  M                M   ", "   M   O            M  D  M            O   M   ", "   M                M  D  M                M   ", "    M     M        M   D   M        M     M    ", "     MMMMM         M   D   M         MMMMM     ", "       C          M    D    M          C       ", "      CCC        M     D     M        CCC      ", "     C C C      KKKKKKKDKKKKKKK      C C C     ", "    C  C  C     KHHHHHHDHHHHHHK     C  C  C    ", "   CCCCCCCCC    KQQQQQQDQQQQQQK    CCCCCCCCC   ", "EFFGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGFFE"}, {"                      III                      ", "                     IIIII                     ", "                    IIIIIII                    ", "                  M IIIIIII M                  ", "                  M IIIIIII M                  ", "                  M  IIIII  M                  ", "                   M  III  M                   ", "                    M     M                    ", "                     MMMMM                     ", "                       M                       ", "                       M                       ", "                       M                       ", "                       M                       ", "                       M                       ", "                       M                       ", "                       M                       ", "                      MMM                      ", "                      MMM                      ", "                      MMM                      ", "                     M   M                     ", "                     M   M                     ", "                     M   M                     ", "    M                M   M                M    ", "   M                 M   M                 M   ", "   M                M     M                M   ", "   M                M     M                M   ", "    M               M     M               M    ", "    MM   MM        M       M        MM   MM    ", "      MMM          M       M          MMM      ", "                  M         M                  ", "      CCC        M           M        CCC      ", "     C   C      KKKKKKKKKKKKKKK      C   C     ", "    C     C     KHHHHHIHIHHHHHK     C     C    ", "   CCCCCCCCCPPPPPQQQQQHQHQQQQQPPPPPCCCCCCCCC   ", "EIIGGGGGGGGGIIIIGGGGGGGGGGGGGGGIIIIGGGGGGGGGIIE"}, {"                                               ", "                     IIIII                     ", "                     IIIII                     ", "                  M  IIIII  M                  ", "                  M  IIIII  M                  ", "                   M IIIII M                   ", "                   M       M                   ", "                    MM   MM                    ", "                      MMM                      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                      MMM                      ", "                      MMM                      ", "                      MMM                      ", "    M                 MMM                 M    ", "    M                 MMM                 M    ", "   M                 M   M                 M   ", "    M                M   M                M    ", "    M                M   M                M    ", "     MM MM         M       M         MM MM     ", "       M           M       M           M       ", "                  M         M                  ", "                 M           M                 ", "      CCC       KKKKKKKKKKKKKKK       CCC      ", "     C   C      KHHHHIHHHIHHHHK      C   C     ", "   CCCCCCCCC    KQQQQHQQQHQQQQK    CCCCCCCCC   ", "EFFGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGFFE"}, {"                                               ", "                                               ", "                      III                      ", "                   M  III  M                   ", "                   M  III  M                   ", "                   M       M                   ", "                    M     M                    ", "                     MMMMM                     ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "     M                                   M     ", "    MM                                   MM    ", "    M                 MMM                 M    ", "    MM                MMM                MM    ", "     MM MM            MMM            MM MM     ", "      MMM           M     M           MMM      ", "                    M     M                    ", "                   M       M                   ", "                  M         M                  ", "                KKKKKKKKKKKKKKK                ", "      CCC       KHHHIHHHHHIHHHK       CCC      ", "    CCCCCCCPPPPPPQQQHQQQQQHQQQPPPPPPCCCCCCC    ", "EIIIGGGGGGGIIIIIGGGGGGGGGGGGGGGIIIIIGGGGGGGIIIE"}, {"                                               ", "                                               ", "                                               ", "                    M     M                    ", "                    M     M                    ", "                    MM   MM                    ", "                     MMMMM                     ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "      M                                 M      ", "     MMM                               MMM     ", "      MMM                             MMM      ", "       M                               M       ", "                     MMMMM                     ", "                     MMMMM                     ", "                    M     M                    ", "                  M         M                  ", "                KKKKKKKKKKKKKKK                ", "                KHHIHHHHHHHIHHK                ", "    PCCCCC      KQQHQQQQQQQHQQK      CCCCCP    ", "EFFGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                     MMMMM                     ", "                     MMMMM                     ", "                      MMM                      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                     MMMMM                     ", "                   MM     MM                   ", "                KKKKKKKKKKKKKKK                ", "                KHIHHHHHHHHHIHK                ", "    P PPPPPPPPPPPQHQQQQQQQQQHQPPPPPPPPPPP P    ", "EFFGGGIIIIIIIIIIGGGGGGGGGGGGGGGIIIIIIIIIIGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                     MMMMM                     ", "                KKKKKKKKKKKKKKK                ", "                KIHHHHHHHHHHHIK                ", "    P P         KHQQQQQQQQQQQHK         P P    ", "EFFGGGIGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGIGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                KKKKKKKKKKKKKKK                ", "                KKKKKKKKKKKKKKK                ", "    P P PPPPPPPPPKPKPKPKPKPKPKPPPPPPPPP P P    ", "EFFGGGIGIIIIIIIIGGGGGGGGGGGGGGGIIIIIIIIGIGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "    P P P       P P P P P P P P       P P P    ", "EFFGGGIGIGGGGGGGIGIGIGIGIGIGIGIGGGGGGGIGIGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "    P P P       P P P P P P P P       P P P    ", "EFFGGGIGIGIIIIIGIGIGIGIGIGIGIGIGIIIIIGIGIGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "    P P P       P P P P P P P P       P P P    ", "EFFGGGIGIGIGGGIGIGIGIGIGIGIGIGIGIGGGIGIGIGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "    P P P       P P P P P P P P       P P P    ", "EFFGGGIGIGIGIGIGIGIGIGIGIGIGIGIGIGIGIGIGIGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "    P P P       P P PCCCCCP P P       P P P    ", "EFFGGGIGIGIGGGIGIGIGIGGGGGIGIGIGIGGGIGIGIGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                      MMM                      ", "                                               ", "                                               ", "                                               ", "                                               ", "                      CCC                      ", "    P EEE       P P CCCCCCC P P       EEE P    ", "EFFGGGGGGGIIIIIGIGIGGGGGGGGGIGIGIIIIIGGGGGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "      JJJ                             JJJ      ", "      JJJ                             JJJ      ", "      JJJ                             JJJ      ", "                                               ", "                                               ", "      JJJ                             JJJ      ", "                                               ", "      JJJ                             JJJ      ", "                    M     M                    ", "      JJJ            MM MM            JJJ      ", "                       M                       ", "      JJJ                             JJJ      ", "                                               ", "                      CCC                      ", "      BBB            C   C            BBB      ", "    PEEEEE      P PCCCCCCCCCP P      EEEEEP    ", "EFFGGGGGGGGGGGGGIGIGGGGGGGGGIGIGGGGGGGGGGGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "      JJJ                             JJJ      ", "     JJJJJ                           JJJJJ     ", "     JJJJJ                           JJJJJ     ", "     JJJJJ                           JJJJJ     ", "      JJJ                             JJJ      ", "                                               ", "     J L J                           J L J     ", "                                               ", "     J L J         M       M         J L J     ", "                    M     M                    ", "     J L J          MM   MM          J L J     ", "                      MMM                      ", "     J L J                           J L J     ", "                      CCC                      ", "                     C   C                     ", "     B   B          C     C          B   B     ", "    EEBBBEEPPPPPP PCCCCCCCCCP PPPPPPEEBBBEE    ", "EIIIGGGGGGGIIIIIIGIGGGGGGGGGIGIIIIIIGGGGGGGIIIE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "      JJJ                             JJJ      ", "     JJJJJ                           JJJJJ     ", "     JJJJJ                           JJJJJ     ", "     JJJJJ                           JJJJJ     ", "      JJJ                             JJJ      ", "       A                               A       ", "     JLALJ                           JLALJ     ", "       A           M       M           A       ", "     JLALJ         M   O   M         JLALJ     ", "       A           M       M           A       ", "     JLALJ          M     M          JLALJ     ", "       A             MMMMM             A       ", "     JLALJ             C             JLALJ     ", "       A              CCC              A       ", "       A             C C C             A       ", "     B A B          C  C  C          B A B     ", "    EEBABEE       PCCCCCCCCCP       EEBABEE    ", "EFFGGGGGGGGGGGGGGGIGGGGGGGGGIGGGGGGGGGGGGGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "      JJJ                             JJJ      ", "     JJJJJ                           JJJJJ     ", "     JJJJJ                           JJJJJ     ", "     JJJJJ                           JJJJJ     ", "      JJJ                             JJJ      ", "                                               ", "     J L J         M       M         J L J     ", "                   M       M                   ", "     J L J         M       M         J L J     ", "                    M     M                    ", "     J L J          MM   MM          J L J     ", "                      MMM                      ", "     J L J                           J L J     ", "                      CCC                      ", "                     C   C                     ", "     B   B          C     C          B   B     ", "    EEBBBEEPPPPPPPPCCCCCCCCCPPPPPPPPEEBBBEE    ", "EIIIGGGGGGGIIIIIIIIGGGGGGGGGIIIIIIIIGGGGGGGIIIE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "      JJJ                             JJJ      ", "      JJJ                             JJJ      ", "      JJJ                             JJJ      ", "                                               ", "                    M     M                    ", "      JJJ           M     M           JJJ      ", "                   M       M                   ", "      JJJ           M     M           JJJ      ", "                    M     M                    ", "      JJJ            MM MM            JJJ      ", "                       M                       ", "      JJJ                             JJJ      ", "                                               ", "                      CCC                      ", "      BBB            C   C            BBB      ", "    PEEEEE         CCCCCCCCC         EEEEEP    ", "EFFGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                     MM MM                     ", "                    MM   MM                    ", "                    M     M                    ", "                    MM   MM                    ", "                     MM MM                     ", "                      MMM                      ", "                                               ", "                                               ", "                                               ", "                                               ", "                      CCC                      ", "    PPEEEPPPPPPPPPPPCCCCCCCPPPPPPPPPPPEEEPP    ", "EFFGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                       M                       ", "                       M                       ", "                      MMM                      ", "                     MMMMM                     ", "                      MMM                      ", "                       M                       ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                     CCCCC                     ", "EFFGGGIGIGGGGGGGGGGGIGGGGGIGGGGGGGGGGGIGIGGGFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "EFFFFFIFIFFFFFFFFFFFIFIFIFIFFFFFFFFFFFIFIFFFFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "EFFFFFIFIFFFFFFFFFFFIFIFIFIFFFFFFFFFFFIFIFFFFFE"}, {"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE"}};
        OC_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.cfgi.0");
        OV_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.cfgi.1");
        MAX_TEMP_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.cfgo.0");
        COMPUTE_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.cfgo.1");
        OC_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)1.0, (double)1.0, (double)3.0, (double[])new double[0]);
        OV_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.7, (double)0.8, (double)1.2, (double)2.0, (double[])new double[0]);
        MAX_TEMP_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)-10000.0, (double)0.0, (double)0.0, (double)5000.0, (double[])new double[0]);
        COMPUTE_STATUS = (base, p) -> {
            if (base.eAvailableData < 0L) {
                return LedStatus.STATUS_TOO_LOW;
            }
            if (base.eAvailableData == 0L) {
                return LedStatus.STATUS_NEUTRAL;
            }
            return LedStatus.STATUS_OK;
        };
        STRUCTURE_DEFINITION = null;
    }
}

