/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine.GeneratorMultis;

import com.Nxer.TwistSpaceTechnology.client.texture.TstMachineTextures;
import com.Nxer.TwistSpaceTechnology.common.init.TstBlocks;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.common.tile.TileLargeSolarBoilerRender;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.common.blocks.BlockCasings1;
import gregtech.common.blocks.BlockCasings2;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class TST_LargeSolarBoiler
extends GTCM_MultiMachineBase<TST_LargeSolarBoiler> {
    private static final double heatIncreaseSpeed = 0.001;
    private static final double heatDecreaseSpeed = 1.0E-4;
    private static final long calcificationDelayTicks = 1728000L;
    private static final long calcificationTimeSeconds = 129600L;
    private static final int calcificationFactor = 3;
    private static final int steamProductionBronze = 4800;
    private static final int steamProductionSteel = 14400;
    private static final double heatThresholdToExplode = 0.5;
    private static final long explosionPower = GTValues.V[1];
    private static final FluidStack waterFluid = FluidUtils.getWater((int)1);
    private static final FluidStack distilledWaterFluid = FluidUtils.getDistilledWater((int)1);
    private double heat = 0.0;
    private double calcification = 0.0;
    private long runningTicks = 0L;
    private boolean shouldExplode = false;
    private int machineTier = 1;
    private boolean isRendering = false;
    private int tierFrameCasing = -1;
    private int tierGearBoxCasing = -1;
    private int tierPipeCasing = -1;
    private int tierFireBoxCasing = -1;
    private int tierMachineCasing = -1;
    private static final String STRUCTURE_PIECE_MAIN = "mainLargeSolarBoiler";
    private final int horizontalOffSet = 6;
    private final int verticalOffSet = 0;
    private final int depthOffSet = 0;
    private static IStructureDefinition<TST_LargeSolarBoiler> STRUCTURE_DEFINITION = null;
    private final String[][] shapeMain = new String[][]{{"     C~C     ", " C  CAAAC  C ", "CCC CAAAC CCC", " C  CAAAC  C ", "     CCC     "}, {"     DDD     ", "CAC D   D CAC", "A-A D   D A-A", "CAC D   D CAC", "     DDD     "}, {"     FFF     ", "GJG FHHHF GKG", "JCCEFHHHFECCK", "GJG FHHHF GKG", "     FFF     "}};

    public TST_LargeSolarBoiler(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_LargeSolarBoiler(String aName) {
        super(aName);
    }

    @Override
    @Nonnull
    public CheckRecipeResult checkProcessing() {
        if (!this.isRendering) {
            this.createRenderBlock();
        }
        ArrayList storedFluids = super.getStoredFluids();
        for (FluidStack hatchFluid : storedFluids) {
            boolean shouldIncreaseCalcification;
            boolean hasWater = hatchFluid.isFluidEqual(waterFluid);
            boolean hasDistilledWater = hatchFluid.isFluidEqual(distilledWaterFluid);
            int amountOfFluidInHatch = 0;
            if (hasWater || hasDistilledWater) {
                amountOfFluidInHatch = hatchFluid.amount;
            }
            boolean bl = shouldIncreaseCalcification = this.runningTicks / 20L % 1296L == 0L;
            if (this.runningTicks > 1728000L && shouldIncreaseCalcification && hasWater) {
                this.calcification += 0.01;
                if (this.calcification > 1.0) {
                    this.calcification = 1.0;
                }
            }
            if (amountOfFluidInHatch <= 0) continue;
            if (this.heat < 0.5) {
                this.shouldExplode = false;
            }
            if (this.shouldExplode) {
                for (MTEHatchInput hatch : this.mInputHatches) {
                    hatch.doExplosion(explosionPower);
                }
                return CheckRecipeResultRegistry.NONE;
            }
            int consumedWater = (int)((double)Math.min(amountOfFluidInHatch, this.getSteamProduction() / 160) * this.heat / (this.calcification * 2.0 + 1.0));
            FluidStack liquidToDeplete = hasWater ? FluidUtils.getWater((int)consumedWater) : FluidUtils.getDistilledWater((int)consumedWater);
            if (!super.depleteInput(liquidToDeplete)) continue;
            this.mOutputFluids = new FluidStack[]{FluidUtils.getSteam((int)(consumedWater * 160))};
            this.mMaxProgresstime = 20;
            this.mEfficiency = this.getMaxEfficiency(null);
            this.runningTicks += 20L;
            return CheckRecipeResultRegistry.SUCCESSFUL;
        }
        this.shouldExplode = this.heat >= 0.5;
        return CheckRecipeResultRegistry.NO_RECIPE;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aTick % 20L == 0L && this.mMachine) {
            World world = aBaseMetaTileEntity.getWorld();
            boolean isClearWeather = !world.func_72896_J() && !world.func_72911_I() || aBaseMetaTileEntity.getBiome().field_76751_G == 0.0f;
            boolean isSeeSky = aBaseMetaTileEntity.getSkyAtSide(ForgeDirection.UP);
            boolean isDay = world.func_72935_r();
            if (!(isClearWeather && isSeeSky && isDay)) {
                this.heat -= 1.0E-4;
                if (this.heat < 0.0) {
                    this.heat = 0.0;
                }
            } else {
                this.heat += 0.001;
                if (this.heat > 1.0) {
                    this.heat = 1.0;
                }
            }
        }
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.tierFrameCasing = -1;
        this.tierGearBoxCasing = -1;
        this.tierPipeCasing = -1;
        this.tierFireBoxCasing = -1;
        this.tierMachineCasing = -1;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 6, 0, 0)) {
            if (this.isRendering) {
                this.destroyRenderBlock();
            }
            return false;
        }
        if (this.tierGearBoxCasing == 1 && this.tierPipeCasing == 1 && this.tierFireBoxCasing == 1 && this.tierMachineCasing == 1 && this.tierFrameCasing == 1) {
            this.updateHatchTexture();
            this.machineTier = 1;
            return true;
        }
        if (this.tierGearBoxCasing == 2 && this.tierPipeCasing == 2 && this.tierFireBoxCasing == 2 && this.tierMachineCasing == 2 && this.tierFrameCasing == 2) {
            this.updateHatchTexture();
            this.machineTier = 2;
            return true;
        }
        return false;
    }

    private void updateHatchTexture() {
        for (MTEHatchInput hatch : this.mInputHatches) {
            hatch.updateTexture(this.getCasingTextureID());
        }
        for (MTEHatchInput hatch : this.mOutputHatches) {
            hatch.updateTexture(this.getCasingTextureID());
        }
    }

    private int getCasingTextureID() {
        if (this.machineTier == 2) {
            return ((BlockCasings2)GregTechAPI.sBlockCasings2).getTextureIndex(0);
        }
        return ((BlockCasings1)GregTechAPI.sBlockCasings1).getTextureIndex(10);
    }

    public void onValueUpdate(byte aValue) {
        this.machineTier = aValue;
    }

    public byte getUpdateData() {
        return (byte)this.machineTier;
    }

    private int getSteamProduction() {
        if (this.machineTier == 2) {
            return 14400;
        }
        return 4800;
    }

    public void createRenderBlock() {
        int x = this.getBaseMetaTileEntity().getXCoord();
        short y = this.getBaseMetaTileEntity().getYCoord();
        int z = this.getBaseMetaTileEntity().getZCoord();
        int xBackOffset = this.getExtendedFacing().getRelativeBackInWorld().offsetX;
        int zBackOffset = this.getExtendedFacing().getRelativeBackInWorld().offsetZ;
        int xRightOffset = this.getExtendedFacing().getRelativeLeftInWorld().offsetX;
        int zRightOffset = this.getExtendedFacing().getRelativeLeftInWorld().offsetZ;
        if (this.getBaseMetaTileEntity().getWorld().func_147439_a(x + xBackOffset * 2, y - 1, z + zBackOffset * 2).equals(Blocks.field_150350_a)) {
            this.getBaseMetaTileEntity().getWorld().func_147449_b(x + xBackOffset * 2, y - 1, z + zBackOffset * 2, TstBlocks.BlockLargeSolarBoilerRender);
            TileEntity tileEntity = this.getBaseMetaTileEntity().getWorld().func_147438_o(x + xBackOffset * 2, y - 1, z + zBackOffset * 2);
            if (tileEntity instanceof TileLargeSolarBoilerRender) {
                TileLargeSolarBoilerRender tileRenderer = (TileLargeSolarBoilerRender)tileEntity;
                tileRenderer.zBackOffset = zBackOffset;
                tileRenderer.xRightOffset = xRightOffset;
                tileRenderer.zRightOffset = zRightOffset;
                tileRenderer.updateToClient();
            }
        }
        this.isRendering = true;
    }

    private void destroyRenderBlock() {
        IGregTechTileEntity gregTechTileEntity = this.getBaseMetaTileEntity();
        int x = gregTechTileEntity.getXCoord();
        short y = gregTechTileEntity.getYCoord();
        int z = gregTechTileEntity.getZCoord();
        int xBackOffset = this.getExtendedFacing().getRelativeBackInWorld().offsetX;
        int zBackOffset = this.getExtendedFacing().getRelativeBackInWorld().offsetZ;
        if (this.getBaseMetaTileEntity().getWorld().func_147439_a(x + xBackOffset * 2, y - 1, z + zBackOffset * 2).equals(TstBlocks.BlockLargeSolarBoilerRender)) {
            this.getBaseMetaTileEntity().getWorld().func_147449_b(x + xBackOffset * 2, y - 1, z + zBackOffset * 2, Blocks.field_150350_a);
        }
        this.isRendering = false;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 6, 0, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 6, 0, 0, elementBudget, env, false, true);
    }

    public IStructureDefinition<TST_LargeSolarBoiler> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])this.shapeMain)).addElement('A', GTStructureUtility.chainAllGlasses()).addElement('J', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(TST_LargeSolarBoiler.class).atLeast(new IHatchElement[]{HatchElement.InputHatch}).casingIndex(this.getCasingTextureID()).dot(1).build(), StructureUtility.ofBlocksTiered(TST_LargeSolarBoiler::getMachineCasingTier, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings1, (Object)10), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)0)), (Object)-1, (t, m) -> {
                t.tierMachineCasing = m;
            }, t -> t.tierMachineCasing)})).addElement('K', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(TST_LargeSolarBoiler.class).atLeast(new IHatchElement[]{HatchElement.OutputHatch}).casingIndex(this.getCasingTextureID()).dot(2).build(), StructureUtility.ofBlocksTiered(TST_LargeSolarBoiler::getMachineCasingTier, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings1, (Object)10), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)0)), (Object)-1, (t, m) -> {
                t.tierMachineCasing = m;
            }, t -> t.tierMachineCasing)})).addElement('C', StructureUtility.ofBlocksTiered(TST_LargeSolarBoiler::getMachineCasingTier, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings1, (Object)10), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)0)), (Object)-1, (t, m) -> {
                t.tierMachineCasing = m;
            }, t -> t.tierMachineCasing)).addElement('D', StructureUtility.ofBlocksTiered(TST_LargeSolarBoiler::getGearBoxCasingTier, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)2), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)3)), (Object)-1, (t, m) -> {
                t.tierGearBoxCasing = m;
            }, t -> t.tierGearBoxCasing)).addElement('E', StructureUtility.ofBlocksTiered(TST_LargeSolarBoiler::getPipeCasingTier, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)12), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)13)), (Object)-1, (t, m) -> {
                t.tierPipeCasing = m;
            }, t -> t.tierPipeCasing)).addElement('F', StructureUtility.ofBlocksTiered(TST_LargeSolarBoiler::getFireBoxCasingTier, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings3, (Object)13), (Object)Pair.of((Object)GregTechAPI.sBlockCasings3, (Object)14)), (Object)-1, (t, m) -> {
                t.tierFireBoxCasing = m;
            }, t -> t.tierFireBoxCasing)).addElement('G', StructureUtility.ofBlocksTiered(TST_LargeSolarBoiler::getFrameCasingTier, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockFrames, (Object)300), (Object)Pair.of((Object)GregTechAPI.sBlockFrames, (Object)305)), (Object)-1, (t, m) -> {
                t.tierFrameCasing = m;
            }, t -> t.tierFrameCasing)).addElement('H', StructureUtility.ofBlock((Block)GregTechAPI.sBlockMetal6, (int)10)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public static Integer getFrameCasingTier(Block block, int meta) {
        if (block == GregTechAPI.sBlockFrames && meta == 300) {
            return 1;
        }
        if (block == GregTechAPI.sBlockFrames && meta == 305) {
            return 2;
        }
        return null;
    }

    public static Integer getGearBoxCasingTier(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings2 && meta == 2) {
            return 1;
        }
        if (block == GregTechAPI.sBlockCasings2 && meta == 3) {
            return 2;
        }
        return null;
    }

    public static Integer getPipeCasingTier(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings2 && meta == 12) {
            return 1;
        }
        if (block == GregTechAPI.sBlockCasings2 && meta == 13) {
            return 2;
        }
        return null;
    }

    public static Integer getFireBoxCasingTier(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings3 && meta == 13) {
            return 1;
        }
        if (block == GregTechAPI.sBlockCasings3 && meta == 14) {
            return 2;
        }
        return null;
    }

    public static Integer getMachineCasingTier(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings1 && meta == 10) {
            return 1;
        }
        if (block == GregTechAPI.sBlockCasings2 && meta == 0) {
            return 2;
        }
        return null;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextEnums.tr("TST_LargeSolarBoiler.machineType")).addInfo(TextEnums.tr("TST_LargeSolarBoiler.tooltip.01")).addInfo(TextEnums.tr("TST_LargeSolarBoiler.tooltip.02")).addInfo(TextEnums.tr("TST_LargeSolarBoiler.tooltip.03")).addInfo(TextEnums.tr("TST_LargeSolarBoiler.tooltip.04") + " (" + 0.1 + "%/s) " + TextEnums.tr("TST_LargeSolarBoiler.tooltip.05")).addInfo(TextEnums.tr("TST_LargeSolarBoiler.tooltip.06") + " (" + 0.01 + "%/s).").addInfo(TextEnums.tr("TST_LargeSolarBoiler.tooltip.07")).addInfo(TextEnums.tr("TST_LargeSolarBoiler.tooltip.08") + " " + EnumChatFormatting.GREEN + String.format("%.1f ", 24.0) + EnumChatFormatting.GRAY + TextEnums.tr("TST_LargeSolarBoiler.tooltip.09") + " " + EnumChatFormatting.GREEN + String.format("%.2f%%", 33.333333333333336) + EnumChatFormatting.GRAY + ".").addInfo(TextEnums.tr("TST_LargeSolarBoiler.tooltip.10") + " " + EnumChatFormatting.GREEN + String.format("%.1f ", 36.0) + EnumChatFormatting.GRAY + TextEnums.tr("TST_LargeSolarBoiler.tooltip.11")).addInfo(TextEnums.tr("TST_LargeSolarBoiler.tooltip.17")).addSeparator().addInfo(TextEnums.tr("TST_LargeSolarBoiler.tooltip.16")).addSeparator().addInfo(TextEnums.tr("TST_LargeSolarBoiler.tooltip.12")).addInfo(TextEnums.tr("TST_LargeSolarBoiler.tooltip.13")).addInfo("  - " + TextEnums.tr("TST_LargeSolarBoiler.tooltip.14") + " " + EnumChatFormatting.WHITE + 4800 + " L/s" + EnumChatFormatting.GRAY).addInfo("  - " + TextEnums.tr("TST_LargeSolarBoiler.tooltip.15") + " " + EnumChatFormatting.WHITE + 14400 + " L/s" + EnumChatFormatting.GRAY).addSeparator().addInfo(TextEnums.Author_Faotik.getText()).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    @Override
    public boolean supportsVoidProtection() {
        return false;
    }

    @Override
    public boolean supportsInputSeparation() {
        return false;
    }

    @Override
    public boolean supportsBatchMode() {
        return false;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_LargeSolarBoiler(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)this.getCasingTextureID()), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)this.getCasingTextureID()), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)this.getCasingTextureID())};
    }

    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)((Column)((Column)screenElements.widget((Widget)new TextWidget().setStringSupplier(() -> EnumChatFormatting.WHITE + TextEnums.tr("TST_LargeSolarBoiler.gui.02") + " " + EnumChatFormatting.GOLD + this.numberFormat.format((long)((int)(this.heat * 100.0))) + "% " + EnumChatFormatting.RESET))).widget((Widget)new TextWidget().setStringSupplier(() -> EnumChatFormatting.WHITE + TextEnums.tr("TST_LargeSolarBoiler.gui.03") + " " + EnumChatFormatting.GOLD + this.numberFormat.format((long)((int)(this.calcification * 100.0))) + "% " + EnumChatFormatting.RESET))).widget((Widget)new FakeSyncWidget.DoubleSyncer(() -> this.heat, val -> {
            this.heat = val;
        }))).widget((Widget)new FakeSyncWidget.DoubleSyncer(() -> this.calcification, val -> {
            this.calcification = val;
        }));
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (clickData.mouseButton == 0) {
                this.calcification = 0.0;
                this.runningTicks = 0L;
            }
        }).setPlayClickSound(true).setBackground(() -> new IDrawable[]{GTUITextures.BUTTON_STANDARD, GTUITextures.OVERLAY_BUTTON_MACHINEMODE_WASHPLANT}).addTooltip(EnumChatFormatting.WHITE + TextEnums.tr("TST_LargeSolarBoiler.gui.01") + EnumChatFormatting.RESET).setTooltipShowUpDelay(5).setPos(new Pos2d(174, 91)).setSize(16, 16));
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74780_a("heat", this.heat);
        aNBT.func_74780_a("calcification", this.calcification);
        aNBT.func_74757_a("shouldExplode", this.shouldExplode);
        aNBT.func_74772_a("runningTicks", this.runningTicks);
        aNBT.func_74768_a("machineTier", this.machineTier);
        aNBT.func_74757_a("isRendering", this.isRendering);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.heat = aNBT.func_74769_h("heat");
        this.calcification = aNBT.func_74769_h("calcification");
        this.shouldExplode = aNBT.func_74767_n("shouldExplode");
        this.runningTicks = aNBT.func_74763_f("runningTicks");
        this.machineTier = aNBT.func_74762_e("machineTier");
        this.isRendering = aNBT.func_74767_n("isRendering");
    }

    public void stopMachine(@Nonnull ShutDownReason reason) {
        this.destroyRenderBlock();
        super.stopMachine(reason);
    }

    public void onBlockDestroyed() {
        this.destroyRenderBlock();
        super.onBlockDestroyed();
    }
}

