/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine.GeneratorMultis;

import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.TT_MultiMachineBase_EM;
import com.Nxer.TwistSpaceTechnology.common.misc.CheckRecipeResults.CheckRecipeResults;
import com.Nxer.TwistSpaceTechnology.common.misc.MachineShutDownReasons.SimpleShutDownReasons;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.rewrites.TST_ItemID;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchDynamo;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import tectech.thing.casing.TTCasingsContainer;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;
import tectech.thing.metaTileEntity.multi.base.render.TTRenderedExtendedFacingTexture;

public class GTCM_LightningSpire
extends TT_MultiMachineBase_EM
implements IConstructable,
ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "STRUCTURE_PIECE_MAIN_LR";
    private final int hOffset = 5;
    private final int vOffset = 20;
    private final int dOffset = 3;
    private static IStructureDefinition<GTCM_LightningSpire> STRUCTURE_DEFINITION = null;
    protected final String[][] shapeMain = new String[][]{{"           ", "           ", "           ", "           ", "    CCC    ", "    CCC    ", "    CCC    ", "           ", "           ", "           ", "           "}, {"           ", "           ", "           ", "    CCC    ", "   CCCCC   ", "   CCCCC   ", "   CCCCC   ", "    CCC    ", "           ", "           ", "           "}, {"           ", "           ", "           ", "    CCC    ", "   CCCCC   ", "   CCCCC   ", "   CCCCC   ", "    CCC    ", "           ", "           ", "           "}, {"           ", "           ", "           ", "    CCC    ", "   CCCCC   ", "   CCCCC   ", "   CCCCC   ", "    CCC    ", "           ", "           ", "           "}, {"           ", "           ", "           ", "           ", "    CCC    ", "    CCC    ", "    CCC    ", "           ", "           ", "           ", "           "}, {"           ", "           ", "           ", "           ", "           ", "     D     ", "           ", "           ", "           ", "           ", "           "}, {"           ", "           ", "           ", "    CCC    ", "   C C C   ", "   CCDCC   ", "   C C C   ", "    CCC    ", "           ", "           ", "           "}, {"           ", "           ", "           ", "           ", "           ", "     D     ", "           ", "           ", "           ", "           ", "           "}, {"           ", "           ", "           ", "           ", "           ", "     D     ", "           ", "           ", "           ", "           ", "           "}, {"           ", "           ", "   CCCCC   ", "  C  C  C  ", "  C  C  C  ", "  CCCDCCC  ", "  C  C  C  ", "  C  C  C  ", "   CCCCC   ", "           ", "           "}, {"           ", "           ", "           ", "           ", "           ", "     D     ", "           ", "           ", "           ", "           ", "           "}, {"           ", "           ", "           ", "           ", "           ", "     D     ", "           ", "           ", "           ", "           ", "           "}, {"           ", "           ", "           ", "           ", "           ", "     D     ", "           ", "           ", "           ", "           ", "           "}, {"           ", "   CCCCC   ", "  C  C  C  ", " C   C   C ", " C   C   C ", " CCCCDCCCC ", " C   C   C ", " C   C   C ", "  C  C  C  ", "   CCCCC   ", "           "}, {"           ", "           ", "           ", "           ", "           ", "     D     ", "           ", "           ", "           ", "           ", "           "}, {"           ", "           ", "           ", "           ", "           ", "     D     ", "           ", "           ", "           ", "           ", "           "}, {"           ", "           ", "           ", "           ", "           ", "     D     ", "           ", "           ", "           ", "           ", "           "}, {"           ", "           ", "           ", "           ", "           ", "     D     ", "           ", "           ", "           ", "           ", "           "}, {"           ", "           ", "           ", "           ", "    BBB    ", "    BDB    ", "    BBB    ", "           ", "           ", "           ", "           "}, {"           ", "           ", "           ", "    BBB    ", "   BCCCB   ", "   BCDCB   ", "   BCCCB   ", "    BBB    ", "           ", "           ", "           "}, {"           ", "           ", "           ", "    B~B    ", "   BCCCB   ", "   BCDCB   ", "   BCCCB   ", "    BBB    ", "           ", "           ", "           "}, {"           ", "           ", "    BBB    ", "   BBBBB   ", "  BBAAABB  ", "  BBADABB  ", "  BBAAABB  ", "   BBBBB   ", "    BBB    ", "           ", "           "}, {"   BBBBB   ", "  BBBBBBB  ", " BBBBBBBBB ", "BBBBBBBBBBB", "BBBBAAABBBB", "BBBBABABBBB", "BBBBAAABBBB", "BBBBBBBBBBB", " BBBBBBBBB ", "  BBBBBBB  ", "   BBBBB   "}};
    public static final int CRYOTHEUM_CONSUMPTION = 128;
    protected static Fluid MOLTEN_IRON;
    protected static Fluid CRYOTHEUM;
    private static final int MAXRODS = 512;
    List<ItemStack> mStored = new ArrayList<ItemStack>();
    private long tStored;
    private long tProduct;
    private long tMaxStored;
    private int OperatingMode = 0;
    protected boolean enable_lightning = true;
    private int tRods;
    private int aX;
    private int aY;
    private int aZ;

    public GTCM_LightningSpire(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
        this.useLongPower = true;
    }

    public GTCM_LightningSpire(String name) {
        super(name);
        this.useLongPower = true;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GTCM_LightningSpire(this.mName);
    }

    public IStructureDefinition<GTCM_LightningSpire> getStructure_EM() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])this.shapeMain)).addElement('C', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsBA0, (int)7)).addElement('D', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsBA0, (int)8)).addElement('A', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsBA0, (int)4)).addElement('B', (IStructureElement)GTStructureUtility.buildHatchAdder(GTCM_LightningSpire.class).atLeast(new IHatchElement[]{HatchElement.Dynamo.or((IHatchElement)TTMultiblockBase.HatchElement.DynamoMulti), HatchElement.InputBus, HatchElement.InputHatch, HatchElement.OutputBus}).dot(1).casingIndex(1046).buildAndChain(TTCasingsContainer.sBlockCasingsBA0, 6)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.repairMachine();
        if (!this.structureCheck_EM(STRUCTURE_PIECE_MAIN, 5, 20, 3)) {
            return false;
        }
        this.setLightningPosition(this.getBaseMetaTileEntity().getFrontFacing());
        return true;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(STRUCTURE_PIECE_MAIN, 5, 20, 3, stackSize, hintsOnly);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 5, 20, 3, elementBudget, env, false, true);
    }

    public void onFirstTick_EM(IGregTechTileEntity aBaseMetaTileEntity) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (null == MOLTEN_IRON) {
                MOLTEN_IRON = Materials.Iron.getMolten(1L).getFluid();
            }
            if (null == CRYOTHEUM) {
                CRYOTHEUM = FluidRegistry.getFluid((String)"cryotheum");
            }
        }
    }

    private void setLightningPosition(ForgeDirection face) {
        this.aY = this.getBaseMetaTileEntity().getYCoord() + 21;
        if (face == ForgeDirection.NORTH) {
            this.aX = this.getBaseMetaTileEntity().getXCoord();
            this.aZ = this.getBaseMetaTileEntity().getZCoord() + 2;
        } else if (face == ForgeDirection.SOUTH) {
            this.aX = this.getBaseMetaTileEntity().getXCoord();
            this.aZ = this.getBaseMetaTileEntity().getZCoord() - 2;
        } else if (face == ForgeDirection.WEST) {
            this.aX = this.getBaseMetaTileEntity().getXCoord() + 2;
            this.aZ = this.getBaseMetaTileEntity().getZCoord();
        } else if (face == ForgeDirection.EAST) {
            this.aX = this.getBaseMetaTileEntity().getXCoord() - 2;
            this.aZ = this.getBaseMetaTileEntity().getZCoord();
        } else {
            this.aX = this.getBaseMetaTileEntity().getXCoord();
            this.aZ = this.getBaseMetaTileEntity().getZCoord();
        }
    }

    protected void lightOnWorld() {
        if (!this.enable_lightning) {
            return;
        }
        World world = this.getBaseMetaTileEntity().getWorld();
        world.func_72942_c((Entity)new EntityLightningBolt(world, (double)this.aX, (double)this.aY, (double)this.aZ));
    }

    @NotNull
    public CheckRecipeResult checkProcessing_EM() {
        if (this.OperatingMode == 0 && this.tRods > 0) {
            ArrayList tFluids = this.getStoredFluids();
            if (tFluids.isEmpty()) {
                this.stopMachine(SimpleShutDownReasons.NoCorrectFluidInput);
                return CheckRecipeResults.NoCorrectFluidInput;
            }
            int tCryotheum = 0;
            ArrayList<FluidStack> cryotheums = new ArrayList<FluidStack>();
            int tMoltenIron = 0;
            ArrayList<FluidStack> moltenIrons = new ArrayList<FluidStack>();
            for (FluidStack f : tFluids) {
                if (null == f || f.amount < 1) continue;
                if (f.getFluid() == CRYOTHEUM) {
                    tCryotheum += f.amount;
                    cryotheums.add(f);
                    continue;
                }
                if (f.getFluid() != MOLTEN_IRON) continue;
                tMoltenIron += f.amount;
                moltenIrons.add(f);
            }
            int moltenIronConsumption = this.tRods * 72;
            if (tCryotheum == 128 && tMoltenIron == moltenIronConsumption) {
                int toConsume = 128;
                for (FluidStack f : cryotheums) {
                    if (f.amount >= toConsume) {
                        f.amount -= toConsume;
                        break;
                    }
                    toConsume -= f.amount;
                    f.amount = 0;
                }
                toConsume = moltenIronConsumption;
                for (FluidStack f : moltenIrons) {
                    if (f.amount >= toConsume) {
                        f.amount -= toConsume;
                        break;
                    }
                    toConsume -= f.amount;
                    f.amount = 0;
                }
            } else {
                this.stopMachine(SimpleShutDownReasons.NoCorrectFluidInput);
                return CheckRecipeResults.NoCorrectFluidInput;
            }
            this.tStored = Math.min(this.tStored + this.tProduct, this.tMaxStored);
            this.lightOnWorld();
            this.mMaxProgresstime = 256;
            this.updateSlots();
            return CheckRecipeResultRegistry.GENERATING;
        }
        if (this.OperatingMode > 0) {
            if (this.OperatingMode == 1 && this.tRods < 512) {
                TST_ItemID LightningRod = TST_ItemID.createNoNBT(ItemList.Machine_HV_LightningRod.get(1L, new Object[0]));
                int canAdd = 512 - this.tRods;
                ArrayList tInput = this.getStoredInputs();
                if (tInput.isEmpty()) {
                    return CheckRecipeResultRegistry.NO_RECIPE;
                }
                for (ItemStack machine : tInput) {
                    if (null == machine || machine.field_77994_a < 1 || !LightningRod.equalItemStack(machine)) continue;
                    if (canAdd > machine.field_77994_a) {
                        this.mStored.add(machine.func_77946_l());
                        this.tRods += machine.field_77994_a;
                        canAdd -= machine.field_77994_a;
                        machine.field_77994_a = 0;
                        continue;
                    }
                    this.mStored.add(GTUtility.copyAmountUnsafe((int)(512 - this.tRods), (ItemStack)machine));
                    machine.field_77994_a -= canAdd;
                    this.tRods = 512;
                    break;
                }
                this.tProduct = (long)this.tRods * 28000000L;
                this.tMaxStored = (long)this.tRods * 280000000L;
                this.mMaxProgresstime = 20;
                this.updateSlots();
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }
            if (this.OperatingMode == 2 && this.tRods > 0 && this.tStored == 0L) {
                this.mOutputItems = this.mStored.toArray(new ItemStack[0]);
                this.mStored.clear();
                this.updateSlots();
                this.tRods = 0;
                this.tProduct = 0L;
                this.tMaxStored = 0L;
                this.mMaxProgresstime = 20;
                this.updateSlots();
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }
        }
        return CheckRecipeResultRegistry.NO_RECIPE;
    }

    public boolean onRunningTick(ItemStack stack) {
        if (this.tStored > 0L) {
            long power;
            for (MTEHatchDynamo eDynamo : this.mDynamoHatches) {
                if (eDynamo == null || !eDynamo.isValid()) continue;
                power = eDynamo.maxEUStore() - eDynamo.getEUVar();
                if (this.tStored >= power) {
                    eDynamo.setEUVar(eDynamo.getEUVar() + power);
                    this.tStored -= power;
                    continue;
                }
                eDynamo.setEUVar(eDynamo.getEUVar() + this.tStored);
                this.tStored = 0L;
            }
            for (MTEHatchDynamo eDynamo : this.eDynamoMulti) {
                if (eDynamo == null || !eDynamo.isValid()) continue;
                power = eDynamo.maxEUStore() - eDynamo.getEUVar();
                if (this.tStored >= power) {
                    eDynamo.setEUVar(eDynamo.getEUVar() + power);
                    this.tStored -= power;
                    continue;
                }
                eDynamo.setEUVar(eDynamo.getEUVar() + this.tStored);
                this.tStored = 0L;
            }
        }
        return true;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("enable_lightning", this.enable_lightning);
        aNBT.func_74772_a("tStored", this.tStored);
        aNBT.func_74772_a("tProduct", this.tProduct);
        aNBT.func_74772_a("tMaxStored", this.tMaxStored);
        aNBT.func_74768_a("tRods", this.tRods);
        aNBT.func_74768_a("OperatingMode", this.OperatingMode);
        NBTTagList tTags = new NBTTagList();
        for (ItemStack titem : this.mStored) {
            tTags.func_74742_a((NBTBase)titem.func_77955_b(new NBTTagCompound()));
        }
        aNBT.func_74782_a("tTags", (NBTBase)tTags);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.enable_lightning = aNBT.func_74767_n("enable_lightning");
        this.tStored = aNBT.func_74763_f("tStored");
        this.tProduct = aNBT.func_74763_f("tProduct");
        this.tMaxStored = aNBT.func_74763_f("tMaxStored");
        this.tRods = aNBT.func_74762_e("tRods");
        this.OperatingMode = aNBT.func_74762_e("OperatingMode");
        NBTTagList tTags = aNBT.func_150295_c("tTags", 10);
        for (int i = 0; i < tTags.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = tTags.func_150305_b(i);
            this.mStored.add(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][22], new TTRenderedExtendedFacingTexture((IIconContainer)(active ? TTMultiblockBase.ScreenON : TTMultiblockBase.ScreenOFF))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][22]};
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextEnums.tr("GTCM_LightningSpire_MachineType")).addInfo(TextEnums.tr("GTCM_LightningSpire_01")).addInfo(TextEnums.tr("GTCM_LightningSpire_02")).addSeparator().addInfo(TextEnums.tr("GTCM_LightningSpire_03")).addInfo(TextEnums.tr("GTCM_LightningSpire_04")).addInfo(TextEnums.tr("GTCM_LightningSpire_05")).addInfo(TextEnums.tr("GTCM_LightningSpire_06")).addInfo(TextEnums.tr("GTCM_LightningSpire_07")).addSeparator().addInfo(TextEnums.tr("GTCM_LightningSpire_08")).addInfo(TextEnums.tr("GTCM_LightningSpire_09")).addInfo(TextEnums.tr("GTCM_LightningSpire_10")).addInfo(TextEnums.tr("GTCM_LightningSpire_11")).addInfo(TextEnums.tr("GTCM_LightningSpire_12")).addSeparator().beginStructureBlock(11, 23, 11, false).addInputHatch(TextLocalization.BLUE_PRINT_INFO).addInputBus(TextLocalization.BLUE_PRINT_INFO).addOutputBus(TextLocalization.BLUE_PRINT_INFO).addDynamoHatch(TextLocalization.BLUE_PRINT_INFO).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aStack) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.OperatingMode = (this.OperatingMode + 1) % 3;
            GTUtility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)TextEnums.tr("LightningSpire.ModeMsg." + this.OperatingMode)));
        }
    }

    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.enable_lightning = !this.enable_lightning;
            GTUtility.sendChatToPlayer((EntityPlayer)aPlayer, (String)TextEnums.tr("LightningSpire.enable_lightning." + this.enable_lightning));
            return true;
        }
        return false;
    }

    public boolean isPowerPassButtonEnabled() {
        return false;
    }

    public boolean isSafeVoidButtonEnabled() {
        return false;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget(new ProgressBar().setProgress(() -> Float.valueOf((float)this.tStored / (float)this.tMaxStored)).setDirection(ProgressBar.Direction.RIGHT).setTexture(GTUITextures.PROGRESSBAR_STORED_EU, 147).setPos(7, 85).setSize(130, 5));
    }

    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)((Column)((Column)screenElements.widget(new TextWidget().setStringSupplier(() -> "Currently stored LR:" + numberFormat.format((long)this.tRods)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getErrorDisplayID() == 0))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.tRods, val -> {
            this.tRods = val;
        }))).widget(new TextWidget().setStringSupplier(() -> "EU Gen per strike:" + numberFormat.format(this.tProduct)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getErrorDisplayID() == 0))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.tProduct, val -> {
            this.tProduct = val;
        }));
    }
}

