/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.item;

import com.Nxer.TwistSpaceTechnology.client.TstCreativeTabs;
import com.Nxer.TwistSpaceTechnology.common.api.IHasTooltips;
import com.Nxer.TwistSpaceTechnology.common.api.IHasVariantAndTooltips;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class AbstractTstMetaItem
extends Item
implements IHasVariantAndTooltips {
    protected final HashSet<Integer> usedMetaIds = new HashSet();
    protected final HashMap<Integer, String[]> tooltipMap = new HashMap();
    protected Map<Integer, IIcon> iconMap = new HashMap<Integer, IIcon>();

    public AbstractTstMetaItem(String unlocalizedName) {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(TstCreativeTabs.TabMetaItems);
        this.func_77655_b(unlocalizedName);
    }

    public int func_77647_b(int aMeta) {
        return aMeta;
    }

    public final String func_77667_c(ItemStack aItemStack) {
        return super.func_77658_a() + "." + aItemStack.func_77960_j();
    }

    public final String func_77658_a() {
        return super.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item aItem, CreativeTabs aCreativeTabs, List<ItemStack> aList) {
        ItemStack[] variants = this.getVariants();
        aList.addAll(Arrays.asList(variants));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack aItemStack, EntityPlayer aEntityPlayer, List<String> aTooltipsList, boolean isAdvancedMode) {
        String[] tooltips = this.getTooltips(aItemStack.func_77960_j(), IHasTooltips.isShiftKeyDown());
        if (tooltips != null) {
            aTooltipsList.addAll(Arrays.asList(tooltips));
        }
    }

    public void func_94581_a(IIconRegister register) {
        this.iconMap = this.registerAllVariantIcons(register, meta -> "gtnhcommunitymod:" + this.field_77774_bZ + "/" + meta);
        this.field_77791_bV = this.iconMap.get(0);
    }

    public IIcon func_77617_a(int meta) {
        return this.iconMap.get(meta);
    }

    @Override
    public ItemStack getVariant(int meta) throws IllegalArgumentException {
        return AbstractTstMetaItem.checkAndGetVariant(this, meta, this.usedMetaIds);
    }

    @Override
    public ItemStack[] getVariants() {
        return AbstractTstMetaItem.getAllVariants(this, this.usedMetaIds);
    }

    @Override
    public ItemStack registerVariant(int meta) throws IllegalArgumentException {
        return AbstractTstMetaItem.checkAndRegisterVariant(this, meta, this.usedMetaIds);
    }

    @Override
    public @Unmodifiable Set<Integer> getVariantIds() {
        return new HashSet<Integer>(this.usedMetaIds);
    }

    @Override
    public void setTooltips(int metaValue, @Nullable String[] tooltips, boolean advanced) {
        this.tooltipMap.put(metaValue, tooltips);
    }

    @Override
    @Nullable
    public String[] getTooltips(int metaValue, boolean advanced) {
        return this.tooltipMap.get(metaValue);
    }

    @ApiStatus.Internal
    protected static ItemStack checkAndGetVariant(Item self, int meta, Collection<Integer> allowMetaValues) throws IllegalArgumentException {
        if (allowMetaValues.contains(meta)) {
            return TstUtils.newItemWithMeta(self, meta);
        }
        throw new IllegalArgumentException("Invalid meta value: " + meta);
    }

    @ApiStatus.Internal
    protected static ItemStack checkAndRegisterVariant(Item self, int meta, Collection<Integer> allowMetaValues) throws IllegalArgumentException {
        if (allowMetaValues.contains(meta)) {
            throw new IllegalArgumentException("Meta value already exists: " + meta + " in " + self.func_77658_a() + " (" + self.getClass().getSimpleName() + ")");
        }
        allowMetaValues.add(meta);
        return TstUtils.newItemWithMeta(self, meta);
    }

    @ApiStatus.Internal
    protected static ItemStack[] getAllVariants(Item self, Collection<Integer> allowMetaValues) {
        return (ItemStack[])allowMetaValues.stream().map(m -> TstUtils.newItemWithMeta(self, (int)m)).toArray(ItemStack[]::new);
    }
}

