# 项目重构

## Image/Model

注意对其修改时不要落下任何用到该Image/Model的 node。

> [!TIP]
>
> 善用全局搜索

## Pipeline

### Sub Node

这里将 `is_sub` (已废弃) 值为 `true` 的 node 称为 `sub node` 。

重构 `sub node` ，有以下几个步骤：

1. 判断该 `sub node` 在 当前node `next` 列表中是否处于最低优先级（即直接放到 当前node `interrupt` 列表中对实际效果有无影响）
2. 若该 `sub node` 不处于最低优先级，重构方法是将 当前node 的 `next` 和 `interrupt` 加入  `sub node` (原 `next` 和 `interrupt` 为空可直接进行，不为空则需考虑是否冲突)；若该 `sub node` 处于最低优先级，重构方法为直接放到 当前node 的 `interrupt` 中
3. 若该 `sub node` 不处于最低优先级，且步骤2的改动会引起冲突，则需要重新考虑任务逻辑
4. 将 `sub node` 的 `is_sub` 属性删除

> [!WARNING]
>
> 以上全部改动均需考虑所有使用该 `sub node` 的 node，不要落下！

### 其它 node

接下来按照其它 node 的重构目的来分别说明如何重构。

#### 规范 node 名称

如果只是想规范 node 名称，则只需通过 vscode 的全局搜索、替换功能完成即可。  
不过需要注意替换时带着双引号替换，以免出现包含该 node 名的其它 node 也被修改。

#### 简化任务流程、减少耦合

先行阅读 [Node 连接](./Pipeline编写.md#node-连接)，向贴合连接原则的方向进行重构。

部分node 可放在 当前node 的 祖先node 的 `interrupt` 中。  
注意移动后将不必要的 next node 删除，避免在 `interrupt` 中继续执行主任务链，导致后续任务报错后跳回 祖先node。

#### 合并相同功能 node

如果有多个 node 都实现了相同的功能，则可以考虑合并为一个 node。

步骤为：

1. 合并前检查该 node `next` 中是否不相关的 node，如有则先将其拆分出来。
2. 合并时所有 node 改用相同规范名称。
3. 合并后检查该 node 在所有任务中的位置是否正确。如本该在 `interrupt` 中的 node 是否位于任务链主干的 `next` 部分。
