#!/sbin/sh
configValue="$1"
nikgapps_config_file_name="$2"
install_partition="$3"
pkg_required_size="$4"
part_size="$5"

make_dir() {
  addToLog "- Creating Directory: $install_partition/$1" "$package_title"
  mkdir -p "$install_partition/$1"
  set_perm 1000 1000 0755 "$install_partition/$1"
}
# Initialize the variables
default_partition="product"
clean_flash_only="false"
product_prefix=$(find_product_prefix "$install_partition")
title="SetupWizardPrebuilt"
package_title="SetupWizard"
pkg_size="13369"
package_name="com.google.android.setupwizard"
packagePath=installSetupWizardFiles
deleteFilesPath=deleteSetupWizardFiles
propFilePath=$(get_prop_file_path $package_title)

remove_aosp_apps_from_rom="
Provision
SetupWizard
LineageSetupWizard
"

delete_overlays="
"

file_list="
___priv-app___SetupWizardPrebuilt/SetupWizardPrebuilt.apk
___etc___permissions/com.google.android.setupwizard.xml
"

remove_overlays() {
   for i in $delete_overlays; do
       delete_overlays "$i" "$propFilePath" "$package_title" 
   done
}

remove_existing_package() {
   # remove the existing folder for clean install of SetupWizard
   delete_package "SetupWizardPrebuilt" "$package_title" 
}

remove_aosp_apps() {
   # Delete the folders that we want to remove with installing SetupWizard
   for i in $remove_aosp_apps_from_rom; do
       RemoveAospAppsFromRom "$i" "$propFilePath" "$package_title" 
   done
}

install_package() {
   remove_existing_package
   remove_aosp_apps
   remove_overlays
   # Create folders and set the permissions
   make_dir "priv-app/SetupWizardPrebuilt"

   delete_prop_lines "$propFilePath"

   # Copy the files and set the permissions
   for i in $file_list; do
       install_file "$i"
   done


       set_prop "setupwizard.feature.baseline_setupwizard_enabled" "true" "$product/etc/build.prop" "$propFilePath" "$package_title"
       set_prop "ro.setupwizard.enterprise_mode" "1" "$product/etc/build.prop" "$propFilePath" "$package_title"
       set_prop "ro.setupwizard.rotation_locked" "true" "$product/etc/build.prop" "$propFilePath" "$package_title"
       set_prop "setupwizard.enable_assist_gesture_training" "true" "$product/etc/build.prop" "$propFilePath" "$package_title"
       set_prop "setupwizard.theme" "glif_v3_light" "$product/etc/build.prop" "$propFilePath" "$package_title"
       set_prop "setupwizard.feature.skip_button_use_mobile_data.carrier1839" "true" "$product/etc/build.prop" "$propFilePath" "$package_title"
       set_prop "setupwizard.feature.show_pai_screen_in_main_flow.carrier1839" "false" "$product/etc/build.prop" "$propFilePath" "$package_title"
       set_prop "setupwizard.feature.show_pixel_tos" "false" "$product/etc/build.prop" "$propFilePath" "$package_title"
       set_prop "setupwizard.feature.show_digital_warranty" "true" "$product/etc/build.prop" "$propFilePath" "$package_title"
       set_prop "ro.setupwizard.esim_cid_ignore" "00000001" "$product/etc/build.prop" "$propFilePath" "$package_title"
       set_prop "ro.setupwizard.setupwizard.feature.show_support_link_in_deferred_setup" "false" "$product/etc/build.prop" "$package_title"
       set_prop "setupwizard.feature.enable_wifi_tracker" "true" "$product/etc/build.prop" "$package_title"
       set_prop "setupwizard.feature.day_night_mode_enabled" "true" "$product/etc/build.prop" "$package_title"
       set_prop "setupwizard.feature.portal_notification" "true" "$product/etc/build.prop" "$package_title"
       set_prop "setupwizard.feature.lifecycle_refactoring" "true" "$product/etc/build.prop" "$propFilePath" "$package_title"
       set_prop "setupwizard.feature.notification_refactoring" "true" "$product/etc/build.prop" "$package_title"
        
   chmod 755 "$COMMONDIR/addon.sh";
   update_prop "$propFilePath" "install" "$propFilePath" "SetupWizard" 
   . $COMMONDIR/addon.sh "SetupWizard" "$propFilePath" "07"
   copy_file "$propFilePath" "$logDir/addonfiles/$package_title.prop"
}

find_install_mode

