#!/sbin/sh
configValue="$1"
nikgapps_config_file_name="$2"
install_partition="$3"
pkg_required_size="$4"
part_size="$5"

make_dir() {
  addToLog "- Creating Directory: $install_partition/$1" "$package_title"
  mkdir -p "$install_partition/$1"
  set_perm 1000 1000 0755 "$install_partition/$1"
}
# Initialize the variables
default_partition="product"
clean_flash_only="false"
product_prefix=$(find_product_prefix "$install_partition")
title="DevicePersonalizationPrebuiltPixel2024-U.32_V.7_playstore_aiai_20240725.00_RC08"
package_title="DevicePersonalizationServices"
pkg_size="108724"
package_name="com.google.android.as"
packagePath=installDevicePersonalizationServicesFiles
deleteFilesPath=deleteDevicePersonalizationServicesFiles
propFilePath=$(get_prop_file_path $package_title)

remove_aosp_apps_from_rom="
DevicePersonalizationPrebuiltPixel2
DevicePersonalizationPrebuiltPixel3
DevicePersonalizationPrebuiltPixel4
DevicePersonalizationPrebuiltPixel2020
DevicePersonalizationPrebuiltPixel2021
DevicePersonalizationPrebuiltPixel2021-v.U.14.playstore
DevicePersonalizationPrebuiltPixel2021-aiai_20240329.00_RC16
DevicePersonalizationPrebuiltPixel2021-U.32_V.7_playstore_aiai_20240725.00_RC08
DevicePersonalizationPrebuiltPixel2022
DevicePersonalizationPrebuiltPixel2022-v.U.14.playstore
DevicePersonalizationPrebuiltPixel2022-aiai_20240329.00_RC16
DevicePersonalizationPrebuiltPixel2022-U.32_V.7_playstore_aiai_20240725.00_RC08
DevicePersonalizationPrebuiltPixel2023
DevicePersonalizationPrebuiltPixel2023-v.U.14.playstore
DevicePersonalizationPrebuiltPixel2023-aiai_20240329.00_RC16
DevicePersonalizationPrebuiltPixel2023-U.32_V.7_playstore_aiai_20240725.00_RC08
DevicePersonalizationPrebuiltPixel2024-aiai_20240329.00_RC16
DevicePersonalizationPrebuiltPixelTablet2023-U.32_V.7_playstore_aiai_20240725.00_RC08
DevicePersonalizationPrebuiltPixelTablet2024-U.32_V.7_playstore_aiai_20240725.00_RC08
"

delete_overlays="
"

file_list="
___overlay/DevicePersonalizationServicesOverlay.apk
___priv-app___DevicePersonalizationPrebuiltPixel2024-U.32_V.7_playstore_aiai_20240725.00_RC08/DevicePersonalizationPrebuiltPixel2024-U.32_V.7_playstore_aiai_20240725.00_RC08.apk
___system___etc___textclassifier/actions_suggestions.universal.model
___system___etc___textclassifier/textclassifier.universal.model
___system___etc___textclassifier/textclassifier.en.model
___system___etc___textclassifier/lang_id.model
___etc___permissions/com.google.android.as.xml
"

remove_overlays() {
   for i in $delete_overlays; do
       delete_overlays "$i" "$propFilePath" "$package_title" 
   done
}

remove_existing_package() {
   # remove the existing folder for clean install of DevicePersonalizationServices
   delete_package "DevicePersonalizationPrebuiltPixel2024-U.32_V.7_playstore_aiai_20240725.00_RC08" "$package_title" 
}

remove_aosp_apps() {
   # Delete the folders that we want to remove with installing DevicePersonalizationServices
   for i in $remove_aosp_apps_from_rom; do
       RemoveAospAppsFromRom "$i" "$propFilePath" "$package_title" 
   done
}

install_package() {
   remove_existing_package
   remove_aosp_apps
   remove_overlays
   # Create folders and set the permissions

   delete_prop_lines "$propFilePath"

   # Copy the files and set the permissions
   for i in $file_list; do
       install_file "$i"
   done

   chmod 755 "$COMMONDIR/addon.sh";
   update_prop "$propFilePath" "install" "$propFilePath" "DevicePersonalizationServices" 
   . $COMMONDIR/addon.sh "DevicePersonalizationServices" "$propFilePath" "09"
   copy_file "$propFilePath" "$logDir/addonfiles/$package_title.prop"
}

find_install_mode

