/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.meta;

import arc.Core;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Floatf;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.event.HandCursorListener;
import arc.scene.style.Drawable;
import arc.scene.ui.Image;
import arc.scene.ui.Label;
import arc.scene.ui.Tooltip;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Collapser;
import arc.scene.ui.layout.Stack;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectFloatMap;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.content.StatusEffects;
import mindustry.core.UI;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.abilities.Ability;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.ContinuousFlameBulletType;
import mindustry.entities.bullet.ContinuousLaserBulletType;
import mindustry.entities.bullet.EmpBulletType;
import mindustry.entities.bullet.LaserBulletType;
import mindustry.entities.bullet.LightningBulletType;
import mindustry.entities.bullet.PointLaserBulletType;
import mindustry.entities.bullet.RailBulletType;
import mindustry.entities.bullet.ShrapnelBulletType;
import mindustry.gen.Icon;
import mindustry.maps.Map;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.type.PayloadStack;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.production.BurstDrill;
import mindustry.world.blocks.production.Drill;
import mindustry.world.blocks.production.Separator;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValue;

public class StatValues {
    public static StatValue string(String value, Object ... args) {
        String result = Strings.format(value, args);
        return table -> table.add(result);
    }

    public static StatValue bool(boolean value) {
        return table -> table.add(!value ? "@no" : "@yes");
    }

    public static String fixValue(float value) {
        return Strings.autoFixed(value, 3);
    }

    public static StatValue squared(float value, StatUnit unit) {
        return table -> {
            String fixed = StatValues.fixValue(value);
            table.add(fixed + "x" + fixed);
            table.add((unit.space ? " " : "") + unit.localized());
        };
    }

    public static StatValue number(float value, StatUnit unit, boolean merge) {
        return table -> {
            String l1 = (unit.icon == null ? "" : unit.icon + " ") + StatValues.fixValue(value);
            String l2 = (unit.space ? " " : "") + unit.localized();
            if (merge) {
                table.add(l1 + l2).left();
            } else {
                table.add(l1).left();
                table.add(l2).left();
            }
        };
    }

    public static StatValue number(float value, StatUnit unit) {
        return StatValues.number(value, unit, false);
    }

    public static StatValue multiplierModifier(float value, StatUnit unit, boolean merge) {
        return table -> {
            String l1 = (unit.icon == null ? "" : unit.icon + " ") + StatValues.multStat(value);
            String l2 = (unit.space ? " " : "") + unit.localized();
            if (merge) {
                table.add(l1 + l2).left();
            } else {
                table.add(l1).left();
                table.add(l2).left();
            }
        };
    }

    public static StatValue multiplierModifier(float value, StatUnit unit) {
        return StatValues.multiplierModifier(value, unit, true);
    }

    public static StatValue multiplierModifier(float value) {
        return StatValues.multiplierModifier(value, StatUnit.multiplier);
    }

    public static StatValue percentModifier(float value, StatUnit unit, boolean merge) {
        return table -> {
            String l1 = (unit.icon == null ? "" : unit.icon + " ") + StatValues.ammoStat((value - 1.0f) * 100.0f);
            String l2 = (unit.space ? " " : "") + unit.localized();
            if (merge) {
                table.add(l1 + l2).left();
            } else {
                table.add(l1).left();
                table.add(l2).left();
            }
        };
    }

    public static StatValue percentModifier(float value, StatUnit unit) {
        return StatValues.percentModifier(value, unit, true);
    }

    public static StatValue percentModifier(float value) {
        return StatValues.percentModifier(value, StatUnit.percent);
    }

    public static StatValue liquid(Liquid liquid, float amount, boolean perSecond) {
        return table -> table.add(StatValues.displayLiquid(liquid, amount, perSecond)).left();
    }

    public static StatValue liquids(Boolf<Liquid> filter, float amount, boolean perSecond) {
        return table -> {
            Seq<Liquid> list = Vars.content.liquids().select(i -> filter.get((Liquid)i) && i.unlockedNow() && !i.isHidden());
            for (int i2 = 0; i2 < list.size; ++i2) {
                table.add(StatValues.displayLiquid(list.get(i2), amount, perSecond)).padRight(5.0f);
                if (i2 == list.size - 1) continue;
                table.add("/");
            }
        };
    }

    public static StatValue liquids(float timePeriod, LiquidStack ... stacks) {
        return StatValues.liquids(timePeriod, true, stacks);
    }

    public static StatValue liquids(float timePeriod, boolean perSecond, LiquidStack ... stacks) {
        return table -> {
            for (LiquidStack stack : stacks) {
                table.add(StatValues.displayLiquid(stack.liquid, stack.amount * (60.0f / timePeriod), perSecond)).padRight(5.0f);
            }
        };
    }

    public static StatValue items(ItemStack ... stacks) {
        return StatValues.items(true, stacks);
    }

    public static StatValue items(boolean displayName, ItemStack ... stacks) {
        return table -> {
            for (ItemStack stack : stacks) {
                table.add(StatValues.displayItem(stack.item, stack.amount, displayName)).padRight(5.0f);
            }
        };
    }

    public static StatValue items(float timePeriod, ItemStack ... stacks) {
        return table -> {
            for (ItemStack stack : stacks) {
                table.add(StatValues.displayItem(stack.item, stack.amount, timePeriod, true)).padRight(5.0f);
            }
        };
    }

    public static StatValue items(Boolf<Item> filter) {
        return StatValues.items(-1.0f, filter);
    }

    public static StatValue items(float timePeriod, Boolf<Item> filter) {
        return table -> {
            Seq<Item> list = Vars.content.items().select(i -> filter.get((Item)i) && i.unlockedNow() && !i.isHidden());
            for (int i2 = 0; i2 < list.size; ++i2) {
                Item item = list.get(i2);
                table.add(timePeriod <= 0.0f ? StatValues.displayItem(item) : StatValues.displayItem(item, 1, timePeriod, true)).padRight(5.0f);
                if (i2 == list.size - 1) continue;
                table.add("/");
            }
        };
    }

    public static Table displayLiquid(final Liquid liquid, final float amount, boolean perSecond) {
        Table t = new Table();
        t.add(new Stack(){
            {
                this.add(new Image(liquid.uiIcon).setScaling(Scaling.fit));
                if (amount != 0.0f) {
                    Table t = new Table().left().bottom();
                    t.add(Strings.autoFixed(amount, 3)).style(Styles.outlineLabel);
                    this.add(t);
                }
            }
        }).size(32.0f).padRight(3 + (amount != 0.0f ? (Strings.autoFixed(amount, 3).length() - 1) * 10 : 0)).with(s -> StatValues.withTooltip(s, liquid, false));
        if (perSecond && amount != 0.0f) {
            t.add(StatUnit.perSecond.localized()).padLeft(2.0f).padRight(5.0f).color(Color.lightGray).style(Styles.outlineLabel);
        }
        t.add(liquid.localizedName);
        return t;
    }

    public static <T extends Element> T withTooltip(T element, UnlockableContent content, boolean tooltip) {
        if (content != null) {
            if (!Vars.mobile) {
                if (tooltip) {
                    element.addListener(Tooltip.Tooltips.getInstance().create(content.localizedName, Vars.mobile));
                }
                element.addListener(new HandCursorListener(() -> !content.isHidden(), true));
            }
            element.clicked(() -> {
                if (!content.isHidden()) {
                    Vars.ui.content.show(content);
                }
            });
        }
        return element;
    }

    public static <T extends Element> T withTooltip(T element, UnlockableContent content) {
        return StatValues.withTooltip(element, content, false);
    }

    private static Stack stack(TextureRegion region, int amount, @Nullable UnlockableContent content, boolean tooltip) {
        Stack stack = new Stack();
        stack.add(new Table(o -> {
            o.left();
            o.add(new Image(region)).size(32.0f).scaling(Scaling.fit);
        }));
        if (amount != 0) {
            stack.add(new Table(t -> {
                t.left().bottom();
                t.add(amount >= 1000 ? UI.formatAmount(amount) : amount + "").style(Styles.outlineLabel);
                t.pack();
            }));
        }
        StatValues.withTooltip(stack, content, tooltip);
        return stack;
    }

    private static Stack stack(TextureRegion region, int amount, @Nullable UnlockableContent content) {
        return StatValues.stack(region, amount, content, true);
    }

    public static Stack stack(ItemStack stack) {
        return StatValues.stack(stack.item.uiIcon, stack.amount, stack.item);
    }

    public static Stack stack(UnlockableContent item, int amount) {
        return StatValues.stack(item.uiIcon, amount, item);
    }

    public static Stack stack(UnlockableContent item, int amount, boolean tooltip) {
        return StatValues.stack(item.uiIcon, amount, item, tooltip);
    }

    public static Stack stack(Item item) {
        return StatValues.stack(item.uiIcon, 0, item);
    }

    public static Stack stack(PayloadStack stack) {
        return StatValues.stack(stack.item.uiIcon, stack.amount, stack.item);
    }

    public static Table displayItem(Item item) {
        return StatValues.displayItem(item, 0);
    }

    public static Table displayItem(Item item, int amount, boolean showName) {
        Table t = new Table();
        t.add(StatValues.stack(item, amount, !showName));
        if (showName) {
            t.add(item.localizedName).padLeft(4 + amount > 99 ? 4.0f : 0.0f);
        }
        return t;
    }

    public static Table displayItem(Item item, int amount) {
        return StatValues.displayItem(item, amount, true);
    }

    public static Table displayItem(Item item, int amount, float timePeriod, boolean showName) {
        Table t = new Table();
        t.add(StatValues.stack(item, amount, !showName));
        t.add((showName ? item.localizedName + "\n" : "") + "[lightgray]" + Strings.autoFixed((float)amount / (timePeriod / 60.0f), 3) + StatUnit.perSecond.localized()).padLeft(2.0f).padRight(5.0f).style(Styles.outlineLabel);
        return t;
    }

    public static Table displayItemPercent(Item item, int percent, boolean showName) {
        Table t = new Table();
        t.add(StatValues.stack(item, 0, !showName));
        t.add((showName ? item.localizedName + "\n" : "") + "[lightgray]" + percent + "%").padLeft(2.0f).padRight(5.0f).style(Styles.outlineLabel);
        return t;
    }

    public static StatValue content(UnlockableContent content) {
        return table -> {
            table.add(new Image(content.uiIcon)).size(24.0f).padRight(3.0f);
            table.add(content.localizedName).padRight(3.0f);
        };
    }

    public static StatValue blockEfficiency(Block floor, float multiplier, boolean startZero) {
        return table -> table.stack(new Image(floor.uiIcon).setScaling(Scaling.fit), new Table(t -> t.top().right().add((multiplier < 0.0f ? "[scarlet]" : (startZero ? "[accent]" : "[accent]+")) + (int)(multiplier * 100.0f) + "%").style(Styles.outlineLabel))).maxSize(64.0f);
    }

    public static StatValue blocks(Attribute attr, boolean floating, float scale, boolean startZero) {
        return StatValues.blocks(attr, floating, scale, startZero, true);
    }

    public static StatValue blocks(Attribute attr, boolean floating, float scale, boolean startZero, boolean checkFloors) {
        return table -> table.table(c -> {
            Runnable[] rebuild = new Runnable[]{null};
            Map[] lastMap = new Map[]{null};
            rebuild[0] = () -> {
                c.clearChildren();
                c.left();
                if (Vars.state.isGame()) {
                    Seq<Block> blocks = Vars.content.blocks().select(block -> {
                        Floor f;
                        return !(checkFloors && !(block instanceof Floor) || block.attributes.get(attr) == 0.0f || block instanceof Floor && (f = (Floor)block).isDeep() && !floating);
                    }).with(s -> s.sort(f -> f.attributes.get(attr)));
                    if (blocks.any()) {
                        int i = 0;
                        for (Block block2 : blocks) {
                            StatValues.blockEfficiency(block2, block2.attributes.get(attr) * scale, startZero).display((Table)c);
                            if (++i % 5 != 0) continue;
                            c.row();
                        }
                    } else {
                        c.add("@none.inmap");
                    }
                } else {
                    c.add("@stat.showinmap");
                }
            };
            rebuild[0].run();
            c.update(() -> {
                Map current;
                Map map = current = Vars.state.isGame() ? Vars.state.map : null;
                if (current != lastMap[0]) {
                    rebuild[0].run();
                    lastMap[0] = current;
                }
            });
        });
    }

    public static StatValue content(Seq<UnlockableContent> list) {
        return StatValues.content(list, i -> true);
    }

    public static <T extends UnlockableContent> StatValue content(Seq<T> list, Boolf<T> check) {
        return table -> table.table(l -> {
            l.left();
            boolean any = false;
            for (int i = 0; i < list.size; ++i) {
                UnlockableContent item = (UnlockableContent)list.get(i);
                if (!check.get(item)) continue;
                any = true;
                if (item.uiIcon.found()) {
                    l.image(item.uiIcon).size(24.0f).scaling(Scaling.fit).padRight(2.0f).padLeft(2.0f).padTop(3.0f).padBottom(3.0f).with(img -> StatValues.withTooltip(img, item, false));
                }
                l.add(item.localizedName).left().padLeft(1.0f).padRight(4.0f).colspan(item.uiIcon.found() ? 1 : 2);
                if (i % 5 != 4) continue;
                l.row();
            }
            if (!any) {
                l.add("@none.inmap");
            }
        });
    }

    public static StatValue drillUnit(UnitType unit) {
        Seq<Block> list = Vars.content.blocks().select(b -> {
            block3: {
                block2: {
                    if (b.itemDrop == null) return false;
                    if (!(b instanceof Floor)) break block2;
                    Floor f = (Floor)b;
                    if (f.wallOre && unit.mineWalls || !f.wallOre && unit.mineFloor) break block3;
                }
                if (b instanceof Floor) return false;
                if (!unit.mineWalls) return false;
            }
            if (b.itemDrop.hardness > unit.mineTier) return false;
            if (!b.playerUnmineable) return true;
            if (!Core.settings.getBool("doubletapmine")) return false;
            return true;
        });
        list.sort(t -> t.itemDrop.hardness);
        return table -> {
            table.row();
            table.table(t -> {
                t.background(Styles.grayPanel);
                t.table(tt -> {
                    StringBuilder oreList = new StringBuilder();
                    if (unit.mineHardnessScaling) {
                        for (int i = 0; i < list.size; ++i) {
                            Block block = (Block)list.get(i);
                            oreList.append(block.emoji()).append(" ").append(block.localizedName);
                            if (i == list.size - 1 || ((Block)list.get((int)(i + 1))).itemDrop.hardness != block.itemDrop.hardness) {
                                tt.labelWrap(oreList.toString()).width(250.0f).padLeft(20.0f).padTop(5.0f);
                                float eff = 60.0f * unit.mineSpeed / (50.0f + (float)((Block)list.get((int)i)).itemDrop.hardness * 15.0f);
                                tt.add("[stat]" + Strings.fixed(eff, 2)).padLeft(20.0f);
                                tt.row();
                                oreList = new StringBuilder();
                                continue;
                            }
                            oreList.append("  ");
                        }
                    } else {
                        for (int i = 0; i < list.size; ++i) {
                            Block block = (Block)list.get(i);
                            oreList.append(block.emoji()).append(" ").append(block.localizedName);
                        }
                        tt.labelWrap(oreList.toString()).width(250.0f).padLeft(20.0f).padTop(5.0f);
                        float eff = 60.0f * unit.mineSpeed / 65.0f;
                        tt.add("[stat]" + Strings.fixed(eff, 2)).padLeft(20.0f);
                    }
                });
            });
        };
    }

    public static StatValue drillBlock(Drill drill) {
        Seq<Block> list = Vars.content.blocks().select(b -> {
            if (!(b instanceof Floor)) return false;
            Floor f = (Floor)b;
            if (f.wallOre) return false;
            if (f.itemDrop == null) return false;
            if (f.itemDrop.hardness > drill.tier) return false;
            if (f.itemDrop == drill.blockedItem) return false;
            return true;
        });
        if (drill instanceof BurstDrill) {
            BurstDrill burstDrill = (BurstDrill)drill;
            list.sort(t -> burstDrill.drillMultipliers.get(t.itemDrop, 1.0f));
            return table -> {
                table.row();
                table.table(at -> {
                    at.background(Styles.grayPanel);
                    at.add("[stat]" + drill.tier + "[lightgray]\u7ea7[#" + ARCVars.getThemeColor() + "] ~ [stat]" + Strings.autoFixed(60.0f / drill.drillTime * (float)drill.size * (float)drill.size, 2) + "[lightgray]\u7269\u54c1/s");
                    at.row();
                    at.table(t -> {
                        StringBuilder oreList = new StringBuilder();
                        for (int i = 0; i < list.size; ++i) {
                            Block block = (Block)list.get(i);
                            oreList.append(block.emoji()).append(" ").append(block.localizedName);
                            if (i == list.size - 1 || burstDrill.drillMultipliers.containsKey(((Block)list.get((int)(i + 1))).itemDrop)) {
                                t.labelWrap(oreList.toString()).width(250.0f).padLeft(20.0f).padTop(5.0f);
                                float eff = 60.0f / (drill.drillTime + drill.hardnessDrillMultiplier * (float)block.itemDrop.hardness) * (float)drill.size * (float)drill.size * burstDrill.drillMultipliers.get(block.itemDrop, 1.0f);
                                t.add("[stat]" + Strings.fixed(eff, 2)).padLeft(20.0f);
                                t.add("[cyan]" + Strings.fixed(eff * drill.liquidBoostIntensity * drill.liquidBoostIntensity, 2)).padLeft(20.0f).padRight(20.0f);
                                t.row();
                                oreList = new StringBuilder();
                                continue;
                            }
                            oreList.append("  ");
                        }
                    });
                });
            };
        }
        list.sort(t -> t.itemDrop.hardness);
        return table -> {
            table.row();
            table.table(at -> {
                at.background(Styles.grayPanel);
                at.add("[stat]" + drill.tier + "[lightgray]\u7ea7[#" + ARCVars.getThemeColor() + "] ~ [stat]" + Strings.autoFixed(60.0f / drill.drillTime * (float)drill.size * (float)drill.size, 2) + "[lightgray]\u7269\u54c1/s");
                at.row();
                at.table(t -> {
                    StringBuilder oreList = new StringBuilder();
                    for (int i = 0; i < list.size; ++i) {
                        Block block = (Block)list.get(i);
                        oreList.append(block.emoji()).append(" ").append(block.localizedName);
                        if (i == list.size - 1 || ((Block)list.get((int)(i + 1))).itemDrop.hardness != block.itemDrop.hardness) {
                            t.labelWrap(oreList.toString()).width(250.0f).padLeft(20.0f).padTop(5.0f);
                            float eff = 60.0f / (drill.drillTime + drill.hardnessDrillMultiplier * (float)block.itemDrop.hardness) * (float)drill.size * (float)drill.size;
                            t.add("[stat]" + Strings.fixed(eff, 2)).padLeft(20.0f);
                            t.add("[cyan]" + Strings.fixed(eff * drill.liquidBoostIntensity * drill.liquidBoostIntensity, 2)).padLeft(20.0f).padRight(20.0f);
                            t.row();
                            oreList = new StringBuilder();
                            continue;
                        }
                        oreList.append("  ");
                    }
                });
            });
        };
    }

    public static StatValue arcSeparator(Separator separator) {
        return table -> {
            for (ItemStack stack : separator.results) {
                table.add(StatValues.stack(stack)).padRight(5.0f);
                table.add("  ");
            }
        };
    }

    public static StatValue blocks(Boolf<Block> pred) {
        return StatValues.content(Vars.content.blocks(), pred);
    }

    public static StatValue blocks(Seq<Block> list) {
        return StatValues.content(list.as());
    }

    public static StatValue statusEffects(Seq<StatusEffect> list) {
        return StatValues.content(list.as());
    }

    public static StatValue drillables(float drillTime, float drillMultiplier, float size, ObjectFloatMap<Item> multipliers, Boolf<Block> filter) {
        return table -> {
            table.row();
            table.table(c -> {
                int i = 0;
                for (Block block : Vars.content.blocks()) {
                    if (!filter.get(block)) continue;
                    c.table(Styles.grayPanel, b -> {
                        b.image(block.uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit);
                        b.table(info -> {
                            info.left();
                            info.add(block.localizedName).left().row();
                            info.add(block.itemDrop.emoji()).with(l -> StatValues.withTooltip(l, block.itemDrop)).left();
                        }).grow();
                        b.add(Strings.autoFixed(60.0f / ((drillTime + drillMultiplier * (float)block.itemDrop.hardness) / (multipliers == null ? 1.0f : multipliers.get(block.itemDrop, 1.0f))) * size, 2) + StatUnit.perSecond.localized()).right().pad(10.0f).padRight(15.0f).color(Color.lightGray);
                    }).growX().pad(5.0f);
                    if (++i % 2 != 0) continue;
                    c.row();
                }
            }).growX().colspan(table.getColumns());
        };
    }

    public static StatValue boosters(float reload, float maxUsed, float multiplier, boolean baseReload, Boolf<Liquid> filter) {
        return table -> {
            table.row();
            table.table(c -> {
                for (Liquid liquid : Vars.content.liquids()) {
                    if (!filter.get(liquid)) continue;
                    c.table(Styles.grayPanel, b -> {
                        b.image(liquid.uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit).with(i -> StatValues.withTooltip(i, liquid, false));
                        b.table(info -> {
                            info.add(liquid.localizedName).left().row();
                            info.add(Strings.autoFixed(maxUsed * 60.0f, 2) + StatUnit.perSecond.localized()).left().color(Color.lightGray);
                        });
                        b.table(bt -> {
                            bt.right().defaults().padRight(3.0f).left();
                            float reloadRate = (baseReload ? 1.0f : 0.0f) + maxUsed * multiplier * liquid.heatCapacity;
                            float standardReload = baseReload ? reload : reload / (maxUsed * multiplier * 0.4f);
                            float result = standardReload / (reload / reloadRate);
                            bt.add(Core.bundle.format("bullet.reload", Strings.autoFixed(result * 100.0f, 2))).pad(5.0f);
                        }).right().grow().pad(10.0f).padRight(15.0f);
                    }).growX().pad(5.0f).row();
                }
            }).growX().colspan(table.getColumns());
            table.row();
        };
    }

    public static StatValue itemEffMultiplier(Floatf<Item> efficiency, float timePeriod, Boolf<Item> filter) {
        return StatValues.itemEffMultiplier(efficiency, timePeriod, filter, null);
    }

    public static StatValue itemEffMultiplier(Floatf<Item> efficiency, float timePeriod, Boolf<Item> filter, @Nullable ObjectFloatMap<Item> itemDurationMultipliers) {
        return table -> {
            if (table.getCells().size > 0) {
                table.getCells().peek().growX();
            }
            table.row();
            table.table(c -> {
                for (Item item : Vars.content.items().select(i -> filter.get((Item)i) && i.unlockedNow() && !i.isHidden())) {
                    float timeMultiplier = itemDurationMultipliers == null ? 1.0f : itemDurationMultipliers.get(item, 1.0f);
                    float time = 1.0f / (timePeriod * timeMultiplier / 60.0f);
                    c.table(Styles.grayPanel, b -> {
                        b.image(item.uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit);
                        b.add(item.localizedName + (timePeriod > 0.0f ? "\n[lightgray]" + Strings.autoFixed(time, time < 0.01f ? 4 : 2) + StatUnit.perSecond.localized() : "")).left().grow();
                        b.add(Core.bundle.format("stat.efficiency", StatValues.fixValue(efficiency.get(item) * 100.0f))).right().pad(10.0f).padRight(15.0f);
                    }).growX().pad(5.0f).row();
                }
            }).growX().colspan(table.getColumns()).row();
        };
    }

    public static StatValue liquidEffMultiplier(Floatf<Liquid> efficiency, float amount, Boolf<Liquid> filter) {
        return table -> {
            if (table.getCells().size > 0) {
                table.getCells().peek().growX();
            }
            table.row();
            table.table(c -> {
                for (Liquid liquid : Vars.content.liquids().select(l -> filter.get((Liquid)l) && l.unlockedNow() && !l.isHidden())) {
                    c.table(Styles.grayPanel, b -> {
                        b.add(StatValues.displayLiquid(liquid, amount, true)).pad(10.0f).left().grow();
                        b.add(Core.bundle.format("stat.efficiency", StatValues.fixValue(efficiency.get(liquid) * 100.0f))).right().pad(10.0f).padRight(15.0f);
                    }).growX().pad(5.0f).row();
                }
            }).growX().colspan(table.getColumns()).row();
        };
    }

    public static StatValue speedBoosters(String unit, float amount, float speed, boolean strength, Boolf<Liquid> filter) {
        return StatValues.speedBoosters(unit, amount, speed, strength, filter, false);
    }

    public static StatValue speedBoosters(String unit, float amount, float speed, boolean strength, Boolf<Liquid> filter, Boolean isForce) {
        return table -> {
            table.row();
            table.table(c -> {
                for (Liquid liquid : Vars.content.liquids()) {
                    if (!filter.get(liquid)) continue;
                    c.table(Styles.grayPanel, b -> {
                        b.image(liquid.uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit).with(i -> StatValues.withTooltip(i, liquid, false));
                        b.table(info -> {
                            info.add(liquid.localizedName).left().row();
                            info.add(Strings.autoFixed(amount * 60.0f, 2) + StatUnit.perSecond.localized()).left().color(Color.lightGray);
                        });
                        b.table(bt -> {
                            bt.right().defaults().padRight(3.0f).left();
                            if (isForce.booleanValue()) {
                                bt.add(unit.replace("{0}", "[stat]" + Strings.autoFixed(speed * ((liquid.heatCapacity - 0.4f) * 0.9f + 1.0f), 2) + "[lightgray]")).pad(5.0f);
                            } else if (speed != Float.MAX_VALUE) {
                                bt.add(unit.replace("{0}", "[stat]" + Strings.autoFixed(speed * (strength ? liquid.heatCapacity : 1.0f) + (strength ? 1.0f : 0.0f), 2) + "[lightgray]")).pad(5.0f);
                            }
                        }).right().grow().pad(10.0f).padRight(15.0f);
                    }).growX().pad(5.0f).row();
                }
            }).growX().colspan(table.getColumns());
            table.row();
        };
    }

    public static StatValue itemBoosters(String unit, float timePeriod, float speedBoost, float rangeBoost, ItemStack[] items) {
        return table -> {
            table.row();
            table.table(c -> c.table(Styles.grayPanel, b -> {
                b.table(it -> {
                    for (ItemStack stack : items) {
                        if (timePeriod < 0.0f) {
                            it.add(StatValues.displayItem(stack.item, stack.amount, true)).pad(10.0f).padLeft(15.0f).left();
                        } else {
                            it.add(StatValues.displayItem(stack.item, stack.amount, timePeriod, true)).pad(10.0f).padLeft(15.0f).left();
                        }
                        it.row();
                    }
                }).left();
                b.table(bt -> {
                    bt.right().defaults().padRight(3.0f).left();
                    if (rangeBoost != 0.0f) {
                        bt.add("[lightgray]+[stat]" + Strings.autoFixed(rangeBoost / 8.0f, 2) + "[lightgray] " + StatUnit.blocks.localized()).row();
                    }
                    if (speedBoost != 0.0f) {
                        bt.add("[lightgray]" + unit.replace("{0}", "[stat]" + Strings.autoFixed(speedBoost, 2) + "[lightgray]"));
                    }
                }).right().top().grow().pad(10.0f).padRight(15.0f);
            }).growX().pad(5.0f).padBottom(-5.0f).row()).growX().colspan(table.getColumns());
            table.row();
        };
    }

    public static StatValue weapons(UnitType unit, Seq<Weapon> weapons) {
        return table -> {
            table.row();
            for (int i = 0; i < weapons.size; ++i) {
                Weapon weapon = (Weapon)weapons.get(i);
                if (weapon.flipSprite || !weapon.hasStats(unit)) continue;
                TextureRegion region = !weapon.name.isEmpty() ? Core.atlas.find(weapon.name + "-preview", weapon.region) : null;
                table.table(Styles.grayPanel, w -> {
                    w.left().top().defaults().padRight(3.0f).left();
                    if (region != null && region.found() && weapon.showStatSprite) {
                        w.image(region).size(60.0f).scaling(Scaling.bounded).left().top();
                    }
                    w.row();
                    weapon.addStats(unit, (Table)w);
                }).growX().pad(5.0f).margin(10.0f);
                table.row();
            }
        };
    }

    public static StatValue abilities(Seq<Ability> abilities) {
        return table -> {
            table.row();
            table.table(t -> {
                int count = 0;
                for (Ability ability : abilities) {
                    if (!ability.display) continue;
                    ability.display((Table)t);
                    if (++count != 2) continue;
                    count = 0;
                    t.row();
                }
            });
        };
    }

    public static StatValue targets(UnitType unit, BlockFlag[] targetFlags) {
        return table -> {
            table.row();
            table.table(t -> {
                t.background(Styles.grayPanel);
                for (BlockFlag flag : targetFlags) {
                    if (flag == null) continue;
                    t.add(flag.name()).width(150.0f).padBottom(5.0f);
                    int count = 0;
                    for (Block block : Vars.content.blocks()) {
                        if (!block.flags.contains(flag)) continue;
                        if (count >= 3) {
                            t.add("\ue813").width(30.0f);
                            break;
                        }
                        t.add(block.emoji()).width(30.0f);
                        ++count;
                    }
                    t.row();
                }
            }).padLeft(12.0f);
        };
    }

    public static StatValue abilities(UnitType unit, Seq<Ability> abilities) {
        return table -> {
            table.row();
            table.table(t -> {
                t.background(Styles.grayPanel);
                for (Ability a : abilities) {
                    if (!a.display) continue;
                    if (a.description(unit).length() > 0) {
                        t.table(tt -> {
                            tt.add(a.localized()).width(100.0f);
                            tt.add(a.description(unit)).minWidth(350.0f).padRight(12.0f).padBottom(5.0f);
                        });
                    } else {
                        t.add(a.localized()).minWidth(350.0f).padRight(12.0f).padBottom(5.0f);
                    }
                    t.row();
                }
            }).padLeft(12.0f);
        };
    }

    public static <T extends UnlockableContent> StatValue ammo(ObjectMap<T, BulletType> map) {
        return StatValues.ammo(map, false, false);
    }

    public static <T extends UnlockableContent> StatValue ammo(ObjectMap<T, BulletType> map, boolean showUnit) {
        return StatValues.ammo(map, false, showUnit);
    }

    public static <T extends UnlockableContent> StatValue ammo(ObjectMap<T, BulletType> map, boolean nested, boolean showUnit) {
        return table -> {
            table.row();
            Seq orderedKeys = map.keys().toSeq();
            orderedKeys.sort();
            for (UnlockableContent t : orderedKeys) {
                boolean compact = t instanceof UnitType && !showUnit || nested;
                BulletType type = (BulletType)map.get(t);
                if (type.spawnUnit != null && type.spawnUnit.weapons.size > 0) {
                    StatValues.ammo(ObjectMap.of(t, type.spawnUnit.weapons.first().bullet), nested, false).display(table);
                    continue;
                }
                table.table(Styles.grayPanel, bt -> {
                    Seq<BulletType> spawn;
                    block36: {
                        block37: {
                            bt.left().top().defaults().padRight(3.0f).left();
                            if (!compact && !(t instanceof Turret)) {
                                bt.table(title -> {
                                    title.image(StatValues.icon(t)).size(24.0f).padRight(4.0f).right().scaling(Scaling.fit).top().with(i -> StatValues.withTooltip(i, t, false));
                                    title.add(t.localizedName).padRight(10.0f).left().top();
                                    if (type.displayAmmoMultiplier && type.statLiquidConsumed > 0.0f) {
                                        title.add("[stat]" + StatValues.fixValue(type.statLiquidConsumed / type.ammoMultiplier * 60.0f) + " [lightgray]" + StatUnit.perSecond.localized());
                                    }
                                });
                                bt.row();
                            }
                            if (type instanceof LightningBulletType) {
                                LightningBulletType lb = (LightningBulletType)type;
                                StatValues.lightning(0, lb.damage, lb.lightningLength, lb.lightningLengthRand).display((Table)bt);
                            } else if (type.damage > 0.0f && (type.collides || type.splashDamage <= 0.0f)) {
                                if (type.continuousDamage() > 0.0f) {
                                    bt.add(Core.bundle.format("bullet.damage", Float.valueOf(type.continuousDamage())) + StatUnit.perSecond.localized());
                                } else {
                                    bt.add(Core.bundle.format("bullet.damage", Float.valueOf(type.damage)));
                                }
                            }
                            if (type.buildingDamageMultiplier != 1.0f) {
                                StatValues.sep(bt, StatValues.colorize(type.buildingDamageMultiplier) + "[lightgray]x\u5efa\u7b51\u4f24\u5bb3");
                            }
                            if (type.rangeChange != 0.0f && !compact) {
                                StatValues.sep(bt, "[lightgray]\u5c04\u7a0b + " + StatValues.colorize(type.rangeChange / 8.0f > 0.0f) + Strings.autoFixed(type.rangeChange / 8.0f, 1) + " [lightgray]\u683c");
                            }
                            if (type.shieldDamageMultiplier != 1.0f) {
                                StatValues.sep(bt, Core.bundle.format("bullet.shielddamage", StatValues.ammoStat((int)(type.shieldDamageMultiplier * 100.0f - 100.0f))));
                            }
                            if (type.splashDamage > 0.0f) {
                                StatValues.sep(bt, Core.bundle.format("bullet.splashdamage", (int)type.splashDamage, Strings.fixed(type.splashDamageRadius / 8.0f, 1)));
                            }
                            if (!(type.statLiquidConsumed <= 0.0f) || compact || Mathf.equal(type.ammoMultiplier, 1.0f) || !type.displayAmmoMultiplier) break block36;
                            if (!(t instanceof Turret)) break block37;
                            Turret turret = (Turret)t;
                            if (!turret.displayAmmoMultiplier) break block36;
                        }
                        StatValues.sep(bt, Core.bundle.format("bullet.multiplier", (int)type.ammoMultiplier));
                    }
                    if (!compact && !Mathf.equal(type.reloadMultiplier, 1.0f)) {
                        StatValues.sep(bt, StatValues.colorize(type.reloadMultiplier) + "[lightgray]x\u5c04\u901f");
                    }
                    if (type.knockback > 0.0f) {
                        StatValues.sep(bt, Core.bundle.format("bullet.knockback", Strings.autoFixed(type.knockback, 2)));
                    }
                    if (type.healPercent > 0.0f) {
                        StatValues.sep(bt, Core.bundle.format("bullet.healpercent", Strings.autoFixed(type.healPercent, 2)));
                    }
                    if (type.healAmount > 0.0f) {
                        StatValues.sep(bt, Core.bundle.format("bullet.healamount", Strings.autoFixed(type.healAmount, 2)));
                    }
                    if ((type.pierce || type.pierceCap != -1) && !(type instanceof PointLaserBulletType)) {
                        boolean laserPierce = type instanceof LaserBulletType || type instanceof ContinuousLaserBulletType || type instanceof ShrapnelBulletType;
                        boolean pierceBuilding = laserPierce || type instanceof ContinuousFlameBulletType || type instanceof RailBulletType || type.pierceBuilding;
                        boolean pierceUnit = type.pierce;
                        StringBuilder str = new StringBuilder("[stat]");
                        if (type instanceof RailBulletType) {
                            RailBulletType rail = (RailBulletType)type;
                            str.append(Strings.autoFixed(rail.pierceDamageFactor * 100.0f, 1) + "%\u8870\u51cf");
                        } else {
                            str.append(type.pierceCap == -1 ? "\u65e0\u9650" : type.pierceCap + "x");
                        }
                        str.append("\u7a7f\u900f[lightgray]");
                        if (pierceBuilding && pierceUnit) {
                            str.append("\u5efa\u7b51\u4e0e\u5355\u4f4d");
                        } else {
                            str.append(pierceBuilding ? "\u5efa\u7b51" : "\u5355\u4f4d");
                        }
                        if (laserPierce) {
                            str.append("[stat](\u7535\u6027)");
                        }
                        StatValues.sep(bt, str.toString());
                    }
                    if (type.incendAmount > 0) {
                        StatValues.sep(bt, "@bullet.incendiary");
                    }
                    if (type.homingPower > 0.01f) {
                        StatValues.sep(bt, "[stat]\u8ffd\u8e2a[lightgray]~[]" + Strings.autoFixed(type.homingPower * 50.0f * 60.0f, 1) + "\u00b0/s[lightgray]~[]" + Strings.fixed(type.homingRange / 8.0f, 1) + "[lightgray]\u683c");
                    }
                    if (!(type instanceof LightningBulletType) && type.lightning > 0) {
                        StatValues.lightning(type.lightning, type.lightningDamage < 0.0f ? type.damage : type.lightningDamage, type.lightningLength, type.lightningLengthRand).display((Table)bt);
                    }
                    if (type.pierceArmor) {
                        StatValues.sep(bt, "@bullet.armorpierce");
                    }
                    if (type.maxDamageFraction > 0.0f) {
                        StatValues.sep(bt, Core.bundle.format("bullet.maxdamagefraction", (int)(type.maxDamageFraction * 100.0f)));
                    }
                    if (type.suppressionRange > 0.0f) {
                        StatValues.sep(bt, Core.bundle.format("bullet.suppression", Strings.autoFixed(type.suppressionDuration / 60.0f, 2), Strings.fixed(type.suppressionRange / 8.0f, 1)));
                    }
                    if (type instanceof EmpBulletType) {
                        EmpBulletType eb = (EmpBulletType)type;
                        StatValues.collapser(bt, Strings.format("[stat]EMP~@[lightgray]\u683c[]~[white]\ue810[]@%/[white]\ue86d[]@%~[white]\uf899[][green]@%[]/[negstat]@%[]", Strings.autoFixed(eb.radius / 8.0f, 0), Strings.autoFixed(eb.powerDamageScl * 100.0f, 0), Strings.autoFixed(eb.unitDamageScl * 100.0f, 0), Strings.autoFixed(eb.timeIncrease * 100.0f, 0), Strings.autoFixed(eb.powerSclDecrease * 100.0f, 0)), ec -> {
                            ec.defaults().padLeft(5.0f);
                            StatValues.sep(ec, Strings.format("[stat]\u5bf9\u654c\u65b9\u7535\u7f51\u5efa\u7b51\u9020\u6210@%\u5b50\u5f39\u4f24\u5bb3", Strings.autoFixed(eb.powerDamageScl * 100.0f, 0)));
                            StatValues.sep(ec, Strings.format("[stat]\u5bf9\u654c\u65b9\u5355\u4f4d\u9020\u6210@%\u5b50\u5f39\u4f24\u5bb3", Strings.autoFixed(eb.unitDamageScl * 100.0f, 0)));
                            StatValues.sep(ec, Strings.format("[stat]\u5bf9\u6211\u65b9\u8017\u7535\u5efa\u7b51\u8d85\u901f\u81f3@%", Strings.autoFixed(eb.timeIncrease * 100.0f, 0)));
                            StatValues.sep(ec, Strings.format("[stat]\u5bf9\u654c\u65b9\u7535\u7f51\u5efa\u7b51\u51cf\u901f\u81f3@%", Strings.autoFixed(eb.powerSclDecrease * 100.0f, 0)));
                        });
                    }
                    if (type.status != StatusEffects.none) {
                        StatValues.sep(bt, (type.status.hasEmoji() ? type.status.emoji() : "") + "[stat]" + type.status.localizedName + (type.status.reactive ? "" : "[lightgray] ~ [stat]" + Strings.autoFixed(type.statusDuration / 60.0f, 1) + "[lightgray] " + Core.bundle.get("unit.seconds"))).with(c -> StatValues.withTooltip(c, type.status));
                    }
                    if (!type.targetMissiles) {
                        StatValues.sep(bt, "@bullet.notargetsmissiles");
                    }
                    if (!type.targetBlocks) {
                        StatValues.sep(bt, "@bullet.notargetsbuildings");
                    }
                    if (type.fragBullet != null) {
                        bt.row();
                        Table fc = new Table();
                        StatValues.ammo(ObjectMap.of(t, type.fragBullet), true, false).display(fc);
                        Collapser coll = new Collapser(fc, true);
                        coll.setDuration(0.1f);
                    }
                    if (type.intervalBullet != null) {
                        StatValues.collapser(bt, Core.bundle.format("bullet.interval", Strings.autoFixed((float)type.intervalBullets / type.bulletInterval * 60.0f, 2)), ic -> StatValues.ammo(ObjectMap.of(t, type.intervalBullet), nested, false).display((Table)ic));
                    }
                    if ((spawn = type.spawnBullets.copy()).any()) {
                        StatValues.collapser(bt, Strings.format("[stat]@x[lightgray]\u751f\u6210\u5b50\u5f39\uff1a", spawn.size), sc -> {
                            while (spawn.any()) {
                                BulletType bullet = (BulletType)spawn.first();
                                Boolf<BulletType> pred = b -> bullet.damage == b.damage && bullet.splashDamage == b.splashDamage;
                                int count = spawn.count(pred);
                                if (count == type.spawnBullets.size) {
                                    StatValues.ammo(ObjectMap.of(t, bullet), nested, false).display((Table)sc);
                                } else {
                                    StatValues.sep(sc, Strings.format(" [stat]@x[lightgray]\u5b50\u5f39\uff1a", count)).padLeft(0.0f);
                                    StatValues.ammo(ObjectMap.of(t, bullet), nested, false).display((Table)sc);
                                }
                                bt.row();
                                spawn.removeAll(pred);
                            }
                        });
                    }
                }).padLeft(5.0f).padTop(5.0f).padBottom(compact ? 0.0f : 5.0f).growX().margin(compact ? 0.0f : 10.0f);
                table.row();
            }
        };
    }

    public static StatValue lightning(int shots, float damage, int length, int lengthRand) {
        return table -> {
            String str = "[lightgray]";
            if (shots > 0) {
                str = str + String.format("[stat]%d[]x", shots);
            }
            str = str + String.format("\u95ea\u7535~[stat]%s[]\u4f24\u5bb3~", Strings.autoFixed(damage, 1));
            str = lengthRand > 0 ? str + String.format("[stat]%d~%d[]\u957f\u5ea6", length, length + lengthRand) : str + String.format("[stat]%d[]\u957f\u5ea6", length);
            StatValues.sep(table, str);
        };
    }

    public static StatValue turretReload(Turret turret) {
        return table -> table.add(((float)turret.shoot.totalShots() == 1.0f ? "" : turret.shoot.totalShots() + " x ") + Strings.autoFixed(60.0f / turret.reload, 2) + "/s");
    }

    private static Cell<Label> sep(Table table, String text) {
        table.row();
        return table.add(text);
    }

    private static void collapser(Table table, String text, Cons<Table> cons) {
        table.row();
        Table collt = new Table();
        collt.left().defaults().left();
        cons.get(collt);
        Collapser coll = new Collapser(collt, true);
        coll.setDuration(0.1f);
        table.table(tt -> {
            tt.add(text);
            tt.button((Drawable)Icon.downOpen, Styles.emptyi, () -> coll.toggle(false)).update(i -> {
                i.getStyle().imageUp = !coll.isCollapsed() ? Icon.upOpen : Icon.downOpen;
            }).size(8.0f).padLeft(16.0f).expandX();
        });
        table.row();
        table.add(coll);
    }

    private static String ammoStat(float val) {
        return (val > 0.0f ? "[stat]+" : "[negstat]") + Strings.autoFixed(val, 1);
    }

    private static String colorize(float val) {
        return (val > 1.0f ? "[stat]" : "[negstat]") + Strings.autoFixed(val, 2);
    }

    private static String colorize(boolean val) {
        return val ? "[stat]" : "[negstat]";
    }

    private static String multStat(float val) {
        return (val >= 1.0f ? "[stat]" : "[negstat]") + Strings.autoFixed(val, 2);
    }

    private static TextureRegion icon(UnlockableContent t) {
        return t.uiIcon;
    }
}

