/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.storage;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import java.util.Comparator;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.blocks.storage.StorageBlock;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class Unloader
extends Block {
    public TextureRegion centerRegion;
    public float speed = 1.0f;
    static Item[] allItems;

    public Unloader(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.health = 70;
        this.hasItems = true;
        this.configurable = true;
        this.saveConfig = true;
        this.itemCapacity = 0;
        this.noUpdateDisabled = true;
        this.clearOnDoubleTap = true;
        this.unloadable = false;
        this.config(Item.class, (tile, item) -> {
            tile.sortItem = item;
        });
        this.configClear(tile -> {
            tile.sortItem = null;
        });
    }

    @Override
    public void init() {
        super.init();
        allItems = (Item[])Vars.content.items().toArray(Item.class);
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.speed, 60.0f / this.speed, StatUnit.itemsSecond);
    }

    @Override
    public void drawPlanConfig(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawPlanConfigCenter(plan, plan.config, "unloader-center");
    }

    @Override
    public void setBars() {
        super.setBars();
        this.removeBar("items");
    }

    public class UnloaderBuild
    extends Building {
        public float unloadTimer = 0.0f;
        public int rotations = 0;
        public Item sortItem = null;
        public ContainerStat dumpingFrom;
        public ContainerStat dumpingTo;
        public final Seq<ContainerStat> possibleBlocks = new Seq(ContainerStat.class);
        protected final Comparator<ContainerStat> comparator = (x, y) -> {
            int unloadPriority = Boolean.compare(x.canUnload && !x.canLoad, y.canUnload && !y.canLoad);
            if (unloadPriority != 0) {
                return unloadPriority;
            }
            int loadPriority = Boolean.compare(x.canUnload || !x.canLoad, y.canUnload || !y.canLoad);
            if (loadPriority != 0) {
                return loadPriority;
            }
            int loadFactor = Float.compare(x.loadFactor, y.loadFactor);
            if (loadFactor != 0) {
                return loadFactor;
            }
            return Integer.compare(y.lastUsed, x.lastUsed);
        };

        private boolean isPossibleItem(Item item) {
            boolean hasProvider = false;
            boolean hasReceiver = false;
            boolean isDistinct = false;
            ContainerStat[] pbi = (ContainerStat[])this.possibleBlocks.items;
            int l = this.possibleBlocks.size;
            for (int i = 0; i < l; ++i) {
                ContainerStat pb = pbi[i];
                Building other = pb.building;
                pb.canLoad = pb.notStorage && other.acceptItem(this, item);
                pb.canUnload = other.canUnload() && other.items != null && other.items.has(item);
                isDistinct |= hasProvider && pb.canLoad || hasReceiver && pb.canUnload;
                hasProvider |= pb.canUnload;
                hasReceiver |= pb.canLoad;
            }
            return isDistinct;
        }

        @Override
        public void onProximityUpdate() {
            super.onProximityUpdate();
            Pools.freeAll(this.possibleBlocks, true);
            this.possibleBlocks.clear();
            for (int i = 0; i < this.proximity.size; ++i) {
                boolean canUnload;
                Building other = (Building)this.proximity.get(i);
                if (!other.interactable(this.team)) continue;
                boolean canLoad = !(other.block instanceof StorageBlock);
                boolean bl = canUnload = other.canUnload() && other.items != null;
                if (!canLoad && !canUnload) continue;
                ContainerStat pb = Pools.obtain(ContainerStat.class, ContainerStat::new);
                pb.building = other;
                pb.notStorage = canLoad;
                this.possibleBlocks.add(pb);
            }
        }

        @Override
        public void updateTile() {
            boolean any;
            Item item;
            block8: {
                block7: {
                    if ((this.unloadTimer += this.delta()) < Unloader.this.speed || this.possibleBlocks.size < 2) {
                        return;
                    }
                    item = null;
                    any = false;
                    if (this.sortItem == null) break block7;
                    if (!this.isPossibleItem(this.sortItem)) break block8;
                    item = this.sortItem;
                    break block8;
                }
                int l = allItems.length;
                for (int i = 0; i < l; ++i) {
                    int id = (this.rotations + i + 1) % l;
                    Item possibleItem = allItems[id];
                    if (!this.isPossibleItem(possibleItem)) continue;
                    item = possibleItem;
                    break;
                }
            }
            if (item != null) {
                int i;
                this.rotations = item.id;
                ContainerStat[] pbi = (ContainerStat[])this.possibleBlocks.items;
                int pbs = this.possibleBlocks.size;
                for (i = 0; i < pbs; ++i) {
                    ContainerStat pb = pbi[i];
                    Building other = pb.building;
                    int maxAccepted = other.getMaximumAccepted(item);
                    pb.loadFactor = maxAccepted == 0 || other.items == null ? 0.0f : (float)other.items.get(item) / (float)maxAccepted;
                    pb.lastUsed = (pb.lastUsed + 1) % Integer.MAX_VALUE;
                }
                this.possibleBlocks.sort(this.comparator);
                this.dumpingTo = null;
                this.dumpingFrom = null;
                for (i = 0; i < pbs; ++i) {
                    if (!pbi[i].canLoad) continue;
                    this.dumpingTo = pbi[i];
                    break;
                }
                for (i = pbs - 1; i >= 0; --i) {
                    if (!pbi[i].canUnload) continue;
                    this.dumpingFrom = pbi[i];
                    break;
                }
                if (!(this.dumpingFrom == null || this.dumpingTo == null || this.dumpingFrom.loadFactor == this.dumpingTo.loadFactor && this.dumpingFrom.canLoad)) {
                    this.dumpingTo.building.handleItem(this, item);
                    this.dumpingFrom.building.removeStack(item, 1);
                    this.dumpingTo.lastUsed = 0;
                    this.dumpingFrom.lastUsed = 0;
                    any = true;
                }
            }
            this.unloadTimer = any ? (this.unloadTimer %= Unloader.this.speed) : Math.min(this.unloadTimer, Unloader.this.speed);
        }

        @Override
        public void draw() {
            super.draw();
            if (Core.settings.getBool("arcchoiceuiIcon") && this.sortItem != null) {
                Draw.rect(this.sortItem.uiIcon, this.x, this.y, 4.0f, 4.0f);
            } else {
                Draw.color(this.sortItem == null ? Color.clear : this.sortItem.color);
                Draw.rect(Unloader.this.centerRegion, this.x, this.y);
                Draw.color();
            }
        }

        @Override
        public void drawSelect() {
            super.drawSelect();
            this.drawItemSelection(this.sortItem);
        }

        @Override
        public void buildConfiguration(Table table) {
            ItemSelection.buildTable(Unloader.this, table, Vars.content.items(), () -> this.sortItem, this::configure, Unloader.this.selectionRows, Unloader.this.selectionColumns);
        }

        @Override
        public Item config() {
            return this.sortItem;
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.s(this.sortItem == null ? -1 : (int)this.sortItem.id);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            short id = revision == 1 ? read.s() : (short)read.b();
            this.sortItem = id == -1 ? null : Vars.content.item(id);
        }
    }

    public static class ContainerStat
    implements Pool.Poolable {
        Building building;
        float loadFactor;
        boolean canLoad;
        boolean canUnload;
        boolean notStorage;
        int lastUsed;

        @Override
        public void reset() {
            this.building = null;
        }
    }
}

