/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.sandbox;

import mindustry.world.blocks.power.PowerNode;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class PowerSource
extends PowerNode {
    public float powerProduction = 10000.0f;

    public PowerSource(String name) {
        super(name);
        this.maxNodes = 100;
        this.outputsPower = true;
        this.consumesPower = false;
        this.drawDisabled = true;
        this.envEnabled = -1;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.basePowerGeneration, this.powerProduction * 60.0f, StatUnit.powerSecond);
    }

    public class PowerSourceBuild
    extends PowerNode.PowerNodeBuild {
        @Override
        public void onProximityUpdate() {
            super.onProximityUpdate();
            if (!this.allowUpdate()) {
                this.enabled = false;
            }
        }

        @Override
        public float getPowerProduction() {
            return this.enabled ? PowerSource.this.powerProduction : 0.0f;
        }
    }
}

