/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.Core;
import arc.func.Cons;
import arc.func.Intc2;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.struct.EnumSet;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.entities.Effect;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;

public class WallCrafter
extends Block {
    static int idx = 0;
    public TextureRegion topRegion;
    public TextureRegion rotatorBottomRegion;
    public TextureRegion rotatorRegion;
    public float drillTime = 150.0f;
    public float liquidBoostIntensity = 1.6f;
    public Effect updateEffect = Fx.mineWallSmall;
    public float updateEffectChance = 0.02f;
    public float rotateSpeed = 2.0f;
    public Attribute attribute = Attribute.sand;
    public Item output = Items.sand;
    public float boostItemUseTime = 120.0f;
    public float itemBoostIntensity = 1.6f;
    @Nullable
    public Consume itemConsumer;
    public boolean hasLiquidBooster;
    public final int timerUse = this.timers++;

    public WallCrafter(String name) {
        super(name);
        this.hasItems = true;
        this.rotate = true;
        this.update = true;
        this.solid = true;
        this.regionRotated1 = 1;
        this.envEnabled |= 2;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.drill});
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("drillspeed", e -> new Bar(() -> (this.output == null ? "\u6316\u6398\u901f\u5ea6\uff1a" : this.output.emoji()) + " " + Strings.fixed(e.lastEfficiency * 60.0f / this.drillTime, 2) + "/s", () -> Pal.ammo, () -> e.warmup));
    }

    @Override
    public void setStats() {
        Consume consume;
        boolean consItems;
        super.setStats();
        this.stats.add(Stat.output, this.output);
        this.stats.add(Stat.tiles, StatValues.blocks(this.attribute, this.floating, 1.0f, true, false));
        this.stats.add(Stat.drillSpeed, 60.0f / this.drillTime * (float)this.size, StatUnit.itemsSecond);
        boolean bl = consItems = this.itemConsumer != null;
        if (consItems) {
            this.stats.timePeriod = this.boostItemUseTime;
        }
        if (consItems && (consume = this.itemConsumer) instanceof ConsumeItems) {
            ConsumeItems coni = (ConsumeItems)consume;
            this.stats.remove(Stat.booster);
            this.stats.add(Stat.booster, StatValues.itemBoosters("{0}" + StatUnit.timesSpeed.localized(), this.stats.timePeriod, this.itemBoostIntensity, 0.0f, coni.items));
        }
        if (this.liquidBoostIntensity != 1.0f && (consume = this.findConsumer(f -> f instanceof ConsumeLiquidBase && f.booster)) instanceof ConsumeLiquidBase) {
            ConsumeLiquidBase consBase = (ConsumeLiquidBase)consume;
            this.stats.remove(Stat.booster);
            this.stats.add(Stat.booster, StatValues.speedBoosters("{0}" + StatUnit.timesSpeed.localized(), consBase.amount, this.liquidBoostIntensity, false, consBase::consumes));
        }
    }

    @Override
    public void init() {
        super.init();
        this.hasLiquidBooster = this.findConsumer(f -> f instanceof ConsumeLiquidBase && f.booster) != null;
    }

    @Override
    public boolean outputsItems() {
        return true;
    }

    @Override
    public boolean rotatedOutput(int x, int y) {
        return false;
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.topRegion};
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect(this.region, plan.drawx(), plan.drawy());
        Draw.rect(this.topRegion, plan.drawx(), plan.drawy(), (float)(plan.rotation * 90));
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        float eff = this.getEfficiency(x, y, rotation, null, null);
        this.drawPlaceText(Core.bundle.formatFloat("bar.drillspeed", 60.0f / this.drillTime * eff, 2), x, y, valid);
    }

    @Override
    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        return this.getEfficiency(tile.x, tile.y, rotation, null, null) > 0.0f;
    }

    float getEfficiency(int tx, int ty, int rotation, @Nullable Cons<Tile> ctile, @Nullable Intc2 cpos) {
        float eff = 0.0f;
        int cornerX = tx - (this.size - 1) / 2;
        int cornerY = ty - (this.size - 1) / 2;
        int s = this.size;
        for (int i = 0; i < this.size; ++i) {
            Tile other;
            int rx = 0;
            int ry = 0;
            switch (rotation) {
                case 0: {
                    rx = cornerX + s;
                    ry = cornerY + i;
                    break;
                }
                case 1: {
                    rx = cornerX + i;
                    ry = cornerY + s;
                    break;
                }
                case 2: {
                    rx = cornerX - 1;
                    ry = cornerY + i;
                    break;
                }
                case 3: {
                    rx = cornerX + i;
                    ry = cornerY - 1;
                }
            }
            if (cpos != null) {
                cpos.get(rx, ry);
            }
            if ((other = Vars.world.tile(rx, ry)) == null || !other.solid()) continue;
            float at = other.block().attributes.get(this.attribute);
            eff += at;
            if (!(at > 0.0f) || ctile == null) continue;
            ctile.get(other);
        }
        return eff;
    }

    public class WallCrafterBuild
    extends Building {
        public float time;
        public float warmup;
        public float totalTime;
        public float lastEfficiency;

        @Override
        public void updateTile() {
            super.updateTile();
            boolean cons = this.shouldConsume();
            boolean itemValid = WallCrafter.this.itemConsumer != null && WallCrafter.this.itemConsumer.efficiency(this) > 0.0f;
            this.warmup = Mathf.approachDelta(this.warmup, Mathf.num(this.efficiency > 0.0f), 0.025f);
            float dx = (float)Geometry.d4x(this.rotation) * 0.5f;
            float dy = (float)Geometry.d4y(this.rotation) * 0.5f;
            float eff = WallCrafter.this.getEfficiency(this.tile.x, this.tile.y, this.rotation, dest -> {
                if (this.wasVisible && cons && Mathf.chanceDelta(WallCrafter.this.updateEffectChance * this.warmup)) {
                    WallCrafter.this.updateEffect.at(dest.worldx() + Mathf.range(3.0f) - dx * 8.0f, dest.worldy() + Mathf.range(3.0f) - dy * 8.0f, dest.block().mapColor);
                }
            }, null) * Mathf.lerp(1.0f, WallCrafter.this.liquidBoostIntensity, WallCrafter.this.hasLiquidBooster ? this.optionalEfficiency : 0.0f) * (itemValid ? WallCrafter.this.itemBoostIntensity : 1.0f);
            if (itemValid && eff * this.efficiency > 0.0f && this.timer(WallCrafter.this.timerUse, WallCrafter.this.boostItemUseTime)) {
                this.consume();
            }
            this.lastEfficiency = eff * this.timeScale * this.efficiency;
            if (cons) {
                float f;
                this.time += this.edelta() * eff;
                if (f >= WallCrafter.this.drillTime) {
                    this.offload(WallCrafter.this.output);
                    this.time %= WallCrafter.this.drillTime;
                }
            }
            this.totalTime += this.edelta() * this.warmup * (eff <= 0.0f ? 0.0f : 1.0f);
            if (this.timer(WallCrafter.this.timerDump, (float)WallCrafter.this.dumpTime / this.timeScale)) {
                this.dump(WallCrafter.this.output);
            }
        }

        @Override
        public boolean shouldConsume() {
            return this.items.get(WallCrafter.this.output) < WallCrafter.this.itemCapacity;
        }

        @Override
        public void draw() {
            Draw.rect(this.block.region, this.x, this.y);
            Draw.rect(WallCrafter.this.topRegion, this.x, this.y, this.rotdeg());
            float ds = 0.6f;
            float dx = (float)Geometry.d4x(this.rotation) * ds;
            float dy = (float)Geometry.d4y(this.rotation) * ds;
            int bs = this.rotation == 0 || this.rotation == 3 ? 1 : -1;
            idx = 0;
            WallCrafter.this.getEfficiency(this.tile.x, this.tile.y, this.rotation, null, (cx, cy) -> {
                int sign = idx++ >= WallCrafter.this.size / 2 && WallCrafter.this.size % 2 == 0 ? -1 : 1;
                float vx = ((float)cx - dx) * 8.0f;
                float vy = ((float)cy - dy) * 8.0f;
                Draw.z(35.0f);
                Draw.rect(WallCrafter.this.rotatorBottomRegion, vx, vy, this.totalTime * WallCrafter.this.rotateSpeed * (float)sign * (float)bs);
                Draw.rect(WallCrafter.this.rotatorRegion, vx, vy);
            });
        }
    }
}

