/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.EnumSet;
import arc.struct.ObjectFloatMap;
import arc.struct.ObjectIntMap;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.production.BurstDrill;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;

public class Drill
extends Block {
    public float hardnessDrillMultiplier = 50.0f;
    protected final ObjectIntMap<Item> oreCount = new ObjectIntMap();
    protected final Seq<Item> itemArray = new Seq();
    public int tier;
    public float drillTime = 300.0f;
    public float liquidBoostIntensity = 1.6f;
    public float warmupSpeed = 0.015f;
    @Nullable
    public Item blockedItem;
    @Nullable
    public Seq<Item> blockedItems;
    @Nullable
    protected Item returnItem;
    protected int returnCount;
    public boolean drawMineItem = true;
    public Effect drillEffect = Fx.mine;
    public float drillEffectRnd = -1.0f;
    public float drillEffectChance = 0.02f;
    public float rotateSpeed = 2.0f;
    public Effect updateEffect = Fx.pulverizeSmall;
    public float updateEffectChance = 0.02f;
    public ObjectFloatMap<Item> drillMultipliers = new ObjectFloatMap();
    public boolean drawRim = false;
    public boolean drawSpinSprite = true;
    public Color heatColor = Color.valueOf("ff5512");
    public TextureRegion rimRegion;
    public TextureRegion rotatorRegion;
    public TextureRegion topRegion;
    public TextureRegion itemRegion;

    public Drill(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.group = BlockGroup.drills;
        this.hasLiquids = true;
        this.liquidCapacity = 5.0f;
        this.hasItems = true;
        this.ambientSound = Sounds.drill;
        this.ambientSoundVolume = 0.018f;
        this.envEnabled |= 2;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.drill});
    }

    @Override
    public void init() {
        super.init();
        if (this.blockedItems == null && this.blockedItem != null) {
            this.blockedItems = Seq.with(this.blockedItem);
        }
        if (this.drillEffectRnd < 0.0f) {
            this.drillEffectRnd = this.size;
        }
    }

    @Override
    public void drawPlanConfigTop(BuildPlan plan, Eachable<BuildPlan> list) {
        if (!plan.worldContext) {
            return;
        }
        Tile tile = plan.tile();
        if (tile == null) {
            return;
        }
        this.countOre(tile);
        if (this.returnItem == null || !this.drawMineItem) {
            return;
        }
        Draw.color(this.returnItem.color);
        Draw.rect(this.itemRegion, plan.drawx(), plan.drawy());
        Draw.color();
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("drillspeed", e -> new Bar(() -> (e.dominantItem == null ? "\u6316\u6398\u901f\u5ea6\uff1a" : e.dominantItem.emoji()) + " " + Strings.fixed(e.lastDrillSpeed * 60.0f * e.timeScale(), 2) + "/s", () -> Pal.ammo, () -> e.warmup));
        if (!(this instanceof BurstDrill) && Core.settings.getBool("arcDrillProgress")) {
            this.addBar("progress", e -> new Bar(() -> e.dominantItem == null ? "" : "\ue85e " + Math.round(e.progress / (this.drillTime + this.hardnessDrillMultiplier * (float)e.dominantItem.hardness) * 100.0f) + " %", () -> e.dominantItem == null ? Pal.ammo : e.dominantItem.color, () -> e.dominantItem == null ? 0.0f : e.progress / (this.drillTime + this.hardnessDrillMultiplier * (float)e.dominantItem.hardness)));
        }
    }

    public Item getDrop(Tile tile) {
        return tile.drop();
    }

    @Override
    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        if (this.isMultiblock()) {
            for (Tile other : tile.getLinkedTilesAs((Block)this, tempTiles)) {
                if (!this.canMine(other)) continue;
                return true;
            }
            return false;
        }
        return this.canMine(tile);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return;
        }
        this.countOre(tile);
        if (this.returnItem != null) {
            float speed = 60.0f / this.getDrillTime(this.returnItem) * (float)this.returnCount;
            float width = this.liquidBoostIntensity > 1.0f ? this.drawPurePlaceText("\ue85e []" + this.returnItem.emoji() + this.returnItem.localizedName + " [stat]" + Strings.autoFixed(speed, 2) + "[white]([cyan]" + Strings.autoFixed(speed * this.liquidBoostIntensity * this.liquidBoostIntensity, 2) + "[white])", x, y, valid) : this.drawPurePlaceText("\ue85e " + this.returnItem.emoji() + "[stat]" + this.returnItem.localizedName + " " + Strings.autoFixed(speed, 2), x, y, valid);
            float dx = (float)(x * 8) + this.offset - width / 2.0f - 4.0f;
            float dy = (float)(y * 8) + this.offset + (float)(this.size * 8) / 2.0f + 5.0f;
            float s = 6.0f;
            if (this.drawMineItem) {
                Draw.color(this.returnItem.color);
                Draw.rect(this.itemRegion, tile.worldx() + this.offset, tile.worldy() + this.offset);
                Draw.color();
            }
        } else {
            Item item;
            Tile to = tile.getLinkedTilesAs((Block)this, tempTiles).find(t -> t.drop() != null && (t.drop().hardness > this.tier || this.blockedItems != null && this.blockedItems.contains(t.drop())));
            Item item2 = item = to == null ? null : to.drop();
            if (item != null) {
                if (item == this.blockedItem) {
                    this.drawPlaceText(Core.bundle.format("bar.drillcantmine", new Object[0]), x, y, valid);
                } else {
                    this.drawPlaceText(Core.bundle.format("bar.drilltierreq", item.hardness, this.tier), x, y, valid);
                }
            }
        }
    }

    public float getDrillTime(Item item) {
        return (this.drillTime + this.hardnessDrillMultiplier * (float)item.hardness) / this.drillMultipliers.get(item, 1.0f);
    }

    @Override
    public void setStats() {
        Object t;
        super.setStats();
        this.stats.add(Stat.drillTier, StatValues.drillables(this.drillTime, this.hardnessDrillMultiplier, this.size * this.size, this.drillMultipliers, b -> {
            if (!(b instanceof Floor)) return false;
            Floor f = (Floor)b;
            if (f.wallOre) return false;
            if (f.itemDrop == null) return false;
            if (f.itemDrop.hardness > this.tier) return false;
            if (this.blockedItems != null) {
                if (this.blockedItems.contains(f.itemDrop)) return false;
            }
            if (Vars.indexer.isBlockPresent(f)) return true;
            if (!Vars.state.isMenu()) return false;
            return true;
        }));
        this.stats.add(Stat.drillSpeed, 60.0f / this.drillTime * (float)this.size * (float)this.size, StatUnit.itemsSecond);
        if (this.liquidBoostIntensity != 1.0f && (t = this.findConsumer(f -> f instanceof ConsumeLiquidBase && f.booster)) instanceof ConsumeLiquidBase) {
            ConsumeLiquidBase consBase = (ConsumeLiquidBase)t;
            this.stats.remove(Stat.booster);
            this.stats.add(Stat.booster, StatValues.speedBoosters("{0}" + StatUnit.timesSpeed.localized(), consBase.amount, this.liquidBoostIntensity * this.liquidBoostIntensity, false, consBase::consumes));
        }
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.rotatorRegion, this.topRegion};
    }

    public int countOreArc(Tile tile) {
        this.countOre(tile);
        return this.returnCount;
    }

    protected void countOre(Tile tile) {
        this.returnItem = null;
        this.returnCount = 0;
        this.oreCount.clear();
        this.itemArray.clear();
        for (Tile other : tile.getLinkedTilesAs((Block)this, tempTiles)) {
            if (!this.canMine(other)) continue;
            this.oreCount.increment(this.getDrop(other), 0, 1);
        }
        for (Item item : this.oreCount.keys()) {
            this.itemArray.add(item);
        }
        this.itemArray.sort((item1, item2) -> {
            int type = Boolean.compare(!item1.lowPriority, !item2.lowPriority);
            if (type != 0) {
                return type;
            }
            int amounts = Integer.compare(this.oreCount.get((Item)item1, 0), this.oreCount.get((Item)item2, 0));
            if (amounts != 0) {
                return amounts;
            }
            return Integer.compare(item1.id, item2.id);
        });
        if (this.itemArray.size == 0) {
            return;
        }
        this.returnItem = this.itemArray.peek();
        this.returnCount = this.oreCount.get(this.itemArray.peek(), 0);
    }

    public boolean canMine(Tile tile) {
        if (tile == null || tile.block().isStatic()) {
            return false;
        }
        Item drops = tile.drop();
        return drops != null && drops.hardness <= this.tier && (this.blockedItems == null || !this.blockedItems.contains(drops));
    }

    public class DrillBuild
    extends Building {
        public float progress;
        public float warmup;
        public float timeDrilled;
        public float lastDrillSpeed;
        public int dominantItems;
        public Item dominantItem;

        @Override
        public boolean shouldConsume() {
            return this.items.total() < Drill.this.itemCapacity && this.enabled && this.dominantItem != null;
        }

        @Override
        public boolean shouldAmbientSound() {
            return this.efficiency > 0.01f && this.items.total() < Drill.this.itemCapacity;
        }

        @Override
        public float ambientVolume() {
            return this.efficiency * (float)(Drill.this.size * Drill.this.size) / 4.0f;
        }

        @Override
        public void drawSelect() {
            if (!Core.settings.getBool("arcdrillmode") && this.dominantItem != null) {
                float dx = this.x - (float)(Drill.this.size * 8) / 2.0f;
                float dy = this.y + (float)(Drill.this.size * 8) / 2.0f;
                float s = 6.0f;
                Draw.mixcol(Color.darkGray, 1.0f);
                Draw.rect(this.dominantItem.fullIcon, dx, dy - 1.0f, s, s);
                Draw.reset();
                Draw.rect(this.dominantItem.fullIcon, dx, dy, s, s);
            }
        }

        @Override
        public void pickedUp() {
            this.dominantItem = null;
        }

        @Override
        public void onProximityUpdate() {
            super.onProximityUpdate();
            Drill.this.countOre(this.tile);
            this.dominantItem = Drill.this.returnItem;
            this.dominantItems = Drill.this.returnCount;
        }

        @Override
        public Object senseObject(LAccess sensor) {
            if (sensor == LAccess.firstItem) {
                return this.dominantItem;
            }
            return super.senseObject(sensor);
        }

        @Override
        public void updateTile() {
            if (this.timer(Drill.this.timerDump, (float)Drill.this.dumpTime / this.timeScale)) {
                this.dump(this.dominantItem != null && this.items.has(this.dominantItem) ? this.dominantItem : null);
            }
            if (this.dominantItem == null) {
                return;
            }
            this.timeDrilled += this.warmup * this.delta();
            float delay = Drill.this.getDrillTime(this.dominantItem);
            if (this.items.total() < Drill.this.itemCapacity && this.dominantItems > 0 && this.efficiency > 0.0f) {
                float speed = Mathf.lerp(1.0f, Drill.this.liquidBoostIntensity, this.optionalEfficiency) * this.efficiency;
                this.lastDrillSpeed = speed * (float)this.dominantItems * this.warmup / delay;
                this.warmup = Mathf.approachDelta(this.warmup, speed, Drill.this.warmupSpeed);
                this.progress += this.delta() * (float)this.dominantItems * speed * this.warmup;
                if (Core.settings.getInt("blockRenderLevel") > 1 && Mathf.chanceDelta(Drill.this.updateEffectChance * this.warmup)) {
                    Drill.this.updateEffect.at(this.x + Mathf.range((float)Drill.this.size * 2.0f), this.y + Mathf.range((float)Drill.this.size * 2.0f));
                }
            } else {
                this.lastDrillSpeed = 0.0f;
                this.warmup = Mathf.approachDelta(this.warmup, 0.0f, Drill.this.warmupSpeed);
                return;
            }
            if (this.dominantItems > 0 && this.progress >= delay && this.items.total() < Drill.this.itemCapacity) {
                int amount = (int)(this.progress / delay);
                for (int i = 0; i < amount; ++i) {
                    this.offload(this.dominantItem);
                }
                this.progress %= delay;
                if (Core.settings.getInt("blockRenderLevel") > 1 && this.wasVisible && Mathf.chanceDelta(Drill.this.updateEffectChance * this.warmup)) {
                    Drill.this.drillEffect.at(this.x + Mathf.range(Drill.this.drillEffectRnd), this.y + Mathf.range(Drill.this.drillEffectRnd), this.dominantItem.color);
                }
            }
        }

        @Override
        public float progress() {
            return this.dominantItem == null ? 0.0f : Mathf.clamp(this.progress / Drill.this.getDrillTime(this.dominantItem));
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.progress && this.dominantItem != null) {
                return this.progress;
            }
            return super.sense(sensor);
        }

        @Override
        public void drawCracks() {
        }

        public void drawDefaultCracks() {
            super.drawCracks();
        }

        @Override
        public void draw() {
            float s = 0.3f;
            float ts = 0.6f;
            Draw.rect(Drill.this.region, this.x, this.y);
            Draw.z(30.1f);
            this.drawDefaultCracks();
            Draw.z(30.2f);
            if (Drill.this.drawRim) {
                Draw.color(Drill.this.heatColor);
                Draw.alpha(this.warmup * ts * (1.0f - s + Mathf.absin(Time.time, 3.0f, s)));
                Draw.blend(Blending.additive);
                Draw.rect(Drill.this.rimRegion, this.x, this.y);
                Draw.blend();
                Draw.color();
            }
            if (Drill.this.drawSpinSprite) {
                Drawf.spinSprite(Drill.this.rotatorRegion, this.x, this.y, this.timeDrilled * Drill.this.rotateSpeed);
            } else {
                Draw.rect(Drill.this.rotatorRegion, this.x, this.y, this.timeDrilled * Drill.this.rotateSpeed);
            }
            Draw.rect(Drill.this.topRegion, this.x, this.y);
            if (this.dominantItem != null && Drill.this.drawMineItem) {
                Draw.color(this.dominantItem.color);
                Draw.rect(Drill.this.itemRegion, this.x, this.y);
                Draw.color();
            }
            if (Core.settings.getBool("arcdrillmode") && this.dominantItem != null) {
                float dx = this.x - (float)(Drill.this.size * 8) / 2.0f + 5.0f;
                float dy = this.y - (float)(Drill.this.size * 8) / 2.0f + 5.0f;
                float iconSize = 5.0f;
                Draw.rect(this.dominantItem.fullIcon, dx, dy, iconSize, iconSize);
                Draw.reset();
                float eff = Mathf.lerp(0.0f, 1.0f, Math.min(1.0f, (float)this.dominantItems / (float)(Drill.this.size * Drill.this.size)));
                if (eff < 0.9f) {
                    Draw.alpha(0.5f);
                    Draw.color(this.dominantItem.color);
                    Lines.stroke(1.0f);
                    Lines.arc(dx, dy, iconSize * 0.75f, eff);
                }
            }
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
            write.f(this.warmup);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 1) {
                this.progress = read.f();
                this.warmup = read.f();
            }
        }
    }
}

