/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.Core;
import arc.math.Mathf;
import arc.math.WindowedMean;
import arc.struct.IntSet;
import arc.struct.Queue;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.PowerGraphUpdater;
import mindustry.world.consumers.ConsumePower;

public class PowerGraph {
    private static final Queue<Building> queue = new Queue();
    private static final Seq<Building> outArray1 = new Seq();
    private static final Seq<Building> outArray2 = new Seq();
    private static final IntSet closedSet = new IntSet();
    public final Seq<Building> producers = new Seq(false, 16, Building.class);
    public final Seq<Building> consumers = new Seq(false, 16, Building.class);
    public final Seq<Building> batteries = new Seq(false, 16, Building.class);
    public final Seq<Building> all = new Seq(false, 16, Building.class);
    @Nullable
    private final PowerGraphUpdater entity;
    private final WindowedMean powerBalance = new WindowedMean(60);
    private float lastPowerProduced;
    private float lastPowerNeeded;
    private float lastPowerStored;
    private float lastScaledPowerIn;
    private float lastScaledPowerOut;
    private float lastCapacity;
    public boolean active = true;
    public Team team;
    private float energyDelta = 0.0f;
    private long lastFrameUpdated = -1L;
    private final int graphID;
    private static int lastGraphID;

    public PowerGraph() {
        this.entity = PowerGraphUpdater.create();
        this.entity.graph = this;
        this.graphID = lastGraphID++;
    }

    public PowerGraph(boolean noEntity) {
        this.entity = null;
        this.graphID = lastGraphID++;
    }

    public int getID() {
        return this.graphID;
    }

    public float getLastScaledPowerIn() {
        return this.lastScaledPowerIn;
    }

    public float getLastScaledPowerOut() {
        return this.lastScaledPowerOut;
    }

    public float getLastCapacity() {
        return this.lastCapacity;
    }

    public float getPowerBalance() {
        return this.powerBalance.rawMean();
    }

    public boolean hasPowerBalanceSamples() {
        return this.powerBalance.hasEnoughData();
    }

    public float getLastPowerNeeded() {
        return this.lastPowerNeeded;
    }

    public float getLastPowerProduced() {
        return this.lastPowerProduced;
    }

    public float getLastPowerStored() {
        return this.lastPowerStored;
    }

    public void transferPower(float amount) {
        if (amount > 0.0f) {
            this.chargeBatteries(amount);
        } else {
            this.useBatteries(-amount);
        }
        this.energyDelta += amount;
    }

    public float getSatisfaction() {
        if (Mathf.zero(this.lastPowerProduced)) {
            return 0.0f;
        }
        if (Mathf.zero(this.lastPowerNeeded)) {
            return 1.0f;
        }
        return Mathf.clamp(this.lastPowerProduced / this.lastPowerNeeded);
    }

    public float getPowerProduced() {
        float powerProduced = 0.0f;
        Building[] items = (Building[])this.producers.items;
        for (int i = 0; i < this.producers.size; ++i) {
            Building producer = items[i];
            powerProduced += producer.getPowerProduction() * producer.delta();
        }
        return powerProduced;
    }

    public float getPowerNeeded() {
        float powerNeeded = 0.0f;
        Building[] items = (Building[])this.consumers.items;
        for (int i = 0; i < this.consumers.size; ++i) {
            Building consumer = items[i];
            ConsumePower consumePower = consumer.block.consPower;
            if (!consumer.shouldConsumePower) continue;
            powerNeeded += consumePower.requestedPower(consumer) * consumer.delta();
        }
        return powerNeeded;
    }

    public float getBatteryStored() {
        float totalAccumulator = 0.0f;
        Building[] items = (Building[])this.batteries.items;
        for (int i = 0; i < this.batteries.size; ++i) {
            Building battery = items[i];
            if (!battery.enabled) continue;
            totalAccumulator += battery.power.status * battery.block.consPower.capacity;
        }
        return totalAccumulator;
    }

    public float getBatteryCapacity() {
        float totalCapacity = 0.0f;
        Building[] items = (Building[])this.batteries.items;
        for (int i = 0; i < this.batteries.size; ++i) {
            Building battery = items[i];
            if (!battery.enabled) continue;
            totalCapacity += (1.0f - battery.power.status) * battery.block.consPower.capacity;
        }
        return totalCapacity;
    }

    public float getTotalBatteryCapacity() {
        float totalCapacity = 0.0f;
        Building[] items = (Building[])this.batteries.items;
        for (int i = 0; i < this.batteries.size; ++i) {
            Building battery = items[i];
            if (!battery.enabled) continue;
            totalCapacity += battery.block.consPower.capacity;
        }
        return totalCapacity;
    }

    public float useBatteries(float needed) {
        float stored = this.getBatteryStored();
        if (Mathf.equal(stored, 0.0f)) {
            return 0.0f;
        }
        float used = Math.min(stored, needed);
        float consumedPowerPercentage = Math.min(1.0f, needed / stored);
        Building[] items = (Building[])this.batteries.items;
        for (int i = 0; i < this.batteries.size; ++i) {
            Building battery = items[i];
            if (!battery.enabled) continue;
            battery.power.status *= 1.0f - consumedPowerPercentage;
        }
        return used;
    }

    public float chargeBatteries(float excess) {
        float capacity = this.getBatteryCapacity();
        float chargedPercent = Math.min(excess / capacity, 1.0f);
        if (Mathf.equal(capacity, 0.0f)) {
            return 0.0f;
        }
        Building[] items = (Building[])this.batteries.items;
        for (int i = 0; i < this.batteries.size; ++i) {
            Building battery = items[i];
            if (!battery.enabled || !(battery.block.consPower.capacity > 0.0f)) continue;
            battery.power.status += (1.0f - battery.power.status) * chargedPercent;
        }
        return Math.min(excess, capacity);
    }

    public void distributePower(float needed, float produced, boolean charged) {
        float coverage = Mathf.zero(needed) && Mathf.zero(produced) && !charged && Mathf.zero(this.lastPowerStored) ? 0.0f : (Mathf.zero(needed) ? 1.0f : Math.min(1.0f, produced / needed));
        Building[] items = (Building[])this.consumers.items;
        for (int i = 0; i < this.consumers.size; ++i) {
            Building consumer = items[i];
            ConsumePower cons = consumer.block.consPower;
            if (cons.buffered) {
                if (Mathf.zero(cons.capacity)) continue;
                float maximumRate = cons.requestedPower(consumer) * coverage * consumer.delta();
                consumer.power.status = Mathf.clamp(consumer.power.status + maximumRate / cons.capacity);
                continue;
            }
            if (consumer.shouldConsumePower) {
                consumer.power.status = coverage;
                continue;
            }
            consumer.power.status = Math.min(1.0f, produced / (needed + cons.usage * consumer.delta()));
            if (!Float.isNaN(consumer.power.status)) continue;
            consumer.power.status = 0.0f;
        }
    }

    public void update() {
        Team team = this.team = this.all.size == 0 ? null : this.all.first().team;
        if (!this.consumers.isEmpty() && this.consumers.first().cheating()) {
            for (Building tile : this.consumers) {
                tile.power.status = 1.0f;
            }
            this.lastPowerProduced = 1.0f;
            this.lastPowerNeeded = 1.0f;
            return;
        }
        this.lastFrameUpdated = Core.graphics.getFrameId();
        float powerNeeded = this.getPowerNeeded();
        float powerProduced = this.getPowerProduced();
        this.lastPowerNeeded = powerNeeded;
        this.lastPowerProduced = powerProduced;
        this.lastScaledPowerIn = (powerProduced + this.energyDelta) / Time.delta;
        this.lastScaledPowerOut = powerNeeded / Time.delta;
        this.lastCapacity = this.getTotalBatteryCapacity();
        this.lastPowerStored = this.getBatteryStored();
        this.powerBalance.add((this.lastPowerProduced - this.lastPowerNeeded + this.energyDelta) / Time.delta);
        this.energyDelta = 0.0f;
        if (this.consumers.size != 0 || this.producers.size != 0 || this.batteries.size != 0) {
            boolean charged = false;
            if (!Mathf.equal(powerNeeded, powerProduced)) {
                if (powerNeeded > powerProduced) {
                    float powerBatteryUsed = this.useBatteries(powerNeeded - powerProduced);
                    powerProduced += powerBatteryUsed;
                    this.lastPowerProduced += powerBatteryUsed;
                } else if (powerProduced > powerNeeded) {
                    charged = true;
                    powerProduced -= this.chargeBatteries(powerProduced - powerNeeded);
                }
            }
            this.distributePower(powerNeeded, powerProduced, charged);
        }
    }

    public void addGraph(PowerGraph graph) {
        if (graph == this) {
            return;
        }
        if (graph.all.size > this.all.size) {
            graph.addGraph(this);
            return;
        }
        if (graph.entity != null) {
            graph.entity.remove();
        }
        for (Building tile : graph.all) {
            this.add(tile);
        }
        this.checkAdd();
    }

    public void add(Building build) {
        if (build == null || build.power == null) {
            return;
        }
        if (build.power.graph != this || !build.power.init) {
            if (build.power.graph != null && build.power.graph != this && build.power.graph.entity != null) {
                build.power.graph.entity.remove();
            }
            build.power.graph = this;
            build.power.init = true;
            this.all.add(build);
            if (build.block.outputsPower && build.block.consumesPower && !build.block.consPower.buffered) {
                this.producers.add(build);
                this.consumers.add(build);
            } else if (build.block.outputsPower && build.block.consumesPower) {
                this.batteries.add(build);
            } else if (build.block.outputsPower) {
                this.producers.add(build);
            } else if (build.block.consumesPower && build.block.consPower != null) {
                this.consumers.add(build);
            }
        }
    }

    public void checkAdd() {
        if (this.entity != null) {
            this.entity.add();
        }
    }

    public void clear() {
        this.all.clear();
        this.producers.clear();
        this.consumers.clear();
        this.batteries.clear();
        if (this.entity != null) {
            this.entity.remove();
        }
    }

    public void reflow(Building tile) {
        queue.clear();
        queue.addLast(tile);
        closedSet.clear();
        while (PowerGraph.queue.size > 0) {
            Building child = queue.removeFirst();
            this.add(child);
            this.checkAdd();
            for (Building next : child.getPowerConnections(outArray2)) {
                if (!closedSet.add(next.pos())) continue;
                queue.addLast(next);
            }
        }
    }

    public void removeList(Building build) {
        this.all.remove(build);
        this.producers.remove(build);
        this.consumers.remove(build);
        this.batteries.remove(build);
    }

    public void remove(Building tile) {
        for (Building other : tile.getPowerConnections(outArray1)) {
            if (other.power.graph != this) continue;
            PowerGraph graph = new PowerGraph();
            graph.checkAdd();
            graph.add(other);
            queue.clear();
            queue.addLast(other);
            while (PowerGraph.queue.size > 0) {
                Building child = queue.removeFirst();
                graph.add(child);
                for (Building next : child.getPowerConnections(outArray2)) {
                    if (next == tile || next.power.graph == graph) continue;
                    graph.add(next);
                    queue.addLast(next);
                }
            }
            graph.update();
        }
        if (this.entity != null) {
            this.entity.remove();
        }
    }

    public int getId() {
        return this.graphID;
    }

    public String toString() {
        return "PowerGraph{producers=" + this.producers + ", consumers=" + this.consumers + ", batteries=" + this.batteries + ", all=" + this.all + ", lastFrameUpdated=" + this.lastFrameUpdated + ", graphID=" + this.graphID + '}';
    }
}

