/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.logic;

import arc.Core;
import arc.graphics.Color;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.ui.Label;
import arc.scene.ui.layout.Table;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Icon;
import mindustry.logic.LAccess;
import mindustry.logic.LExecutor;
import mindustry.logic.LReadable;
import mindustry.logic.LVar;
import mindustry.logic.LWritable;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class MemoryBlock
extends Block {
    public int memoryCapacity = 32;
    boolean showInfo = false;
    int numPerRow = 10;
    int period = 15;
    Table infoTable = new Table();

    public MemoryBlock(String name) {
        super(name);
        this.destructible = true;
        this.solid = true;
        this.group = BlockGroup.logic;
        this.drawDisabled = false;
        this.envEnabled = -1;
        this.canOverdrive = false;
        this.configurable = true;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.memoryCapacity, this.memoryCapacity, StatUnit.none);
    }

    public boolean accessible() {
        return !this.privileged || Vars.state.rules.editor || Vars.state.rules.allowEditWorldProcessors;
    }

    @Override
    public boolean canBreak(Tile tile) {
        return this.accessible();
    }

    public class MemoryBuild
    extends Building
    implements LReadable,
    LWritable {
        public double[] memory;
        float counter;
        int deci;

        public MemoryBuild() {
            this.memory = new double[MemoryBlock.this.memoryCapacity];
            this.counter = 0.0f;
            this.deci = -1;
        }

        @Override
        public boolean canPickup() {
            return false;
        }

        @Override
        public boolean collide(Bullet other) {
            return !MemoryBlock.this.privileged;
        }

        @Override
        public boolean displayable() {
            return MemoryBlock.this.accessible();
        }

        @Override
        public boolean readable(LExecutor exec) {
            return this.isValid() && (exec.privileged || this.team == exec.team && !this.block.privileged);
        }

        @Override
        public void read(LVar position, LVar output) {
            int address = position.numi();
            output.setnum(address < 0 || address >= this.memory.length ? Double.NaN : this.memory[address]);
        }

        @Override
        public boolean writable(LExecutor exec) {
            return this.readable(exec);
        }

        @Override
        public void write(LVar position, LVar value) {
            int address = position.numi();
            if (address < 0 || address >= this.memory.length) {
                return;
            }
            this.memory[address] = value.num();
        }

        @Override
        public double sense(LAccess sensor) {
            double d;
            switch (sensor) {
                case memoryCapacity: {
                    d = MemoryBlock.this.memoryCapacity;
                    break;
                }
                default: {
                    d = super.sense(sensor);
                }
            }
            return d;
        }

        @Override
        public void damage(float damage) {
            if (MemoryBlock.this.privileged) {
                return;
            }
            super.damage(damage);
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.i(this.memory.length);
            for (double v : this.memory) {
                write.d(v);
            }
        }

        @Override
        public void buildConfiguration(Table table) {
            if (!Core.settings.getBool("showOtherTeamState") && !MemoryBlock.this.accessible()) {
                this.deselect();
                return;
            }
            this.rebuildInfo();
            table.add(MemoryBlock.this.infoTable);
        }

        private void rebuildInfo() {
            MemoryBlock.this.infoTable.clear();
            if (!MemoryBlock.this.showInfo) {
                MemoryBlock.this.infoTable.button((Drawable)Icon.pencil, Styles.cleari, () -> {
                    MemoryBlock.this.showInfo = !MemoryBlock.this.showInfo;
                    this.rebuildInfo();
                }).size(40.0f);
                return;
            }
            MemoryBlock.this.infoTable.update(() -> {
                this.counter += Time.delta;
                if (this.counter > (float)MemoryBlock.this.period) {
                    this.counter = 0.0f;
                }
            });
            MemoryBlock.this.infoTable.setColor(Color.lightGray);
            MemoryBlock.this.infoTable.table(t -> {
                t.button((Drawable)Icon.pencil, Styles.cleari, () -> {
                    MemoryBlock.this.showInfo = !MemoryBlock.this.showInfo;
                    this.rebuildInfo();
                }).size(40.0f);
                t.button((Drawable)Icon.refreshSmall, Styles.cleari, () -> {
                    this.rebuildInfo();
                    ARCVars.arcui.arcInfo("\u5df2\u66f4\u65b0\u5185\u5b58\u5143\uff01");
                }).size(40.0f);
                Label rowNum = t.add("\u6bcf\u884c " + MemoryBlock.this.numPerRow).get();
                t.slider(2.0f, 15.0f, 1.0f, MemoryBlock.this.numPerRow, res -> {
                    MemoryBlock.this.numPerRow = (int)res;
                    rowNum.setText("\u6bcf\u884c " + MemoryBlock.this.numPerRow);
                });
                Label deciL = t.add(this.deci == -1 ? "\u4e0d\u7ea6\u5316" : "\u7ea6\u5316 " + this.deci).get();
                t.slider(-1.0f, 15.0f, 1.0f, this.deci, res -> {
                    this.deci = (int)res;
                    deciL.setText(this.deci == -1 ? "\u4e0d\u7ea6\u5316" : "\u7ea6\u5316 " + this.deci);
                });
                Label refresh = t.add("\u5237\u65b0 " + MemoryBlock.this.period).get();
                t.slider(1.0f, 60.0f, 1.0f, 20.0f, res -> {
                    MemoryBlock.this.period = (int)res;
                    refresh.setText("\u5237\u65b0 " + MemoryBlock.this.period);
                });
            });
            MemoryBlock.this.infoTable.row();
            MemoryBlock.this.infoTable.pane(t -> {
                int index = 0;
                for (double v : this.memory) {
                    Label textR = t.add(index + " ").get();
                    int finalIndex = index++;
                    t.table(tt -> {
                        Label text = tt.add(this.showString(this.memory[finalIndex])).get();
                        tt.update(() -> {
                            if (this.counter + Time.delta > (float)MemoryBlock.this.period) {
                                textR.setText((this.memory[finalIndex] == 0.0 ? "[gray]" : "") + finalIndex + " ");
                                text.setText(this.showString(this.memory[finalIndex]));
                            }
                        });
                        tt.touchable = Touchable.enabled;
                        tt.tapped(() -> {
                            Core.app.setClipboardText(this.memory[finalIndex] + "");
                            ARCVars.arcui.arcInfo("[cyan]\u590d\u5236\u5185\u5b58[white]\n " + this.memory[finalIndex]);
                        });
                    });
                    if (index % MemoryBlock.this.numPerRow == 0) {
                        t.row();
                        continue;
                    }
                    t.add(" " + (index % MemoryBlock.this.numPerRow % 2 == 0 ? "[cyan]" : "[acid]") + "|[white] ");
                }
            }).maxWidth(1000.0f).maxHeight(500.0f);
        }

        public String showString(double number) {
            if (number == 0.0) {
                return "[gray]-";
            }
            if (this.deci == 0 || number == (double)((int)number)) {
                return "[orange]" + (int)number + "";
            }
            if (this.deci == -1) {
                return "[orange]" + number + "";
            }
            return "[orange]" + String.format("%." + this.deci + "f", number) + "";
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            int amount = read.i();
            for (int i = 0; i < amount; ++i) {
                double val = read.d();
                if (i >= this.memory.length) continue;
                this.memory[i] = val;
            }
        }
    }
}

