/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.heat;

import arc.graphics.g2d.TextureRegion;
import arc.struct.IntSet;
import arc.util.Eachable;
import mindustry.Vars;
import mindustry.arcModule.NumberFormat;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.blocks.heat.HeatBlock;
import mindustry.world.blocks.heat.HeatConsumer;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;

public class HeatConductor
extends Block {
    public float visualMaxHeat = 15.0f;
    public DrawBlock drawer = new DrawDefault();
    public boolean splitHeat = false;

    public HeatConductor(String name) {
        super(name);
        this.rotate = true;
        this.solid = true;
        this.update = true;
        this.rotateDraw = false;
        this.size = 3;
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("heat", entity -> new Bar(() -> NumberFormat.formatPercent("\u70ed\u91cf", entity.heat, this.visualMaxHeat), () -> Pal.lightOrange, () -> entity.heat / this.visualMaxHeat));
    }

    @Override
    public void load() {
        super.load();
        this.drawer.load(this);
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawer.drawPlan(this, plan, list);
    }

    @Override
    public TextureRegion[] icons() {
        return this.drawer.finalIcons(this);
    }

    public class HeatConductorBuild
    extends Building
    implements HeatBlock,
    HeatConsumer {
        public float heat = 0.0f;
        public float[] sideHeat = new float[4];
        public IntSet cameFrom = new IntSet();
        public long lastHeatUpdate = -1L;

        @Override
        public void draw() {
            HeatConductor.this.drawer.draw(this);
        }

        @Override
        public void drawLight() {
            super.drawLight();
            HeatConductor.this.drawer.drawLight(this);
        }

        @Override
        public float[] sideHeat() {
            return this.sideHeat;
        }

        @Override
        public float heatRequirement() {
            return HeatConductor.this.visualMaxHeat;
        }

        @Override
        public void updateTile() {
            this.updateHeat();
        }

        public void updateHeat() {
            if (this.lastHeatUpdate == Vars.state.updateId) {
                return;
            }
            this.lastHeatUpdate = Vars.state.updateId;
            this.heat = this.calculateHeat(this.sideHeat, this.cameFrom);
        }

        @Override
        public float warmup() {
            return this.heat;
        }

        @Override
        public float heat() {
            return this.heat;
        }

        @Override
        public float heatFrac() {
            return this.heat / HeatConductor.this.visualMaxHeat / (HeatConductor.this.splitHeat ? 3.0f : 1.0f);
        }
    }
}

