/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.Autotiler;
import mindustry.world.blocks.distribution.Conveyor;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class StackConveyor
extends Block
implements Autotiler {
    protected static final int stateMove = 0;
    protected static final int stateLoad = 1;
    protected static final int stateUnload = 2;
    public TextureRegion[] regions;
    public TextureRegion edgeRegion;
    public TextureRegion stackRegion;
    public TextureRegion glowRegion;
    public TextureRegion edgeGlowRegion;
    public float glowAlpha = 1.0f;
    public Color glowColor = Pal.redLight;
    public float baseEfficiency = 0.0f;
    public float speed = 0.0f;
    public boolean outputRouter = true;
    public float recharge = 2.0f;
    public Effect loadEffect = Fx.conveyorPoof;
    public Effect unloadEffect = Fx.conveyorPoof;

    public StackConveyor(String name) {
        super(name);
        this.rotate = true;
        this.update = true;
        this.group = BlockGroup.transportation;
        this.hasItems = true;
        this.itemCapacity = 10;
        this.conveyorPlacement = true;
        this.underBullets = true;
        this.priority = -1.0f;
        this.ambientSound = Sounds.conveyor;
        this.ambientSoundVolume = 0.004f;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.itemsMoved, Mathf.round((float)this.itemCapacity * this.speed * 60.0f), StatUnit.itemsSecond);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean blends(Tile tile, int rotation, int otherx, int othery, int otherrot, Block otherblock) {
        Building building = tile.build;
        if (building instanceof StackConveyorBuild) {
            StackConveyorBuild b = (StackConveyorBuild)building;
            int state = b.state;
            if (state == 1) {
                if (!otherblock.outputsItems()) return false;
                if (!this.lookingAtEither(tile, rotation, otherx, othery, otherrot, otherblock)) return false;
                return true;
            }
            if (state == 2 && !this.outputRouter) {
                Building building2;
                if (!otherblock.acceptsItems) return false;
                if (otherblock.noSideBlend) {
                    if (!this.lookingAtEither(tile, rotation, otherx, othery, otherrot, otherblock)) return false;
                }
                if (!this.notLookingAt(tile, rotation, otherx, othery, otherrot, otherblock)) {
                    if (!(otherblock instanceof StackConveyor)) return false;
                    if (!this.facing(otherx, othery, otherrot, tile.x, tile.y)) return false;
                }
                if ((building2 = Vars.world.build(otherx, othery)) instanceof StackConveyorBuild) {
                    StackConveyorBuild s = (StackConveyorBuild)building2;
                    if (s.state == 2) return false;
                }
                if (!((building2 = Vars.world.build(otherx, othery)) instanceof StackConveyorBuild)) return true;
                StackConveyorBuild s2 = (StackConveyorBuild)building2;
                if (s2.state != 0) return true;
                if (!this.facing(otherx, othery, otherrot, tile.x, tile.y)) return false;
                return true;
            }
        }
        if (!otherblock.outputsItems()) return false;
        if (!this.blendsArmored(tile, rotation, otherx, othery, otherrot, otherblock)) return false;
        if (!(otherblock instanceof StackConveyor)) return false;
        return true;
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        int[] bits = this.getTiling(plan, list);
        if (bits == null) {
            return;
        }
        TextureRegion region = this.regions[0];
        Draw.rect(region, plan.drawx(), plan.drawy(), (float)(plan.rotation * 90));
        for (int i = 0; i < 4; ++i) {
            if ((bits[3] & 1 << i) != 0) continue;
            Draw.rect(this.edgeRegion, plan.drawx(), plan.drawy(), (float)((plan.rotation - i) * 90));
        }
    }

    @Override
    public boolean rotatedOutput(int x, int y) {
        Building tile = Vars.world.build(x, y);
        if (tile instanceof StackConveyorBuild) {
            StackConveyorBuild s = (StackConveyorBuild)tile;
            return s.state != 2;
        }
        return super.rotatedOutput(x, y);
    }

    public class StackConveyorBuild
    extends Building {
        public int state;
        public int blendprox;
        public int link = -1;
        public float cooldown;
        public Item lastItem;
        boolean proxUpdating = false;

        @Override
        public void draw() {
            int i;
            Draw.z(29.8f);
            Draw.rect(StackConveyor.this.regions[this.state], this.x, this.y, this.rotdeg());
            for (i = 0; i < 4; ++i) {
                if ((this.blendprox & 1 << i) != 0) continue;
                Draw.rect(StackConveyor.this.edgeRegion, this.x, this.y, (float)((this.rotation - i) * 90));
            }
            if (this.state == 1) {
                for (i = 0; i < 4; ++i) {
                    int dir = this.rotation - i;
                    Building near = this.nearby(dir);
                    if ((this.blendprox & 1 << i) == 0 || i == 0 || near == null || near.block.squareSprite) continue;
                    Draw.rect(StackConveyor.this.sliced(StackConveyor.this.regions[0], Autotiler.SliceMode.bottom), this.x + (float)(Geometry.d4x(dir) * 8) * 0.75f, this.y + (float)(Geometry.d4y(dir) * 8) * 0.75f, (float)(dir * 90));
                }
            } else if (this.state == 2 && (this.blendprox & 1) != 0 && !this.front().block.squareSprite) {
                Draw.rect(StackConveyor.this.sliced(StackConveyor.this.regions[0], Autotiler.SliceMode.top), this.x + (float)(Geometry.d4x(this.rotation) * 8) * 0.75f, this.y + (float)(Geometry.d4y(this.rotation) * 8) * 0.75f, (float)this.rotation * 90.0f);
            }
            Draw.z(29.9f);
            Tile from = Vars.world.tile(this.link);
            if (StackConveyor.this.glowRegion.found() && this.power != null && this.power.status > 0.0f) {
                Draw.z(31.0f);
                Draw.color(StackConveyor.this.glowColor, StackConveyor.this.glowAlpha * this.power.status);
                Draw.blend(Blending.additive);
                Draw.rect(this.state == 1 ? StackConveyor.this.edgeGlowRegion : StackConveyor.this.glowRegion, this.x, this.y, (float)(this.rotation * 90));
                Draw.blend();
                Draw.color();
                Draw.z(29.9f);
            }
            if (this.link == -1 || from == null || this.lastItem == null) {
                return;
            }
            int fromRot = from.build == null ? this.rotation : from.build.rotation;
            Tmp.v1.set(from.worldx(), from.worldy());
            Tmp.v2.set(this.x, this.y);
            Tmp.v1.interpolate(Tmp.v2, 1.0f - this.cooldown, Interp.linear);
            float a = fromRot % 4 * 90;
            float b = this.rotation % 4 * 90;
            if (fromRot % 4 == 3 && this.rotation % 4 == 0) {
                a = -90.0f;
            }
            if (fromRot % 4 == 0 && this.rotation % 4 == 3) {
                a = 360.0f;
            }
            if (StackConveyor.this.glowRegion.found()) {
                Draw.z(31.01f);
            }
            Draw.rect(StackConveyor.this.stackRegion, Tmp.v1.x, Tmp.v1.y, Mathf.lerp(a, b, Interp.smooth.apply(1.0f - Mathf.clamp(this.cooldown * 2.0f, 0.0f, 1.0f))));
            float size = 5.0f * Mathf.lerp(Math.min((float)this.items.total() / (float)StackConveyor.this.itemCapacity, 1.0f), 1.0f, 0.4f);
            Drawf.shadow(Tmp.v1.x, Tmp.v1.y, size * 1.2f);
            Draw.rect(this.lastItem.fullIcon, Tmp.v1.x, Tmp.v1.y, size, size, 0.0f);
        }

        @Override
        public void dropped() {
            super.dropped();
            Point2 prev = Geometry.d4[(this.rotation + 2) % 4];
            this.link = Point2.pack(this.tile.x + prev.x, this.tile.y + prev.y);
        }

        @Override
        public void drawCracks() {
            Draw.z(29.85f);
            super.drawCracks();
        }

        @Override
        public void payloadDraw() {
            Draw.rect(this.block.fullIcon, this.x, this.y);
        }

        @Override
        public void onProximityUpdate() {
            int[] bits;
            int lastState;
            block12: {
                block13: {
                    super.onProximityUpdate();
                    lastState = this.state;
                    this.state = 0;
                    bits = StackConveyor.this.buildBlending(this.tile, this.rotation, null, true);
                    if (bits[0] != 0 || !StackConveyor.this.blends(this.tile, this.rotation, 0)) break block12;
                    if (!StackConveyor.this.blends(this.tile, this.rotation, 2)) break block13;
                    Building building = this.back();
                    if (!(building instanceof StackConveyorBuild)) break block12;
                    StackConveyorBuild b = (StackConveyorBuild)building;
                    if (b.state != 2) break block12;
                }
                this.state = 1;
            }
            if (StackConveyor.this.outputRouter && bits[0] == 0 && !StackConveyor.this.blends(this.tile, this.rotation, 0) && StackConveyor.this.blends(this.tile, this.rotation, 2)) {
                this.state = 2;
            }
            if (!StackConveyor.this.outputRouter && !(this.front() instanceof StackConveyorBuild)) {
                this.state = 2;
            }
            if (!Vars.headless) {
                this.blendprox = 0;
                for (int i = 0; i < 4; ++i) {
                    if (!StackConveyor.this.blends(this.tile, this.rotation, i) || this.state == 2 && !StackConveyor.this.outputRouter && i != 0 && !(this.nearby(Mathf.mod(this.rotation - i, 4)) instanceof StackConveyorBuild)) continue;
                    this.blendprox |= 1 << i;
                }
            }
            if (this.state == 1) {
                for (Building near : this.proximity) {
                    if (!(near instanceof StackConveyorBuild) || near.front() != this) continue;
                    this.state = 0;
                    break;
                }
            }
            if (this.state != lastState) {
                this.proxUpdating = true;
                for (Building near : this.proximity) {
                    if (near instanceof StackConveyorBuild) {
                        StackConveyorBuild b = (StackConveyorBuild)near;
                        if (b.proxUpdating && b.state != 2) continue;
                    }
                    near.onProximityUpdate();
                }
                this.proxUpdating = false;
            }
        }

        @Override
        public boolean canUnload() {
            return this.state != 1;
        }

        @Override
        public void updateTile() {
            Building building;
            float eff;
            float f = eff = this.enabled ? this.efficiency + StackConveyor.this.baseEfficiency : 1.0f;
            if (this.cooldown > 0.0f) {
                this.cooldown = Mathf.clamp(this.cooldown - StackConveyor.this.speed * eff * this.delta(), 0.0f, StackConveyor.this.recharge);
            }
            if (this.link == -1) {
                return;
            }
            if (this.cooldown > 0.0f) {
                return;
            }
            if (this.lastItem == null || !this.items.has(this.lastItem)) {
                this.lastItem = this.items.first();
            }
            if (!this.enabled) {
                return;
            }
            if (this.state == 2) {
                while (this.lastItem != null && !StackConveyor.this.outputRouter ? this.moveForward(this.lastItem) : this.dump(this.lastItem)) {
                    if (!StackConveyor.this.outputRouter) {
                        this.items.remove(this.lastItem, 1);
                    }
                    if (!this.items.has(this.lastItem)) {
                        this.poofOut();
                        this.lastItem = null;
                    } else if (this.lastItem == this.items.first()) continue;
                    break;
                }
            } else if ((this.state != 1 || this.items.total() >= this.getMaximumAccepted(this.lastItem)) && (building = this.front()) instanceof StackConveyorBuild) {
                StackConveyorBuild e = (StackConveyorBuild)building;
                if (e.team == this.team && e.link == -1) {
                    e.items.add(this.items);
                    e.lastItem = this.lastItem;
                    e.link = this.tile.pos();
                    this.link = -1;
                    this.items.clear();
                    this.cooldown = StackConveyor.this.recharge;
                    e.cooldown = 1.0f;
                }
            }
        }

        @Override
        public void overwrote(Seq<Building> builds) {
            Building building = builds.first();
            if (building instanceof Conveyor.ConveyorBuild) {
                Conveyor.ConveyorBuild build = (Conveyor.ConveyorBuild)building;
                Item item = build.items.first();
                if (item != null) {
                    this.handleStack(item, build.items.get(item), null);
                }
            }
        }

        @Override
        public boolean shouldAmbientSound() {
            return false;
        }

        protected void poofIn() {
            this.link = this.tile.pos();
            StackConveyor.this.loadEffect.at(this);
        }

        protected void poofOut() {
            StackConveyor.this.unloadEffect.at(this);
            this.link = -1;
        }

        @Override
        public int acceptStack(Item item, int amount, Teamc source) {
            if (this.items.any() && !this.items.has(item)) {
                return 0;
            }
            return super.acceptStack(item, amount, source);
        }

        @Override
        public void handleItem(Building source, Item item) {
            if (this.items.empty() && this.tile != null) {
                this.poofIn();
            }
            super.handleItem(source, item);
            this.lastItem = item;
        }

        @Override
        public void handleStack(Item item, int amount, Teamc source) {
            if (amount <= 0) {
                return;
            }
            if (this.items.empty() && this.tile != null) {
                this.poofIn();
            }
            super.handleStack(item, amount, source);
            this.lastItem = item;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int removeStack(Item item, int amount) {
            try {
                int n = super.removeStack(item, amount);
                return n;
            }
            finally {
                if (this.items.empty()) {
                    this.poofOut();
                }
            }
        }

        @Override
        public void itemTaken(Item item) {
            if (this.items.empty()) {
                this.poofOut();
            }
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            if (this == source) {
                return this.items.total() < StackConveyor.this.itemCapacity && (!this.items.any() || this.items.has(item));
            }
            if (this.cooldown > StackConveyor.this.recharge - 1.0f) {
                return false;
            }
            return this.state == 1 && (!this.items.any() || this.items.has(item)) && this.items.total() < this.getMaximumAccepted(item) && this.front() != source;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.i(this.link);
            write.f(this.cooldown);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.link = read.i();
            this.cooldown = read.f();
            this.lastItem = this.items.first();
        }
    }
}

