/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.math.geom.Geometry;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.BufferItem;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.DirectionalItemBuffer;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class Junction
extends Block {
    public float speed = 26.0f;
    public int capacity = 6;
    public float displayedSpeed = 13.0f;

    public Junction(String name) {
        super(name);
        this.update = true;
        this.solid = false;
        this.underBullets = true;
        this.group = BlockGroup.transportation;
        this.unloadable = false;
        this.floating = true;
        this.noUpdateDisabled = true;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.itemsMoved, this.displayedSpeed, StatUnit.itemsSecond);
        this.stats.add(Stat.itemCapacity, this.capacity, StatUnit.items);
    }

    @Override
    public boolean outputsItems() {
        return true;
    }

    public class JunctionBuild
    extends Building {
        public DirectionalItemBuffer buffer;

        public JunctionBuild() {
            this.buffer = new DirectionalItemBuffer(Junction.this.capacity);
        }

        @Override
        public int acceptStack(Item item, int amount, Teamc source) {
            return 0;
        }

        @Override
        public void updateTile() {
            for (int i = 0; i < 4; ++i) {
                long l;
                float time;
                if (this.buffer.indexes[i] <= 0) continue;
                if (this.buffer.indexes[i] > Junction.this.capacity) {
                    this.buffer.indexes[i] = Junction.this.capacity;
                }
                if (!(Time.time >= (time = BufferItem.time(l = this.buffer.buffers[i][0])) + Junction.this.speed / this.timeScale) && !(Time.time < time)) continue;
                Item item = Vars.content.item(BufferItem.item(l));
                Building dest = this.nearby(i);
                if (item == null || dest == null || !dest.acceptItem(this, item) || dest.team != this.team) continue;
                dest.handleItem(this, item);
                System.arraycopy(this.buffer.buffers[i], 1, this.buffer.buffers[i], 0, this.buffer.indexes[i] - 1);
                int n = i;
                this.buffer.indexes[n] = this.buffer.indexes[n] - 1;
            }
        }

        @Override
        public void handleItem(Building source, Item item) {
            byte relative = source.relativeTo(this.tile);
            this.buffer.accept(relative, item);
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            byte relative = source.relativeTo(this.tile);
            if (relative == -1 || !this.buffer.accepts(relative)) {
                return false;
            }
            Building to = this.nearby(relative);
            return to != null && to.team == this.team;
        }

        @Override
        public void draw() {
            super.draw();
            if (Core.settings.getInt("HiddleItemTransparency") > 1) {
                float[][] times = this.buffer.getTimes();
                Item[][] items = this.buffer.getItems();
                for (int i = 0; i < 4; ++i) {
                    float endx = this.x + (float)(Geometry.d4((int)i).x * 8) / 2.0f + (float)(Geometry.d4((int)Math.floorMod((int)(i + 1), (int)4)).x * 8) / 4.0f;
                    float endy = this.y + (float)(Geometry.d4((int)i).y * 8) / 2.0f + (float)(Geometry.d4((int)Math.floorMod((int)(i + 1), (int)4)).y * 8) / 4.0f;
                    float begx = this.x - (float)(Geometry.d4((int)i).x * 8) / 4.0f + (float)(Geometry.d4((int)Math.floorMod((int)(i + 1), (int)4)).x * 8) / 4.0f;
                    float begy = this.y - (float)(Geometry.d4((int)i).y * 8) / 4.0f + (float)(Geometry.d4((int)Math.floorMod((int)(i + 1), (int)4)).y * 8) / 4.0f;
                    if (this.buffer.indexes[i] <= 0) continue;
                    float loti = 0.0f;
                    for (int idi = 0; idi < this.buffer.indexes[i]; ++idi) {
                        if (items[i][idi] != null) {
                            Draw.alpha((float)Core.settings.getInt("HiddleItemTransparency") / 100.0f);
                            Draw.rect(items[i][idi].uiIcon, begx + (endx - begx) / (float)Junction.this.capacity * Math.min((Time.time - times[i][idi]) * this.timeScale / Junction.this.speed * (float)Junction.this.capacity, (float)Junction.this.capacity - loti), begy + (endy - begy) / (float)Junction.this.capacity * Math.min((Time.time - times[i][idi]) * this.timeScale / Junction.this.speed * (float)Junction.this.capacity, (float)Junction.this.capacity - loti), 4.0f, 4.0f);
                        }
                        loti += 1.0f;
                    }
                }
            }
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            this.buffer.write(write);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.buffer.read(read, revision == 0);
        }
    }
}

