/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.math.geom.Geometry;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.world.ItemBuffer;
import mindustry.world.Tile;
import mindustry.world.blocks.distribution.ItemBridge;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class BufferedItemBridge
extends ItemBridge {
    public final int timerAccept;
    public float speed;
    public int bufferCapacity;
    public float displayedSpeed;

    public BufferedItemBridge(String name) {
        super(name);
        this.timerAccept = this.timers++;
        this.speed = 40.0f;
        this.bufferCapacity = 50;
        this.displayedSpeed = 11.0f;
        this.hasPower = false;
        this.hasItems = true;
        this.canOverdrive = true;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.bufferCapacity, this.bufferCapacity);
        this.stats.add(Stat.itemsMoved, this.displayedSpeed, StatUnit.itemsSecond);
    }

    public class BufferedItemBridgeBuild
    extends ItemBridge.ItemBridgeBuild {
        ItemBuffer buffer;

        public BufferedItemBridgeBuild() {
            super(BufferedItemBridge.this);
            this.buffer = new ItemBuffer(BufferedItemBridge.this.bufferCapacity);
        }

        @Override
        public void updateTransport(Building other) {
            if (this.buffer.accepts() && this.items.total() > 0) {
                this.buffer.accept(this.items.take());
            }
            Item item = this.buffer.poll(BufferedItemBridge.this.speed / this.timeScale);
            if (this.timer(BufferedItemBridge.this.timerAccept, 4.0f / this.timeScale) && item != null && other.acceptItem(this, item)) {
                this.moved = true;
                other.handleItem(this, item);
                this.buffer.remove();
            }
        }

        @Override
        public void doDump() {
            this.dump();
        }

        @Override
        public void draw() {
            super.draw();
            if (Core.settings.getInt("HiddleItemTransparency") > 1) {
                float endy;
                float endx;
                float begy;
                float begx;
                Item[] bufferItems = this.buffer.getItems();
                float[] bufferTimes = this.buffer.getTimes();
                Tile other = Vars.world.tile(this.link);
                if (!BufferedItemBridge.this.linkValid(this.tile, other)) {
                    begx = this.x - 4.0f;
                    begy = this.y - 4.0f;
                    endx = this.x + 4.0f;
                    endy = this.y - 4.0f;
                } else {
                    byte i = this.tile.absoluteRelativeTo(other.x, other.y);
                    float ex = other.worldx() - this.x - (float)(Geometry.d4((int)i).x * 8) / 2.0f;
                    float ey = other.worldy() - this.y - (float)(Geometry.d4((int)i).y * 8) / 2.0f;
                    float warmup = Vars.state.isEditor() ? 1.0f : this.warmup;
                    begx = this.x + (float)(Geometry.d4((int)i).x * 8) / 2.0f;
                    begy = this.y + (float)(Geometry.d4((int)i).y * 8) / 2.0f;
                    endx = this.x + (ex *= warmup);
                    endy = this.y + (ey *= warmup);
                }
                float loti = 0.0f;
                for (int idi = 0; idi < bufferItems.length; ++idi) {
                    if (bufferItems[idi] != null) {
                        Draw.alpha((float)Core.settings.getInt("HiddleItemTransparency") / 100.0f);
                        Draw.rect(bufferItems[idi].uiIcon, begx + (endx - begx) / (float)bufferItems.length * Math.min((Time.time - bufferTimes[idi]) * this.timeScale / BufferedItemBridge.this.speed * (float)BufferedItemBridge.this.bufferCapacity, (float)BufferedItemBridge.this.bufferCapacity - loti), begy + (endy - begy) / (float)bufferItems.length * Math.min((Time.time - bufferTimes[idi]) * this.timeScale / BufferedItemBridge.this.speed * (float)BufferedItemBridge.this.bufferCapacity, (float)BufferedItemBridge.this.bufferCapacity - loti), 4.0f, 4.0f);
                    }
                    loti += 1.0f;
                }
            }
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            this.buffer.write(write);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.buffer.read(read);
        }
    }
}

