/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.Core;
import arc.Events;
import arc.graphics.g2d.Draw;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.OrderedMap;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.arcModule.NumberFormat;
import mindustry.content.Items;
import mindustry.entities.bullet.BulletType;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.ui.Bar;
import mindustry.ui.MultiReqImage;
import mindustry.ui.ReqImage;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.consumers.ConsumeItemFilter;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;
import mindustry.world.meta.Stats;

public class ItemTurret
extends Turret {
    public ObjectMap<Item, BulletType> ammoTypes = new OrderedMap<Item, BulletType>();

    public ItemTurret(String name) {
        super(name);
        this.hasItems = true;
    }

    public void ammo(Object ... objects) {
        this.ammoTypes = OrderedMap.of(objects);
    }

    public void limitRange() {
        this.limitRange(9.0f);
    }

    public void limitRange(float margin) {
        for (ObjectMap.Entry entry : this.ammoTypes.entries()) {
            this.limitRange((BulletType)entry.value, margin);
        }
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.itemCapacity);
        this.stats.add(Stat.ammo, StatValues.ammo(this.ammoTypes));
        this.stats.add(Stat.ammoCapacity, this.maxAmmo / this.ammoPerShot, StatUnit.shots);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        this.ammoTypes.each((Item2, BulletType2) -> {
            if (!Item2.unlockedNow()) {
                return;
            }
            if (BulletType2.rangeChange > 0.0f) {
                Drawf.dashCircle((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.range + BulletType2.rangeChange, Pal.placing);
            }
        });
        if (Core.settings.getBool("arcTurretPlacementItem")) {
            int sectors = this.ammoTypes.size;
            this.drawIndex = 0;
            float iconSize = 6.0f + 2.0f * (float)this.size;
            this.ammoTypes.each((Item2, BulletType2) -> {
                ++this.drawIndex;
                if (!Item2.unlockedNow()) {
                    return;
                }
                for (int i = 0; i < 4; ++i) {
                    float rot = ((float)i + (float)this.drawIndex / (float)sectors) / 4.0f * 360.0f + Time.time * 0.5f;
                    Draw.rect(Item2.uiIcon, (float)(x * 8) + this.offset + Mathf.sin((float)Math.toRadians(rot)) * (this.range + BulletType2.rangeChange + iconSize + 1.0f), (float)(y * 8) + this.offset + Mathf.cos((float)Math.toRadians(rot)) * (this.range + BulletType2.rangeChange + iconSize + 1.0f), iconSize, iconSize, -rot);
                }
            });
        }
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("ammo", entity -> new Bar(() -> "\u5b50\u5f39" + ((float)entity.totalAmmo > 0.0f ? NumberFormat.formatPercent(((ItemEntry)entity.ammo.peek()).item.emoji(), entity.totalAmmo, this.maxAmmo) : ""), () -> Pal.ammo, () -> (float)entity.totalAmmo / (float)this.maxAmmo));
    }

    @Override
    public void init() {
        this.consume(new ConsumeItemFilter(i -> this.ammoTypes.containsKey((Item)i)){

            @Override
            public void build(Building build, Table table) {
                MultiReqImage image = new MultiReqImage();
                Vars.content.items().each(i -> this.filter.get(i) && i.unlockedNow(), item -> image.add(new ReqImage((Element)new Image(item.uiIcon), () -> {
                    if (!(build instanceof ItemTurretBuild)) return false;
                    ItemTurretBuild it = (ItemTurretBuild)build;
                    if (it.ammo.isEmpty()) return false;
                    if (((ItemEntry)it.ammo.peek()).item != item) return false;
                    return true;
                })));
                table.add(image).size(32.0f);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public float efficiency(Building build) {
                if (!(build instanceof ItemTurretBuild)) return 0.0f;
                ItemTurretBuild it = (ItemTurretBuild)build;
                if (it.ammo.size <= 0) return 0.0f;
                if (((Turret.AmmoEntry)it.ammo.peek()).amount >= ItemTurret.this.ammoPerShot) return 1.0f;
                if (!it.cheating()) return 0.0f;
                return 1.0f;
            }

            @Override
            public void display(Stats stats) {
            }
        });
        this.ammoTypes.each((item, type) -> {
            this.placeOverlapRange = Math.max(this.placeOverlapRange, this.range + type.rangeChange + this.placeOverlapMargin);
        });
        super.init();
    }

    public class ItemTurretBuild
    extends Turret.TurretBuild {
        public ItemTurretBuild() {
            super(ItemTurret.this);
        }

        @Override
        public void drawSelect() {
            if (Core.settings.getBool("arcTurretPlacementItem")) {
                if (this.ammo.isEmpty()) {
                    int sectors = ItemTurret.this.ammoTypes.size;
                    ItemTurret.this.drawIndex = 0;
                    float iconSize = 6.0f + 2.0f * (float)ItemTurret.this.size;
                    ItemTurret.this.ammoTypes.each((Item2, BulletType2) -> {
                        ++ItemTurret.this.drawIndex;
                        if (!Item2.unlockedNow()) {
                            return;
                        }
                        for (int i = 0; i < 4; ++i) {
                            float rot = ((float)i + (float)ItemTurret.this.drawIndex / (float)sectors) / 4.0f * 360.0f + Time.time * 0.5f;
                            Draw.rect(Item2.uiIcon, this.x + ItemTurret.this.offset + Mathf.sin((float)Math.toRadians(rot)) * (ItemTurret.this.range + BulletType2.rangeChange + iconSize + 1.0f), this.y + ItemTurret.this.offset + Mathf.cos((float)Math.toRadians(rot)) * (ItemTurret.this.range + BulletType2.rangeChange + iconSize + 1.0f), iconSize, iconSize, -rot);
                        }
                    });
                } else {
                    float iconSize = 6.0f + 2.0f * (float)ItemTurret.this.size;
                    ItemEntry entry = (ItemEntry)this.ammo.peek();
                    Item lastAmmo = entry.item;
                    for (int i = 0; i < 4; ++i) {
                        float rot = (float)i / 4.0f * 360.0f + Time.time * 0.5f;
                        Draw.rect(lastAmmo.uiIcon, this.x + ItemTurret.this.offset + Mathf.sin((float)Math.toRadians(rot)) * (ItemTurret.this.range + entry.type().rangeChange + iconSize + 1.0f), this.y + ItemTurret.this.offset + Mathf.cos((float)Math.toRadians(rot)) * (ItemTurret.this.range + entry.type().rangeChange + iconSize + 1.0f), iconSize, iconSize, -rot);
                    }
                }
            }
            super.drawSelect();
        }

        @Override
        public void onProximityAdded() {
            super.onProximityAdded();
            if (!this.hasAmmo() && this.cheating() && ItemTurret.this.ammoTypes.size > 0) {
                this.handleItem(this, ItemTurret.this.ammoTypes.keys().next());
            }
        }

        @Override
        public Object senseObject(LAccess sensor) {
            Object object;
            switch (sensor) {
                case currentAmmoType: {
                    if (this.ammo.size > 0) {
                        object = ((ItemEntry)this.ammo.peek()).item;
                        break;
                    }
                    object = null;
                    break;
                }
                default: {
                    object = super.senseObject(sensor);
                }
            }
            return object;
        }

        @Override
        public void updateTile() {
            this.unit.ammo((float)this.unit.type().ammoCapacity * (float)this.totalAmmo / (float)ItemTurret.this.maxAmmo);
            super.updateTile();
        }

        @Override
        public int acceptStack(Item item, int amount, Teamc source) {
            BulletType type = ItemTurret.this.ammoTypes.get(item);
            if (type == null) {
                return 0;
            }
            return Math.min((int)((float)(ItemTurret.this.maxAmmo - this.totalAmmo) / ItemTurret.this.ammoTypes.get((Item)item).ammoMultiplier), amount);
        }

        @Override
        public void handleStack(Item item, int amount, Teamc source) {
            for (int i = 0; i < amount; ++i) {
                this.handleItem(null, item);
            }
        }

        @Override
        public int removeStack(Item item, int amount) {
            return 0;
        }

        @Override
        public void handleItem(Building source, Item item) {
            BulletType type;
            if (item == Items.pyratite) {
                Events.fire(EventType.Trigger.flameAmmo);
            }
            if (this.totalAmmo == 0) {
                Events.fire(EventType.Trigger.resupplyTurret);
            }
            if ((type = ItemTurret.this.ammoTypes.get(item)) == null) {
                return;
            }
            this.totalAmmo = (int)((float)this.totalAmmo + type.ammoMultiplier);
            for (int i = 0; i < this.ammo.size; ++i) {
                ItemEntry entry = (ItemEntry)this.ammo.get(i);
                if (entry.item != item) continue;
                entry.amount = (int)((float)entry.amount + type.ammoMultiplier);
                this.ammo.swap(i, this.ammo.size - 1);
                return;
            }
            this.ammo.add(new ItemEntry(item, (int)type.ammoMultiplier));
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return ItemTurret.this.ammoTypes.get(item) != null && (float)this.totalAmmo + ItemTurret.this.ammoTypes.get((Item)item).ammoMultiplier <= (float)ItemTurret.this.maxAmmo;
        }

        @Override
        public byte version() {
            return 2;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.b(this.ammo.size);
            for (Turret.AmmoEntry entry : this.ammo) {
                ItemEntry i = (ItemEntry)entry;
                write.s(i.item.id);
                write.s(i.amount);
            }
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.ammo.clear();
            this.totalAmmo = 0;
            int amount = read.ub();
            for (int i = 0; i < amount; ++i) {
                Item item = Vars.content.item(revision < 2 ? read.ub() : (int)read.s());
                short a = read.s();
                if (item == null || !ItemTurret.this.ammoTypes.containsKey(item)) continue;
                this.totalAmmo += a;
                this.ammo.add(new ItemEntry(item, a));
            }
        }
    }

    public class ItemEntry
    extends Turret.AmmoEntry {
        public Item item;

        ItemEntry(Item item, int amount) {
            this.item = item;
            this.amount = amount;
        }

        @Override
        public BulletType type() {
            return ItemTurret.this.ammoTypes.get(this.item);
        }

        public String toString() {
            return "ItemEntry{item=" + this.item + ", amount=" + this.amount + '}';
        }
    }
}

