/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.math.Mathf;
import arc.struct.ObjectMap;
import arc.util.Time;
import mindustry.content.Fx;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.world.blocks.defense.turrets.ContinuousTurret;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.consumers.ConsumeLiquidFilter;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;
import mindustry.world.meta.Stats;

public class ContinuousLiquidTurret
extends ContinuousTurret {
    public ObjectMap<Liquid, BulletType> ammoTypes = new ObjectMap();
    public float liquidConsumed = 0.016666668f;

    public ContinuousLiquidTurret(String name) {
        super(name);
        this.hasLiquids = true;
        this.loopSound = Sounds.minebeam;
        this.shootSound = Sounds.none;
        this.smokeEffect = Fx.none;
        this.shootEffect = Fx.none;
    }

    public void ammo(Object ... objects) {
        this.ammoTypes = ObjectMap.of(objects);
    }

    @Override
    public void setStats() {
        super.setStats();
        this.ammoTypes.each((l, b) -> {
            b.statLiquidConsumed = this.liquidConsumed;
        });
        this.stats.replace(Stat.ammo, StatValues.ammo(this.ammoTypes));
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        this.ammoTypes.each((Item2, BulletType2) -> {
            if (BulletType2.rangeChange > 0.0f && Item2.unlockedNow()) {
                Drawf.dashCircle((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.range + BulletType2.rangeChange, Pal.placing);
            }
        });
        if (Core.settings.getBool("arcTurretPlacementItem") && this.ammoTypes.size >= 2) {
            int sectors = this.ammoTypes.size;
            this.drawIndex = 0;
            float iconSize = 6.0f + 2.0f * (float)this.size;
            this.ammoTypes.each((Item2, BulletType2) -> {
                ++this.drawIndex;
                if (!Item2.unlockedNow()) {
                    return;
                }
                for (int i = 0; i < 4; ++i) {
                    float rot = ((float)i + (float)this.drawIndex / (float)sectors) / 4.0f * 360.0f + Time.time * 0.5f;
                    Draw.rect(Item2.uiIcon, (float)(x * 8) + this.offset + Mathf.sin((float)Math.toRadians(rot)) * (this.range + BulletType2.rangeChange + iconSize + 1.0f), (float)(y * 8) + this.offset + Mathf.cos((float)Math.toRadians(rot)) * (this.range + BulletType2.rangeChange + iconSize + 1.0f), iconSize, iconSize, -rot);
                }
            });
        }
    }

    @Override
    public void init() {
        this.consume(new ConsumeLiquidFilter(i -> this.ammoTypes.containsKey((Liquid)i), this.liquidConsumed){
            {
                this.multiplier = b -> {
                    BulletType ammo = ContinuousLiquidTurret.this.ammoTypes.get(b.liquids.current());
                    return ammo == null ? 1.0f : 1.0f / ammo.ammoMultiplier;
                };
            }

            @Override
            public void display(Stats stats) {
            }
        });
        this.ammoTypes.each((item, type) -> {
            this.placeOverlapRange = Math.max(this.placeOverlapRange, this.range + type.rangeChange + this.placeOverlapMargin);
        });
        super.init();
    }

    public class ContinuousLiquidTurretBuild
    extends ContinuousTurret.ContinuousTurretBuild {
        public ContinuousLiquidTurretBuild() {
            super(ContinuousLiquidTurret.this);
        }

        @Override
        public void drawSelect() {
            super.drawSelect();
            if (Core.settings.getBool("arcTurretPlacementItem")) {
                if (this.liquids.currentAmount() == 0.0f) {
                    int sectors = ContinuousLiquidTurret.this.ammoTypes.size;
                    ContinuousLiquidTurret.this.drawIndex = 0;
                    float iconSize = 6.0f + 2.0f * (float)ContinuousLiquidTurret.this.size;
                    ContinuousLiquidTurret.this.ammoTypes.each((Item2, BulletType2) -> {
                        ++ContinuousLiquidTurret.this.drawIndex;
                        if (!Item2.unlockedNow()) {
                            return;
                        }
                        for (int i = 0; i < 4; ++i) {
                            float rot = ((float)i + (float)ContinuousLiquidTurret.this.drawIndex / (float)sectors) / 4.0f * 360.0f + Time.time * 0.5f;
                            Draw.rect(Item2.uiIcon, this.x + ContinuousLiquidTurret.this.offset + Mathf.sin((float)Math.toRadians(rot)) * (ContinuousLiquidTurret.this.range + BulletType2.rangeChange + iconSize + 1.0f), this.y + ContinuousLiquidTurret.this.offset + Mathf.cos((float)Math.toRadians(rot)) * (ContinuousLiquidTurret.this.range + BulletType2.rangeChange + iconSize + 1.0f), iconSize, iconSize, -rot);
                        }
                    });
                } else {
                    float iconSize = 6.0f + 2.0f * (float)ContinuousLiquidTurret.this.size;
                    for (int i = 0; i < 4; ++i) {
                        float rot = (float)i / 4.0f * 360.0f + Time.time * 0.5f;
                        Draw.rect(this.liquids.current().uiIcon, this.x + ContinuousLiquidTurret.this.offset + Mathf.sin((float)Math.toRadians(rot)) * (ContinuousLiquidTurret.this.range + ContinuousLiquidTurret.this.ammoTypes.get((Liquid)this.liquids.current()).rangeChange + iconSize + 1.0f), this.y + ContinuousLiquidTurret.this.offset + Mathf.cos((float)Math.toRadians(rot)) * (ContinuousLiquidTurret.this.range + ContinuousLiquidTurret.this.ammoTypes.get((Liquid)this.liquids.current()).rangeChange + iconSize + 1.0f), iconSize, iconSize, -rot);
                    }
                }
            }
        }

        @Override
        public boolean shouldActiveSound() {
            return this.wasShooting && this.enabled;
        }

        @Override
        public void updateTile() {
            super.updateTile();
            this.unit.ammo((float)this.unit.type().ammoCapacity * this.liquids.currentAmount() / ContinuousLiquidTurret.this.liquidCapacity);
        }

        @Override
        public Object senseObject(LAccess sensor) {
            Object object;
            switch (sensor) {
                case currentAmmoType: {
                    object = this.liquids.current();
                    break;
                }
                default: {
                    object = super.senseObject(sensor);
                }
            }
            return object;
        }

        @Override
        public boolean canConsume() {
            return this.hasCorrectAmmo() && super.canConsume();
        }

        @Override
        public BulletType useAmmo() {
            return this.peekAmmo();
        }

        @Override
        public BulletType peekAmmo() {
            return ContinuousLiquidTurret.this.ammoTypes.get(this.liquids.current());
        }

        @Override
        public boolean hasAmmo() {
            return this.hasCorrectAmmo() && ContinuousLiquidTurret.this.ammoTypes.get(this.liquids.current()) != null && this.liquids.currentAmount() > 0.0f;
        }

        public boolean hasCorrectAmmo() {
            return !this.bullets.any() || ((Turret.BulletEntry)this.bullets.first()).bullet.type == this.peekAmmo();
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return false;
        }

        @Override
        public boolean acceptLiquid(Building source, Liquid liquid) {
            return ContinuousLiquidTurret.this.ammoTypes.get(liquid) != null && (this.liquids.current() == liquid || !ContinuousLiquidTurret.this.ammoTypes.containsKey(this.liquids.current()) || this.liquids.get(this.liquids.current()) <= 1.0f / ContinuousLiquidTurret.this.ammoTypes.get((Liquid)this.liquids.current()).ammoMultiplier + 0.001f);
        }
    }
}

