/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.math.Mathf;
import arc.struct.EnumSet;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.Ranged;
import mindustry.world.Block;
import mindustry.world.blocks.RotBlock;
import mindustry.world.consumers.ConsumeCoolant;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class BaseTurret
extends Block {
    public float range = 80.0f;
    public float placeOverlapMargin = 56.0f;
    public float rotateSpeed = 5.0f;
    public float fogRadiusMultiplier = 1.0f;
    public boolean disableOverlapCheck = false;
    public Effect coolEffect = Fx.fuelburn;
    public float coolantMultiplier = 5.0f;
    @Nullable
    public ConsumeLiquidBase coolant;

    public BaseTurret(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.outlineIcon = true;
        this.attacks = true;
        this.priority = 1.0f;
        this.group = BlockGroup.turrets;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.turret});
    }

    @Override
    public void init() {
        if (this.coolant == null) {
            this.coolant = (ConsumeLiquidBase)this.findConsumer(c -> c instanceof ConsumeCoolant);
        }
        if (this.coolant != null) {
            this.coolant.update = false;
            this.coolant.booster = true;
            this.coolant.optional = true;
            if (!this.hasConsumer(this.coolant)) {
                this.consume(this.coolant);
            }
        }
        if (!this.disableOverlapCheck) {
            this.placeOverlapRange = Math.max(this.placeOverlapRange, this.range + this.placeOverlapMargin);
        }
        this.fogRadius = Math.max(Mathf.round(this.range / 8.0f * this.fogRadiusMultiplier), this.fogRadius);
        super.init();
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.range, Pal.placing);
        if (Vars.state.rules.placeRangeCheck && Core.settings.getBool("arcTurretPlaceCheck")) {
            Draw.alpha(0.5f);
            Drawf.dashCircle((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.placeOverlapRange, Pal.remove);
        }
        if (this.fogRadiusMultiplier < 0.99f && Vars.state.rules.fog) {
            Drawf.dashCircle((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.range * this.fogRadiusMultiplier, Pal.lightishGray);
        }
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.shootRange, this.range / 8.0f, StatUnit.blocks);
    }

    public class BaseTurretBuild
    extends Building
    implements Ranged,
    RotBlock {
        public float rotation = 90.0f;

        @Override
        public float range() {
            return BaseTurret.this.range;
        }

        @Override
        public float buildRotation() {
            return this.rotation;
        }

        @Override
        public void drawSelect() {
            Drawf.dashCircle(this.x, this.y, this.range(), this.team.color);
        }

        public float estimateDps() {
            return 0.0f;
        }
    }
}

