/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.EnumSet;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.logic.Ranged;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.BlockStatus;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatCat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;

public class MendProjector
extends Block {
    public final int timerUse;
    public Color baseColor;
    public Color phaseColor;
    public TextureRegion topRegion;
    public float reload;
    public float range;
    public float healPercent;
    public float phaseBoost;
    public float phaseRangeBoost;
    public float useTime;

    public MendProjector(String name) {
        super(name);
        this.timerUse = this.timers++;
        this.baseColor = Color.valueOf("84f491");
        this.phaseColor = Color.valueOf("ffd59e");
        this.reload = 250.0f;
        this.range = 60.0f;
        this.healPercent = 12.0f;
        this.phaseBoost = 12.0f;
        this.phaseRangeBoost = 50.0f;
        this.useTime = 400.0f;
        this.solid = true;
        this.update = true;
        this.group = BlockGroup.projectors;
        this.hasPower = true;
        this.hasItems = true;
        this.emitLight = true;
        this.lightRadius = 50.0f;
        this.suppressable = true;
        this.envEnabled |= 2;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.blockRepair});
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void setStats() {
        this.stats.timePeriod = this.useTime;
        super.setStats();
        this.stats.add(Stat.range, this.range / 8.0f, StatUnit.blocks);
        this.stats.add("\u4fee\u590d\u91cf", StatCat.function, this.healPercent, StatUnit.percent);
        this.stats.add("\u4fee\u590d\u95f4\u9694", StatCat.function, this.reload / 60.0f, StatUnit.seconds);
        this.stats.add("\u5e73\u5747\u4fee\u590d\u901f\u5ea6", StatCat.function, "@%/s", Strings.autoFixed(this.healPercent / (this.reload / 60.0f), 1));
        Object t = this.findConsumer(c -> c instanceof ConsumeItems);
        if (t instanceof ConsumeItems) {
            ConsumeItems cons = (ConsumeItems)t;
            this.stats.remove(Stat.booster);
            this.stats.add(Stat.booster, StatValues.itemBoosters("{0}x\u4fee\u590d\u91cf", this.stats.timePeriod, (this.phaseBoost + this.healPercent) / this.healPercent, this.phaseRangeBoost, cons.items));
        }
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("charge", entity -> new Bar(() -> "\u5145\u80fd: " + (int)entity.charge + " / " + this.reload, () -> Pal.items, () -> entity.charge / this.reload));
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.range, this.baseColor);
        Vars.indexer.eachBlock(Vars.player.team(), (float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.range + this.phaseRangeBoost, other -> true, other -> Drawf.selected(other, Tmp.c1.set(this.phaseColor).a(Mathf.absin(4.0f, 1.0f))));
        Drawf.dashCircle((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.range + this.phaseRangeBoost, this.phaseColor);
        Vars.indexer.eachBlock(Vars.player.team(), (float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.range, other -> true, other -> Drawf.selected(other, Tmp.c1.set(this.baseColor).a(Mathf.absin(4.0f, 1.0f))));
    }

    public class MendBuild
    extends Building
    implements Ranged {
        public float heat;
        public float charge;
        public float phaseHeat;
        public float smoothEfficiency;

        public MendBuild() {
            this.charge = Mathf.random(MendProjector.this.reload);
        }

        @Override
        public float range() {
            return MendProjector.this.range;
        }

        @Override
        public void updateTile() {
            boolean canHeal = !this.checkSuppression();
            this.smoothEfficiency = Mathf.lerpDelta(this.smoothEfficiency, this.efficiency, 0.08f);
            this.heat = Mathf.lerpDelta(this.heat, this.efficiency > 0.0f && canHeal ? 1.0f : 0.0f, 0.08f);
            this.charge += this.heat * this.delta();
            this.phaseHeat = Mathf.lerpDelta(this.phaseHeat, this.optionalEfficiency, 0.1f);
            if (this.optionalEfficiency > 0.0f && this.timer(MendProjector.this.timerUse, MendProjector.this.useTime) && canHeal) {
                this.consume();
            }
            if (this.charge >= MendProjector.this.reload && canHeal) {
                float realRange = MendProjector.this.range + this.phaseHeat * MendProjector.this.phaseRangeBoost;
                this.charge = 0.0f;
                Vars.indexer.eachBlock(this, realRange, b -> b.damaged() && !b.isHealSuppressed(), other -> {
                    other.heal(other.maxHealth() * (MendProjector.this.healPercent + this.phaseHeat * MendProjector.this.phaseBoost) / 100.0f * this.efficiency);
                    other.recentlyHealed();
                    Fx.healBlockFull.at(other.x, other.y, other.block.size, MendProjector.this.baseColor, other.block);
                });
            }
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.progress) {
                return Mathf.clamp(this.charge / MendProjector.this.reload);
            }
            return super.sense(sensor);
        }

        @Override
        public void drawSelect() {
            float realRange = MendProjector.this.range + this.phaseHeat * MendProjector.this.phaseRangeBoost;
            Vars.indexer.eachBlock(this, realRange, other -> true, other -> Drawf.selected(other, Tmp.c1.set(MendProjector.this.baseColor).a(Mathf.absin(4.0f, 1.0f))));
            Drawf.dashCircle(this.x, this.y, realRange, MendProjector.this.baseColor);
        }

        @Override
        public void draw() {
            super.draw();
            float realRange = MendProjector.this.range + this.phaseHeat * MendProjector.this.phaseRangeBoost;
            if (this.status() == BlockStatus.active && (float)Core.settings.getInt("mend_zone") > 2.0f) {
                if ((double)this.phaseHeat > 0.2) {
                    Draw.color(Color.valueOf("00ff55"), (float)Core.settings.getInt("mend_zone") / 100.0f);
                } else {
                    Draw.color(Color.valueOf("66ff99"), (float)Core.settings.getInt("mend_zone") / 100.0f);
                }
                Lines.dashCircle(this.x, this.y, realRange);
            }
            float f = 1.0f - Time.time / 100.0f % 1.0f;
            Draw.color(MendProjector.this.baseColor, MendProjector.this.phaseColor, this.phaseHeat);
            Draw.alpha(this.heat * Mathf.absin(Time.time, 7.957747f, 1.0f) * 0.5f);
            Draw.rect(MendProjector.this.topRegion, this.x, this.y);
            Draw.alpha(1.0f);
            Lines.stroke((2.0f * f + 0.2f) * this.heat);
            Lines.square(this.x, this.y, Math.min(1.0f + (1.0f - f) * (float)MendProjector.this.size * 8.0f / 2.0f, (float)(MendProjector.this.size * 8) / 2.0f));
            Draw.reset();
        }

        @Override
        public void drawBars() {
            super.drawBars();
            if (Core.settings.getBool("blockBars_mend")) {
                Draw.color(Color.black, 0.3f);
                Lines.stroke(4.0f);
                Lines.line(this.x - (float)(this.block.size * 8) / 2.0f * 0.6f, this.y + (float)(this.block.size * 8) / 2.5f, this.x + (float)(this.block.size * 8) / 2.0f * 0.6f, this.y + (float)(this.block.size * 8) / 2.5f);
                Draw.color(Pal.heal, 1.0f);
                Lines.stroke(2.0f);
                Lines.line(this.x - (float)(this.block.size * 8) / 2.0f * 0.6f, this.y + (float)(this.block.size * 8) / 2.5f, this.x + 0.6f * (this.charge / MendProjector.this.reload - 0.5f) * (float)this.block.size * 8.0f, this.y + (float)(this.block.size * 8) / 2.5f);
                Draw.color();
            }
        }

        @Override
        public void drawLight() {
            Drawf.light(this.x, this.y, MendProjector.this.lightRadius * this.smoothEfficiency, MendProjector.this.baseColor, 0.7f * this.smoothEfficiency);
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.heat);
            write.f(this.phaseHeat);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.heat = read.f();
            this.phaseHeat = read.f();
        }
    }
}

