/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world;

import arc.Events;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.IntSet;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.arcModule.ui.AdvanceToolTable;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.Liquids;
import mindustry.entities.Units;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.OverlayFloor;
import mindustry.world.blocks.storage.CoreBlock;

public class Build {
    private static final IntSet tmp = new IntSet();

    public static void beginBreak(@Nullable Unit unit, Team team, int x, int y) {
        if (!Build.validBreak(team, x, y)) {
            return;
        }
        Tile tile = Vars.world.tileBuilding(x, y);
        float prevPercent = 1.0f;
        if (tile.build != null) {
            prevPercent = tile.build.healthf();
        }
        int rotation = tile.build != null ? tile.build.rotation : 0;
        Block previous = tile.block();
        if (previous.instantDeconstruct) {
            ConstructBlock.deconstructFinish(tile, previous, unit);
            return;
        }
        ConstructBlock sub = ConstructBlock.get(previous.size);
        Seq<Building> prevBuild = new Seq<Building>(1);
        if (tile.build != null) {
            prevBuild.add(tile.build);
            tile.build.onDeconstructed(unit);
            tile.build.dead = true;
        }
        tile.setBlock(sub, team, rotation);
        ConstructBlock.ConstructBuild build = (ConstructBlock.ConstructBuild)tile.build;
        build.setDeconstruct(previous);
        build.prevBuild = prevBuild;
        tile.build.health = tile.build.maxHealth * prevPercent;
        if (unit != null && unit.getControllerName() != null) {
            tile.build.lastAccessed = unit.getControllerName();
        }
        Events.fire(new EventType.BlockBuildBeginEvent(tile, team, unit, true));
    }

    public static void beginPlace(@Nullable Unit unit, Block result, Team team, int x, int y, int rotation, @Nullable Object placeConfig) {
        Tile tile;
        if (AdvanceToolTable.worldCreator) {
            tile = Vars.world.tile(x, y);
            if (tile == null) {
                return;
            }
            if (result == Blocks.cliff) {
                int rotationb = 0;
                for (int i = 0; i < 8; ++i) {
                    Tile other = Vars.world.tiles.get(tile.x + Geometry.d8[i].x, tile.y + Geometry.d8[i].y);
                    if (other == null || other.floor().hasSurface()) continue;
                    rotationb |= 1 << i;
                }
                if (rotationb != 0) {
                    tile.setBlock(Blocks.cliff);
                }
                tile.data = (byte)rotationb;
                return;
            }
            if (result instanceof OverlayFloor) {
                tile.setOverlay(result);
                return;
            }
            if (result instanceof Floor) {
                Floor floor = (Floor)result;
                tile.setFloor(floor);
                Vars.pathfinder.updateTile(tile);
                return;
            }
        }
        if (!AdvanceToolTable.worldCreator && !Build.validPlace(result, team, x, y, rotation)) {
            return;
        }
        tile = Vars.world.tile(x, y);
        if (tile == null) {
            return;
        }
        if (tile.team() == team && tile.block == result && tile.build != null && tile.block.quickRotate) {
            if (unit != null && unit.getControllerName() != null) {
                tile.build.lastAccessed = unit.getControllerName();
            }
            int previous = tile.build.rotation;
            tile.build.rotation = Mathf.mod(rotation, 4);
            tile.build.updateProximity();
            tile.build.noSleep();
            Fx.rotateBlock.at(tile.build.x, tile.build.y, tile.build.block.size);
            Events.fire(new EventType.BuildRotateEvent(tile.build, unit, previous));
            return;
        }
        if (tile.team() == Team.derelict && team != Team.derelict && tile.block == result && tile.build != null && tile.block.allowDerelictRepair && Vars.state.rules.derelictRepair) {
            float healthf = tile.build.healthf();
            Object config = tile.build.config();
            tile.setBlock(result, team, rotation);
            if (unit != null && unit.getControllerName() != null) {
                tile.build.lastAccessed = unit.getControllerName();
            }
            if (config != null) {
                tile.build.configured(unit, config);
            }
            tile.build.health = (float)result.health * healthf;
            if (Vars.fogControl.isVisibleTile(team, tile.x, tile.y)) {
                result.placeEffect.at(tile.drawx(), tile.drawy(), result.size);
                Fx.rotateBlock.at(tile.build.x, tile.build.y, tile.build.block.size);
            }
            Events.fire(new EventType.BlockBuildEndEvent(tile, unit, team, false, config));
            return;
        }
        tile.getLinkedTilesAs(result, out -> {
            if (out.block != Blocks.air && out.block.alwaysReplace) {
                out.block.breakEffect.at(out.drawx(), out.drawy(), (float)out.block.size, out.block.mapColor);
                out.remove();
            }
        });
        if (result.instantBuild) {
            Events.fire(new EventType.BlockBuildBeginEvent(tile, team, unit, false));
            result.placeBegan(tile, tile.block, unit);
            ConstructBlock.constructFinish(tile, result, unit, (byte)rotation, team, placeConfig);
            return;
        }
        Block previous = tile.block();
        ConstructBlock sub = ConstructBlock.get(result.size);
        Seq prevBuild = new Seq(9);
        result.beforePlaceBegan(tile, previous);
        tmp.clear();
        tile.getLinkedTilesAs(result, t -> {
            if (t.build != null && t.build.team == team && tmp.add(t.build.id)) {
                prevBuild.add(t.build);
            }
        });
        tile.setBlock(sub, team, rotation);
        ConstructBlock.ConstructBuild build = (ConstructBlock.ConstructBuild)tile.build;
        build.setConstruct(previous.size == sub.size ? previous : Blocks.air, result);
        build.prevBuild = prevBuild;
        if (unit != null && unit.getControllerName() != null) {
            build.lastAccessed = unit.getControllerName();
        }
        Events.fire(new EventType.BlockBuildBeginEvent(tile, team, unit, false));
        result.placeBegan(tile, previous, unit);
    }

    public static boolean validPlace(Block type, Team team, int x, int y, int rotation) {
        return Build.validPlace(type, team, x, y, rotation, true);
    }

    public static boolean validPlace(Block type, Team team, int x, int y, int rotation, boolean checkVisible) {
        return Build.validPlace(type, team, x, y, rotation, checkVisible, true);
    }

    public static boolean validPlace(Block type, Team team, int x, int y, int rotation, boolean checkVisible, boolean ignoreCoreRadius) {
        return Build.validPlaceIgnoreUnits(type, team, x, y, rotation, checkVisible, ignoreCoreRadius) && Build.checkNoUnitOverlap(type, x, y);
    }

    public static boolean checkNoUnitOverlap(Block type, int x, int y) {
        return !type.solid && !type.solidifes || !Units.anyEntities((float)(x * 8) + type.offset - (float)(type.size * 8) / 2.0f, (float)(y * 8) + type.offset - (float)(type.size * 8) / 2.0f, type.size * 8, type.size * 8);
    }

    public static boolean validPlaceIgnoreUnits(Block type, Team team, int x, int y, int rotation, boolean checkVisible, boolean checkCoreRadius) {
        Tile tile;
        if (AdvanceToolTable.forcePlacement) {
            Tile tile2 = Vars.world.tile(x, y);
            return tile2 != null;
        }
        if (AdvanceToolTable.worldCreator) {
            Tile tile3 = Vars.world.tile(x, y);
            if (tile3 == null) {
                return false;
            }
            if (type instanceof OverlayFloor) {
                OverlayFloor of = (OverlayFloor)type;
                return tile3.overlay != of;
            }
            if (type instanceof Floor) {
                Floor f = (Floor)type;
                return tile3.floor != f;
            }
        }
        if (!(type != null && (!checkVisible || type.environmentBuildable() && (type.isPlaceable() || Vars.state.rules.waves && team == Vars.state.rules.waveTeam && type.isVisible())))) {
            return false;
        }
        if (!Vars.state.rules.editor && checkCoreRadius) {
            if (Vars.state.rules.polygonCoreProtection) {
                float mindst = Float.MAX_VALUE;
                CoreBlock.CoreBuild closest = null;
                for (Teams.TeamData data : Vars.state.teams.active) {
                    for (CoreBlock.CoreBuild tile4 : data.cores) {
                        float dst = tile4.dst2((float)(x * 8) + type.offset, (float)(y * 8) + type.offset);
                        if (!(dst < mindst)) continue;
                        closest = tile4;
                        mindst = dst;
                    }
                }
                if (closest != null && closest.team != team) {
                    return false;
                }
            } else if (Vars.state.teams.anyEnemyCoresWithinBuildRadius(team, (float)(x * 8) + type.offset, (float)(y * 8) + type.offset)) {
                return false;
            }
        }
        if ((tile = Vars.world.tile(x, y)) == null) {
            return false;
        }
        if (!type.canPlaceOn(tile, team, rotation)) {
            return false;
        }
        if (type.isFloor()) {
            return type.isOverlay() ? tile.overlay() != type : tile.floor() != type;
        }
        if (!type.ignoreBuildDarkness && Vars.world.getDarkness(x, y) >= 3.0f) {
            return false;
        }
        if (!(type.requiresWater || Build.contactsShallows(tile.x, tile.y, type) || type.placeableLiquid)) {
            return false;
        }
        int offsetx = -(type.size - 1) / 2;
        int offsety = -(type.size - 1) / 2;
        for (int dx = 0; dx < type.size; ++dx) {
            for (int dy = 0; dy < type.size; ++dy) {
                block24: {
                    Tile check;
                    block25: {
                        int wx = dx + offsetx + tile.x;
                        int wy = dy + offsety + tile.y;
                        check = Vars.world.tile(wx, wy);
                        if (check == null || type.size == 2 && Vars.world.getDarkness(wx, wy) >= 3.0f || Vars.state.rules.staticFog && Vars.state.rules.fog && !Vars.fogControl.isDiscovered(team, wx, wy) || check.floor().isDeep() && !type.floating && !type.requiresWater && !type.placeableLiquid || type == check.block() && check.build != null && rotation == check.build.rotation && type.rotate && (type != check.block || team == Team.derelict || check.team() != Team.derelict) || !check.interactable(team) || !check.floor().placeableOn && !type.ignoreBuildDarkness || !checkVisible && checkCoreRadius && !check.block().alwaysReplace) break block24;
                        if (type.canReplace(check.block()) || check.build != null && check.build.canBeReplaced(type) || type == check.block && team != Team.derelict && Vars.state.rules.derelictRepair && check.team() == Team.derelict) break block25;
                        Building building = check.build;
                        if (!(building instanceof ConstructBlock.ConstructBuild)) break block24;
                        ConstructBlock.ConstructBuild build = (ConstructBlock.ConstructBuild)building;
                        if (build.current != type || check.centerX() != tile.x || check.centerY() != tile.y) break block24;
                    }
                    if (type.bounds(tile.x, tile.y, Tmp.r1).grow(0.01f).contains(check.block.bounds(check.centerX(), check.centerY(), Tmp.r2)) && (!type.requiresWater || check.floor().liquidDrop == Liquids.water)) continue;
                }
                return false;
            }
        }
        return !Vars.state.rules.placeRangeCheck || !checkCoreRadius || Vars.state.isEditor() || Build.getEnemyOverlap(type, team, x, y) == null;
    }

    @Nullable
    public static Building getEnemyOverlap(Block block, Team team, int x, int y) {
        return Vars.indexer.findEnemyTile(team, x * 8 + block.size, y * 8 + block.size, block.placeOverlapRange + 4.0f, p -> true);
    }

    public static boolean contactsGround(int x, int y, Block block) {
        if (block.isMultiblock()) {
            for (Point2 point : Edges.getEdges(block.size)) {
                Tile tile = Vars.world.tile(x + point.x, y + point.y);
                if (tile == null || tile.floor().isLiquid) continue;
                return true;
            }
        } else {
            for (Point2 point : Geometry.d4) {
                Tile tile = Vars.world.tile(x + point.x, y + point.y);
                if (tile == null || tile.floor().isLiquid) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contactsShallows(int x, int y, Block block) {
        if (block.isMultiblock()) {
            Tile tile;
            for (Point2 point : block.getInsideEdges()) {
                tile = Vars.world.tile(x + point.x, y + point.y);
                if (tile == null || tile.floor().isDeep()) continue;
                return true;
            }
            for (Point2 point : block.getEdges()) {
                tile = Vars.world.tile(x + point.x, y + point.y);
                if (tile == null || tile.floor().isDeep()) continue;
                return true;
            }
        } else {
            for (Point2 point : Geometry.d4) {
                Tile tile = Vars.world.tile(x + point.x, y + point.y);
                if (tile == null || tile.floor().isDeep()) continue;
                return true;
            }
            Tile tile = Vars.world.tile(x, y);
            return tile != null && !tile.floor().isDeep();
        }
        return false;
    }

    public static boolean validBreak(Team team, int x, int y) {
        Tile tile = Vars.world.tile(x, y);
        return AdvanceToolTable.worldCreator && tile.block() != Blocks.air || tile != null && tile.block().canBreak(tile) && tile.breakable() && tile.interactable(team);
    }
}

