/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.scene.Group;
import arc.scene.event.ClickListener;
import arc.scene.event.HandCursorListener;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.RFuncs;
import mindustry.arcModule.ui.dialogs.TeamSelectDialog;
import mindustry.game.Team;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Icon;
import mindustry.gen.Player;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.input.DesktopInput;
import mindustry.input.InputHandler;
import mindustry.net.NetConnection;
import mindustry.net.Packets;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class PlayerListFragment {
    public Table content = new Table().marginRight(13.0f).marginLeft(13.0f);
    private boolean visible = false;
    private Interval timer = new Interval();
    private TextField search;
    public Seq<Player> players = new Seq();
    public Seq<Player> blackList = new Seq();
    private float buttonSize = 30.0f;
    private boolean teamMode = false;

    public void build(Group parent) {
        this.content.name = "players";
        parent.fill(cont -> {
            cont.name = "playerlist";
            cont.visible(() -> this.visible);
            cont.update(() -> {
                if (!Vars.net.active() || !Vars.state.isGame()) {
                    this.visible = false;
                    return;
                }
                if (this.visible && this.timer.get(20.0f)) {
                    this.rebuild();
                    this.content.pack();
                    this.content.act(Core.graphics.getDeltaTime());
                    Core.scene.act(0.0f);
                }
            });
            cont.table(Tex.buttonTrans, pane -> {
                pane.label(() -> Core.bundle.format(Groups.player.size() == 1 ? "players.single" : "players", Groups.player.size()));
                pane.row();
                this.search = pane.field(null, text -> this.rebuild()).grow().pad(8.0f).name("search").maxTextLength(40).get();
                this.search.setMessageText(Core.bundle.get("players.search"));
                pane.row();
                pane.pane(this.content).grow().scrollX(false);
                pane.row();
                pane.table(menu -> {
                    menu.defaults().growX().height(50.0f).fillY();
                    menu.name = "menu";
                    if (Core.settings.getBool("arcPlayerList") && Core.settings.getBool("easyJS")) {
                        menu.button("js\u6362\u961f", () -> {
                            this.teamMode = !this.teamMode;
                        }).checked(t -> this.teamMode);
                    }
                    menu.button("@server.bans", Vars.ui.bans::show).disabled(b -> Vars.net.client());
                    menu.button("@server.admins", Vars.ui.admins::show).disabled(b -> Vars.net.client());
                    menu.button("@close", this::toggle);
                }).margin(0.0f).pad(10.0f).growX();
            }).touchable(Touchable.enabled).margin(14.0f).minWidth(720.0f);
        });
        this.rebuild();
    }

    public void rebuild() {
        this.content.clear();
        float h = 40.0f;
        float bs = h - 2.0f;
        boolean found = false;
        this.players.clear();
        Groups.player.copy(this.players);
        this.players.sort(Structs.comps(Structs.comparing(Player::team), Structs.comparingBool(p -> !p.admin)));
        if (this.search.getText().length() > 0) {
            this.players.retainAll(p -> Strings.stripColors(p.name().toLowerCase()).contains(this.search.getText().toLowerCase()));
        }
        for (final Player user : this.players) {
            boolean clickable;
            found = true;
            NetConnection connection = user.con;
            if (connection == null && Vars.net.server() && !user.isLocal()) {
                return;
            }
            if (this.search.getText().length() > 0 && !user.name().toLowerCase().contains(this.search.getText().toLowerCase()) && !Strings.stripColors(user.name().toLowerCase()).contains(this.search.getText().toLowerCase())) {
                return;
            }
            Table button = new Table();
            button.left();
            button.margin(5.0f).marginBottom(10.0f);
            final ClickListener listener = new ClickListener();
            Table iconTable = new Table(){

                @Override
                public void draw() {
                    super.draw();
                    Draw.colorMul(user.team().color, listener.isOver() ? 1.3f : 1.0f);
                    Draw.alpha(this.parentAlpha);
                    Lines.stroke(Scl.scl(4.0f));
                    Lines.rect(this.x, this.y, this.width, this.height);
                    Draw.reset();
                }
            };
            boolean bl = clickable = !Vars.state.rules.fog || !Vars.state.rules.pvp || user.team() == Vars.player.team();
            if (clickable) {
                iconTable.addListener(listener);
                iconTable.addListener(new HandCursorListener());
            }
            iconTable.margin(8.0f);
            iconTable.name = user.name();
            iconTable.touchable = Touchable.enabled;
            iconTable.tapped(() -> {
                if (!user.dead() && clickable) {
                    Core.camera.position.set(user.unit());
                    ARCVars.arcui.arcInfo("\u5b9a\u4f4d\u73a9\u5bb6\uff1a" + user.name);
                    InputHandler patt5186$temp = Vars.control.input;
                    if (patt5186$temp instanceof DesktopInput) {
                        DesktopInput input = (DesktopInput)patt5186$temp;
                        input.panning = true;
                    }
                    Vars.control.input.spectate(user.unit());
                    Vars.ui.showInfoFade(Core.bundle.format("viewplayer", user.name), 1.0f);
                }
            });
            ImageButton.ImageButtonStyle style = new ImageButton.ImageButtonStyle(){
                {
                    this.down = Styles.none;
                    this.up = Styles.none;
                    this.imageCheckedColor = Pal.accent;
                    this.imageDownColor = Pal.accent;
                    this.imageUpColor = Color.white;
                    this.imageOverColor = Color.lightGray;
                }
            };
            ImageButton.ImageButtonStyle ustyle = new ImageButton.ImageButtonStyle(){
                {
                    this.down = Styles.none;
                    this.up = Styles.none;
                    this.imageDownColor = Pal.accent;
                    this.imageUpColor = Color.white;
                    this.imageOverColor = Color.lightGray;
                }
            };
            iconTable.margin(4.0f);
            iconTable.add(new Image(user.icon()).setScaling(Scaling.bounded)).grow();
            iconTable.name = user.name();
            if (Core.settings.getBool("arcPlayerList")) {
                button.add(iconTable).size(h);
                button.image(Icon.admin).visible(() -> user.admin && (user.isLocal() || !Vars.net.server())).size(bs).get().updateVisibility();
                button.table(t -> {
                    t.labelWrap("[#" + user.color().toString().toUpperCase() + "]" + user.name()).minWidth(380.0f);
                    t.touchable = Touchable.enabled;
                    t.tapped(() -> {
                        Core.app.setClipboardText(user.name);
                        ARCVars.arcui.arcInfo("\u590d\u5236\u6635\u79f0\uff1a" + user.name);
                    });
                }).width(400.0f).pad(10.0f).left();
                button.add().grow();
                button.button("[#" + ARCVars.getThemeColor() + "]\u2650", Styles.cleart, () -> {
                    String message = this.arcAtPlayer(user.name);
                    RFuncs.shareString(message);
                }).size(this.buttonSize);
                button.button(String.valueOf('\uf83a'), Styles.cleart, () -> {
                    if (this.blackList.contains(user)) {
                        this.blackList.remove(user);
                        ARCVars.arcui.arcInfo("\u5df2\u89e3\u9664\u5c4f\u853d\uff1a" + user.name);
                    } else {
                        this.blackList.add(user);
                        ARCVars.arcui.arcInfo("\u5df2\u5c4f\u853d\uff1a" + user.name);
                    }
                }).checked(b -> {
                    boolean contains = this.blackList.contains(user);
                    b.setText(contains ? String.valueOf('\uf679') : String.valueOf('\uf83a'));
                    return contains;
                }).size(this.buttonSize);
                button.button(String.valueOf('\ue88d'), Styles.cleart, () -> {
                    InputHandler.follow = InputHandler.follow != user ? user : null;
                    if (Vars.control.input instanceof DesktopInput) {
                        ((DesktopInput)Vars.control.input).panning = InputHandler.follow == user;
                        ARCVars.arcui.arcInfo("\u8ffd\u8e2a\u73a9\u5bb6\uff1a" + user.name);
                    }
                }).checked(b -> {
                    boolean checked = InputHandler.follow == user;
                    b.setText(checked ? String.valueOf('\ue88d') : String.valueOf('\ue876'));
                    return checked;
                }).size(this.buttonSize);
                button.button("[coral]\ue81a", Styles.cleart, () -> Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmvotekick", user.name()), () -> Call.sendChatMessage("/votekick " + user.name()))).size(this.buttonSize);
                if (!(!Vars.net.server() && !Vars.player.admin || user.isLocal() || user.admin && !Vars.net.server())) {
                    button.button("[gold]\ue88a", Styles.cleart, () -> Call.adminRequest(user, Packets.AdminAction.trace, null)).size(this.buttonSize);
                    button.button("[gold]\ue815", Styles.cleart, () -> Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmkick", user.name()), () -> Call.adminRequest(user, Packets.AdminAction.kick, null))).size(this.buttonSize);
                    button.button("[gold]\ue817", Styles.cleart, () -> Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmban", user.name()), () -> Call.adminRequest(user, Packets.AdminAction.ban, null))).size(this.buttonSize);
                }
                if (this.teamMode) {
                    if (Vars.state.teams.getActive().size <= 5) {
                        Vars.state.teams.getActive().each(teamData -> button.button("[#" + teamData.team.color + "]" + teamData.team.localized(), Styles.cleart, () -> Call.sendChatMessage("/js Groups.player.find(e=>e.name== \"" + user.name + "\").team(Team.get(" + teamData.team.id + "))")).size(this.buttonSize));
                    }
                    button.button("[violet]+", Styles.cleart, () -> new TeamSelectDialog(team -> Call.sendChatMessage("/js Groups.player.find(e=>e.name== \"" + user.name + "\").team(Team.get(" + team.id + "))"), user.team()).show()).size(this.buttonSize);
                } else if (Vars.net.server() || Vars.player.admin && (!user.admin || user == Vars.player)) {
                    if (Vars.state.teams.getActive().size <= 5) {
                        Vars.state.teams.getActive().each(teamData -> button.button("[#" + teamData.team.color + "]" + teamData.team.localized(), Styles.cleart, () -> Call.adminRequest(user, Packets.AdminAction.switchTeam, teamData.team)).size(this.buttonSize));
                    }
                    button.button("[violet]+", Styles.cleart, () -> new TeamSelectDialog(team -> Call.adminRequest(user, Packets.AdminAction.switchTeam, team), user.team()).show()).size(this.buttonSize);
                }
                if (!(!Vars.net.server() && (!Vars.player.admin || user.admin && user != Vars.player) || Vars.net.client() || user.isLocal())) {
                    button.button("\ue82c", Styles.cleart, () -> {
                        String id = user.uuid();
                        if (user.admin) {
                            Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmunadmin", user.name()), () -> {
                                Vars.netServer.admins.unAdminPlayer(id);
                                user.admin = false;
                            });
                        } else {
                            Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmadmin", user.name()), () -> {
                                Vars.netServer.admins.adminPlayer(id, user.usid());
                                user.admin = true;
                            });
                        }
                    }).checked(b -> user.admin).row();
                }
            } else {
                button.add(iconTable).size(h);
                button.labelWrap("[#" + user.color().toString().toUpperCase() + "]" + user.name()).style(Styles.outlineLabel).width(170.0f).pad(10.0f);
                button.add().grow();
                button.background(Tex.underline);
                button.image(Icon.admin).visible(() -> user.admin && (user.isLocal() || !Vars.net.server())).padRight(5.0f).get().updateVisibility();
                if (Vars.net.server() || Vars.player.admin && (!user.admin || user == Vars.player)) {
                    button.add().growY();
                    button.button((Drawable)Icon.menu, ustyle, () -> {
                        BaseDialog dialog = new BaseDialog(user.coloredName());
                        dialog.title.setColor(Color.white);
                        dialog.titleTable.remove();
                        dialog.closeOnBack();
                        TextButton.TextButtonStyle bstyle = Styles.defaultt;
                        dialog.cont.add(user.coloredName()).row();
                        dialog.cont.image(Tex.whiteui, Pal.accent).fillX().height(3.0f).pad(4.0f).row();
                        dialog.cont.pane(t -> {
                            t.defaults().size(220.0f, 55.0f).pad(3.0f);
                            if (user != Vars.player) {
                                t.button("@player.ban", (Drawable)Icon.hammer, bstyle, () -> {
                                    Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmban", user.name()), () -> Call.adminRequest(user, Packets.AdminAction.ban, null));
                                    dialog.hide();
                                }).row();
                                t.button("@player.kick", (Drawable)Icon.cancel, bstyle, () -> {
                                    Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmkick", user.name()), () -> Call.adminRequest(user, Packets.AdminAction.kick, null));
                                    dialog.hide();
                                }).row();
                            }
                            if (!user.isLocal()) {
                                t.button("@player.trace", (Drawable)Icon.zoom, bstyle, () -> {
                                    Call.adminRequest(user, Packets.AdminAction.trace, null);
                                    dialog.hide();
                                }).row();
                            }
                            t.button("@player.team", (Drawable)Icon.redo, bstyle, () -> {
                                BaseDialog teamSelect = new BaseDialog(Core.bundle.get("player.team") + ": " + user.name);
                                teamSelect.setFillParent(false);
                                ButtonGroup group = new ButtonGroup();
                                int i = 0;
                                for (Team team : Team.baseTeams) {
                                    ImageButton b = new ImageButton(Tex.whiteui, Styles.clearNoneTogglei);
                                    b.margin(4.0f);
                                    b.getImageCell().grow();
                                    b.getStyle().imageUpColor = team.color;
                                    b.clicked(() -> {
                                        Call.adminRequest(user, Packets.AdminAction.switchTeam, team);
                                        teamSelect.hide();
                                    });
                                    teamSelect.cont.add(b).size(50.0f).checked(a -> user.team() == team).group(group);
                                    if (i++ % 3 != 2) continue;
                                    teamSelect.cont.row();
                                }
                                teamSelect.addCloseButton();
                                teamSelect.show();
                                dialog.hide();
                            }).row();
                            if (!Vars.net.client() && !user.isLocal()) {
                                t.button("@player.admin", (Drawable)Icon.admin, Styles.togglet, () -> {
                                    dialog.hide();
                                    String id = user.uuid();
                                    if (user.admin) {
                                        Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmunadmin", user.name()), () -> {
                                            Vars.netServer.admins.unAdminPlayer(id);
                                            user.admin = false;
                                        });
                                    } else {
                                        Vars.ui.showConfirm("@confirm", Core.bundle.format("confirmadmin", user.name()), () -> {
                                            Vars.netServer.admins.adminPlayer(id, user.usid());
                                            user.admin = true;
                                        });
                                    }
                                }).checked(b -> user.admin).row();
                            }
                        }).row();
                        dialog.cont.button("@back", Icon.left, dialog::hide).padTop(-1.0f).size(220.0f, 55.0f);
                        dialog.show();
                    }).size(h);
                } else if (!user.isLocal() && !user.admin && Vars.net.client() && Groups.player.size() >= 3 && Vars.player.team() == user.team()) {
                    button.add().growY();
                    button.button((Drawable)Icon.hammer, ustyle, () -> Vars.ui.showTextInput("@votekick.reason", Core.bundle.format("votekick.reason.message", user.name()), "", reason -> Call.sendChatMessage("/votekick #" + user.id + " " + reason))).size(h);
                }
            }
            this.content.add(button).padBottom(-6.0f).width(700.0f).maxHeight(h + 14.0f);
            this.content.row();
            this.content.image().height(4.0f).color(Vars.state.rules.pvp || Core.settings.getBool("arcAlwaysTeamColor") ? user.team().color : Pal.gray).growX();
            this.content.row();
        }
        if (!found) {
            this.content.add(Core.bundle.format("players.notfound", new Object[0])).padBottom(6.0f).width(350.0f).maxHeight(h + 14.0f);
        }
        this.content.marginBottom(5.0f);
    }

    public void toggle() {
        boolean bl = this.visible = !this.visible;
        if (this.visible) {
            this.rebuild();
        } else {
            Core.scene.setKeyboardFocus(null);
            this.search.clearText();
        }
    }

    private String arcAtPlayer(String name) {
        StringBuilder builder = new StringBuilder(RFuncs.getPrefix("coral", "AT"));
        builder.append("\u6233\u4e86").append(name).append("[white]\u4e00\u4e0b\uff0c\u5e76\u63d0\u9192\u4f60\u7559\u610f\u5bf9\u8bdd\u6846");
        return builder.toString();
    }
}

