/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.Events;
import arc.files.Fi;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.actions.Actions;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.ui.Button;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.Label;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.scene.ui.layout.WidgetGroup;
import arc.struct.Seq;
import arc.util.Http;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Time;
import arc.util.Timer;
import arc.util.Tmp;
import arc.util.serialization.JsonReader;
import arc.util.serialization.JsonValue;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.ui.RStyles;
import mindustry.arcModule.ui.window.Window;
import mindustry.core.Version;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.MenuRenderer;
import mindustry.graphics.Pal;
import mindustry.service.GameService;
import mindustry.ui.Fonts;
import mindustry.ui.MobileButton;
import mindustry.ui.Styles;

public class MenuFragment {
    private Table container;
    private Table submenu;
    private Button currentMenu;
    private MenuRenderer renderer;
    private Seq<MenuButton> customButtons = new Seq();
    public Seq<MenuButton> desktopButtons = null;
    Label textLabel;
    float tx;
    float ty;
    float base;
    String[] labels = new String[]{"[yellow]\u5b66\u672f\u7aef!"};
    float period = 75.0f;
    float varSize = 0.8f;
    String text = this.labels[0];
    static long arcNewsLastUpdate = 0L;
    static boolean haveNewerNews = false;
    Fi arcBackground;
    String arcBackgroundPath = Core.settings.getString("arcBackgroundPath");
    Seq<Fi> arcBGList;
    Image img = new Image();
    int arcBackgroundIndex = 0;

    public void build(Group parent) {
        this.renderer = new MenuRenderer();
        if (!Core.settings.getBool("arcDisableModWarning")) {
            ARCVars.arcui.aboutcn_arc.show();
        }
        Core.settings.put("locale", "zh_CN");
        WidgetGroup group = new WidgetGroup();
        ((Element)group).setFillParent(true);
        group.visible(() -> !Vars.ui.editor.isShown());
        parent.addChild(group);
        WidgetGroup textGroup = new WidgetGroup();
        parent.addChild(textGroup);
        parent = group;
        if (this.arcBackgroundPath != null && Core.files.absolute(this.arcBackgroundPath).exists() && Core.files.absolute(this.arcBackgroundPath).list().length >= 1) {
            this.arcBackgroundIndex = (int)(Math.random() * (double)Core.files.absolute(this.arcBackgroundPath).list().length);
            this.nextBackGroundImg();
            if (this.arcBGList.size == 0) {
                parent.fill((x, y, w, h) -> this.renderer.render());
            } else {
                group.addChild(this.img);
                this.img.setFillParent(true);
            }
        } else {
            parent.fill((x, y, w, h) -> this.renderer.render());
        }
        parent.fill(c -> c.pane(Styles.noBarPane, cont -> {
            this.container = cont;
            cont.name = "menu container";
            if (!Vars.mobile) {
                c.left();
                this.buildDesktop();
                Events.on(EventType.ResizeEvent.class, event -> this.buildDesktop());
            } else {
                this.buildMobile();
                Events.on(EventType.ResizeEvent.class, event -> this.buildMobile());
            }
        }).with(pane -> pane.setOverscroll(false, false)).grow());
        parent.fill(c -> c.bottom().right().button((Drawable)Icon.discord, new ImageButton.ImageButtonStyle(){
            {
                this.up = Tex.discordBanner;
            }
        }, Vars.ui.discord::show).marginTop(9.0f).marginLeft(10.0f).tooltip("@discord").size(84.0f, 45.0f).name("discord"));
        parent.fill(c -> {
            c.bottom().right().button("\u63d0\u4ea4\u53cd\u9988", Icon.github, () -> {
                String link = "https://docs.qq.com/form/page/DTllxbXlCc0lJb1ps";
                if (!Core.app.openURI(link)) {
                    Vars.ui.showErrorMessage("@linkfail");
                    Core.app.setClipboardText(link);
                }
            }).size(200.0f, 60.0f).tooltip("\u53d1\u73b0\u4e86bug/\u63d0\u4ea4\u529f\u80fd\u5efa\u8bae?\n\u70b9\u51fb\u8fd9\u91cc\u63d0\u4ea4\u53cd\u9988").with(b -> {
                TextButton.TextButtonStyle s = new TextButton.TextButtonStyle(b.getStyle());
                s.fontColor = b.color;
                b.setStyle(s);
            }).update(b -> b.color.fromHsv(Time.time % 360.0f, 1.0f, 1.0f)).row();
            c.bottom().right().button("\u68c0\u67e5\u66f4\u65b0", Icon.refresh, () -> {
                Vars.ui.loadfrag.show();
                Vars.becontrol.checkUpdate(result -> {
                    Vars.ui.loadfrag.hide();
                    Vars.becontrol.BeControlTable();
                });
            }).size(200.0f, 60.0f).name("\u68c0\u67e5\u66f4\u65b0").update(t -> t.getLabel().setColor(Vars.becontrol.isUpdateAvailable() ? Tmp.c1.set(Color.white).lerp(Pal.accent, Mathf.absin(5.0f, 1.0f)) : Color.white));
        });
        parent.fill(c -> c.bottom().left().table(t -> {
            t.background(Tex.buttonEdge3);
            t.button("\ue83d", Styles.cleart, this::nextBackGroundImg).width(50.0f);
        }).visible(() -> Core.settings.getString("arcBackgroundPath", "").length() != 0).left().width(100.0f));
        String versionText = (Version.build == -1 ? "[#fc8140aa]" : "[cyan]") + Version.combined();
        String arcversionText = "\n[cyan]ARC version:" + Version.arcBuild;
        parent.fill((Table.DrawRect)(Table.DrawRect)LambdaMetafactory.metafactory(null, null, null, (FFFF)V, lambda$build$19(java.lang.String java.lang.String float float float float ), (FFFF)V)((MenuFragment)this, (String)versionText, (String)arcversionText)).touchable = Touchable.disabled;
        textGroup.setTransform(true);
        textGroup.setRotation(20.0f);
        this.textLabel = new Label("");
        textGroup.addChild(this.textLabel);
        textGroup.visible(() -> Core.settings.getBool("menuFloatText", true));
        this.textLabel.setAlignment(1);
        textGroup.update(() -> {
            textGroup.x = this.tx;
            textGroup.y = this.ty;
            this.textLabel.setFontScale((this.base == 0.0f ? 1.0f : this.base) * Math.abs(Time.time % this.period / this.period - 0.5f) * this.varSize + 1.0f);
            this.textLabel.setText(this.text);
        });
        Events.on(EventType.ClientLoadEvent.class, event -> Core.app.post(() -> Http.get("https://cn-arc.github.io/labels?t=" + Time.millis()).timeout(5000).error(e -> {
            Log.err("\u83b7\u53d6\u6700\u65b0\u4e3b\u9875\u6807\u8bed\u5931\u8d25!\u52a0\u8f7d\u672c\u5730\u6807\u8bed", e);
            this.labels = Core.files.internal("labels").readString("UTF-8").replace("\r", "").replace("\\n", "\n").replace("/n", "\n").split("\n");
            Core.app.post(this::randomLabel);
        }).submit(result -> {
            this.labels = result.getResultAsString().replace("\r", "").replace("\\n", "\n").replace("/n", "\n").split("\n");
            Core.app.post(this::randomLabel);
        })));
        arcNewsLastUpdate = Core.settings.getLong("arcNewsLastUpdate", 0L);
        Events.on(EventType.ClientLoadEvent.class, event -> Timer.schedule(MenuFragment::fetchArcNews, 0.0f, 300.0f));
        parent.fill(c -> c.top().left().table(t -> {
            t.background(Tex.buttonEdge4);
            t.button("\u5b66\u672f\u65e5\u62a5", Styles.cleart, MenuFragment::showArcNews).left().update(b -> b.setColor(haveNewerNews ? Tmp.c1.set(Color.white).lerp(Color.cyan, Mathf.absin(5.0f, 1.0f)) : Color.white)).growX();
        }).left().width(100.0f));
        Core.app.post(() -> Http.get("https://cn-arc.github.io/classes.json?t=" + Time.millis()).timeout(10000).error(Log::err).submit(r -> {
            try {
                JsonValue j = new JsonReader().parse(r.getResultAsString());
                if (j.getLong("lastUpdate", 0L) > Core.settings.getLong("archotfixtime", 0L)) {
                    Http.get("https://cn-arc.github.io/classes.zip").timeout(20000).error(Log::err).submit(r2 -> {
                        try {
                            ZipEntry file;
                            ZipInputStream zip = new ZipInputStream(r2.getResultAsStream());
                            Fi root = Vars.dataDirectory.child("arcvars");
                            root.emptyDirectory();
                            byte[] buffer = new byte[1024];
                            while ((file = zip.getNextEntry()) != null) {
                                int len;
                                Fi f = root.child(file.getName());
                                if (file.isDirectory()) {
                                    f.mkdirs();
                                    continue;
                                }
                                f.parent().mkdirs();
                                while ((len = zip.read(buffer)) > 0) {
                                    f.writeBytes(buffer, 0, len, true);
                                }
                            }
                            Core.settings.put("archotfixtime", j.getLong("lastUpdate", 0L));
                        }
                        catch (Exception e) {
                            Log.err(e);
                        }
                    });
                }
            }
            catch (Exception e) {
                Log.err(e);
            }
        }));
    }

    private void nextBackGroundImg() {
        this.arcBGList = Core.files.absolute(this.arcBackgroundPath).findAll(f -> !f.isDirectory() && (f.extEquals("png") || f.extEquals("jpg") || f.extEquals("jpeg")));
        if (this.arcBGList.size == 0) {
            return;
        }
        this.arcBackgroundPath = Core.settings.getString("arcBackgroundPath");
        ++this.arcBackgroundIndex;
        this.arcBackgroundIndex %= this.arcBGList.size;
        new Thread(() -> {
            try {
                this.arcBackground = this.arcBGList.get(this.arcBackgroundIndex);
                Core.app.post(() -> this.img.setDrawable(new TextureRegion(new Texture(this.arcBackground))));
            }
            catch (Exception e) {
                Core.app.post(() -> Vars.ui.showException("\u80cc\u666f\u56fe\u7247\u65e0\u6548:" + this.arcBGList.get(this.arcBackgroundIndex).path(), e));
            }
        }).start();
    }

    public static void fetchArcNews() {
        Http.get("https://cn-arc.github.io/news?t=" + Time.millis()).timeout(5000).error(e -> {}).submit(result -> {
            try {
                String s = result.getResultAsString();
                long last = Long.parseLong(s.substring(0, s.indexOf(10)));
                if (arcNewsLastUpdate < last) {
                    arcNewsLastUpdate = last;
                    haveNewerNews = true;
                    if (Core.settings.getBool("autoArcNews", false)) {
                        Core.app.post(MenuFragment::showArcNews);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static void showArcNews() {
        Core.settings.put("arcNewsLastUpdate", arcNewsLastUpdate);
        haveNewerNews = false;
        Http.get("https://cn-arc.github.io/news?t=" + Time.millis(), result -> {
            String s = result.getResultAsString();
            Core.app.post(() -> {
                try {
                    String[] news = s.replace("\r", "").split("\n");
                    boolean haveNews = false;
                    Table t = new Table();
                    ScrollPane p = new ScrollPane((Element)t);
                    t.table(t2 -> t2.check("\u6709\u66f4\u65b0\u65f6\u81ea\u52a8\u663e\u793a", b -> Core.settings.put("autoArcNews", b)).checked(Core.settings.getBool("autoArcNews", false))).growX().row();
                    for (int i = 0; i < news.length; i += 3) {
                        haveNews = true;
                        int idx = news[i + 1].indexOf(32);
                        int id = i;
                        t.button(b -> {
                            b.clearChildren();
                            b.add(idx == -1 ? news[id + 1].substring(0, 10) + "..." : news[id + 1].substring(0, idx)).padLeft(5.0f);
                            b.add().grow();
                            b.add(MenuFragment.formatTimeElapsed(Time.millis() - Long.parseLong(news[id]))).padRight(5.0f);
                        }, (Button.ButtonStyle)RStyles.flatt, () -> {
                            Window w = new Window(idx == -1 ? news[id + 1] : news[id + 1].substring(0, idx), 600.0f, 400.0f, Icon.book, ARCVars.arcui.WindowManager);
                            Table content = new Table();
                            ScrollPane pane = new ScrollPane((Element)content);
                            content.table(t2 -> {
                                t2.image().color(ARCVars.getThemeColor()).height(3.0f).growX().row();
                                t2.add(MenuFragment.formatTimeElapsed(Time.millis() - Long.parseLong(news[id]))).align(8).row();
                                t2.table(t3 -> {
                                    String n = (idx == -1 ? news[id + 1] : news[id + 1].substring(idx + 1)).replace("\\n", "\n");
                                    StringBuilder sb = new StringBuilder();
                                    Table there = new Table();
                                    int l = n.length();
                                    block17: for (int ptr = 0; ptr < l; ++ptr) {
                                        char c = n.charAt(ptr);
                                        Table finalThere = there;
                                        switch (c) {
                                            case '\\': {
                                                if (ptr + 1 >= l) continue block17;
                                                sb.append(n.charAt(ptr + 1));
                                                ++ptr;
                                                continue block17;
                                            }
                                            case '{': {
                                                int left = 0;
                                                int right = 0;
                                                for (int ptr2 = ptr; ptr2 < l; ++ptr2) {
                                                    switch (n.charAt(ptr2)) {
                                                        case '{': {
                                                            ++left;
                                                            break;
                                                        }
                                                        case '}': {
                                                            ++right;
                                                        }
                                                    }
                                                    if (left != right) continue;
                                                    String sub = n.substring(ptr + 1, ptr2);
                                                    int index = sub.indexOf(58);
                                                    if (index == -1) {
                                                        sb.append(n, ptr, ptr2 + 1);
                                                        ptr = ptr2;
                                                        continue block17;
                                                    }
                                                    String cont = sub.substring(index + 1);
                                                    boolean found = true;
                                                    String out = "";
                                                    switch (sub.substring(0, index)) {
                                                        case "image": {
                                                            if (sb.length() != 0) {
                                                                there.add(sb.toString());
                                                            }
                                                            Image img = there.image(Icon.refresh.getRegion()).size(64.0f).get();
                                                            img.setScaling(Scaling.fit);
                                                            Http.get(cont, r -> {
                                                                byte[] b = r.getResult();
                                                                Core.app.post(() -> {
                                                                    Pixmap pix = new Pixmap(b);
                                                                    finalThere.getCell(img).size(0.0f).grow();
                                                                    img.setDrawable(new TextureRegion(new Texture(pix)));
                                                                    pix.dispose();
                                                                });
                                                            });
                                                            break;
                                                        }
                                                        case "eval": {
                                                            sb.append(Vars.mods.getScripts().runConsole(cont));
                                                            there.add(sb.toString());
                                                            break;
                                                        }
                                                        default: {
                                                            found = false;
                                                            sb.append(n, ptr, ptr2 + 1);
                                                        }
                                                    }
                                                    if (!found) continue block17;
                                                    sb.setLength(0);
                                                    System.out.println(out);
                                                    ptr = ptr2;
                                                    continue block17;
                                                }
                                                continue block17;
                                            }
                                            case '\n': {
                                                if (sb.length() != 0) {
                                                    there.add(sb.toString());
                                                }
                                                sb.setLength(0);
                                                t3.add(there).row();
                                                there = new Table();
                                                continue block17;
                                            }
                                            default: {
                                                sb.append(c);
                                            }
                                        }
                                    }
                                    if (sb.length() != 0) {
                                        there.add(sb.toString());
                                    }
                                    t3.add(there);
                                }).growX().row();
                                t2.add(news[id + 2]).align(16);
                            }).pad(5.0f).growX().row();
                            w.setBody(new Table(t2 -> {
                                t2.setBackground(Styles.black3);
                                t2.add(pane).grow();
                            }));
                            w.add();
                        }).minHeight(40.0f).growX().row();
                    }
                    if (!haveNews) {
                        t.add("\u8fd9\u91cc\u4ec0\u4e48\u90fd\u6ca1\u6709");
                    }
                    Window w = new Window("\u5b66\u672f\u65e5\u62a5", 600.0f, 400.0f, Icon.book.getRegion(), ARCVars.arcui.WindowManager);
                    w.setBody(new Table(t2 -> t2.add(p).grow()){
                        {
                            this.setBackground(Styles.black3);
                        }
                    });
                    w.add();
                }
                catch (Exception e) {
                    Log.err(e);
                }
            });
        });
    }

    public static String formatTimeElapsed(long milliseconds) {
        long seconds = TimeUnit.MILLISECONDS.toSeconds(milliseconds);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(milliseconds);
        long hours = TimeUnit.MILLISECONDS.toHours(milliseconds);
        long days = TimeUnit.MILLISECONDS.toDays(milliseconds);
        if (days > 0L) {
            return days + "\u5929\u524d";
        }
        if (hours > 0L) {
            return hours + "\u5c0f\u65f6\u524d";
        }
        if (minutes > 0L) {
            return minutes + "\u5206\u949f\u524d";
        }
        return seconds + "\u79d2\u524d";
    }

    private void randomLabel() {
        Timer.schedule(() -> {
            this.text = "[yellow]" + this.labels[new Rand().random(0, this.labels.length - 1)];
        }, 0.11f);
    }

    private void buildMobile() {
        this.container.clear();
        this.container.name = "buttons";
        this.container.setSize(Core.graphics.getWidth(), Core.graphics.getHeight());
        float size = 120.0f;
        this.container.defaults().size(size).pad(5.0f).padTop(4.0f);
        this.initAchievement();
        MobileButton play = new MobileButton((Drawable)Icon.play, "@campaign", () -> this.checkPlay(Vars.ui.planet::show));
        MobileButton custom = new MobileButton((Drawable)Icon.rightOpenOut, "@customgame", () -> this.checkPlay(Vars.ui.custom::show));
        MobileButton maps = new MobileButton((Drawable)Icon.download, "@loadgame", () -> this.checkPlay(Vars.ui.load::show));
        MobileButton join = new MobileButton((Drawable)Icon.add, "@joingame", () -> this.checkPlay(Vars.ui.join::show));
        MobileButton editor = new MobileButton((Drawable)Icon.terrain, "@editor", () -> this.checkPlay(Vars.ui.maps::show));
        MobileButton tools = new MobileButton((Drawable)Icon.settings, "@settings", Vars.ui.settings::show);
        MobileButton mods = new MobileButton((Drawable)Icon.book, "@mods", Vars.ui.mods::show);
        MobileButton exit = new MobileButton((Drawable)Icon.exit, "@quit", () -> Core.app.exit());
        MobileButton cn_arc = new MobileButton((Drawable)Icon.info, "@aboutcn_arc.button", ARCVars.arcui.aboutcn_arc::show);
        MobileButton updatedialog = new MobileButton((Drawable)Icon.info, "@updatedialog.button", ARCVars.arcui.updatedialog::show);
        MobileButton database = new MobileButton((Drawable)Icon.book, "@database", Vars.ui.database::show);
        MobileButton achievements = new MobileButton((Drawable)Icon.star, "@achievements", ARCVars.arcui.achievements::show);
        play.clicked(this::randomLabel);
        custom.clicked(this::randomLabel);
        maps.clicked(this::randomLabel);
        join.clicked(this::randomLabel);
        editor.clicked(this::randomLabel);
        tools.clicked(this::randomLabel);
        mods.clicked(this::randomLabel);
        cn_arc.clicked(this::randomLabel);
        updatedialog.clicked(this::randomLabel);
        database.clicked(this::randomLabel);
        achievements.clicked(this::randomLabel);
        Seq<MobileButton> customs = this.customButtons.map(b -> new MobileButton(b.icon, b.text, b.runnable == null ? () -> {} : b.runnable));
        if (!Core.graphics.isPortrait()) {
            int i;
            this.container.marginTop(60.0f);
            if (Core.settings.getInt("changelogreaded") == ARCVars.changeLogRead) {
                this.container.add(play);
                this.container.add(join);
                this.container.add(custom);
                this.container.add(maps);
                for (i = 1; i < customs.size; i += 2) {
                    customs.get(i).clicked(this::randomLabel);
                    this.container.add(customs.get(i));
                }
                this.container.row();
                this.container.add(editor);
            }
            this.container.add(tools);
            this.container.add(mods);
            this.container.add(achievements);
            for (i = 0; i < customs.size; i += 2) {
                customs.get(i).clicked(this::randomLabel);
                this.container.add(customs.get(i));
            }
            this.container.row();
            this.container.add(cn_arc);
            this.container.add(updatedialog);
            this.container.add(database);
            if (!Vars.ios) {
                this.container.add(exit);
            }
        } else {
            this.container.marginTop(0.0f);
            if (Core.settings.getInt("changelogreaded") == ARCVars.changeLogRead) {
                this.container.add(play);
                this.container.add(maps);
                this.container.row();
                this.container.add(custom);
                this.container.add(join);
                this.container.row();
                this.container.add(editor);
            }
            this.container.add(tools);
            this.container.row();
            this.container.add(mods);
            for (int i = 0; i < customs.size; ++i) {
                customs.get(i).clicked(this::randomLabel);
                this.container.add(customs.get(i));
                if (i % 2 != 0) continue;
                this.container.row();
            }
            if (!Vars.ios) {
                this.container.add(exit);
            }
            this.container.row();
            this.container.add(cn_arc);
            this.container.add(database);
            this.container.row();
            this.container.add(achievements);
            this.container.add(updatedialog);
        }
    }

    void initAchievement() {
        Vars.service = new GameService(){

            @Override
            public boolean enabled() {
                return true;
            }

            @Override
            public void completeAchievement(String name) {
                Core.settings.put("achievement." + name, true);
                Vars.ui.hudfrag.showToast((Drawable)Core.atlas.getDrawable("error"), Core.bundle.get("achievement.unlocked") + "\n" + Core.bundle.get("achievement." + name + ".name"));
            }

            @Override
            public boolean isAchieved(String name) {
                return Core.settings.getBool("achievement." + name, false);
            }

            @Override
            public int getStat(String name, int def) {
                return Core.settings.getInt("achievementstat." + name, def);
            }

            @Override
            public void setStat(String name, int amount) {
                Core.settings.put("achievementstat." + name, amount);
            }
        };
        Vars.service.init();
    }

    private void buildDesktop() {
        this.container.clear();
        this.container.setSize(Core.graphics.getWidth(), Core.graphics.getHeight());
        float width = 230.0f;
        Drawable background = Styles.black6;
        this.container.left();
        this.container.add().width((float)Core.graphics.getWidth() / 10.0f);
        this.container.table(background, t -> {
            t.defaults().width(width).height(70.0f);
            t.name = "buttons";
            if (this.desktopButtons == null) {
                if (Core.settings.getInt("changelogreaded") != ARCVars.changeLogRead) {
                    MenuButton[] menuButtonArray = new MenuButton[3];
                    MenuButton[] menuButtonArray2 = new MenuButton[4];
                    menuButtonArray2[0] = new MenuButton("@schematics", (Drawable)Icon.paste, Vars.ui.schematics::show);
                    menuButtonArray2[1] = new MenuButton("@database", (Drawable)Icon.book, Vars.ui.database::show);
                    menuButtonArray2[2] = new MenuButton("@about.button", (Drawable)Icon.info, Vars.ui.about::show);
                    menuButtonArray2[3] = new MenuButton("@updatedialog.button", (Drawable)Icon.distribution, ARCVars.arcui.updatedialog::show);
                    menuButtonArray[0] = new MenuButton("@database.button", (Drawable)Icon.menu, menuButtonArray2);
                    menuButtonArray[1] = new MenuButton("@settings", (Drawable)Icon.settings, Vars.ui.settings::show);
                    menuButtonArray[2] = new MenuButton("@aboutcn_arc.button", (Drawable)Icon.info, ARCVars.arcui.aboutcn_arc::show);
                    this.desktopButtons = Seq.with(menuButtonArray);
                } else {
                    MenuButton[] menuButtonArray = new MenuButton[6];
                    menuButtonArray[0] = new MenuButton("@play", (Drawable)Icon.play, new MenuButton("@campaign", (Drawable)Icon.play, () -> this.checkPlay(Vars.ui.planet::show)), new MenuButton("@joingame", (Drawable)Icon.add, () -> this.checkPlay(Vars.ui.join::show)), new MenuButton("@customgame", (Drawable)Icon.terrain, () -> this.checkPlay(Vars.ui.custom::show)), new MenuButton("@loadgame", (Drawable)Icon.download, () -> this.checkPlay(Vars.ui.load::show)));
                    MenuButton[] menuButtonArray3 = new MenuButton[3];
                    menuButtonArray3[0] = new MenuButton("@schematics", (Drawable)Icon.paste, Vars.ui.schematics::show);
                    menuButtonArray3[1] = new MenuButton("@database", (Drawable)Icon.book, Vars.ui.database::show);
                    menuButtonArray3[2] = new MenuButton("@about.button", (Drawable)Icon.info, Vars.ui.about::show);
                    menuButtonArray[1] = new MenuButton("@database.button", (Drawable)Icon.menu, menuButtonArray3);
                    menuButtonArray[2] = new MenuButton("@editor", (Drawable)Icon.terrain, () -> this.checkPlay(Vars.ui.maps::show));
                    menuButtonArray[3] = Vars.steam ? new MenuButton("@workshop", (Drawable)Icon.steam, Vars.platform::openWorkshop) : null;
                    menuButtonArray[4] = new MenuButton("@mods", (Drawable)Icon.book, Vars.ui.mods::show);
                    menuButtonArray[5] = new MenuButton("@settings", (Drawable)Icon.settings, Vars.ui.settings::show);
                    this.desktopButtons = Seq.with(menuButtonArray);
                }
            }
            this.buttons((Table)t, (MenuButton[])this.desktopButtons.toArray(MenuButton.class));
            this.buttons((Table)t, (MenuButton[])this.customButtons.toArray(MenuButton.class));
            MenuButton[] menuButtonArray = new MenuButton[1];
            menuButtonArray[0] = new MenuButton("@quit", (Drawable)Icon.exit, Core.app::exit);
            this.buttons((Table)t, menuButtonArray);
        }).width(width).growY();
        this.container.table(background, t -> {
            this.submenu = t;
            t.name = "submenu";
            t.color.a = 0.0f;
            t.top();
            t.defaults().width(width).height(70.0f);
            t.visible(() -> !t.getChildren().isEmpty());
        }).width(width).growY();
    }

    private void checkPlay(Runnable run) {
        if (!Vars.mods.hasContentErrors()) {
            run.run();
        } else {
            Vars.ui.showInfo("@mod.noerrorplay");
        }
    }

    private void fadeInMenu() {
        this.submenu.clearActions();
        this.submenu.actions(Actions.alpha(1.0f, 0.15f, Interp.fade));
    }

    private void fadeOutMenu() {
        if (this.submenu.getChildren().isEmpty()) {
            return;
        }
        this.submenu.clearActions();
        this.submenu.actions(Actions.alpha(1.0f), Actions.alpha(0.0f, 0.2f, Interp.fade), Actions.run(() -> this.submenu.clearChildren()));
    }

    private void buttons(Table t, MenuButton ... buttons) {
        for (MenuButton b : buttons) {
            if (b == null) continue;
            Button[] out = new Button[]{null};
            out[0] = t.button(b.text, b.icon, Styles.flatToggleMenut, () -> {
                if (this.currentMenu == out[0]) {
                    this.currentMenu = null;
                    this.fadeOutMenu();
                } else if (b.submenu != null && b.submenu.any()) {
                    this.currentMenu = out[0];
                    this.submenu.clearChildren();
                    this.fadeInMenu();
                    this.submenu.add().height(((float)Core.graphics.getHeight() - Core.scene.marginTop - Core.scene.marginBottom - out[0].getY(10)) / Scl.scl(1.0f));
                    this.submenu.row();
                    this.buttons(this.submenu, b.submenu.toArray());
                } else {
                    this.currentMenu = null;
                    this.fadeOutMenu();
                    this.randomLabel();
                    b.runnable.run();
                }
            }).marginLeft(11.0f).get();
            out[0].update(() -> out[0].setChecked(this.currentMenu == out[0]));
            t.row();
        }
    }

    public void addButton(String text, Drawable icon, Runnable callback) {
        this.addButton(new MenuButton(text, icon, callback));
    }

    public void addButton(String text, Runnable callback) {
        this.addButton(text, Styles.none, callback);
    }

    public void addButton(MenuButton button) {
        this.customButtons.add(button);
    }

    private /* synthetic */ void lambda$build$19(String versionText, String arcversionText, float x, float y, float w, float h) {
        TextureAtlas.AtlasRegion logo = Core.atlas.find("logo");
        float width = Core.graphics.getWidth();
        float height = (float)Core.graphics.getHeight() - Core.scene.marginTop;
        float logoscl = Scl.scl(1.0f) * logo.scale;
        float logow = Math.min((float)logo.width * logoscl, (float)Core.graphics.getWidth() - Scl.scl(20.0f));
        float logoh = logow * (float)logo.height / (float)logo.width;
        float fx = (int)(width / 2.0f);
        float fy = (float)((int)(height - 6.0f - logoh)) + logoh / 2.0f - (Core.graphics.isPortrait() ? Scl.scl(30.0f) : 0.0f);
        if (Core.settings.getBool("macnotch")) {
            fy -= Scl.scl(Vars.macNotchHeight);
        }
        this.tx = width / 2.0f + logow * 0.35f;
        this.ty = fy - logoh / 2.0f - Scl.scl(2.0f) + logoh * 0.15f;
        this.base = logoh * 0.03f;
        Draw.color();
        Draw.rect((TextureRegion)logo, fx, fy, logow, logoh);
        Fonts.outline.setColor(Color.white);
        Fonts.outline.draw(versionText + arcversionText, fx, fy - logoh / 2.0f - Scl.scl(2.0f), 1);
    }

    public static class MenuButton {
        public final Drawable icon;
        public final String text;
        public final Runnable runnable;
        @Nullable
        public final Seq<MenuButton> submenu;

        public MenuButton(String text, Drawable icon, Runnable runnable) {
            this.icon = icon;
            this.text = text;
            this.runnable = runnable;
            this.submenu = null;
        }

        public MenuButton(String text, Drawable icon, Runnable runnable, MenuButton ... submenu) {
            this.icon = icon;
            this.text = text;
            this.runnable = runnable;
            this.submenu = submenu != null ? Seq.with(submenu) : null;
        }

        MenuButton(String text, Drawable icon, MenuButton ... submenu) {
            this.icon = icon;
            this.text = text;
            this.runnable = () -> {};
            this.submenu = submenu != null ? Seq.with(submenu) : null;
        }
    }
}

