/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.func.Boolp;
import arc.func.Cons;
import arc.func.Floatp;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.actions.Actions;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.Slider;
import arc.scene.ui.Tooltip;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Bits;
import arc.struct.Seq;
import arc.util.Scaling;
import arc.util.Time;
import arc.util.Tmp;
import java.lang.invoke.LambdaMetafactory;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.Marker;
import mindustry.arcModule.RFuncs;
import mindustry.arcModule.TimeControl;
import mindustry.arcModule.ui.AdvanceToolTable;
import mindustry.arcModule.ui.OtherCoreItemDisplay;
import mindustry.arcModule.ui.PowerInfo;
import mindustry.arcModule.ui.QuickCameraTable;
import mindustry.arcModule.ui.RCoreItemsDisplay;
import mindustry.arcModule.ui.auxilliary.AuxilliaryTable;
import mindustry.arcModule.ui.quickTool.QuickToolTable;
import mindustry.content.Blocks;
import mindustry.content.StatusEffects;
import mindustry.core.GameState;
import mindustry.core.UI;
import mindustry.core.World;
import mindustry.ctype.UnlockableContent;
import mindustry.game.EventType;
import mindustry.game.Gamemode;
import mindustry.game.MapObjectives;
import mindustry.game.SpawnGroup;
import mindustry.game.Team;
import mindustry.gen.BlockUnitUnit;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Icon;
import mindustry.gen.Payloadc;
import mindustry.gen.Player;
import mindustry.gen.Sounds;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.input.InputHandler;
import mindustry.input.MobileInput;
import mindustry.net.Packets;
import mindustry.type.Item;
import mindustry.type.Planet;
import mindustry.type.StatusEffect;
import mindustry.ui.Bar;
import mindustry.ui.Displayable;
import mindustry.ui.IntFormat;
import mindustry.ui.Minimap;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.fragments.PlacementFragment;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.defense.turrets.ItemTurret;
import mindustry.world.blocks.environment.OverlayFloor;
import mindustry.world.blocks.environment.RemoveOre;
import mindustry.world.blocks.environment.RemoveWall;
import mindustry.world.meta.BuildVisibility;

public class HudFragment {
    private static final float dsize = 65.0f;
    private static final float pauseHeight = 36.0f;
    public PlacementFragment blockfrag = new PlacementFragment();
    public boolean shown = true;
    private ImageButton flip;
    private Slider minimapSlider;
    public RCoreItemsDisplay coreItems = new RCoreItemsDisplay();
    public OtherCoreItemDisplay otherCoreItemDisplay = new OtherCoreItemDisplay();
    public QuickCameraTable quickCameraTable = new QuickCameraTable();
    private AuxilliaryTable auxilliaryTable;
    private final AdvanceToolTable advanceToolTable = new AdvanceToolTable();
    public QuickToolTable quickToolTable = new QuickToolTable();
    private boolean hideObjectives = true;
    private boolean editorMainShow = true;
    private String hudText = "";
    private boolean showHudText;
    private Table lastUnlockTable;
    private Table lastUnlockLayout;
    private long lastToast;
    private Seq<Block> blocksOut = new Seq();
    private final Table arcStatus = new Table();

    private void addBlockSelection(Table cont) {
        Table blockSelection = new Table();
        ScrollPane pane = new ScrollPane((Element)blockSelection, Styles.smallPane);
        pane.setFadeScrollBars(false);
        Planet[] last = new Planet[]{Vars.state.rules.planet};
        pane.update(() -> {
            Element result;
            if (pane.hasScroll() && ((result = Core.scene.getHoverElement()) == null || !result.isDescendantOf(pane))) {
                Core.scene.setScrollFocus(null);
            }
            if (Vars.state.rules.planet != last[0]) {
                last[0] = Vars.state.rules.planet;
                this.rebuildBlockSelection(blockSelection, "");
            }
        });
        Table[] configTable = new Table[]{null};
        Block[] lastBlock = new Block[]{null};
        cont.table(search -> {
            search.image(Icon.zoom).padRight(8.0f);
            search.field("", text -> this.rebuildBlockSelection(blockSelection, (String)text)).growX().name("editor/search").maxTextLength(40).get().setMessageText("@players.search");
        }).growX().pad(-2.0f).padLeft(6.0f);
        cont.row();
        cont.collapser(t -> {
            configTable[0] = t;
        }, () -> Vars.control.input.block != null && Vars.control.input.block.editorConfigurable).with(c -> c.setEnforceMinSize(true)).update(col -> {
            if (lastBlock[0] != Vars.control.input.block) {
                configTable[0].clear();
                if (Vars.control.input.block != null) {
                    Vars.control.input.block.buildEditorConfig(configTable[0]);
                    col.invalidateHierarchy();
                }
                lastBlock[0] = Vars.control.input.block;
            }
        }).growX().row();
        cont.add(pane).expandY().top().left();
        this.rebuildBlockSelection(blockSelection, "");
    }

    private void rebuildBlockSelection(Table blockSelection, String searchText) {
        blockSelection.clear();
        this.blocksOut.clear();
        this.blocksOut.addAll(Vars.content.blocks());
        this.blocksOut.sort((b1, b2) -> {
            int synth = Boolean.compare(b1.synthetic(), b2.synthetic());
            if (synth != 0) {
                return synth;
            }
            int ore = Boolean.compare(b1 instanceof OverlayFloor && b1 != Blocks.removeOre, b2 instanceof OverlayFloor && b2 != Blocks.removeOre);
            if (ore != 0) {
                return ore;
            }
            return Integer.compare(b1.id, b2.id);
        });
        int i = 0;
        for (Block block : this.blocksOut) {
            TextureRegion region = block.uiIcon;
            if (!Core.atlas.isFound(region) || !block.inEditor && !(block instanceof RemoveWall) && !(block instanceof RemoveOre) || !block.isOnPlanet(Vars.state.rules.planet) || block.buildVisibility == BuildVisibility.debugOnly || !searchText.isEmpty() && !block.localizedName.toLowerCase().contains(searchText.trim().replaceAll(" +", " ").toLowerCase())) continue;
            ImageButton button = new ImageButton(Tex.whiteui, Styles.clearNoneTogglei);
            button.getStyle().imageUp = new TextureRegionDrawable(region);
            button.clicked(() -> {
                Vars.control.input.block = block;
            });
            button.resizeImage(32.0f);
            button.update(() -> button.setChecked(Vars.control.input.block == block));
            blockSelection.add(button).size(48.0f).tooltip(block.localizedName);
            if (++i % 6 != 0) continue;
            blockSelection.row();
        }
        if (i == 0) {
            blockSelection.add("@none.found").padLeft(54.0f).padTop(10.0f);
        }
    }

    public void build(Group parent) {
        this.auxilliaryTable = new AuxilliaryTable();
        Events.on(EventType.WaveEvent.class, e -> {
            int max = 10;
            int winWave = Vars.state.rules.winWave > 0 ? Vars.state.rules.winWave : Integer.MAX_VALUE;
            block0: for (int i = Vars.state.wave - 1; i <= Math.min(Vars.state.wave + max, winWave - 2); ++i) {
                for (SpawnGroup group : Vars.state.rules.spawns) {
                    if (group.effect != StatusEffects.boss || group.getSpawned(i) <= 0) continue;
                    int diff = i + 2 - Vars.state.wave;
                    if (diff != 1 && diff != 2 && diff != 5 && diff != 10) break block0;
                    this.showToast(Icon.warning, group.type.emoji() + " " + Core.bundle.format("wave.guardianwarn" + (diff == 1 ? ".one" : ""), diff));
                    break block0;
                }
            }
        });
        Events.on(EventType.SectorCaptureEvent.class, e -> {
            if (e.sector.isBeingPlayed()) {
                Vars.ui.announce("@sector.capture.current", 5.0f);
            } else {
                this.showToast(Core.bundle.format("sector.capture", e.sector.name()));
            }
        });
        Events.on(EventType.SectorLoseEvent.class, e -> this.showToast(Icon.warning, Core.bundle.format("sector.lost", e.sector.name())));
        Events.on(EventType.SectorInvasionEvent.class, e -> this.showToast(Icon.warning, Core.bundle.format("sector.attacked", e.sector.name())));
        Events.on(EventType.ResetEvent.class, e -> {
            this.coreItems.resetUsed();
            this.coreItems.clear();
        });
        Events.on(EventType.WorldLoadEvent.class, e -> {
            this.auxilliaryTable.toggle();
            this.hideObjectives = false;
            this.rebuildArcStatus();
            if (this.minimapSlider != null) {
                this.minimapSlider.setRange(0.1f, (float)Math.min(Vars.world.width(), Vars.world.height()) / 16.0f / 2.0f);
            }
        });
        parent.fill(t -> {
            t.name = "paused";
            t.top().visible((Boolp)(Boolp)LambdaMetafactory.metafactory(null, null, null, ()Z, lambda$build$16(), ()Z)((HudFragment)this)).touchable = Touchable.disabled;
            t.table(Styles.black6, top -> top.label(() -> Vars.state.gameOver && Vars.state.isCampaign() ? "@sector.curlost" : "@paused").style(Styles.outlineLabel).pad(8.0f)).height(36.0f).growX();
        });
        parent.fill(t -> {
            t.name = "waiting";
            t.visible((Boolp)(Boolp)LambdaMetafactory.metafactory(null, null, null, ()Z, lambda$build$20(), ()Z)((HudFragment)this)).touchable = Touchable.disabled;
            t.table(Styles.black6, top -> top.add("@waiting.players").style(Styles.outlineLabel).pad(18.0f));
        });
        parent.fill(t -> {
            t.name = "minimap/position";
            t.visible(() -> Core.settings.getBool("minimap") && this.shown);
            t.add(new Minimap()).name("minimap");
            t.row();
            if (Vars.mobile) {
                t.table(tt -> {
                    tt.button((Drawable)Icon.play, Styles.cleari, () -> Vars.ui.minimapfrag.toggle()).left();
                    this.minimapSlider = tt.slider(1.0f, 1.0f, 0.1f, n -> Vars.renderer.minimap.setZoom(n)).fillX().get();
                }).fillX().row();
            }
            t.table(tt -> {
                tt.label(() -> Vars.player.unit().type.emoji() + (Core.settings.getBool("position") ? Vars.player.tileX() + "," + Vars.player.tileY() + "\n" : "") + (Core.settings.getBool("mouseposition") ? "[lightgray]\u2650" + World.toTile(Core.input.mouseWorldX()) + "," + World.toTile(Core.input.mouseWorldY()) : "")).visible(() -> Core.settings.getBool("position") || Core.settings.getBool("mouseposition")).touchable(Touchable.disabled).style(Styles.outlineLabel).name("position");
                if (Core.settings.getBool("minimapTools")) {
                    tt.button("\ue815", Styles.cleart, () -> Core.settings.put("minimap", !Core.settings.getBool("minimap"))).size(30.0f, 30.0f).tooltip("\u5173\u95ed\u5c0f\u5730\u56fe(\u518d\u6b21\u6253\u5f00\u53bb\u8bbe\u7f6e\u91cc\u5f00)");
                    tt.button("+", Styles.cleart, () -> Core.settings.put("minimapSize", (int)((double)Core.settings.getInt("minimapSize") * 1.2))).size(30.0f, 30.0f).tooltip("\u589e\u52a0\u5c0f\u5730\u56fe\u5927\u5c0f");
                    tt.button("-", Styles.cleart, () -> Core.settings.put("minimapSize", (int)((double)Core.settings.getInt("minimapSize") / 1.2))).size(30.0f, 30.0f).tooltip("\u51cf\u5c11\u5c0f\u5730\u56fe\u5927\u5c0f");
                    tt.button("\ue872", Styles.cleart, () -> {
                        Vars.renderer.minimap.forceShowPlayer = !Vars.renderer.minimap.forceShowPlayer;
                    }).size(30.0f, 30.0f).tooltip("\u5f00\u5173\u73a9\u5bb6\u540d\u663e\u793a");
                    tt.button("\uf6aa", Styles.cleart, () -> {
                        Vars.renderer.minimap.unitDetailsIcon = !Vars.renderer.minimap.unitDetailsIcon;
                    }).size(30.0f, 30.0f).tooltip("\u5355\u4f4d\u56fe\u6807\u7ec6\u8282");
                }
                tt.button("\u2650", Styles.cleart, Marker::lockonLastMark).size(30.0f, 30.0f).tooltip("\u9501\u5b9a\u4e0a\u4e2a\u6807\u8bb0\u70b9");
            }).style(Styles.outlineLabel);
            if (Core.settings.getInt("AuxiliaryTable") == 3) {
                t.row();
                t.table(infoWave -> {
                    infoWave.left().top();
                    infoWave.add(this.auxilliaryTable);
                }).left().top();
            }
            t.top().right();
        });
        Vars.ui.hints.build(parent);
        parent.fill(cont -> {
            cont.name = "overlaymarker";
            cont.top().left();
            if (Vars.mobile) {
                cont.rect((x, y, w, h) -> {
                    if (Core.scene.marginTop > 0.0f) {
                        Tex.paneRight.draw(x, y, w, Core.scene.marginTop);
                    }
                }).fillX().row();
                cont.table(select -> {
                    select.name = "mobile buttons";
                    select.left();
                    select.defaults().size(65.0f).left();
                    ImageButton.ImageButtonStyle style = Styles.cleari;
                    select.button((Drawable)Icon.menu, style, Vars.ui.paused::show).name("menu");
                    this.flip = select.button((Drawable)Icon.upOpen, style, this::toggleMenus).get();
                    this.flip.name = "flip";
                    select.button((Drawable)Icon.paste, style, Vars.ui.schematics::show).name("schematics");
                    select.button((Drawable)Icon.pause, style, () -> {
                        if (Vars.net.active()) {
                            Vars.ui.listfrag.toggle();
                        } else {
                            Vars.state.set(Vars.state.isPaused() ? GameState.State.playing : GameState.State.paused);
                        }
                    }).name("pause").update(i -> {
                        if (Vars.net.active()) {
                            i.getStyle().imageUp = Icon.players;
                        } else {
                            i.setDisabled(false);
                            i.getStyle().imageUp = Vars.state.isPaused() ? Icon.play : Icon.pause;
                        }
                    });
                    select.button((Drawable)Icon.chat, style, () -> {
                        if (Vars.net.active() && Vars.mobile) {
                            if (Vars.ui.chatfrag.shown()) {
                                Vars.ui.chatfrag.hide();
                            } else {
                                Vars.ui.chatfrag.toggle();
                            }
                        } else if (Vars.state.isCampaign()) {
                            Vars.ui.research.show();
                        } else {
                            Vars.ui.database.show();
                        }
                    }).name("chat").update(i -> {
                        i.getStyle().imageUp = Vars.net.active() && Vars.mobile ? Icon.chat : (Vars.state.isCampaign() ? Icon.tree : Icon.book);
                    });
                    select.image().color(Pal.gray).width(4.0f).fillY();
                });
                cont.row();
                cont.image().height(4.0f).color(Pal.gray).fillX();
                cont.row();
            }
            cont.update(() -> {
                if (Core.input.keyTap(Binding.toggleMenus) && !Vars.ui.chatfrag.shown() && !Core.scene.hasDialog() && !Core.scene.hasField()) {
                    Core.settings.getBoolOnce("ui-hidden", () -> Vars.ui.announce(Core.bundle.format("showui", Binding.toggleMenus.value.key.toString(), 11)));
                    this.toggleMenus();
                }
                if (Core.input.keyTap(Binding.skipWave) && this.canSkipWave()) {
                    if (Vars.net.client() && Vars.player.admin) {
                        Call.adminRequest(Vars.player, Packets.AdminAction.wave, null);
                    } else {
                        Vars.logic.skipWave();
                    }
                }
            });
            Element[] elementArray = new Element[3];
            Table wavesMain = new Table();
            elementArray[0] = wavesMain;
            Table editorMain = new Table();
            elementArray[1] = editorMain;
            elementArray[2] = new Element(){
                {
                    this.visible = false;
                    this.touchable = Touchable.disabled;
                }

                @Override
                public float getPrefHeight() {
                    return Scl.scl(120.0f);
                }
            };
            cont.stack(elementArray).name("waves/editor");
            wavesMain.visible(() -> this.shown && !Vars.state.isEditor());
            wavesMain.top().left().name = "waves";
            ImageButton.ImageButtonStyle rightStyle = new ImageButton.ImageButtonStyle(){
                {
                    this.over = Tex.buttonRightOver;
                    this.down = Tex.buttonRightDown;
                    this.up = Tex.buttonRight;
                    this.disabled = Tex.buttonRightDisabled;
                    this.imageDisabledColor = Color.clear;
                    this.imageUpColor = Color.white;
                }
            };
            if (Core.settings.getBool("arcSpecificTable")) {
                wavesMain.table(s -> s.add(this.makeStatusTableArc()).grow().name("status")).width(329.0f).name("statustable").left();
            } else {
                wavesMain.table(arg_0 -> this.lambda$build$49(rightStyle, arg_0)).width(329.0f).name("statustable").left();
            }
            wavesMain.row();
            if (Core.settings.getInt("AuxiliaryTable") == 2) {
                wavesMain.table(t -> {
                    t.name = "AuxiliaryTable";
                    t.left().top().add(this.auxilliaryTable);
                }).left();
                wavesMain.row();
            }
            this.addInfoTable(wavesMain.table().width(329.0f).left().get());
            editorMain.name = "editor";
            editorMain.button("[green]\u961f", () -> {
                this.editorMainShow = !this.editorMainShow;
            }).left().width(40.0f).padBottom(40.0f);
            editorMain.row();
            editorMain.table(Tex.buttonEdge4, t -> {
                t.name = "teams";
                t.top().table(teams -> {
                    teams.left();
                    int i = 0;
                    for (Team team : Team.baseTeams) {
                        ImageButton button = teams.button(Tex.whiteui, Styles.clearNoneTogglei, 33.0f, () -> Call.setPlayerTeamEditor(Vars.player, team)).size(45.0f).margin(6.0f).get();
                        button.getImageCell().grow();
                        button.getStyle().imageUpColor = team.color;
                        button.update(() -> button.setChecked(Vars.player.team() == team));
                        if (++i % 6 != 0) continue;
                        teams.row();
                    }
                    teams.button("\u66f4\u591a", () -> {
                        BaseDialog dialog = new BaseDialog("\u961f\u4f0d\u9009\u62e9\u5668");
                        Table selectTeam = new Table().top();
                        dialog.cont.pane(td -> {
                            int j = 0;
                            for (Team team : Team.all) {
                                ImageButton button = new ImageButton(Tex.whiteui, Styles.clearTogglei);
                                button.getStyle().imageUpColor = team.color;
                                button.margin(10.0f);
                                button.resizeImage(40.0f);
                                button.clicked(() -> {
                                    Call.setPlayerTeamEditor(Vars.player, team);
                                    dialog.hide();
                                });
                                button.update(() -> button.setChecked(Vars.player.team() == team));
                                td.add(button);
                                if (++j == 5) {
                                    td.row();
                                    td.add("\u961f\u4f0d\uff1a" + j + "~" + (j + 10));
                                    continue;
                                }
                                if ((j - 5) % 10 != 0) continue;
                                td.row();
                                td.add("\u961f\u4f0d\uff1a" + j + "~" + (j + 10));
                            }
                        });
                        dialog.add(selectTeam).center();
                        dialog.row();
                        teams.button((Drawable)Icon.downOpen, Styles.emptyi, () -> Core.settings.put("editor-blocks-shown", !Core.settings.getBool("editor-blocks-shown"))).size(45.0f).update(m -> {
                            m.getStyle().imageUp = Core.settings.getBool("editor-blocks-shown") ? Icon.upOpen : Icon.downOpen;
                        });
                        dialog.addCloseButton();
                        dialog.show();
                    }).center().row();
                }).left();
                t.row();
                t.table(Vars.control.input::buildPlacementUI).growX().left().with(in -> in.left()).row();
                t.collapser(this::addBlockSelection, () -> Core.settings.getBool("editor-blocks-shown"));
                t.table(h -> {
                    Runnable rebuild = () -> {
                        h.clear();
                        h.left();
                        Displayable hover = this.blockfrag.hovered();
                        UnlockableContent toDisplay = Vars.control.input.block;
                        if (toDisplay == null && hover != null) {
                            if (hover instanceof Building) {
                                Building b = (Building)hover;
                                toDisplay = b.block;
                            } else if (hover instanceof Tile) {
                                Tile tile = (Tile)hover;
                                toDisplay = tile.block().itemDrop != null ? tile.block() : (tile.overlay().itemDrop != null || tile.wallDrop() != null ? tile.overlay() : tile.floor());
                            } else if (hover instanceof Unit) {
                                Unit u = (Unit)hover;
                                toDisplay = u.type;
                            }
                        }
                        if (toDisplay != null) {
                            h.image(toDisplay.uiIcon).scaling(Scaling.fit).size(32.0f);
                            h.add(toDisplay.localizedName).ellipsis(true).left().growX().padLeft(5.0f);
                        }
                    };
                    Object[] hovering = new Object[]{null};
                    h.update(() -> {
                        Object nextHover;
                        Object object = nextHover = Vars.control.input.block != null ? Vars.control.input.block : this.blockfrag.hovered();
                        if (nextHover != hovering[0]) {
                            hovering[0] = nextHover;
                            rebuild.run();
                        }
                    });
                }).growX().left().minHeight(36.0f).row();
                t.table(blocks -> this.addBlockSelection((Table)blocks)).fillX().left();
                t.visible(() -> this.editorMainShow);
            }).width(329.0f);
            if (Vars.mobile) {
                editorMain.row().spacerY(() -> {
                    InputHandler patt23128$temp = Vars.control.input;
                    if (patt23128$temp instanceof MobileInput) {
                        MobileInput mob = (MobileInput)patt23128$temp;
                        if (Core.graphics.isPortrait()) {
                            return (float)Core.graphics.getHeight() / 2.0f / Scl.scl(1.0f);
                        }
                        if (mob.hasSchematic()) {
                            return 156.0f;
                        }
                        if (mob.showCancel()) {
                            return 50.0f;
                        }
                    }
                    return 0.0f;
                });
            }
            editorMain.row().add().growY();
            editorMain.visible(() -> this.shown && (Vars.state.isEditor() || Core.settings.getBool("selectTeam")) && !Core.settings.getBool("showAdvanceToolTable"));
            if (Core.settings.getInt("AuxiliaryTable") == 1) {
                cont.table(infoWave -> {
                    infoWave.name = "map/wave";
                    infoWave.left().top();
                    infoWave.add(this.auxilliaryTable);
                }).left().top();
            }
            cont.table(info -> {
                info.name = "fps/ping";
                info.touchable = Touchable.disabled;
                info.top().left().margin(4.0f).visible(() -> Core.settings.getBool("fps") && this.shown);
                IntFormat fps = new IntFormat("fps");
                IntFormat ping = new IntFormat("ping");
                IntFormat tps = new IntFormat("tps");
                IntFormat mem = new IntFormat("memory");
                IntFormat memnative = new IntFormat("memory2");
                info.add("ARC~" + ARCVars.arcVersion).color(ARCVars.getThemeColor()).left();
                info.row();
                info.label(() -> fps.get(Core.graphics.getFramesPerSecond())).left().style(Styles.outlineLabel).name("fps");
                info.row();
                info.label(() -> "\u500d\u901f: " + String.format("%.2f", Float.valueOf(TimeControl.getGameSpeed()))).left().style(Styles.outlineLabel);
                info.row();
                if (!Vars.android) {
                    info.label(() -> "\u7f29\u653e: " + String.format("%.2f", Float.valueOf(Vars.renderer.getScale()))).left().style(Styles.outlineLabel);
                    info.row();
                }
                if (Vars.android) {
                    info.label(() -> memnative.get((int)(Core.app.getJavaHeap() / 1024L / 1024L), (int)(Core.app.getNativeHeap() / 1024L / 1024L))).left().style(Styles.outlineLabel).name("memory2");
                } else {
                    info.label(() -> mem.get((int)(Core.app.getJavaHeap() / 1024L / 1024L))).left().style(Styles.outlineLabel).name("memory");
                }
                info.row();
                info.label(() -> ping.get(Vars.netClient.getPing())).visible(Vars.net::client).left().style(Styles.outlineLabel).name("ping").row();
                info.label(() -> tps.get(Vars.state.serverTps == -1 ? 60 : Vars.state.serverTps)).visible(Vars.net::client).left().style(Styles.outlineLabel).name("tps").row();
            }).top().left();
        });
        parent.fill(t -> {
            t.top();
            if (Core.settings.getBool("macnotch")) {
                t.margin(Vars.macNotchHeight);
            }
            t.visible(() -> this.shown);
            t.name = "coreinfo";
            t.collapser(v -> v.add().height(36.0f), () -> Vars.state.isPaused() && !Vars.netServer.isWaitingForPlayers()).row();
            t.table(c -> {
                c.top().collapser(this.coreItems, () -> Core.settings.getInt("arccoreitems") > 0 && this.shown).fillX().row();
                float notifDuration = 240.0f;
                float[] coreAttackTime = new float[]{0.0f};
                Events.run((Object)EventType.Trigger.teamCoreDamage, () -> {
                    coreAttackTime[0] = notifDuration;
                });
                c.collapser(top -> top.background(Styles.black6).add("@coreattack").pad(8.0f).update(label -> label.color.set(Color.orange).lerp(Color.scarlet, Mathf.absin(Time.time, 2.0f, 1.0f))), true, () -> {
                    float f;
                    if (!this.shown || Vars.state.isPaused()) {
                        return false;
                    }
                    if (Vars.state.isMenu() || !Vars.player.team().data().hasCore()) {
                        coreAttackTime[0] = 0.0f;
                        return false;
                    }
                    coreAttackTime[0] = coreAttackTime[0] - Time.delta;
                    return f > 0.0f;
                }).touchable(Touchable.disabled).fillX().row();
            }).row();
            if (Core.settings.getBool("override_boss_shown")) {
                StringBuilder bossb = new StringBuilder();
                String bossText = Core.bundle.get("guardian");
                int maxBosses = 6;
                t.table(v -> v.margin(10.0f).add(new Bar(() -> {
                    bossb.setLength(0);
                    for (int i = 0; i < Math.min(Vars.state.teams.bosses.size, maxBosses); ++i) {
                        bossb.append(Vars.state.teams.bosses.get((int)i).type.emoji());
                    }
                    if (Vars.state.teams.bosses.size > maxBosses) {
                        bossb.append("[accent]+[]");
                    }
                    bossb.append(" ");
                    bossb.append(bossText);
                    return bossb;
                }, () -> Pal.health, () -> {
                    if (Vars.state.boss() == null) {
                        return 0.0f;
                    }
                    float max = 0.0f;
                    float val = 0.0f;
                    for (Unit boss : Vars.state.teams.bosses) {
                        max += boss.maxHealth;
                        val += boss.health;
                    }
                    return max == 0.0f ? 0.0f : val / max;
                }).blink(Color.white).outline(new Color(0.0f, 0.0f, 0.0f, 0.6f), 7.0f)).grow()).fillX().width(320.0f).height(60.0f).name("boss").visible(() -> Vars.state.rules.waves && Vars.state.boss() != null && (!Vars.mobile || !Core.graphics.isPortrait())).padTop(7.0f).row();
            }
            t.table(Styles.black3, p -> p.margin(4.0f).label(() -> this.hudText).style(Styles.outlineLabel)).touchable(Touchable.disabled).with(p -> p.visible(() -> {
                p.color.a = Mathf.lerpDelta(p.color.a, Mathf.num(this.showHudText), 0.2f);
                if (Vars.state.isMenu()) {
                    p.color.a = 0.0f;
                    this.showHudText = false;
                }
                return p.color.a >= 0.001f;
            }));
        });
        parent.fill(t -> {
            t.name = "otherCore";
            t.left().add(this.otherCoreItemDisplay);
            t.visible(() -> Core.settings.getBool("showOtherTeamResource") && this.shown);
        });
        parent.fill(t -> {
            t.bottom().add(this.quickCameraTable);
            t.visible(() -> Core.settings.getInt("quickHudSize") > 0 && this.shown);
        });
        parent.fill(t -> {
            t.right().add(this.quickToolTable);
            t.visible(() -> Core.settings.getBool("showQuickToolTable") && this.shown);
        });
        parent.fill(t -> {
            t.name = "nearpoint";
            t.touchable = Touchable.disabled;
            t.table((Drawable)Styles.black6, (Cons<Table>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$build$108(arc.scene.ui.layout.Table ), (Larc/scene/ui/layout/Table;)V)()).margin((float)6.0f).update((Cons<Table>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$build$109(arc.scene.ui.layout.Table ), (Larc/scene/ui/layout/Table;)V)()).get().color.a = 0.0f;
        });
        parent.fill(t -> {
            t.name = "saving";
            t.bottom().visible(() -> Vars.control.saves.isSaving());
            t.add("@saving").style(Styles.outlineLabel);
        });
        parent.fill(t -> {
            t.name = "advanceToolTable";
            t.left().bottom().add(this.advanceToolTable);
            t.visible(() -> Core.settings.getBool("showAdvanceToolTable") && this.shown);
        });
        this.blockfrag.build(parent);
    }

    public static void setPlayerTeamEditor(Player player, Team team) {
        if ((Vars.state.isEditor() || Core.settings.getBool("selectTeam")) && player != null) {
            player.team(team);
        }
    }

    public void setHudText(String text) {
        this.showHudText = true;
        this.hudText = text;
    }

    public void toggleHudText(boolean shown) {
        this.showHudText = shown;
    }

    private void scheduleToast(Runnable run) {
        long duration = 3500L;
        long since = Time.timeSinceMillis(this.lastToast);
        if (since > duration) {
            this.lastToast = Time.millis();
            run.run();
        } else {
            Time.runTask((float)(duration - since) / 1000.0f * 60.0f, run);
            this.lastToast += duration;
        }
    }

    public boolean hasToast() {
        return (float)Time.timeSinceMillis(this.lastToast) < 3500.0f;
    }

    public void showToast(String text) {
        this.showToast(Icon.ok, text);
    }

    public void showToast(Drawable icon, String text) {
        this.showToast(icon, -1.0f, text);
    }

    public void showToast(Drawable icon, float size, String text) {
        if (Vars.state.isMenu()) {
            return;
        }
        this.scheduleToast(() -> {
            Sounds.message.play();
            Table table = new Table(Tex.button);
            table.update(() -> {
                if (Vars.state.isMenu() || !Vars.ui.hudfrag.shown) {
                    table.remove();
                }
            });
            table.margin(12.0f);
            Cell<Image> cell = table.image(icon).pad(3.0f);
            if (size > 0.0f) {
                cell.size(size);
            }
            table.add(text).wrap().width(280.0f).get().setAlignment(1, 1);
            table.pack();
            Table container = Core.scene.table();
            container.top().add(table);
            container.setTranslation(0.0f, table.getPrefHeight());
            container.actions(Actions.translateBy(0.0f, -table.getPrefHeight(), 1.0f, Interp.fade), Actions.delay(2.5f), Actions.run(() -> container.actions(Actions.translateBy(0.0f, table.getPrefHeight(), 1.0f, Interp.fade), Actions.remove())));
        });
    }

    public void showUnlock(UnlockableContent content) {
        if (Vars.state.isMenu()) {
            return;
        }
        Sounds.message.play();
        if (this.lastUnlockTable == null) {
            this.scheduleToast(() -> {
                Table table = new Table(Tex.button);
                table.update(() -> {
                    if (Vars.state.isMenu()) {
                        table.remove();
                        this.lastUnlockLayout = null;
                        this.lastUnlockTable = null;
                    }
                });
                table.margin(12.0f);
                Table in = new Table();
                Image image = new Image(content.uiIcon);
                image.setScaling(Scaling.fit);
                in.add(image).size(48.0f).pad(2.0f);
                table.add(in).padRight(8.0f);
                table.add("@unlocked");
                table.pack();
                Table container = Core.scene.table();
                container.top().add(table);
                container.setTranslation(0.0f, table.getPrefHeight());
                container.actions(Actions.translateBy(0.0f, -table.getPrefHeight(), 1.0f, Interp.fade), Actions.delay(2.5f), Actions.run(() -> container.actions(Actions.translateBy(0.0f, table.getPrefHeight(), 1.0f, Interp.fade), Actions.run(() -> {
                    this.lastUnlockTable = null;
                    this.lastUnlockLayout = null;
                }), Actions.remove())));
                this.lastUnlockTable = container;
                this.lastUnlockLayout = in;
            });
        } else {
            int col = 3;
            int cap = col * col - 1;
            Seq<Element> elements = new Seq<Element>(this.lastUnlockLayout.getChildren());
            int esize = elements.size;
            if (esize > cap) {
                return;
            }
            float size = 48.0f / (float)Math.min(elements.size + 1, col);
            this.lastUnlockLayout.clearChildren();
            this.lastUnlockLayout.defaults().size(size).pad(2.0f);
            for (int i = 0; i < esize; ++i) {
                this.lastUnlockLayout.add(elements.get(i));
                if (i % col != col - 1) continue;
                this.lastUnlockLayout.row();
            }
            if (esize < cap) {
                Image image = new Image(content.uiIcon);
                image.setScaling(Scaling.fit);
                this.lastUnlockLayout.add(image);
            } else {
                this.lastUnlockLayout.image(Icon.add);
            }
            this.lastUnlockLayout.pack();
        }
    }

    private void toggleMenus() {
        if (this.flip != null) {
            this.flip.getStyle().imageUp = this.shown ? Icon.downOpen : Icon.upOpen;
        }
        this.shown = !this.shown;
    }

    private Table makeStatusTable() {
        Table table = new Table(Tex.wavepane);
        StringBuilder ibuild = new StringBuilder();
        IntFormat wavef = new IntFormat("wave");
        IntFormat wavefc = new IntFormat("wave.cap");
        IntFormat enemyf = new IntFormat("wave.enemy");
        IntFormat enemiesf = new IntFormat("wave.enemies");
        IntFormat enemycf = new IntFormat("wave.enemycore");
        IntFormat enemycsf = new IntFormat("wave.enemycores");
        IntFormat waitingf = new IntFormat("wave.waiting", i -> {
            ibuild.setLength(0);
            int m = i / 60;
            int s = i % 60;
            if (m > 0) {
                ibuild.append(m);
                ibuild.append(":");
                if (s < 10) {
                    ibuild.append("0");
                }
            }
            ibuild.append(s);
            return ibuild.toString();
        });
        table.touchable = Touchable.enabled;
        StringBuilder builder = new StringBuilder();
        table.name = "waves";
        table.marginTop(0.0f).marginBottom(4.0f).marginLeft(4.0f);
        table.stack(new Element(){

            @Override
            public void draw() {
                Draw.color(Pal.darkerGray, this.parentAlpha);
                Fill.poly(this.x + this.width / 2.0f, this.y + this.height / 2.0f, 6, this.height / Mathf.sqrt3);
                Draw.reset();
                Drawf.shadow(this.x + this.width / 2.0f, this.y + this.height / 2.0f, this.height * 1.13f, this.parentAlpha);
            }
        }, new Table(t -> {
            float bw = 40.0f;
            float pad = -20.0f;
            t.margin(0.0f);
            t.clicked(() -> {
                if (!Vars.player.dead() && Vars.mobile) {
                    Call.unitClear(Vars.player);
                    Vars.control.input.recentRespawnTimer = 1.0f;
                    Vars.control.input.controlledType = null;
                }
            });
            class SideBar
            extends Element {
                public final Floatp amount;
                public final boolean flip;
                public final Boolp flash;
                float last;
                float blink;
                float value;

                public SideBar(Floatp amount, Boolp flash, boolean flip) {
                    this.amount = amount;
                    this.flip = flip;
                    this.flash = flash;
                    this.setColor(Pal.health);
                }

                @Override
                public void draw() {
                    float next = this.amount.get();
                    if (Float.isNaN(next) || Float.isInfinite(next)) {
                        next = 1.0f;
                    }
                    if (next < this.last && this.flash.get()) {
                        this.blink = 1.0f;
                    }
                    this.blink = Mathf.lerpDelta(this.blink, 0.0f, 0.2f);
                    this.value = Mathf.lerpDelta(this.value, next, 0.15f);
                    this.last = next;
                    if (Float.isNaN(this.value) || Float.isInfinite(this.value)) {
                        this.value = 1.0f;
                    }
                    this.drawInner(Pal.darkishGray, 1.0f);
                    this.drawInner(Tmp.c1.set(this.color).lerp(Color.white, this.blink), this.value);
                }

                void drawInner(Color color, float fract) {
                    if (fract < 0.0f) {
                        return;
                    }
                    fract = Mathf.clamp(fract);
                    if (this.flip) {
                        this.x += this.width;
                        this.width = -this.width;
                    }
                    float stroke = this.width * 0.35f;
                    float bh = this.height / 2.0f;
                    Draw.color(color, this.parentAlpha);
                    float f1 = Math.min(fract * 2.0f, 1.0f);
                    float f2 = (fract - 0.5f) * 2.0f;
                    float bo = -(1.0f - f1) * (this.width - stroke);
                    Fill.quad(this.x, this.y, this.x + stroke, this.y, this.x + this.width + bo, this.y + bh * f1, this.x + this.width - stroke + bo, this.y + bh * f1);
                    if (f2 > 0.0f) {
                        float bx = this.x + (this.width - stroke) * (1.0f - f2);
                        Fill.quad(this.x + this.width, this.y + bh, this.x + this.width - stroke, this.y + bh, bx, this.y + this.height * fract, bx + stroke, this.y + this.height * fract);
                    }
                    Draw.reset();
                    if (this.flip) {
                        this.width = -this.width;
                        this.x -= this.width;
                    }
                }
            }
            t.add(new SideBar(() -> Vars.player.unit().healthf(), () -> true, true)).width(bw).growY().padRight(pad);
            t.image(() -> Vars.player.icon()).scaling(Scaling.bounded).grow().maxWidth(54.0f);
            Boolp playerHasPayloads = () -> {
                Payloadc pay;
                Unit patt42451$temp = Vars.player.unit();
                return patt42451$temp instanceof Payloadc && !(pay = (Payloadc)((Object)patt42451$temp)).payloads().isEmpty();
            };
            Floatp playerPayloadCapacityUsed = () -> {
                float f;
                Unit patt42572$temp = Vars.player.unit();
                if (patt42572$temp instanceof Payloadc) {
                    Payloadc pay = (Payloadc)((Object)patt42572$temp);
                    f = pay.payloadUsed() / Vars.player.unit().type().payloadCapacity;
                } else {
                    f = 0.0f;
                }
                return f;
            };
            t.add(new SideBar(() -> Vars.player.dead() ? 0.0f : (Vars.player.displayAmmo() ? Vars.player.unit().ammof() : (playerHasPayloads.get() ? playerPayloadCapacityUsed.get() : Vars.player.unit().healthf())), () -> !Vars.player.displayAmmo() && !playerHasPayloads.get(), false)).width(bw).growY().padLeft(pad).update(b -> b.color.set(Vars.player.displayAmmo() ? (Vars.player.dead() || Vars.player.unit() instanceof BlockUnitc ? Pal.ammo : Vars.player.unit().type.ammoType.color()) : (playerHasPayloads.get() ? Pal.items : Pal.health)));
            ((Element)t.getChildren().get(1)).toFront();
        })).size(120.0f, 80.0f).padRight(4.0f);
        Cell[] lcell = new Cell[]{null};
        boolean[] couldSkip = new boolean[]{true};
        lcell[0] = table.labelWrap(() -> {
            boolean can = this.canSkipWave();
            if (can != couldSkip[0]) {
                if (this.canSkipWave()) {
                    lcell[0].padRight(8.0f);
                } else {
                    lcell[0].padRight(-42.0f);
                }
                table.invalidateHierarchy();
                table.pack();
                couldSkip[0] = can;
            }
            builder.setLength(0);
            if (Vars.state.rules.mission != null && Vars.state.rules.mission.length() > 0) {
                builder.append(Vars.state.rules.mission);
                return builder;
            }
            if (Vars.state.rules.objectives.any()) {
                boolean first = true;
                for (MapObjectives.MapObjective obj : Vars.state.rules.objectives) {
                    String text;
                    if (!obj.qualified() || obj.hidden || (text = obj.text()) == null || text.isEmpty()) continue;
                    if (!first) {
                        builder.append("\n[white]");
                    }
                    builder.append(text);
                    first = false;
                }
                if (builder.length() > 0) {
                    return builder;
                }
            }
            if (!Vars.state.rules.waves && Vars.state.rules.attackMode) {
                int sum = Math.max(Vars.state.teams.present.sum(t -> t.team != Vars.player.team() ? t.cores.size : 0), 1);
                builder.append(sum > 1 ? enemycsf.get(sum) : enemycf.get(sum));
                return builder;
            }
            if (Vars.state.afterGameOver && Vars.state.isCampaign()) {
                return builder;
            }
            if (!Vars.state.rules.waves && Vars.state.isCampaign()) {
                builder.append("[lightgray]").append(Core.bundle.get("sector.curcapture"));
            }
            if (!Vars.state.rules.waves) {
                return builder;
            }
            if (Vars.state.rules.winWave > 1 && Vars.state.rules.winWave >= Vars.state.wave) {
                builder.append(wavefc.get(Vars.state.wave, Vars.state.rules.winWave));
            } else {
                builder.append(wavef.get(Vars.state.wave));
            }
            builder.append("\n");
            if (Vars.state.enemies > 0) {
                if (Vars.state.enemies == 1) {
                    builder.append(enemyf.get(Vars.state.enemies));
                } else {
                    builder.append(enemiesf.get(Vars.state.enemies));
                }
                builder.append("\n");
            }
            if (Vars.state.rules.waveTimer) {
                builder.append(Vars.logic.isWaitingWave() ? Core.bundle.get("wave.waveInProgress") : waitingf.get((int)(Vars.state.wavetime / 60.0f)));
            } else if (Vars.state.enemies == 0) {
                builder.append(Core.bundle.get("waiting"));
            }
            return builder;
        }).growX().pad(8.0f);
        table.row();
        return table;
    }

    private Table makeStatusTableArc() {
        Table table = new Table(Tex.buttonEdge4);
        table.name = "waves";
        table.marginTop(0.0f).marginBottom(4.0f).marginLeft(4.0f);
        table.table(t -> {
            t.margin(0.0f);
            t.clicked(() -> {
                if (!Vars.player.dead() && Vars.mobile) {
                    Call.unitClear(Vars.player);
                    Vars.control.input.recentRespawnTimer = 1.0f;
                    Vars.control.input.controlledType = null;
                }
            });
            t.image(() -> Vars.player.icon()).size(32.0f);
            t.row();
            t.add(new Bar(() -> {
                if (Vars.player.unit().shield > 0.0f) {
                    return UI.formatAmount((long)Vars.player.unit().health) + "[gray]+[white]" + UI.formatAmount((long)Vars.player.unit().shield);
                }
                return UI.formatAmount((long)Vars.player.unit().health);
            }, () -> Pal.health, () -> Math.min(Vars.player.unit().health / Vars.player.unit().maxHealth, 1.0f))).height(18.0f).growX();
            t.row();
            t.add(new Bar(() -> {
                BlockUnitUnit u;
                Building patt48566$temp;
                Unit patt48517$temp = Vars.player.unit();
                if (patt48517$temp instanceof BlockUnitUnit && (patt48566$temp = (u = (BlockUnitUnit)patt48517$temp).tile().buildOn()) instanceof ItemTurret.ItemTurretBuild) {
                    ItemTurret.ItemTurretBuild it = (ItemTurret.ItemTurretBuild)patt48566$temp;
                    return (float)it.totalAmmo > 0.0f ? ((ItemTurret.ItemEntry)it.ammo.peek()).item.emoji() + it.totalAmmo + "/" + ((ItemTurret)it.block).maxAmmo : "";
                }
                if (Vars.state.rules.unitAmmo) {
                    return Vars.player.unit().type.ammoType.icon() + (int)Vars.player.unit().ammo + "/" + Vars.player.unit().type.ammoCapacity;
                }
                return Vars.player.unit().type.ammoType.icon();
            }, () -> Vars.player.unit().type.ammoType.barColor(), () -> {
                if (Vars.state.rules.unitAmmo || Vars.player.unit() instanceof BlockUnitUnit) {
                    return Vars.player.unit().ammof();
                }
                return 1.0f;
            })).height(18.0f).growX();
            t.row();
        }).size(110.0f, 80.0f).padRight(4.0f);
        this.rebuildArcStatus();
        table.add(this.arcStatus).growX().pad(4.0f);
        if (Core.settings.getBool("powerStatistic")) {
            table.row();
            table.add(PowerInfo.getBars()).growX().colspan(table.getColumns());
        }
        return table;
    }

    private void rebuildArcStatus() {
        this.arcStatus.clear();
        boolean showSkipWave = this.canSkipWave();
        this.arcStatus.clicked(() -> {
            this.hideObjectives = !this.hideObjectives;
            this.rebuildArcStatus();
        });
        if (!this.getStatusText().isEmpty()) {
            this.arcStatus.labelWrap(() -> this.hideObjectives && this.getStatusText().length() > 20 ? this.getStatusText().substring(0, 20) : this.getStatusText()).width(showSkipWave ? 150.0f : 190.0f);
        } else {
            this.arcStatus.table(tt -> {
                tt.update(() -> {
                    if (!this.getStatusText().isEmpty()) {
                        this.rebuildArcStatus();
                    }
                });
                tt.add(new Bar(this::calWaveShower, () -> Color.valueOf("ccffcc"), () -> {
                    if (this.CalWinWave() >= 1 && this.CalWinWave() >= Vars.state.wave) {
                        return (float)Vars.state.wave / (float)this.CalWinWave();
                    }
                    return 1.0f;
                })).height(18.0f).growX().row();
                tt.add(new Bar(() -> RFuncs.arcColorTime(Vars.state.rules.waveTimer ? (int)Vars.state.wavetime : (int)Vars.state.tick), () -> Color.valueOf("F5DEB3"), () -> Vars.state.wavetime / Vars.state.rules.waveSpacing)).height(18.0f).growX().row();
                tt.add(new Bar(() -> {
                    if (Vars.spawner.countSpawns() <= 1 || Vars.state.rules.mode() == Gamemode.pvp) {
                        return "[orange]" + Vars.state.enemies + "[gray](+" + this.calWaveEnemy(Vars.state.wave - 1) + ")";
                    }
                    if (this.calWaveEnemy(Vars.state.wave - 1) > 0) {
                        return "[orange]" + Vars.state.enemies + "[gray](+" + this.calWaveEnemy(Vars.state.wave - 1) + "\u00d7" + Vars.spawner.countSpawns() + ")";
                    }
                    return "[orange]" + Vars.state.enemies + "[gray](+0)";
                }, () -> Color.valueOf("F4A460"), () -> (float)Vars.state.enemies / ((float)this.calWaveEnemy(Vars.state.wave - 2) * (float)Vars.spawner.countSpawns()))).height(18.0f).growX();
            }).width(showSkipWave ? 150.0f : 190.0f);
        }
        this.arcStatus.update(() -> {
            if (showSkipWave != this.canSkipWave()) {
                this.rebuildArcStatus();
            }
        });
        if (this.canSkipWave()) {
            this.arcStatus.button(Icon.play, Styles.clearNonei, 30.0f, () -> {
                if (Vars.net.client() && Vars.player.admin) {
                    Call.adminRequest(Vars.player, Packets.AdminAction.wave, null);
                } else {
                    Vars.logic.skipWave();
                }
            }).growY().fillX().right().width(40.0f);
        }
    }

    public String getStatusText() {
        StringBuilder objBuilder = new StringBuilder();
        if (Vars.state.rules.objectives.any()) {
            boolean first = true;
            for (MapObjectives.MapObjective obj : Vars.state.rules.objectives) {
                String text;
                if (!obj.qualified() || (text = obj.text()) == null) continue;
                if (!first) {
                    objBuilder.append('\n');
                }
                objBuilder.append(text);
                first = false;
            }
        }
        if (objBuilder.length() == 0 && Vars.state.rules.mission != null) {
            objBuilder.append(Vars.state.rules.mission);
        }
        return objBuilder.toString();
    }

    private void addInfoTable(Table table) {
        table.name = "infotable";
        table.left();
        float[] count = new float[]{-1.0f};
        table.table().update(t -> {
            Unit patt53366$temp = Vars.player.unit();
            if (patt53366$temp instanceof Payloadc) {
                Payloadc payload = (Payloadc)((Object)patt53366$temp);
                if (count[0] != payload.payloadUsed()) {
                    t.clear();
                    payload.contentInfo((Table)t, 16.0f, 275.0f);
                    count[0] = payload.payloadUsed();
                }
            } else {
                count[0] = -1.0f;
                t.clear();
            }
        }).growX().visible(() -> {
            Payloadc p;
            boolean result;
            Unit patt53780$temp = Vars.player.unit();
            boolean bl = result = patt53780$temp instanceof Payloadc && (p = (Payloadc)((Object)patt53780$temp)).payloadUsed() > 0.0f;
            if (!result) {
                count[0] = -1.0f;
            }
            return result;
        }).colspan(2);
        table.row();
        Bits statuses = new Bits();
        table.table().update(t -> {
            Bits applied;
            t.left();
            Bits bits = applied = Vars.player.dead() ? null : Vars.player.unit().statusBits();
            if (!statuses.equals(applied)) {
                t.clear();
                if (applied != null) {
                    for (StatusEffect effect : Vars.content.statusEffects()) {
                        if (!applied.get(effect.id) || effect.isHidden()) continue;
                        t.image(effect.uiIcon).size(32.0f).get().addListener(new Tooltip(l -> l.label(() -> Vars.player.dead() ? "" : effect.localizedName + " [lightgray]" + UI.formatTime(Vars.player.unit().getDuration(effect))).style(Styles.outlineLabel)));
                    }
                    statuses.set(applied);
                } else {
                    statuses.clear();
                }
            }
        }).left();
    }

    private boolean canSkipWave() {
        return Core.settings.getBool("overrideSkipWave") || Vars.state.rules.waves && Vars.state.rules.waveSending && (Vars.net.server() || Vars.player.admin || !Vars.net.active()) && Vars.state.enemies == 0 && !Vars.spawner.isSpawning();
    }

    private String calWaveShower() {
        StringBuilder builder = new StringBuilder();
        if (!Vars.state.rules.waves && Vars.state.rules.attackMode) {
            int sum = Math.max(Vars.state.teams.present.sum(t -> t.team != Vars.player.team() ? t.cores.size : 0), 1);
            builder.append("\u654c\u4eba\u6838\u5fc3\uff1a[orange]").append(sum);
            return builder.toString();
        }
        if (!Vars.state.rules.waves && Vars.state.isCampaign()) {
            builder.append("[lightgray]").append(Core.bundle.get("sector.curcapture"));
        }
        if (!Vars.state.rules.waves) {
            return builder.toString();
        }
        if (this.CalWinWave() > 1 && this.CalWinWave() >= Vars.state.wave) {
            builder.append("[orange]").append(Vars.state.wave).append("[white]/[yellow]").append(this.CalWinWave());
        } else {
            builder.append("\u6ce2\u6b21\uff1a[orange]").append(Vars.state.wave);
        }
        return builder.toString();
    }

    private int calWaveEnemy(int wave) {
        int waveEnemy = 0;
        for (SpawnGroup group : Vars.state.rules.spawns) {
            waveEnemy += group.getSpawned(Math.max(0, wave));
        }
        return waveEnemy;
    }

    private int CalWinWave() {
        if (Vars.state.rules.winWave >= 1) {
            return Vars.state.rules.winWave;
        }
        int maxwave = 0;
        for (SpawnGroup group : Vars.state.rules.spawns) {
            maxwave = Math.max(maxwave, group.end);
        }
        if (maxwave > 10000) {
            return 0;
        }
        return maxwave + 1;
    }

    private static /* synthetic */ void lambda$build$121(Table t) {
        t.bottom().left();
        t.table(Styles.black6, c -> {
            Bits used = new Bits(Vars.content.items().size);
            Runnable rebuild = () -> {
                c.clearChildren();
                for (Item item : Vars.content.items()) {
                    if (Vars.state.rules.sector == null || !(Vars.state.rules.sector.info.getExport(item) >= 1.0f)) continue;
                    c.image(item.uiIcon);
                    c.label(() -> (int)Vars.state.rules.sector.info.getExport(item) + " /s").color(Color.lightGray);
                    c.row();
                }
            };
            c.update(() -> {
                boolean wrong = false;
                for (Item item : Vars.content.items()) {
                    boolean has;
                    boolean bl = has = Vars.state.rules.sector != null && Vars.state.rules.sector.info.getExport(item) >= 1.0f;
                    if (used.get(item.id) == has) continue;
                    used.set((int)item.id, has);
                    wrong = true;
                }
                if (wrong) {
                    rebuild.run();
                }
            });
        }).visible(() -> Vars.state.isCampaign() && Vars.content.items().contains((Item)((Object)((Boolf<Item>)i -> Vars.state.rules.sector != null && Vars.state.rules.sector.info.getExport((Item)i) > 0.0f))));
    }

    private static /* synthetic */ void lambda$build$109(Table u) {
        u.color.a = Mathf.lerpDelta(u.color.a, Mathf.num(Vars.spawner.playerNear() && Vars.player.unit().hittable()), 0.1f);
    }

    private static /* synthetic */ void lambda$build$108(Table c) {
        c.add("@nearpoint").update(l -> l.setColor(Tmp.c1.set(Color.white).lerp(Color.scarlet, Mathf.absin(Time.time, 10.0f, 1.0f)))).labelAlign(1, 1);
    }

    private /* synthetic */ void lambda$build$49(2 rightStyle, Table s) {
        s.add(this.makeStatusTable()).grow().name("status");
        s.button(Icon.play, rightStyle, 30.0f, () -> {
            if (Vars.net.client() && Vars.player.admin) {
                Call.adminRequest(Vars.player, Packets.AdminAction.wave, null);
            } else {
                Vars.logic.skipWave();
            }
        }).growY().fillX().right().width(40.0f).disabled(b -> !Core.settings.getBool("overrideSkipWave") && !this.canSkipWave()).name("skip");
        if (Core.settings.getBool("powerStatistic")) {
            s.row();
            s.add(PowerInfo.getBars()).growX().colspan(s.getColumns());
        }
    }

    private /* synthetic */ boolean lambda$build$20() {
        return Vars.netServer.isWaitingForPlayers() && Vars.state.isPaused() && this.shown;
    }

    private /* synthetic */ boolean lambda$build$16() {
        return Vars.state.isPaused() && this.shown && !Vars.netServer.isWaitingForPlayers();
    }
}

