/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.func.Boolp;
import arc.input.KeyCode;
import arc.math.Interp;
import arc.scene.Action;
import arc.scene.Group;
import arc.scene.actions.Actions;
import arc.scene.event.Touchable;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.scene.ui.layout.WidgetGroup;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.ai.types.CommandAI;
import mindustry.content.Blocks;
import mindustry.content.Items;
import mindustry.content.Planets;
import mindustry.content.SectorPresets;
import mindustry.core.UI;
import mindustry.entities.units.UnitController;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Payloadc;
import mindustry.gen.Unit;
import mindustry.input.Binding;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.payloads.PayloadBlock;
import mindustry.world.meta.BlockFlag;

public class HintsFragment {
    private static final Boolp isTutorial = () -> Vars.state.rules.sector == SectorPresets.groundZero.sector;
    private static final float foutTime = 0.6f;
    public Seq<Hint> hints = new Seq<DefaultHint>().add(DefaultHint.values()).as();
    @Nullable
    Hint current;
    Group group = new WidgetGroup();
    ObjectSet<String> events = new ObjectSet();
    ObjectSet<Block> placedBlocks = new ObjectSet();
    Table last;

    public void build(Group parent) {
        this.group.setFillParent(true);
        this.group.touchable = Touchable.childrenOnly;
        this.group.visibility = () -> Core.settings.getBool("hints", true) && Vars.ui.hudfrag.shown;
        this.group.update(() -> {
            if (this.current != null) {
                if (this.current.complete()) {
                    this.complete();
                } else if (!this.current.show()) {
                    this.hide();
                }
            } else if (this.hints.size > 0) {
                Hint hint = this.hints.find(Hint::show);
                if (hint != null && hint.complete()) {
                    this.hints.remove(hint);
                } else if (hint != null && !Vars.renderer.isCutscene() && Vars.state.isGame() && Vars.control.saves.getTotalPlaytime() > 8000L) {
                    this.display(hint);
                } else {
                    Building build = Vars.world.buildWorld(Core.input.mouseWorldX(), Core.input.mouseWorldY());
                    if (build != null && build.team == Team.derelict) {
                        this.events.add("derelictmouse");
                    }
                }
            }
        });
        parent.addChild(this.group);
        this.checkNext();
        Events.on(EventType.BlockBuildEndEvent.class, event -> {
            if (!event.breaking && event.unit == Vars.player.unit()) {
                this.placedBlocks.add(event.tile.block());
            }
            if (event.breaking) {
                this.events.add("break");
            }
        });
        Events.run((Object)EventType.Trigger.cannotUpgrade, () -> this.events.add("cannotupgrade"));
        Events.on(EventType.ResetEvent.class, e -> {
            this.placedBlocks.clear();
            this.events.clear();
        });
        Events.on(EventType.BuildingCommandEvent.class, e -> {
            if (e.building instanceof PayloadBlock.PayloadBlockBuild) {
                this.events.add("factorycontrol");
            }
        });
        Events.on(EventType.BlockBuildBeginEvent.class, e -> {
            Building patt3294$temp;
            if (e.unit == Vars.player.unit() && (patt3294$temp = e.tile.build) instanceof ConstructBlock.ConstructBuild) {
                ConstructBlock.ConstructBuild c = (ConstructBlock.ConstructBuild)patt3294$temp;
                if (c.prevBuild != null && c.prevBuild.contains((Building)((Object)((Boolf<Building>)b -> b.team == Team.derelict)))) {
                    this.events.add("derelictbreak");
                }
            }
        });
    }

    void checkNext() {
        if (this.current != null) {
            return;
        }
        this.hints.removeAll(h -> !h.valid() || h.finished() || h.show() && h.complete());
        this.hints.sort(Hint::order);
        Hint first = this.hints.find(Hint::show);
        if (first != null && !Vars.renderer.isCutscene() && Vars.state.isGame()) {
            this.hints.remove(first);
            this.display(first);
        }
    }

    void display(Hint hint) {
        if (this.current != null) {
            return;
        }
        this.group.fill(t -> {
            this.last = t;
            t.left();
            t.table(Styles.black5, cont -> {
                cont.actions(Actions.alpha(0.0f), Actions.alpha(1.0f, 1.0f, Interp.smooth));
                cont.margin(6.0f).add(hint.text()).width(Vars.mobile ? 270.0f : 400.0f).left().labelAlign(8).wrap();
            });
            t.row();
            t.button("@hint.skip", Styles.nonet, () -> {
                if (this.current != null) {
                    this.complete();
                }
            }).size(112.0f, 40.0f).left();
        });
        this.current = hint;
    }

    void complete() {
        if (this.current == null) {
            return;
        }
        this.current.finish();
        this.hints.remove(this.current);
        this.hide();
    }

    void hide() {
        if (this.last != null) {
            this.last.actions(Actions.parallel((Action)Actions.alpha(0.0f, 0.6f, Interp.smooth), (Action)Actions.translateBy(0.0f, Scl.scl(-200.0f), 0.6f, Interp.smooth)), Actions.remove());
        }
        this.current = null;
        this.last = null;
        this.checkNext();
    }

    public boolean shown() {
        return this.current != null;
    }

    static boolean isSerpulo() {
        return !Vars.state.rules.hasEnv(16);
    }

    public static enum DefaultHint implements Hint
    {
        desktopMove(1, () -> Core.input.axis(Binding.moveX) != 0.0f || Core.input.axis(Binding.moveY) != 0.0f),
        zoom(1, () -> Core.input.axis(KeyCode.scroll) != 0.0f),
        breaking(() -> isTutorial.get() && Vars.state.rules.defaultTeam.data().getCount(Blocks.conveyor) > 5, () -> Vars.ui.hints.events.contains("break")),
        desktopShoot(1, () -> HintsFragment.isSerpulo() && Vars.state.enemies > 0, () -> Vars.player.shooting),
        depositItems(() -> Vars.player.unit().hasItem(), () -> !Vars.player.unit().hasItem()),
        desktopPause(1, () -> isTutorial.get() && !Vars.net.active() && Vars.state.wave >= 2, () -> Core.input.keyTap(Binding.pause)),
        unitControl(() -> HintsFragment.isSerpulo() && Vars.state.rules.defaultTeam.data().units.size > 2 && !Vars.net.active() && !Vars.player.dead(), () -> !Vars.player.dead() && !Vars.player.unit().spawnedByCore),
        unitSelectControl(() -> HintsFragment.isSerpulo() && Vars.state.rules.defaultTeam.data().units.size > 3 && !Vars.net.active() && !Vars.player.dead(), () -> {
            if (!Vars.control.input.commandMode) return false;
            if (Vars.control.input.selectedUnits.size <= 0) return false;
            UnitController patt6469$temp = Vars.control.input.selectedUnits.first().controller();
            if (!(patt6469$temp instanceof CommandAI)) return false;
            CommandAI ai = (CommandAI)patt6469$temp;
            if (ai.targetPos == null) return false;
            return true;
        }),
        respawn(2, () -> !Vars.player.dead() && !Vars.player.unit().spawnedByCore, () -> !Vars.player.dead() && Vars.player.unit().spawnedByCore),
        launch(() -> (isTutorial.get() || Vars.state.rules.sector == SectorPresets.onset.sector) && Vars.state.rules.sector.isCaptured(), () -> Vars.ui.planet.isShown()),
        schematicSelect(1, () -> Vars.ui.hints.placedBlocks.contains(Blocks.router) || Vars.ui.hints.placedBlocks.contains(Blocks.ductRouter), () -> Core.input.keyRelease(Binding.schematicSelect) || Core.input.keyTap(Binding.pick)),
        conveyorPathfind(() -> Vars.control.input.block == Blocks.titaniumConveyor, () -> Core.input.keyRelease(Binding.diagonalPlacement) || Vars.mobile && Core.settings.getBool("swapdiagonal")),
        boost(1, () -> !Vars.player.dead() && Vars.player.unit().type.canBoost, () -> Core.input.keyDown(Binding.boost)),
        blockInfo(() -> Vars.control.input.block == Blocks.graphitePress, () -> Vars.ui.content.isShown()),
        derelict(() -> Vars.ui.hints.events.contains("derelictmouse") && !isTutorial.get(), () -> Vars.ui.hints.events.contains("derelictbreak")),
        payloadPickup(() -> {
            Payloadc p;
            Unit patt7684$temp;
            return HintsFragment.isSerpulo() && !Vars.player.unit().dead && (patt7684$temp = Vars.player.unit()) instanceof Payloadc && (p = (Payloadc)((Object)patt7684$temp)).payloads().isEmpty();
        }, () -> {
            Payloadc p;
            Unit patt7753$temp = Vars.player.unit();
            return patt7753$temp instanceof Payloadc && (p = (Payloadc)((Object)patt7753$temp)).payloads().any();
        }),
        payloadDrop(() -> {
            Payloadc p;
            Unit patt7862$temp;
            return !Vars.player.unit().dead && (patt7862$temp = Vars.player.unit()) instanceof Payloadc && (p = (Payloadc)((Object)patt7862$temp)).payloads().any();
        }, () -> {
            Payloadc p;
            Unit patt7927$temp = Vars.player.unit();
            return patt7927$temp instanceof Payloadc && (p = (Payloadc)((Object)patt7927$temp)).payloads().isEmpty();
        }),
        waveFire(() -> Groups.fire.size() > 0 && Blocks.wave.unlockedNow(), () -> Vars.indexer.getFlagged((Team)Vars.state.rules.defaultTeam, (BlockFlag)BlockFlag.extinguisher).size > 0),
        generator(() -> Vars.control.input.block == Blocks.combustionGenerator, () -> Vars.ui.hints.placedBlocks.contains(Blocks.combustionGenerator)),
        rebuildSelect(() -> Vars.state.rules.defaultTeam.data().plans.size >= 10, () -> Vars.control.input.isRebuildSelecting()),
        guardian(() -> Vars.state.boss() != null && HintsFragment.isSerpulo() && Vars.state.boss().armor >= 4.0f, () -> Vars.state.boss() == null),
        cannotUpgrade(() -> Vars.ui.hints.events.contains("cannotupgrade"), () -> false),
        factoryControl(() -> (!Vars.state.isCampaign() || Vars.state.rules.sector.preset != SectorPresets.onset) && Vars.state.rules.defaultTeam.data().getBuildings((Block)Blocks.tankFabricator).size + Vars.state.rules.defaultTeam.data().getBuildings((Block)Blocks.groundFactory).size > 0, () -> Vars.ui.hints.events.contains("factorycontrol")),
        coreUpgrade(() -> Vars.state.isCampaign() && Vars.state.rules.sector.planet == Planets.serpulo && Blocks.coreFoundation.unlocked() && Vars.state.rules.defaultTeam.core() != null && Vars.state.rules.defaultTeam.core().block == Blocks.coreShard && Vars.state.rules.defaultTeam.core().items.has(Blocks.coreFoundation.requirements), () -> Vars.ui.hints.placedBlocks.contains(Blocks.coreFoundation)),
        presetLaunch(() -> Vars.state.isCampaign() && Vars.state.getSector().preset == null, () -> Vars.state.isCampaign() && Vars.state.getSector().preset == SectorPresets.frozenForest),
        presetDifficulty(() -> Vars.state.isCampaign() && Vars.state.getSector().preset == null && Vars.state.getSector().threat >= 0.5f && !SectorPresets.tarFields.sector.isCaptured(), () -> Vars.state.isCampaign() && Vars.state.getSector().preset != null),
        coreIncinerate(() -> Vars.state.isCampaign() && Vars.state.rules.defaultTeam.core() != null && Vars.state.rules.defaultTeam.core().items.get(Items.copper) >= Vars.state.rules.defaultTeam.core().storageCapacity - 10, () -> false);

        @Nullable
        String text;
        int visibility = 3;
        Hint[] dependencies = new Hint[0];
        boolean finished;
        boolean cached;
        Boolp complete;
        Boolp shown = () -> true;

        private DefaultHint(Boolp complete) {
            this.complete = complete;
        }

        private DefaultHint(int visiblity, Boolp complete) {
            this(complete);
            this.visibility = visiblity;
        }

        private DefaultHint(Boolp shown, Boolp complete) {
            this(complete);
            this.shown = shown;
        }

        private DefaultHint(int visiblity, Boolp shown, Boolp complete) {
            this(complete);
            this.shown = shown;
            this.visibility = visiblity;
        }

        @Override
        public boolean finished() {
            if (!this.cached) {
                this.cached = true;
                this.finished = Core.settings.getBool(this.name() + "-hint-done", false);
            }
            return this.finished;
        }

        @Override
        public void finish() {
            this.finished = true;
            Core.settings.put(this.name() + "-hint-done", true);
        }

        @Override
        public String text() {
            if (this.text == null) {
                String string = this.text = Vars.mobile && Core.bundle.has("hint." + this.name() + ".mobile") ? Core.bundle.get("hint." + this.name() + ".mobile") : Core.bundle.get("hint." + this.name());
                if (!Vars.mobile) {
                    this.text = this.text.replace("tap", "click").replace("Tap", "Click");
                }
            }
            return UI.formatIcons(this.text);
        }

        @Override
        public boolean complete() {
            return this.complete.get();
        }

        @Override
        public boolean show() {
            return this.shown.get() && (this.dependencies.length == 0 || !Structs.contains(this.dependencies, d -> !d.finished()));
        }

        @Override
        public int order() {
            return this.ordinal();
        }

        @Override
        public boolean valid() {
            return Vars.mobile && (this.visibility & 2) != 0 || !Vars.mobile && (this.visibility & 1) != 0;
        }
    }

    public static interface Hint {
        public static final int visibleDesktop = 1;
        public static final int visibleMobile = 2;
        public static final int visibleAll = 3;

        public String name();

        public String text();

        public boolean complete();

        public boolean show();

        public int order();

        public boolean valid();

        default public void finish() {
            Core.settings.put(this.name() + "-hint-done", true);
        }

        default public boolean finished() {
            return Core.settings.getBool(this.name() + "-hint-done", false);
        }
    }
}

