/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.Events;
import arc.Graphics;
import arc.files.Fi;
import arc.files.ZipFi;
import arc.func.Boolc;
import arc.func.Cons;
import arc.graphics.Texture;
import arc.input.KeyCode;
import arc.scene.Element;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.CheckBox;
import arc.scene.ui.Image;
import arc.scene.ui.Label;
import arc.scene.ui.Slider;
import arc.scene.ui.TextArea;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.scene.utils.Elem;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.OS;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.io.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.RFuncs;
import mindustry.arcModule.ui.AdvanceToolTable;
import mindustry.content.TechTree;
import mindustry.core.GameState;
import mindustry.core.Version;
import mindustry.ctype.UnlockableContent;
import mindustry.game.EventType;
import mindustry.game.Saves;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Shaders;
import mindustry.input.DesktopInput;
import mindustry.input.MobileInput;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.JoinDialog;

public class SettingsMenuDialog
extends BaseDialog {
    public SettingsTable graphics;
    public SettingsTable game;
    public SettingsTable sound;
    public SettingsTable arc;
    public SettingsTable forcehide;
    public SettingsTable specmode;
    public SettingsTable cheating;
    public SettingsTable main;
    private Table prefs;
    private Table menu;
    private BaseDialog dataDialog;
    private Seq<SettingsCategory> categories = new Seq();

    public SettingsMenuDialog() {
        super(Core.bundle.get("settings", "Settings"));
        this.addCloseButton();
        this.main = new SettingsTable();
        this.cont.add(this.main);
        this.shouldPause = true;
        this.shown(() -> {
            this.back();
            this.rebuildMenu();
        });
        this.onResize(() -> {
            this.graphics.rebuild();
            this.sound.rebuild();
            this.game.rebuild();
            this.updateScrollFocus();
        });
        this.cont.clearChildren();
        this.cont.remove();
        this.buttons.remove();
        this.menu = new Table(Tex.button);
        this.game = new SettingsTable();
        this.graphics = new SettingsTable();
        this.sound = new SettingsTable();
        this.arc = new SettingsTable();
        this.forcehide = new SettingsTable();
        this.specmode = new SettingsTable();
        this.cheating = new SettingsTable();
        this.prefs = new Table();
        this.prefs.top();
        this.prefs.margin(14.0f);
        this.rebuildMenu();
        this.prefs.clearChildren();
        this.prefs.add(this.menu);
        this.dataDialog = new BaseDialog("@settings.data");
        this.dataDialog.addCloseButton();
        this.dataDialog.cont.table(Tex.button, t -> {
            t.defaults().size(280.0f, 60.0f).left();
            TextButton.TextButtonStyle style = Styles.flatt;
            t.button("@settings.cleardata", (Drawable)Icon.trash, style, () -> Vars.ui.showConfirm("@confirm", "@settings.clearall.confirm", () -> {
                ObjectMap<String, Object> map = new ObjectMap<String, Object>();
                for (String value : Core.settings.keys()) {
                    if (!value.contains("usid") && !value.contains("uuid")) continue;
                    map.put(value, Core.settings.get(value, null));
                }
                Core.settings.clear();
                Core.settings.putAll(map);
                for (Fi file : Vars.dataDirectory.list()) {
                    file.deleteDirectory();
                }
                Core.app.exit();
            })).marginLeft(4.0f);
            t.row();
            t.button("@settings.clearsaves", (Drawable)Icon.trash, style, () -> Vars.ui.showConfirm("@confirm", "@settings.clearsaves.confirm", () -> Vars.control.saves.deleteAll())).marginLeft(4.0f);
            t.row();
            t.button("@settings.clearresearch", (Drawable)Icon.trash, style, () -> Vars.ui.showConfirm("@confirm", "@settings.clearresearch.confirm", () -> {
                Vars.universe.clearLoadoutInfo();
                for (TechTree.TechNode node : TechTree.all) {
                    node.reset();
                }
                Vars.content.each(c -> {
                    if (c instanceof UnlockableContent) {
                        UnlockableContent u = (UnlockableContent)c;
                        u.clearUnlock();
                    }
                });
                Core.settings.remove("unlocks");
            })).marginLeft(4.0f);
            t.row();
            t.button("@settings.clearcampaignsaves", (Drawable)Icon.trash, style, () -> Vars.ui.showConfirm("@confirm", "@settings.clearcampaignsaves.confirm", () -> {
                for (Planet planet : Vars.content.planets()) {
                    for (Sector sec : planet.sectors) {
                        sec.clearInfo();
                        if (sec.save == null) continue;
                        sec.save.delete();
                        sec.save = null;
                    }
                }
                for (Saves.SaveSlot slot : Vars.control.saves.getSaveSlots().copy()) {
                    if (!slot.isSector()) continue;
                    slot.delete();
                }
            })).marginLeft(4.0f);
            t.row();
            t.button("@data.export", (Drawable)Icon.upload, style, () -> {
                if (Vars.ios) {
                    Fi file2 = Core.files.local("mindustry-data-export.zip");
                    try {
                        this.exportData(file2);
                    }
                    catch (Exception e) {
                        Vars.ui.showException(e);
                    }
                    Vars.platform.shareFile(file2);
                } else {
                    Vars.platform.showFileChooser(false, "zip", file -> {
                        try {
                            this.exportData((Fi)file);
                            Vars.ui.showInfo("@data.exported");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Vars.ui.showException(e);
                        }
                    });
                }
            }).marginLeft(4.0f);
            t.row();
            t.button("@data.import", (Drawable)Icon.download, style, () -> Vars.ui.showConfirm("@confirm", "@data.import.confirm", () -> Vars.platform.showFileChooser(true, "zip", file -> {
                try {
                    this.importData((Fi)file);
                    Vars.control.saves.resetSave();
                    Vars.state = new GameState();
                    Core.app.exit();
                }
                catch (IllegalArgumentException e) {
                    Vars.ui.showErrorMessage("@data.invalid");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (e.getMessage() == null || !e.getMessage().contains("too short")) {
                        Vars.ui.showException(e);
                    }
                    Vars.ui.showErrorMessage("@data.invalid");
                }
            }))).marginLeft(4.0f);
            if (!Vars.mobile) {
                t.row();
                t.button("@data.openfolder", (Drawable)Icon.folder, style, () -> Core.app.openFolder(Core.settings.getDataDirectory().absolutePath())).marginLeft(4.0f);
            }
            t.row();
            t.button("@crash.export", (Drawable)Icon.upload, style, () -> {
                if (Core.settings.getDataDirectory().child("crashes").list().length == 0 && !Core.settings.getDataDirectory().child("last_log.txt").exists()) {
                    Vars.ui.showInfo("@crash.none");
                } else if (Vars.ios) {
                    Fi logs = Vars.tmpDirectory.child("logs.txt");
                    logs.writeString(this.getLogs());
                    Vars.platform.shareFile(logs);
                } else {
                    Vars.platform.showFileChooser(false, "txt", file -> {
                        try {
                            file.writeBytes(this.getLogs().getBytes(Strings.utf8));
                            Core.app.post(() -> Vars.ui.showInfo("@crash.exported"));
                        }
                        catch (Throwable e) {
                            Vars.ui.showException(e);
                        }
                    });
                }
            }).marginLeft(4.0f);
        });
        this.row();
        this.pane(this.prefs).grow().top();
        this.row();
        this.add(this.buttons).fillX();
        this.addSettings();
    }

    String getLogs() {
        Fi log = Core.settings.getDataDirectory().child("last_log.txt");
        StringBuilder out = new StringBuilder();
        for (Fi fi : Core.settings.getDataDirectory().child("crashes").list()) {
            out.append(fi.name()).append("\n\n").append(fi.readString()).append("\n");
        }
        if (log.exists()) {
            out.append("\nlast log:\n").append(log.readString());
        }
        return out.toString();
    }

    public void addCategory(String name, @Nullable String region, Cons<SettingsTable> builder) {
        this.categories.add(new SettingsCategory(name, region == null ? null : new TextureRegionDrawable(Core.atlas.find(region)), builder));
    }

    public void addCategory(String name, @Nullable Drawable icon, Cons<SettingsTable> builder) {
        this.categories.add(new SettingsCategory(name, icon, builder));
    }

    public void addCategory(String name, Cons<SettingsTable> builder) {
        this.addCategory(name, (Drawable)null, builder);
    }

    public Seq<SettingsCategory> getCategories() {
        return this.categories;
    }

    void rebuildMenu() {
        block9: {
            TextButton.TextButtonStyle style;
            block6: {
                float isize;
                float marg;
                block8: {
                    block7: {
                        this.menu.clearChildren();
                        style = Styles.flatt;
                        marg = 8.0f;
                        isize = 32.0f;
                        this.menu.defaults().size(300.0f, 60.0f);
                        if (Core.settings.getInt("changelogreaded") != ARCVars.changeLogRead) break block6;
                        this.menu.button("@settings.game", Icon.settings, style, isize, () -> this.visible(0)).marginLeft(marg).row();
                        this.menu.row();
                        this.menu.button("@settings.graphics", Icon.image, style, isize, () -> this.visible(1)).marginLeft(marg).row();
                        this.menu.row();
                        this.menu.button("@settings.sound", Icon.filters, style, isize, () -> this.visible(2)).marginLeft(marg).row();
                        this.menu.row();
                        this.menu.button("@settings.arc", Icon.star, style, isize, () -> this.visible(3)).marginLeft(marg).row();
                        this.menu.row();
                        this.menu.button("@settings.forcehide", Icon.eyeSmall, style, isize, () -> this.visible(4)).marginLeft(marg).row();
                        this.menu.row();
                        this.menu.button("@settings.specmode", Icon.info, style, isize, () -> this.visible(5)).marginLeft(marg).row();
                        this.menu.row();
                        this.menu.button("@settings.cheating", Icon.lock, style, isize, () -> this.visible(6)).marginLeft(marg).row();
                        this.menu.row();
                        this.menu.button("@settings.language", Icon.chat, style, isize, Vars.ui.language::show).marginLeft(marg).row();
                        if (!Vars.mobile) break block7;
                        if (!Core.settings.getBool("keyboard")) break block8;
                    }
                    this.menu.button("@settings.controls", Icon.move, style, isize, Vars.ui.controls::show).marginLeft(marg).row();
                }
                this.menu.button("@settings.data", Icon.save, style, isize, () -> this.dataDialog.show()).marginLeft(marg).row();
                int i = Core.settings.getInt("changelogreaded") == ARCVars.changeLogRead ? 7 : 1;
                for (SettingsCategory cat : this.categories) {
                    int index = i;
                    if (cat.icon == null) {
                        this.menu.button(cat.name, style, () -> this.visible(index)).marginLeft(marg).row();
                    } else {
                        this.menu.button(cat.name, cat.icon, style, isize, () -> this.visible(index)).with(b -> ((Image)b.getChildren().get(1)).setScaling(Scaling.fit)).marginLeft(marg).row();
                    }
                    ++i;
                }
                break block9;
            }
            this.menu.button("@settings.arc", style, () -> this.visible(0));
            this.menu.row();
            this.menu.button("@settings.language", style, Vars.ui.language::show);
        }
    }

    void addSettings() {
        if (Core.settings.getInt("changelogreaded") != ARCVars.changeLogRead) {
            this.arc.sliderPref("changelogreaded", 0, 0, 150, 1, i -> i + "");
            this.arc.checkPref("changelogexplain", false);
        } else {
            this.sound.checkPref("alwaysmusic", false);
            this.sound.sliderPref("musicvol", 100, 0, 100, 1, i -> i + "%");
            this.sound.sliderPref("sfxvol", 100, 0, 100, 1, i -> i + "%");
            this.sound.sliderPref("ambientvol", 100, 0, 100, 1, i -> i + "%");
            this.sound.sliderPref("arcvol", Core.settings.getInt("musicvol"), 0, 100, 1, i -> i + "%");
            this.game.addCategory("arcCNet");
            this.game.stringInput("arcNetProxy", "");
            this.game.addCategory("arcCSave");
            this.game.checkPref("savecreate", true);
            this.game.checkPref("save_more_map", false);
            this.game.sliderPref("saveinterval", 60, 10, 600, 10, i -> Core.bundle.format("setting.seconds", i));
            this.game.addCategory("arcCAssist");
            this.game.checkPref("autotarget", true);
            this.game.checkPref("keyboard", false, val -> {
                Vars.control.setInput(val ? new DesktopInput() : new MobileInput());
                Core.input.setUseKeyboard(val);
            });
            if (Core.settings.getBool("keyboard")) {
                Vars.control.setInput(new DesktopInput());
                Core.input.setUseKeyboard(true);
            }
        }
        if (!Vars.mobile) {
            this.game.checkPref("crashreport", true);
        }
        this.game.checkPref("communityservers", true, val -> {
            Vars.defaultServers.clear();
            if (val) {
                JoinDialog.fetchServers();
            }
        });
        this.game.sliderPref("maxSchematicSize", 32, 32, 256, 1, v -> v == 256 ? "\u65e0\u9650" : String.valueOf(v));
        this.game.checkPref("savecreate", true);
        this.game.checkPref("blockreplace", true);
        this.game.checkPref("conveyorpathfinding", true);
        this.game.checkPref("shiftCopyIcon", true);
        this.game.checkPref("hints", true);
        this.game.checkPref("logichints", true);
        this.game.checkPref("backgroundpause", true);
        this.game.checkPref("buildautopause", false);
        this.game.checkPref("distinctcontrolgroups", true);
        this.game.checkPref("doubletapmine", false);
        this.game.checkPref("commandmodehold", true);
        if (!Vars.ios) {
            this.game.checkPref("modcrashdisable", true);
        }
        if (Vars.steam) {
            this.game.sliderPref("playerlimit", 16, 2, 32, i -> {
                Vars.platform.updateLobby();
                return i + "";
            });
            if (!Version.modifier.contains("beta")) {
                this.game.checkPref("steampublichost", false, i -> Vars.platform.updateLobby());
            }
        }
        this.game.addCategory("arcCHint");
        this.game.checkPref("hints", true);
        this.game.checkPref("logichints", true);
        this.game.checkPref("console", false);
        this.graphics.addCategory("arcCOverview");
        this.graphics.sliderPref("fpscap", 240, 10, 245, 5, s -> s > 240 ? Core.bundle.get("setting.fpscap.none") : Core.bundle.format("setting.fpscap.text", s));
        int[] lastUiScale = new int[]{Core.settings.getInt("uiscale", 100)};
        this.graphics.sliderPref("uiscale", 100, 25, 300, 5, s -> {
            Core.settings.put("uiscalechanged", s != lastUiScale[0]);
            return s + "%";
        });
        this.graphics.sliderPref("chatopacity", 100, 0, 100, 5, s -> s + "%");
        this.graphics.sliderPref("screenshake", 4, 0, 8, i -> (float)i / 4.0f + "x");
        this.graphics.sliderPref("bloomintensity", 6, 0, 16, i -> (int)((float)i / 4.0f * 100.0f) + "%");
        this.graphics.sliderPref("bloomblur", 2, 1, 16, i -> i + "x");
        this.graphics.sliderPref("fpscap", 240, 10, 245, 5, s -> s > 240 ? Core.bundle.get("setting.fpscap.none") : Core.bundle.format("setting.fpscap.text", s));
        this.graphics.sliderPref("chatopacity", 100, 0, 100, 5, s -> s + "%");
        this.graphics.sliderPref("lasersopacity", 100, 0, 100, 5, s -> {
            if (Vars.ui.settings != null) {
                Core.settings.put("preferredlaseropacity", s);
            }
            return s + "%";
        });
        this.graphics.sliderPref("unitlaseropacity", 100, 0, 100, 5, s -> s + "%");
        this.graphics.sliderPref("bridgeopacity", 100, 0, 100, 5, s -> s + "%");
        this.graphics.sliderPref("maxmagnificationmultiplierpercent", 100, 100, 200, 25, s -> {
            if (Vars.ui.settings != null) {
                Core.settings.put("maxzoomingamemultiplier", Float.valueOf((float)s / 100.0f));
            }
            return s + "%";
        });
        this.graphics.sliderPref("minmagnificationmultiplierpercent", 100, 100, 300, 25, s -> {
            if (Vars.ui.settings != null) {
                Core.settings.put("minzoomingamemultiplier", Float.valueOf((float)s / 100.0f));
            }
            return s + "%";
        });
        if (!Vars.mobile) {
            this.graphics.checkPref("vsync", true, b -> Core.graphics.setVSync(b));
            this.graphics.checkPref("fullscreen", false, b -> {
                if (b && Core.settings.getBool("borderlesswindow")) {
                    Core.graphics.setWindowedMode(Core.graphics.getWidth(), Core.graphics.getHeight());
                    Core.settings.put("borderlesswindow", false);
                    this.graphics.rebuild();
                }
                if (b) {
                    Core.graphics.setFullscreen();
                } else {
                    Core.graphics.setWindowedMode(Core.graphics.getWidth(), Core.graphics.getHeight());
                }
            });
            this.graphics.checkPref("borderlesswindow", false, b -> {
                if (b && Core.settings.getBool("fullscreen")) {
                    Core.graphics.setWindowedMode(Core.graphics.getWidth(), Core.graphics.getHeight());
                    Core.settings.put("fullscreen", false);
                    this.graphics.rebuild();
                }
                Core.graphics.setBorderless(b);
            });
            Core.graphics.setVSync(Core.settings.getBool("vsync"));
            if (Core.settings.getBool("fullscreen")) {
                Core.app.post(() -> Core.graphics.setFullscreen());
            }
            if (Core.settings.getBool("borderlesswindow")) {
                Core.app.post(() -> Core.graphics.setBorderless(true));
            }
        } else if (!Vars.ios) {
            this.graphics.checkPref("landscape", false, b -> {
                if (b) {
                    Vars.platform.beginForceLandscape();
                } else {
                    Vars.platform.endForceLandscape();
                }
            });
            if (Core.settings.getBool("landscape")) {
                Vars.platform.beginForceLandscape();
            }
        }
        this.graphics.addCategory("arcCgamewindow");
        this.graphics.checkPref("fps", false);
        this.graphics.checkPref("override_boss_shown", false);
        this.graphics.checkPref("displayselection", true);
        this.graphics.checkPref("effects", true);
        this.graphics.checkPref("atmosphere", !Vars.mobile);
        this.graphics.checkPref("drawlight", true);
        this.graphics.checkPref("destroyedblocks", true);
        this.graphics.checkPref("blockstatus", false);
        this.graphics.checkPref("playerchat", true);
        if (!Vars.mobile) {
            this.graphics.checkPref("coreitems", true);
        }
        this.graphics.checkPref("minimap", !Vars.mobile);
        this.graphics.sliderPref("minimapSize", 140, 40, 400, 10, i -> i + "");
        this.graphics.checkPref("minimapTools", !Vars.mobile);
        if (!Vars.mobile) {
            this.graphics.checkPref("detach-camera", false);
        }
        this.graphics.checkPref("position", false);
        this.graphics.checkPref("mouseposition", false);
        this.graphics.sliderPref("chatopacity", 100, 0, 100, 5, i -> i > 0 ? i + "%" : "\u5173\u95ed");
        this.graphics.addCategory("arcCgameview");
        this.graphics.checkPref("blockstatus", false);
        this.graphics.checkPref("playerchat", true);
        this.graphics.checkPref("alwaysshowdropzone", false);
        this.graphics.checkPref("showFlyerSpawn", false);
        this.graphics.checkPref("showFlyerSpawnLine", false);
        this.graphics.sliderPref("lasersopacity", 100, 0, 100, 5, s -> {
            if (Vars.ui.settings != null) {
                Core.settings.put("preferredlaseropacity", s);
            }
            return s + "%";
        });
        this.graphics.sliderPref("bridgeopacity", 100, 0, 100, 5, i -> i > 0 ? i + "%" : "\u5173\u95ed");
        this.graphics.sliderPref("HiddleItemTransparency", 0, 0, 100, 2, i -> i > 0 ? i + "%" : "\u5173\u95ed");
        this.graphics.checkPref("playerindicators", true);
        this.graphics.checkPref("indicators", true);
        this.graphics.addCategory("arcCGraphicsOther");
        this.graphics.checkPref("smoothcamera", true);
        this.graphics.sliderPref("screenshake", 4, 0, 8, i -> (float)i / 4.0f + "x");
        this.graphics.checkPref("skipcoreanimation", false);
        if (!Vars.mobile) {
            Core.settings.put("swapdiagonal", false);
        }
        this.arc.addCategory("arcHudToolbox");
        this.arc.sliderPref("AuxiliaryTable", 0, 0, 3, 1, s -> {
            if (s == 0) {
                return "\u5173\u95ed";
            }
            if (s == 1) {
                return "\u5de6\u4e0a-\u53f3";
            }
            if (s == 2) {
                return "\u5de6\u4e0a-\u4e0b";
            }
            if (s == 3) {
                return "\u53f3\u4e0a-\u4e0b";
            }
            return "";
        });
        this.arc.checkPref("showAdvanceToolTable", false);
        this.arc.checkPref("arcSpecificTable", true);
        this.arc.checkPref("logicSupport", true);
        this.arc.checkPref("powerStatistic", true);
        this.arc.sliderPref("arccoreitems", 3, 0, 3, 1, s -> {
            if (s == 0) {
                return "\u4e0d\u663e\u793a";
            }
            if (s == 1) {
                return "\u8d44\u6e90\u72b6\u6001";
            }
            if (s == 2) {
                return "\u5175\u79cd\u72b6\u6001";
            }
            return "\u663e\u793a\u8d44\u6e90\u548c\u5175\u79cd";
        });
        this.arc.sliderPref("statisticsInterval", 0, 0, 120, 10, s -> {
            if (s == 0) {
                return "\u4e0d\u7edf\u8ba1";
            }
            return "\u6bcf " + s + " s";
        });
        this.arc.sliderPref("arcCoreItemsCol", 5, 4, 15, 1, i -> i + "\u5217");
        this.arc.checkPref("showQuickToolTable", Core.settings.getBool("showFloatingSettings"));
        this.arc.sliderPref("quickHudSize", 0, 0, 10, 1, i -> i + "");
        this.arc.sliderPref("arcDetailInfo", 1, 0, 1, 1, s -> {
            if (s == 0) {
                return "\u8be6\u7ec6\u6a21\u5f0f";
            }
            if (s == 1) {
                return "\u7b80\u7565\u6a21\u5f0f";
            }
            return s + "";
        });
        this.arc.checkPref("hoveredTileInfo", false);
        this.arc.addCategory("arcAddBlockInfo");
        this.arc.sliderPref("overdrive_zone", 0, 0, 100, 2, i -> i > 0 ? i + "%" : "\u5173\u95ed");
        this.arc.sliderPref("mend_zone", 0, 0, 100, 2, i -> i > 0 ? i + "%" : "\u5173\u95ed");
        this.arc.checkPref("blockdisabled", false);
        this.arc.checkPref("blockBars", false);
        this.arc.sliderPref("blockbarminhealth", 0, 0, 4000, 50, i -> i + "[red]HP");
        this.arc.checkPref("blockBars_mend", false);
        this.arc.checkPref("arcdrillmode", false);
        this.arc.checkPref("arcDrillProgress", false);
        this.arc.checkPref("arcchoiceuiIcon", false);
        this.arc.checkPref("hidedisplays", false);
        this.arc.checkPref("arcPlacementEffect", false);
        this.arc.addCategory("arcMassDriverInfo");
        this.arc.sliderPref("msLineAlpha", Core.settings.getInt("mass_driver_line_alpha", 0), 0, 100, 1, i -> i > 0 ? i + "%" : "\u5173\u95ed");
        this.arc.checkPref("msShootingDraw", false);
        this.arc.sliderPref("msLineInterval", Core.settings.getInt("mass_driver_line_interval", 40), 8, 400, 8, i -> (float)i / 8.0f + "\u683c");
        this.arc.stringInput("msLineColor", Core.settings.getString("mass_driver_line_color", "ff8c66"));
        this.arc.addCategory("arcAddTurretInfo");
        this.arc.checkPref("showTurretAmmo", false);
        this.arc.checkPref("showTurretAmmoAmount", false);
        this.arc.checkPref("arcTurretPlacementItem", false);
        this.arc.checkPref("arcTurretPlaceCheck", false);
        this.arc.sliderPref("turretShowRange", 0, 0, 3, 1, s -> {
            if (s == 0) {
                return "\u5173\u95ed";
            }
            if (s == 1) {
                return "\u4ec5\u5bf9\u5730";
            }
            if (s == 2) {
                return "\u4ec5\u5bf9\u7a7a";
            }
            if (s == 3) {
                return "\u5168\u90e8";
            }
            return "";
        });
        this.arc.checkPref("turretForceShowRange", false);
        this.arc.sliderPref("turretAlertRange", 0, 0, 30, 1, i -> i > 0 ? i + "\u683c" : "\u5173\u95ed");
        this.arc.checkPref("blockWeaponTargetLine", false);
        this.arc.checkPref("blockWeaponTargetLineWhenIdle", false);
        this.arc.addCategory("arcAddUnitInfo");
        this.arc.checkPref("alwaysShowPlayerUnit", false);
        this.arc.sliderPref("unitTransparency", 100, 0, 100, 5, i -> i > 0 ? i + "%" : "\u5173\u95ed");
        this.arc.sliderPref("unitDrawMinHealth", Core.settings.getInt("minhealth_unitshown", 0), 0, 2500, 50, i -> i + "[red]HP");
        this.arc.checkPref("unitHealthBar", false);
        this.arc.sliderPref("unitBarDrawMinHealth", Core.settings.getInt("minhealth_unithealthbarshown", 0), 0, 2500, 100, i -> i + "[red]HP");
        this.arc.sliderPref("unitWeaponRange", Core.settings.getInt("unitAlertRange", 0), 0, 30, 1, s -> {
            if (s == 0) {
                return "\u5173\u95ed";
            }
            if (s == 30) {
                return "\u4e00\u76f4\u5f00\u542f";
            }
            return s + "\u683c";
        });
        this.arc.sliderPref("unitWeaponRangeAlpha", Core.settings.getInt("unitweapon_range", 0), 0, 100, 1, i -> i > 0 ? i + "%" : "\u5173\u95ed");
        this.arc.checkPref("unitWeaponTargetLine", false);
        this.arc.checkPref("showminebeam", true);
        this.arc.checkPref("unitItemCarried", false);
        this.arc.checkPref("unithitbox", false);
        this.arc.checkPref("unitLogicMoveLine", false);
        this.arc.checkPref("unitLogicTimerBars", false);
        this.arc.checkPref("arcBuildInfo", false);
        this.arc.checkPref("unitbuildplan", false);
        this.arc.checkPref("payloadpreview", false);
        this.arc.addCategory("arcRTSSupporter");
        this.arc.checkPref("arcCommandTable", true);
        this.arc.checkPref("alwaysShowUnitRTSAi", false);
        this.arc.sliderPref("rtsWoundUnit", 0, 0, 100, 2, s -> s + "%");
        this.arc.addCategory("arcShareinfo");
        this.arc.checkPref("arcPlayerList", true);
        this.arc.checkPref("ShowInfoPopup", true);
        this.arc.checkPref("arcShareWaveInfo", false);
        this.arc.checkPref("arcAlwaysTeamColor", false);
        this.arc.checkPref("arcSelfName", false);
        this.arc.stringInput("arcDisablePacket", "^(.*\\.)?mindustry\\.top(:.*)?$");
        this.arc.addCategory("arcPlayerEffect");
        this.arc.stringInput("playerEffectColor", "ffd37f");
        this.arc.sliderPref("unitTargetType", 0, 0, 5, 1, s -> {
            if (s == 0) {
                return "\u5173\u95ed";
            }
            if (s == 1) {
                return "\u865a\u5706";
            }
            if (s == 2) {
                return "\u653b\u51fb";
            }
            if (s == 3) {
                return "\u653b\u51fb\u53bb\u8fb9\u6846";
            }
            if (s == 4) {
                return "\u5706\u5341\u5b57";
            }
            if (s == 5) {
                return "\u5341\u5b57";
            }
            return s + "";
        });
        this.arc.sliderPref("superUnitEffect", 0, 0, 2, 1, s -> {
            if (s == 0) {
                return "\u5173\u95ed";
            }
            if (s == 1) {
                return "\u72ec\u4e00\u65e0\u4e8c";
            }
            if (s == 2) {
                return "\u5168\u90e8\u73a9\u5bb6";
            }
            return s + "";
        });
        this.arc.sliderPref("playerEffectCurStroke", 0, 1, 30, 1, i -> (float)i / 10.0f + "Pixel(s)");
        this.arc.addCategoryS("\u96f7\u8fbe\u626b\u63cf\u8bbe\u7f6e [lightgray](PC\u6309\u952e\uff0c\u624b\u673a\u8f85\u52a9\u5668)");
        this.arc.sliderPref("radarMode", 0, 0, 30, 1, s -> {
            if (s == 0) {
                return "\u5173\u95ed";
            }
            if (s == 30) {
                return "\u4e00\u952e\u5f00\u5173";
            }
            return "[lightgray]x[white]" + Strings.autoFixed((float)s * 0.2f, 1) + "\u500d\u641c\u7d22";
        });
        this.arc.sliderPref("radarSize", 0, 0, 50, 1, s -> {
            if (s == 0) {
                return "\u56fa\u5b9a\u5927\u5c0f";
            }
            return "[lightgray]x[white]" + Strings.autoFixed((float)s * 0.1f, 1) + "\u500d";
        });
        this.arc.addCategory("developerMode");
        this.arc.checkPref("arcDisableModWarning", false);
        this.arc.sliderPref("menuFlyersCount", 0, -15, 50, 5, i -> i + "");
        this.arc.checkPref("menuFlyersRange", false);
        this.arc.checkPref("menuFlyersFollower", false);
        this.arc.checkPref("menuFloatText", true);
        this.arc.checkPref("showUpdateDialog", true);
        this.arc.checkPref("arcInfSchem", false);
        this.forcehide.addCategory("arcCDisplayBlock");
        this.forcehide.sliderPref("blockRenderLevel", 2, 0, 2, 1, s -> {
            if (s == 0) {
                return "\u9690\u85cf\u5168\u90e8\u5efa\u7b51";
            }
            if (s == 1) {
                return "\u53ea\u663e\u793a\u5efa\u7b51\u72b6\u6001";
            }
            if (s == 2) {
                return "\u5168\u90e8\u663e\u793a";
            }
            return s + "";
        });
        this.forcehide.checkPref("displayblock", true);
        this.forcehide.addCategory("arcCDisplayEffect");
        this.forcehide.checkPref("bulletShow", true);
        this.forcehide.checkPref("drawlight", true);
        this.forcehide.checkPref("effects", true);
        this.forcehide.checkPref("bloom", true, val -> Vars.renderer.toggleBloom(val));
        this.forcehide.sliderPref("bloomintensity", 6, 0, 16, i -> (int)((float)i / 4.0f * 100.0f) + "%");
        this.forcehide.sliderPref("bloomblur", 2, 1, 16, i -> i + "x");
        this.forcehide.checkPref("forceEnableDarkness", true);
        this.forcehide.checkPref("destroyedblocks", true);
        this.forcehide.checkPref("showweather", true);
        this.forcehide.checkPref("animatedwater", true);
        if (Shaders.shield != null) {
            this.forcehide.checkPref("animatedshields", !Vars.mobile);
            this.forcehide.checkPref("staticShieldsBorder", false);
        }
        this.forcehide.checkPref("atmosphere", !Vars.mobile);
        this.graphics.checkPref("pixelate", false, val -> {
            if (val) {
                Events.fire(EventType.Trigger.enablePixelation);
            }
        });
        this.graphics.checkPref("linear", !Vars.mobile, b -> {
            for (Texture tex : Core.atlas.getTextures()) {
                Texture.TextureFilter filter = b ? Texture.TextureFilter.linear : Texture.TextureFilter.nearest;
                tex.setFilter(filter, filter);
            }
        });
        if (Core.settings.getBool("linear")) {
            for (Texture tex : Core.atlas.getTextures()) {
                Texture.TextureFilter filter = Texture.TextureFilter.linear;
                tex.setFilter(filter, filter);
            }
        }
        this.forcehide.checkPref("pixelate", false, val -> {
            if (val) {
                Events.fire(EventType.Trigger.enablePixelation);
            }
        });
        ARCVars.limitUpdate = Core.settings.getBool("limitupdate", false);
        this.forcehide.checkPref("limitupdate", false, v -> {
            Core.settings.put("limitupdate", false);
            if (ARCVars.limitUpdate) {
                ARCVars.limitUpdate = false;
                return;
            }
            Vars.ui.showConfirm("\u786e\u8ba4\u5f00\u542f\u9650\u5236\u66f4\u65b0", "\u6b64\u529f\u80fd\u53ef\u4ee5\u5927\u5e45\u63d0\u5347fps\uff0c\u4f46\u4f1a\u5bfc\u81f4\u89c6\u89d2\u5916\u7684\u4e00\u5207\u505c\u6b62\u66f4\u65b0\n\u5728\u670d\u52a1\u5668\u91cc\u4f1a\u9020\u6210\u4e0d\u540c\u6b65\n\u5f3a\u70c8\u4e0d\u5efa\u8bae\u5728\u5355\u4eba\u5f00\u542f\n\n[darkgray]\u5728\u5e27\u6570\u548c\u4f53\u9a8c\u91cc\u4e8c\u9009\u4e00", () -> {
                ARCVars.limitUpdate = true;
                Core.settings.put("limitupdate", true);
            });
        });
        ARCVars.limitDst = Core.settings.getInt("limitdst", 10);
        this.forcehide.sliderPref("limitdst", 10, 0, 100, 1, s -> {
            ARCVars.limitDst = s * 8;
            return s + "\u683c";
        });
        this.specmode.addCategory("moreContent");
        this.specmode.checkPref("modMode", false);
        this.specmode.sliderPref("itemSelectionHeight", 4, 4, 12, i -> i + "\u884c");
        this.specmode.sliderPref("itemSelectionWidth", 4, 4, 12, i -> i + "\u5217");
        this.specmode.sliderPref("blockInventoryWidth", 3, 3, 16, i -> i + "");
        this.specmode.sliderPref("editorBrush", 4, 3, 12, i -> i + "");
        this.specmode.addCategory("personalized");
        this.specmode.checkPref("colorizedContent", false);
        this.specmode.sliderPref("fontSet", 0, 0, 2, 1, s -> {
            if (s == 0) {
                return "\u539f\u7248\u5b57\u4f53";
            }
            if (s == 1) {
                return "[violet]LC[white]\u306e[cyan]\u840c\u5316\u5b57\u4f53\u5305";
            }
            if (s == 2) {
                return "[violet]9527[white]\u306e[cyan]\u6977\u4f53\u5305";
            }
            return s + "";
        });
        this.specmode.sliderPref("fontSize", 10, 5, 25, 1, i -> "x " + Strings.fixed((float)i * 0.1f, 1));
        this.specmode.stringInput("themeColor", "ffd37f");
        this.specmode.stringInput("arcBackgroundPath", "");
        if (!OS.isAndroid && !OS.isIos) {
            this.specmode.stringInput("arcCursorPath", "");
            this.specmode.buttonInput("[cyan]\u67e5\u770b\u5f53\u524d\u6307\u9488\u6837\u5f0f", () -> new BaseDialog("\u6307\u9488\u6837\u5f0f"){
                {
                    this.shown(() -> {
                        this.addCloseButton();
                        this.cont.add("[orange]\u5c06\u9f20\u6807\u60ac\u505c\u5728\u8fd9\u4e9b\u6846\u6846\u4e0a\u9762\uff0c\u9884\u89c8\u6307\u9488\u6837\u5f0f (\u8fd9\u4e9b\u540d\u5b57\u5c31\u662f\u81ea\u5b9a\u4e49\u6307\u9488\u6587\u4ef6\u540d)").row();
                        this.cont.add("[cyan]\u56fe\u7247\u4e2d\u5fc3\u662f\u6307\u9488\u4e2d\u5fc3").row();
                        this.cont.button("[orange]\u91cd\u8f7d\u6307\u9488", () -> {
                            RFuncs.cursorChecked = false;
                            RFuncs.cachedCursor = null;
                            Vars.ui.drillCursor = RFuncs.customCursor("drill", Fonts.cursorScale());
                            Vars.ui.unloadCursor = RFuncs.customCursor("unload", Fonts.cursorScale());
                            Vars.ui.targetCursor = RFuncs.customCursor("target", Fonts.cursorScale());
                            ARCVars.arcui.resizeHorizontalCursor = RFuncs.customCursor("resizeHorizontal", Fonts.cursorScale());
                            ARCVars.arcui.resizeVerticalCursor = RFuncs.customCursor("resizeVertical", Fonts.cursorScale());
                            ARCVars.arcui.resizeLeftCursor = RFuncs.customCursor("resizeLeft", Fonts.cursorScale());
                            ARCVars.arcui.resizeRightCursor = RFuncs.customCursor("resizeRight", Fonts.cursorScale());
                            Fonts.loadSystemCursors();
                        }).growX().row();
                        this.cont.table((Table root) -> {
                            root.table((Table t) -> t.add("cursor").pad(10.0f)).height(80.0f).growX().pad(10.0f).touchable(Touchable.enabled).get().background(Styles.grayPanel).hovered(() -> Core.graphics.cursor(Graphics.Cursor.SystemCursor.arrow));
                            root.table((Table t) -> t.add("hand").pad(10.0f)).height(80.0f).growX().pad(10.0f).touchable(Touchable.enabled).get().background(Styles.grayPanel).hovered(() -> Core.graphics.cursor(Graphics.Cursor.SystemCursor.hand));
                            root.table((Table t) -> t.add("ibeam").pad(10.0f)).height(80.0f).growX().pad(10.0f).touchable(Touchable.enabled).get().background(Styles.grayPanel).hovered(() -> Core.graphics.cursor(Graphics.Cursor.SystemCursor.ibeam));
                        }).growX().row();
                        this.cont.table((Table root) -> {
                            root.table((Table t) -> t.add("drill").pad(10.0f)).height(80.0f).growX().pad(10.0f).touchable(Touchable.enabled).get().background(Styles.grayPanel).hovered(() -> Core.graphics.cursor(Vars.ui.drillCursor));
                            root.table((Table t) -> t.add("unload").pad(10.0f)).height(80.0f).growX().pad(10.0f).touchable(Touchable.enabled).get().background(Styles.grayPanel).hovered(() -> Core.graphics.cursor(Vars.ui.unloadCursor));
                            root.table((Table t) -> t.add("target").pad(10.0f)).height(80.0f).growX().pad(10.0f).touchable(Touchable.enabled).get().background(Styles.grayPanel).hovered(() -> Core.graphics.cursor(Vars.ui.targetCursor));
                        }).growX().row();
                        this.cont.table((Table root) -> {
                            root.table((Table t) -> t.add("resizeHorizontal").pad(10.0f)).height(80.0f).growX().pad(10.0f).touchable(Touchable.enabled).get().background(Styles.grayPanel).hovered(() -> Core.graphics.cursor(ARCVars.arcui.resizeHorizontalCursor));
                            root.table((Table t) -> t.add("resizeVertical").pad(10.0f)).height(80.0f).growX().pad(10.0f).touchable(Touchable.enabled).get().background(Styles.grayPanel).hovered(() -> Core.graphics.cursor(ARCVars.arcui.resizeVerticalCursor));
                            root.table((Table t) -> t.add("resizeLeft").pad(10.0f)).height(80.0f).growX().pad(10.0f).touchable(Touchable.enabled).get().background(Styles.grayPanel).hovered(() -> Core.graphics.cursor(ARCVars.arcui.resizeLeftCursor));
                            root.table((Table t) -> t.add("resizeRight").pad(10.0f)).height(80.0f).growX().pad(10.0f).touchable(Touchable.enabled).get().background(Styles.grayPanel).hovered(() -> Core.graphics.cursor(ARCVars.arcui.resizeRightCursor));
                        }).growX();
                    });
                }
            }.show());
        }
        this.specmode.checkPref("yuanshen", false, b -> {
            if (b) {
                Vars.dataDirectory.child("yuanshen").writeString("\u539f\u795e\uff0c\u542f\u52a8\uff01");
            } else {
                Vars.dataDirectory.child("yuanshen").delete();
            }
        });
        this.specmode.checkPref("xibaoOnKick", false);
        this.specmode.addCategory("specGameMode");
        this.specmode.checkPref("autoSelSchematic", false);
        this.specmode.checkPref("researchViewer", false);
        this.specmode.checkPref("bossKeyValid", false);
        this.specmode.checkPref("arcShareMedia", true);
        this.specmode.checkPref("rotateCanvas", false);
        this.specmode.checkPref("developMode", false);
        this.cheating.addCategory("arcWeakCheat");
        this.cheating.checkPref("forceIgnoreAttack", false);
        this.cheating.checkPref("allBlocksReveal", false, b -> {
            AdvanceToolTable.allBlocksReveal = b;
        });
        this.cheating.checkPref("worldCreator", false, b -> {
            AdvanceToolTable.worldCreator = b;
        });
        this.cheating.checkPref("overrideSkipWave", false);
        this.cheating.checkPref("forceConfigInventory", false);
        this.cheating.addCategory("arcStrongCheat");
        this.cheating.checkPref("showOtherTeamResource", false);
        this.cheating.checkPref("showOtherTeamState", false);
        this.cheating.checkPref("selectTeam", false);
        this.cheating.checkPref("playerNeedShooting", false);
        this.cheating.checkPref("otherCheat", false);
        if (OS.isMac) {
            this.graphics.checkPref("macnotch", false);
        }
        if (!Vars.mobile) {
            Core.settings.put("swapdiagonal", false);
        }
    }

    public void exportData(Fi file) throws IOException {
        Seq<Fi> files = new Seq<Fi>();
        files.add(Core.settings.getSettingsFile());
        files.addAll(Vars.customMapDirectory.list());
        files.addAll(Vars.saveDirectory.list());
        files.addAll(Vars.modDirectory.list());
        files.addAll(Vars.schematicDirectory.list());
        String base = Core.settings.getDataDirectory().path();
        for (Fi other : files.copy()) {
            Fi parent = other.parent();
            while (!files.contains(parent) && !parent.equals(Core.settings.getDataDirectory())) {
                files.add(parent);
            }
        }
        try (OutputStream fos = file.write(false, 2048);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            for (Fi add : files) {
                String path = add.path().substring(base.length());
                if (add.isDirectory()) {
                    path = path + "/";
                }
                path = path.startsWith("/") ? path.substring(1) : path;
                zos.putNextEntry(new ZipEntry(path));
                if (!add.isDirectory()) {
                    try (InputStream stream = add.read();){
                        Streams.copy(stream, zos);
                    }
                }
                zos.closeEntry();
            }
        }
    }

    public void importData(Fi file) {
        Fi dest = Core.files.local("zipdata.zip");
        file.copyTo(dest);
        ZipFi zipped = new ZipFi(dest);
        Fi base = Core.settings.getDataDirectory();
        if (!((Fi)zipped).child("settings.bin").exists()) {
            throw new IllegalArgumentException("Not valid save data.");
        }
        Vars.saveDirectory.deleteDirectory();
        Vars.tmpDirectory.deleteDirectory();
        zipped.walk(f -> f.copyTo(base.child(f.path())));
        dest.delete();
        Core.settings.clear();
        Core.settings.load();
    }

    private void back() {
        this.rebuildMenu();
        this.prefs.clearChildren();
        this.prefs.add(this.menu);
    }

    private void visible(int index) {
        this.prefs.clearChildren();
        Seq<Table> tables = new Seq<Table>();
        if (Core.settings.getInt("changelogreaded") == ARCVars.changeLogRead) {
            tables.addAll(this.game, this.graphics, this.sound, this.arc, this.forcehide, this.specmode, this.cheating);
        } else {
            tables.addAll(this.arc);
        }
        for (SettingsCategory custom : this.categories) {
            tables.add(custom.table);
        }
        this.prefs.add((Table)tables.get(index));
    }

    @Override
    public void addCloseButton() {
        this.buttons.button("@back", Icon.left, () -> {
            if (this.prefs.getChildren().first() != this.menu) {
                this.back();
            } else {
                this.hide();
            }
        }).size(210.0f, 64.0f);
        this.keyDown(key -> {
            if (key == KeyCode.escape || key == KeyCode.back) {
                if (this.prefs.getChildren().first() != this.menu) {
                    this.back();
                } else {
                    this.hide();
                }
            }
        });
    }

    public static class SettingsTable
    extends Table {
        protected Seq<Setting> list = new Seq();

        public SettingsTable() {
            this.left();
        }

        public Seq<Setting> getSettings() {
            return this.list;
        }

        public void pref(Setting setting) {
            this.list.add(setting);
            this.rebuild();
        }

        public SliderSetting sliderPref(String name, int def, int min, int max, StringProcessor s) {
            return this.sliderPref(name, def, min, max, 1, s);
        }

        public SliderSetting sliderPref(String name, int def, int min, int max, int step, StringProcessor s) {
            SliderSetting res = new SliderSetting(name, def, min, max, step, s);
            this.list.add(res);
            Core.settings.defaults(name, def);
            this.rebuild();
            return res;
        }

        public void checkPref(String name, boolean def) {
            this.list.add(new CheckSetting(name, def, null));
            Core.settings.defaults(name, def);
            this.rebuild();
        }

        public void checkPref(String name, boolean def, Boolc changed) {
            this.list.add(new CheckSetting(name, def, changed));
            Core.settings.defaults(name, def);
            this.rebuild();
        }

        public void addCategory(String name) {
            this.list.add(new Divider(name, Core.bundle.get("category." + name + ".name")));
            this.rebuild();
        }

        public void addCategoryS(String name) {
            this.list.add(new Divider(name, name));
            this.rebuild();
        }

        public void buttonInput(String text, Runnable callback) {
            this.list.add(new ButtonFakeSetting(text, callback));
            this.rebuild();
        }

        public void stringInput(String name, String def) {
            this.list.add(new StringSetting(name, def, def));
            Core.settings.defaults(name, def);
            this.rebuild();
        }

        public void textPref(String name, String def) {
            this.list.add(new TextSetting(name, def, null));
            Core.settings.defaults(name, def);
            this.rebuild();
        }

        public void textPref(String name, String def, Cons<String> changed) {
            this.list.add(new TextSetting(name, def, changed));
            Core.settings.defaults(name, def);
            this.rebuild();
        }

        public void areaTextPref(String name, String def) {
            this.list.add(new AreaTextSetting(name, def, null));
            Core.settings.defaults(name, def);
            this.rebuild();
        }

        public void areaTextPref(String name, String def, Cons<String> changed) {
            this.list.add(new AreaTextSetting(name, def, changed));
            Core.settings.defaults(name, def);
            this.rebuild();
        }

        public void rebuild() {
            this.clearChildren();
            for (Setting setting : this.list) {
                setting.add(this);
            }
            this.button(Core.bundle.get("settings.reset", "Reset to Defaults"), () -> {
                for (Setting setting : this.list) {
                    if (setting.name == null || setting.title == null) continue;
                    Core.settings.remove(setting.name);
                }
                this.rebuild();
            }).margin(14.0f).width(240.0f).pad(6.0f);
        }

        public static class SliderSetting
        extends Setting {
            int def;
            int min;
            int max;
            int step;
            StringProcessor sp;

            public SliderSetting(String name, int def, int min, int max, int step, StringProcessor s) {
                super(name);
                this.def = def;
                this.min = min;
                this.max = max;
                this.step = step;
                this.sp = s;
            }

            @Override
            public void add(SettingsTable table) {
                Slider slider = new Slider(this.min, this.max, this.step, false);
                slider.setValue(Core.settings.getInt(this.name));
                Label value = new Label("", Styles.outlineLabel);
                Table content = new Table();
                content.add((CharSequence)this.title, Styles.outlineLabel).left().growX().wrap();
                content.add(value).padLeft(10.0f).right();
                content.margin(3.0f, 33.0f, 3.0f, 33.0f);
                content.touchable = Touchable.disabled;
                slider.changed(() -> {
                    Core.settings.put(this.name, (int)slider.getValue());
                    value.setText(this.sp.get((int)slider.getValue()));
                });
                slider.change();
                this.addDesc(table.stack(slider, content).width(Math.min((float)Core.graphics.getWidth() / 1.2f, 460.0f)).left().padTop(4.0f).get());
                table.row();
            }
        }

        public static class CheckSetting
        extends Setting {
            boolean def;
            Boolc changed;

            public CheckSetting(String name, boolean def, Boolc changed) {
                super(name);
                this.def = def;
                this.changed = changed;
            }

            @Override
            public void add(SettingsTable table) {
                CheckBox box = new CheckBox(this.title);
                box.update(() -> box.setChecked(Core.settings.getBool(this.name)));
                box.changed(() -> {
                    Core.settings.put(this.name, box.isChecked());
                    if (this.changed != null) {
                        this.changed.get(box.isChecked());
                    }
                });
                box.left();
                this.addDesc(table.add(box).left().padTop(3.0f).get());
                table.row();
            }
        }

        public static class Divider
        extends Setting {
            Divider(String name, String title) {
                super(name);
                this.title = title;
            }

            @Override
            public void add(SettingsTable table) {
                table.add(this.title).color(ARCVars.getThemeColor()).colspan(4).pad(10.0f).padTop(15.0f).padBottom(4.0f).row();
                table.image().color(ARCVars.getThemeColor()).fillX().height(3.0f).colspan(4).padTop(0.0f).padBottom(10.0f).row();
            }
        }

        public static class ButtonFakeSetting
        extends Setting {
            Button button;

            public ButtonFakeSetting(String text, Runnable callback) {
                super("fake");
                this.button = Elem.newButton(text, callback);
            }

            @Override
            public void add(SettingsTable table) {
                table.row().add(this.button).growX().height(48.0f).row();
            }
        }

        public static class StringSetting
        extends Setting {
            String def;
            String value;

            StringSetting(String name, String def, String value) {
                super(name);
                this.def = def;
                this.value = value;
            }

            @Override
            public void add(SettingsTable table) {
                this.value = Core.settings.getString(this.name);
                Table field = new Table();
                field.add(Core.bundle.get("setting." + this.name + ".name"));
                field.field(this.value, text -> {
                    Core.settings.put(this.name, text);
                    this.value = text;
                }).growX().padLeft(30.0f);
                table.add(field).growX().pad(10.0f).padTop(15.0f).padBottom(4.0f).row();
            }
        }

        public static class TextSetting
        extends Setting {
            String def;
            Cons<String> changed;

            public TextSetting(String name, String def, Cons<String> changed) {
                super(name);
                this.def = def;
                this.changed = changed;
            }

            @Override
            public void add(SettingsTable table) {
                TextField field = new TextField();
                field.update(() -> field.setText(Core.settings.getString(this.name)));
                field.changed(() -> {
                    Core.settings.put(this.name, field.getText());
                    if (this.changed != null) {
                        this.changed.get(field.getText());
                    }
                });
                Table prefTable = table.table().left().padTop(3.0f).get();
                prefTable.add(field);
                prefTable.label(() -> this.title);
                this.addDesc(prefTable);
                table.row();
            }
        }

        public static class AreaTextSetting
        extends TextSetting {
            public AreaTextSetting(String name, String def, Cons<String> changed) {
                super(name, def, changed);
            }

            @Override
            public void add(SettingsTable table) {
                TextArea area = new TextArea("");
                area.setPrefRows(5.0f);
                area.update(() -> {
                    area.setText(Core.settings.getString(this.name));
                    area.setWidth(table.getWidth());
                });
                area.changed(() -> {
                    Core.settings.put(this.name, area.getText());
                    if (this.changed != null) {
                        this.changed.get(area.getText());
                    }
                });
                this.addDesc(table.label(() -> this.title).left().padTop(3.0f).get());
                table.row().add(area).left();
                table.row();
            }
        }

        public static abstract class Setting {
            public String name;
            public String title;
            @Nullable
            public String description;

            public Setting(String name) {
                this.name = name;
                String winkey = "setting." + name + ".name.windows";
                this.title = OS.isWindows && Core.bundle.has(winkey) ? Core.bundle.get(winkey) : Core.bundle.get("setting." + name + ".name", name);
                this.description = Core.bundle.getOrNull("setting." + name + ".description");
            }

            public abstract void add(SettingsTable var1);

            public void addDesc(Element elem) {
                Vars.ui.addDescTooltip(elem, this.description);
            }
        }
    }

    public static class SettingsCategory {
        public String name;
        @Nullable
        public Drawable icon;
        public Cons<SettingsTable> builder;
        public SettingsTable table;

        public SettingsCategory(String name, Drawable icon, Cons<SettingsTable> builder) {
            this.name = name;
            this.icon = icon;
            this.builder = builder;
            this.table = new SettingsTable();
            builder.get(this.table);
        }
    }

    public static interface StringProcessor {
        public String get(int var1);
    }
}

