/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.func.Cons;
import arc.input.KeyCode;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import java.util.Locale;
import mindustry.Vars;
import mindustry.content.Planets;
import mindustry.gen.Icon;
import mindustry.type.Planet;
import mindustry.type.SectorPreset;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class SectorSelectDialog
extends BaseDialog {
    Table sectors = new Table();
    Planet planet = Planets.serpulo;
    Cons<SectorPreset> cons = s -> {};
    TextField search;

    public SectorSelectDialog() {
        super("@content.sector.name");
        this.cont.top();
        this.cont.table((Table s) -> {
            s.image(Icon.zoom);
            this.search = s.field("", ignored -> this.rebuild()).width(300.0f).get();
            this.search.keyDown(KeyCode.enter, () -> {
                String text = this.search.getText().toLowerCase(Locale.ROOT);
                SectorPreset found = Vars.content.sectors().find((T sec) -> this.matches((SectorPreset)sec, text));
                if (found != null) {
                    this.cons.get(found);
                    this.hide();
                }
            });
        });
        this.cont.row();
        this.cont.pane(this.sectors).grow().top();
        this.sectors.top();
        this.addCloseButton();
        this.shown(() -> {
            this.search.clearText();
            this.search.requestKeyboard();
            Core.app.post(() -> this.search.requestKeyboard());
            this.rebuild();
        });
    }

    public void show(Planet planet, Cons<SectorPreset> cons) {
        this.planet = planet;
        this.cons = cons;
        this.show();
    }

    void rebuild() {
        this.sectors.clear();
        String text = this.search.getText().toLowerCase(Locale.ROOT);
        for (SectorPreset sector : Vars.content.sectors()) {
            if (!this.matches(sector, text)) continue;
            this.sectors.button(sector.localizedName, new TextureRegionDrawable(sector.uiIcon), Styles.grayt, 32.0f, () -> {
                this.cons.get(sector);
                this.hide();
            }).size(400.0f, 50.0f).margin(4.0f).pad(3.0f);
            this.sectors.row();
        }
    }

    boolean matches(SectorPreset sector, String text) {
        return sector.planet == this.planet && (text.isEmpty() || sector.name.toLowerCase(Locale.ROOT).contains(text) || sector.localizedName.toLowerCase(Locale.ROOT).contains(text));
    }
}

