/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.scene.ui.layout.Table;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.editor.MapProcessorsDialog;
import mindustry.game.Rules;
import mindustry.gen.Call;
import mindustry.gen.Icon;
import mindustry.maps.Map;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.CustomRulesDialog;
import mindustry.ui.dialogs.LoadDialog;
import mindustry.ui.dialogs.SaveDialog;

public class PausedDialog
extends BaseDialog {
    private MapProcessorsDialog processors = new MapProcessorsDialog();
    private SaveDialog save = new SaveDialog();
    private LoadDialog load = new LoadDialog();
    private CustomRulesDialog rulesDialog = new CustomRulesDialog();

    public PausedDialog() {
        super("@menu");
        this.shouldPause = true;
        this.clearChildren();
        this.add(this.titleTable).growX().row();
        this.stack(this.cont, new Table(t -> {
            t.bottom().left();
            t.button(Icon.book, () -> {
                Rules toEdit = Vars.state.rules.copy();
                this.rulesDialog.show(toEdit, () -> Vars.state.rules.copy());
                this.rulesDialog.hidden(() -> {
                    Vars.state.rules = toEdit;
                    Call.setRules(toEdit);
                });
            }).size(70.0f).tooltip("@customize").visible(() -> Vars.state.rules.allowEditRules && (Vars.net.server() || !Vars.net.active()));
        })).grow().row();
        this.shown(this::rebuild);
        this.addCloseListener();
    }

    void rebuild() {
        this.cont.clear();
        this.update(() -> {
            if (Vars.state.isMenu() && this.isShown()) {
                this.hide();
            }
        });
        if (!Vars.mobile) {
            float dw = 220.0f;
            this.cont.defaults().width(dw).height(55.0f).pad(5.0f);
            this.cont.button("@objective", Icon.info, () -> Vars.ui.fullText.show("@objective", Vars.state.rules.sector.preset.description)).visible(() -> Vars.state.rules.sector != null && Vars.state.rules.sector.preset != null && Vars.state.rules.sector.preset.description != null).padTop(-60.0f);
            this.cont.button("@abandon", Icon.cancel, () -> Vars.ui.planet.abandonSectorConfirm(Vars.state.rules.sector, this::hide)).padTop(-60.0f).disabled(b -> Vars.net.client() || Vars.state.gameOver).visible(() -> Vars.state.rules.sector != null).row();
            this.cont.button("@back", Icon.left, this::hide).name("back");
            this.cont.button("@settings", Icon.settings, Vars.ui.settings::show).name("settings");
            if (Core.settings.getBool("save_more_map") || !Vars.state.isCampaign() && !Vars.state.isEditor()) {
                this.cont.row();
                this.cont.button("@savegame", Icon.save, this.save::show);
                this.cont.button("@loadgame", Icon.upload, this.load::show).disabled(b -> Vars.net.active());
            }
            this.cont.row();
            this.cont.button(Vars.state.isEditor() ? "@hostserver.mobile" : "@hostserver", Icon.host, () -> {
                if (Vars.net.server() && Vars.steam) {
                    Vars.platform.inviteFriends();
                } else {
                    Vars.ui.host.show();
                }
            }).disabled(b -> (!Vars.steam || !Vars.net.server()) && Vars.net.active()).colspan(Vars.state.isEditor() ? 1 : 2).width(Vars.state.isEditor() ? dw : dw * 2.0f + 10.0f).update((T e) -> e.setText(Vars.net.server() && Vars.steam ? "@invitefriends" : (Vars.state.isEditor() ? "@hostserver.mobile" : "@hostserver")));
            if (Vars.state.isEditor()) {
                this.cont.button("@editor.worldprocessors", Icon.logic, () -> {
                    this.hide();
                    this.processors.show();
                });
            }
            this.cont.row();
            this.cont.button("@joingame", Icon.host, () -> {
                this.hide();
                Vars.ui.join.show();
            });
            this.cont.button("@quit", Icon.exit, this::showQuitConfirm).colspan(2).width(dw + 10.0f).update((T s) -> s.setText(Vars.control.saves.getCurrent() != null && Vars.control.saves.getCurrent().isAutosave() ? "@save.quit" : "@quit"));
        } else {
            this.cont.defaults().size(130.0f).pad(5.0f);
            this.cont.buttonRow("@back", Icon.play, this::hide);
            this.cont.buttonRow("@settings", Icon.settings, Vars.ui.settings::show);
            if (!Vars.state.isCampaign() && !Vars.state.isEditor()) {
                this.cont.buttonRow("@save", Icon.save, this.save::show);
                this.cont.row();
                this.cont.buttonRow("@load", Icon.download, this.load::show).disabled(b -> Vars.net.active());
            } else if (Vars.state.isCampaign()) {
                this.cont.buttonRow("@research", Icon.tree, Vars.ui.research::show);
                this.cont.row();
                this.cont.buttonRow("@planetmap", Icon.map, () -> {
                    this.hide();
                    Vars.ui.planet.show();
                });
            } else {
                this.cont.row();
            }
            this.cont.buttonRow("@database", Icon.book, Vars.ui.database::show);
            this.cont.buttonRow("@hostserver.mobile", Icon.host, Vars.ui.host::show).disabled(b -> Vars.net.active());
            this.cont.buttonRow("@quit", Icon.exit, this::showQuitConfirm).update((T s) -> {
                s.setText(Vars.control.saves.getCurrent() != null && Vars.control.saves.getCurrent().isAutosave() ? "@save.quit" : "@quit");
                s.getLabelCell().growX().wrap();
            });
        }
    }

    void showQuitConfirm() {
        Runnable quit = () -> {
            this.runExitSave();
            this.hide();
        };
        if (Vars.confirmExit) {
            Vars.ui.showConfirm("@confirm", "@quit.confirm", quit);
        } else {
            quit.run();
        }
    }

    public boolean checkPlaytest() {
        if (Vars.state.playtestingMap != null) {
            Map testing = Vars.state.playtestingMap;
            Vars.logic.reset();
            Vars.ui.editor.resumeAfterPlaytest(testing);
            return true;
        }
        return false;
    }

    public void runExitSave() {
        boolean wasClient = Vars.net.client();
        ARCVars.replayController.stopPlay();
        if (Vars.net.client()) {
            Vars.netClient.disconnectQuietly();
        }
        if (Vars.state.isEditor() && !wasClient) {
            Vars.ui.editor.resumeEditing();
            return;
        }
        if (this.checkPlaytest()) {
            return;
        }
        if (Vars.control.saves.getCurrent() == null || !Vars.control.saves.getCurrent().isAutosave() || wasClient || Vars.state.gameOver || Vars.disableSave) {
            Vars.logic.reset();
            return;
        }
        Vars.ui.loadAnd("@saving", () -> {
            try {
                Vars.control.saves.getCurrent().save();
            }
            catch (Throwable e) {
                e.printStackTrace();
                Vars.ui.showException("[accent]" + Core.bundle.get("savefail"), e);
            }
            Vars.logic.reset();
        });
    }
}

