/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.Events;
import arc.freetype.FreeTypeFontGenerator;
import arc.graphics.Color;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.ui.Button;
import arc.scene.ui.Dialog;
import arc.scene.ui.ImageButton;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.Tooltip;
import arc.scene.ui.layout.Collapser;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Http;
import arc.util.Log;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Timer;
import arc.util.serialization.Jval;
import mindustry.Vars;
import mindustry.arcModule.ARCEvents;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.ui.dialogs.USIDDialog;
import mindustry.core.Version;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.io.versions.LegacyIO;
import mindustry.net.Host;
import mindustry.net.Packets;
import mindustry.net.ServerGroup;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.PaletteDialog;

public class JoinDialog
extends BaseDialog {
    Seq<ServerGroup> tmpServers = new Seq();
    Seq<Server> servers = new Seq();
    Dialog add;
    Server renaming;
    Table local = new Table();
    Table remote = new Table();
    Table global = new Table();
    Table hosts = new Table();
    int totalHosts;
    int refreshes;
    boolean showHidden;
    TextButton.TextButtonStyle style;
    Timer.Task fontIgnoreDirtyTask;
    String lastIp;
    int lastPort;
    int lastColumns = -1;
    Timer.Task ping;
    String serverSearch = "";
    String srcaddress;

    public JoinDialog() {
        super("@joingame");
        boolean infoButton;
        this.makeButtonOverlay();
        this.style = new TextButton.TextButtonStyle(){
            {
                this.over = Styles.flatOver;
                this.font = Fonts.def;
                this.fontColor = Color.white;
                this.disabledFontColor = Color.gray;
                this.down = Styles.flatOver;
                this.up = Styles.black5;
            }
        };
        this.loadServers();
        boolean bl = infoButton = !Vars.steam && !Vars.mobile;
        if (infoButton) {
            this.buttons.add().width(60.0f);
        }
        this.buttons.add().growX().width(-1.0f);
        this.addCloseButton(Vars.mobile ? 190.0f : 210.0f);
        this.buttons.button("@server.add", Icon.add, () -> {
            this.renaming = null;
            this.add.show();
        });
        this.buttons.add().growX().width(-1.0f);
        if (infoButton) {
            this.buttons.button("?", () -> Vars.ui.showInfo("@join.info")).size(60.0f, 64.0f);
        }
        this.add = new BaseDialog("@joingame.title");
        this.add.cont.add("@joingame.ip").padRight(5.0f).left();
        TextField field = this.add.cont.field(Core.settings.getString("ip"), text -> Core.settings.put("ip", text)).size(320.0f, 54.0f).maxTextLength(100).get();
        this.add.cont.row();
        this.add.buttons.defaults().size(140.0f, 60.0f).pad(4.0f);
        this.add.buttons.button("@cancel", this.add::hide);
        this.add.buttons.button("@ok", () -> {
            if (this.renaming == null) {
                Server server = new Server();
                server.setIP(Core.settings.getString("ip"));
                this.servers.add(server);
            } else {
                this.renaming.setIP(Core.settings.getString("ip"));
            }
            this.saveServers();
            this.setupRemote();
            this.refreshRemote();
            this.add.hide();
        }).disabled(b -> Core.settings.getString("ip").isEmpty() || Vars.net.active());
        this.add.shown(() -> {
            this.add.title.setText(this.renaming != null ? "@server.edit" : "@server.add");
            if (this.renaming != null) {
                field.setText(this.renaming.displayIP());
            }
        });
        this.keyDown(KeyCode.f5, this::refreshAll);
        this.shown(() -> {
            this.setup();
            this.refreshAll();
            if (!Vars.steam) {
                Core.app.post(() -> Core.settings.getBoolOnce("joininfo", () -> Vars.ui.showInfo("@join.info")));
            }
        });
        this.onResize(() -> {
            if ((float)Math.min(Core.graphics.getWidth(), Core.graphics.getHeight()) / Scl.scl() * 0.9f < 500.0f || this.lastColumns != this.columns()) {
                this.setup();
                this.refreshAll();
            }
            this.lastColumns = this.columns();
        });
    }

    void refreshAll() {
        ++this.refreshes;
        this.refreshLocal();
        this.refreshRemote();
        if (Core.settings.getBool("communityservers", true)) {
            this.refreshCommunity();
        }
    }

    void setupRemote() {
        this.remote.clear();
        for (Server server : this.servers) {
            if (server.lastHost != null) {
                int ServerVersion = server.lastHost.version;
                if (Core.settings.getBool("showAccessibleServer") && ServerVersion != Version.build && Version.build != -1 && ServerVersion != -1) continue;
            }
            Button[] buttons = new Button[]{null};
            Button button = buttons[0] = this.remote.button((Button b) -> {}, (Button.ButtonStyle)this.style, () -> {
                if (!buttons[0].childrenPressed()) {
                    if (server.lastHost != null) {
                        if (Version.build >= 10000 && server.lastHost.version < 10000) {
                            Vars.ui.showErrorMessage("BE\u7248\u5b66\u672f\u4e0d\u80fd\u52a0\u5165\u6b63\u5f0f\u7248\u670d\u52a1\u5668\n\u8bf7\u4f7f\u7528\u6b63\u5f0f\u7248");
                            return;
                        }
                        Version.build = server.lastHost.version;
                        Events.fire(new EventType.ClientPreConnectEvent(server.lastHost));
                        this.safeConnect(server.lastHost.address, server.lastHost.port, server.lastHost.version);
                    } else {
                        this.connect(server.ip, server.port);
                    }
                }
            }).width(this.targetWidth()).growY().top().left().pad(4.0f).get();
            if (this.remote.getChildren().size % this.columns() == 0) {
                this.remote.row();
            }
            Table inner = new Table(Tex.whiteui);
            inner.setColor(Pal.gray);
            button.clearChildren();
            button.add(inner).growX();
            inner.add("[accent]" + server.displayIP()).left().padLeft(10.0f).wrap().style(Styles.outlineLabel).growX();
            inner.button((Drawable)Icon.upOpen, Styles.emptyi, () -> this.moveRemote(server, -1)).margin(3.0f).padTop(6.0f).top().right();
            inner.button((Drawable)Icon.downOpen, Styles.emptyi, () -> this.moveRemote(server, 1)).margin(3.0f).pad(2.0f).padTop(6.0f).top().right();
            inner.button((Drawable)Icon.refresh, Styles.emptyi, () -> this.refreshServer(server)).margin(3.0f).pad(2.0f).padTop(6.0f).top().right();
            inner.button((Drawable)Icon.pencil, Styles.emptyi, () -> {
                this.renaming = server;
                this.add.show();
            }).margin(3.0f).pad(2.0f).padTop(6.0f).top().right();
            inner.button((Drawable)Icon.trash, Styles.emptyi, () -> Vars.ui.showConfirm("@confirm", "@server.delete", () -> {
                this.servers.remove(server, true);
                this.saveServers();
                this.setupRemote();
                this.refreshRemote();
            })).margin(3.0f).pad(2.0f).pad(6.0f).top().right();
            button.row();
            server.content = button.table((Table t) -> {}).grow().get();
        }
    }

    void moveRemote(Server server, int sign) {
        int index = this.servers.indexOf(server);
        if (index + sign < 0) {
            return;
        }
        if (index + sign > this.servers.size - 1) {
            return;
        }
        this.servers.remove(index);
        this.servers.insert(index + sign, server);
        this.saveServers();
        this.setupRemote();
        for (Server other : this.servers) {
            if (other.lastHost != null) {
                this.setupServer(other, other.lastHost);
                continue;
            }
            this.refreshServer(other);
        }
    }

    void refreshRemote() {
        for (Server server : this.servers) {
            this.refreshServer(server);
        }
    }

    void refreshServer(Server server) {
        server.content.clear();
        server.content.background(Tex.whitePane).setColor(Pal.gray);
        server.content.label(() -> Core.bundle.get("server.refreshing") + Strings.animated(Time.time, 4, 11.0f, ".")).grow().center().labelAlign(1).padBottom(4.0f);
        Vars.net.pingHost(server.ip, server.port, host -> this.setupServer(server, (Host)host), e -> {
            server.content.clear();
            server.content.background(Tex.whitePane).setColor(Pal.gray);
            server.content.add("@host.invalid").grow().center().labelAlign(1);
        });
    }

    void setupServer(Server server, Host host) {
        server.lastHost = host;
        server.content.clear();
        this.buildServer(host, server.content, false, true);
    }

    void buildServer(Host host, Table content, boolean local, boolean addName) {
        content.top().left();
        boolean isBanned = local && Vars.steam && host.description != null && host.description.equals("[banned]");
        String versionString = this.getVersionString(host) + (isBanned ? "[red]\ue817 [banned]" : "");
        float twidth = this.targetWidth() - 40.0f;
        content.background(null);
        Color color = Pal.gray;
        if (addName) {
            content.table(Tex.whiteui, t -> {
                t.left();
                t.setColor(color);
                t.add(host.name + "   " + versionString).style(Styles.outlineLabel).padLeft(10.0f).width(twidth).left().ellipsis(true);
            }).growX().height(36.0f).row();
        }
        content.table(Tex.whitePane, t -> {
            t.top().left();
            t.setColor(color);
            t.left();
            if (!host.description.isEmpty() && !isBanned) {
                int count = 0;
                StringBuilder result = new StringBuilder(host.description.length());
                for (int i = 0; i < host.description.length(); ++i) {
                    char c = host.description.charAt(i);
                    if (c == '\n') {
                        if (++count >= 3) continue;
                        result.append(c);
                        continue;
                    }
                    result.append(c);
                }
                t.add("[gray]" + result).width(twidth).left().wrap();
                t.row();
            }
            t.add("[lightgray]" + Core.bundle.format("players" + (host.players == 1 && host.playerLimit <= 0 ? ".single" : ""), (host.players == 0 ? "[lightgray]" : "[accent]") + host.players + (host.playerLimit > 0 ? "[lightgray]/[accent]" + host.playerLimit : "") + "[lightgray]")).left().row();
            t.add("[lightgray]" + Core.bundle.format("save.map", host.mapname) + "[lightgray] / " + (host.modeName == null ? host.mode.toString() : host.modeName)).width(twidth).left().ellipsis(true).row();
            if (host.ping > 0) {
                t.add("\ue819 " + host.ping + "ms").style(Styles.outlineLabel).color(Pal.gray).left();
            }
        }).growY().growX().left().bottom();
    }

    void setup() {
        this.local.clear();
        this.remote.clear();
        this.global.clear();
        float w = this.targetWidth();
        this.hosts.clear();
        this.hosts.marginBottom(70.0f);
        this.section(Vars.steam ? "@servers.local.steam" : "@servers.local", this.local, false);
        this.section("\u5b66\u672f\u529f\u80fd", new Table(t -> {
            t.button("", Styles.flatBordert, () -> {
                Core.settings.put("showAccessibleServer", !Core.settings.getBool("showAccessibleServer"));
                this.setupRemote();
            }).growX().height(48.0f).update((T b) -> b.setText((Core.settings.getBool("showAccessibleServer") ? "\u663e\u793a" : "\u9690\u85cf") + "\u7248\u672c\u4e0d\u5bf9\u7684\u670d\u52a1\u5668"));
            t.button("", Styles.flatBordert, () -> ARCVars.replayController.shouldRecord(!ARCVars.replayController.shouldRecord())).update((T b) -> b.setText(ARCVars.replayController.shouldRecord() ? "\u5173\u95ed\u56de\u653e\u5f55\u5236" : "\u5f00\u542f\u56de\u653e\u5f55\u5236")).growX().height(48.0f);
            t.button("\u52a0\u8f7d\u56de\u653e\u6587\u4ef6", Styles.flatBordert, () -> Vars.platform.showFileChooser(true, "\u6253\u5f00\u56de\u653e\u6587\u4ef6", "mrep", f -> Core.app.post(() -> ARCVars.replayController.startPlay(f.file())))).growX().height(48.0f);
            t.button("usid\u7ba1\u7406\u5668", Styles.flatBordert, () -> new USIDDialog().show()).growX().height(48.0f);
            USIDDialog.chooseUSID = Core.settings.getBool("arc-chooseUSID", false);
        }), false);
        this.section("@servers.remote", this.remote, false);
        if (Core.settings.getBool("communityservers", true)) {
            this.section("@servers.global", this.global, true);
        }
        ScrollPane pane = new ScrollPane((Element)this.hosts);
        pane.setFadeScrollBars(false);
        pane.setScrollingDisabled(true, false);
        this.setupRemote();
        this.cont.clear();
        this.cont.table((Table t) -> {
            t.add("@name").padRight(10.0f);
            t.field(Core.settings.getString("name"), text -> {
                Vars.player.name((String)text);
                Core.settings.put("name", text);
            }).grow().pad(8.0f).maxTextLength(40);
            ImageButton button = t.button(Tex.whiteui, Styles.squarei, 40.0f, () -> new PaletteDialog().show((Color color) -> {
                Vars.player.color().set((Color)color);
                Core.settings.put("color-0", color.rgba8888());
            })).size(54.0f).get();
            button.update(() -> {
                button.getStyle().imageUpColor = Vars.player.color();
            });
        }).width(w).height(70.0f).pad(4.0f);
        this.cont.row();
        this.cont.add(pane).width((w + 5.0f) * (float)this.columns() + 33.0f).pad(0.0f);
        this.cont.row();
    }

    void section(String label, Table servers, boolean eye) {
        Collapser coll = new Collapser(servers, Core.settings.getBool("collapsed-" + label, false));
        coll.setDuration(0.1f);
        this.hosts.table((Table name) -> {
            name.add(label).pad(10.0f).growX().left().color(Pal.accent);
            if (eye) {
                name.button((Drawable)Icon.eyeSmall, Styles.emptyi, () -> {
                    this.showHidden = !this.showHidden;
                    this.refreshCommunity();
                }).update((T i) -> {
                    i.getStyle().imageUp = this.showHidden ? Icon.eyeSmall : Icon.eyeOffSmall;
                }).size(40.0f).right().padRight(3.0f).tooltip("@servers.showhidden");
            }
            name.button((Drawable)Icon.downOpen, Styles.emptyi, () -> {
                coll.toggle(false);
                Core.settings.put("collapsed-" + label, coll.isCollapsed());
            }).update((T i) -> {
                i.getStyle().imageUp = !coll.isCollapsed() ? Icon.upOpen : Icon.downOpen;
            }).size(40.0f).right().padRight(10.0f);
        }).growX();
        this.hosts.row();
        this.hosts.image().growX().pad(5.0f).padLeft(10.0f).padRight(10.0f).height(3.0f).color(Pal.accent);
        this.hosts.row();
        this.hosts.add(coll).width((this.targetWidth() + 5.0f) * (float)this.columns());
        this.hosts.row();
    }

    void refreshLocal() {
        this.totalHosts = 0;
        this.local.clear();
        this.local.background(null);
        this.local.table(Tex.button, t -> t.label(() -> "[accent]" + Core.bundle.get("hosts.discovering.any") + Strings.animated(Time.time, 4, 10.0f, ".")).pad(10.0f)).growX();
        Vars.net.discoverServers(this::addLocalHost, this::finishLocalHosts);
    }

    void refreshCommunity() {
        int cur = this.refreshes;
        this.global.clear();
        this.global.background(null);
        if (!Vars.fetchedServers) {
            JoinDialog.fetchServers();
        }
        this.global.table((Table t) -> {
            t.add("@search").padRight(10.0f);
            t.field(this.serverSearch, text -> {
                this.serverSearch = text.trim().replaceAll(" +", " ").toLowerCase();
            }).grow().pad(8.0f).get().keyDown(KeyCode.enter, this::refreshCommunity);
            t.button((Drawable)Icon.zoom, Styles.emptyi, this::refreshCommunity).size(54.0f);
        }).width((this.targetWidth() + 5.0f) * (float)this.columns()).height(70.0f).pad(4.0f).row();
        Seq<ServerGroup> servers = Vars.fetchedServers ? Vars.defaultServers : this.tmpServers.clear().addAll(Vars.cachedServers).addAll(Vars.defaultServers);
        for (int i = 0; i < servers.size; ++i) {
            ServerGroup group = servers.get((i + servers.size / 2) % servers.size);
            boolean hidden = group.hidden();
            if (hidden && !this.showHidden) continue;
            Table[] groupTable = new Table[]{null, null};
            boolean favorite = group.favorite();
            if (group.prioritized) {
                this.addHeader(groupTable, group, hidden, favorite, false);
            } else if (favorite) {
                this.addHeader(groupTable, group, hidden, true, true);
            }
            for (String address : group.addresses) {
                String resaddress = address.contains(":") ? address.split(":")[0] : address;
                int resport = address.contains(":") ? Strings.parseInt(address.split(":")[1]) : 6567;
                Vars.net.pingHost(resaddress, resport, res -> {
                    if (this.refreshes != cur) {
                        return;
                    }
                    if (this.fontIgnoreDirtyTask == null) {
                        FreeTypeFontGenerator.FreeTypeFontData.ignoreDirty = true;
                        this.fontIgnoreDirtyTask = Time.runTask(36.0f, () -> {
                            FreeTypeFontGenerator.FreeTypeFontData.ignoreDirty = false;
                            this.fontIgnoreDirtyTask = null;
                        });
                    }
                    if (!(this.serverSearch.isEmpty() || group.name.toLowerCase().contains(this.serverSearch) || res.name.toLowerCase().contains(this.serverSearch) || res.description.toLowerCase().contains(this.serverSearch) || res.mapname.toLowerCase().contains(this.serverSearch) || res.modeName != null && res.modeName.toLowerCase().contains(this.serverSearch))) {
                        return;
                    }
                    if (groupTable[0] == null) {
                        this.addHeader(groupTable, group, hidden, favorite, true);
                    } else if (!groupTable[0].visible) {
                        this.addHeader(groupTable, group, hidden, favorite, true);
                    }
                    this.addCommunityHost((Host)res, groupTable[1]);
                    groupTable[0].margin(5.0f);
                    groupTable[0].pack();
                }, e -> {});
            }
        }
    }

    void addHeader(Table[] groupTable, ServerGroup group, boolean hidden, final boolean favorite, boolean doInit) {
        if (groupTable[0] == null) {
            this.global.table((Table t) -> {
                groupTable[0] = t;
            }).fillX().left().row();
        }
        groupTable[0].visible(() -> doInit);
        if (!doInit) {
            return;
        }
        groupTable[0].table((Table head) -> {
            Color col;
            Color color = col = group.prioritized ? Pal.accent : Color.lightGray;
            if (!group.name.isEmpty()) {
                head.add(group.name).color(col).padRight(4.0f);
            }
            head.image().height(3.0f).growX().color(col);
            ImageButton[] image = new ImageButton[]{null, null};
            image[0] = head.button((Drawable)Icon.star, new ImageButton.ImageButtonStyle(){
                {
                    this.imageUpColor = favorite ? Pal.accent : Color.lightGray;
                    this.imageDownColor = Color.white;
                }
            }, () -> {
                group.setFavorite(!group.favorite());
                image[0].getStyle().imageUpColor = group.favorite() ? Pal.accent : Pal.lightishGray;
            }).size(40.0f).get();
            image[0].getStyle().imageUpColor = favorite ? Pal.accent : Pal.lightishGray;
            image[1] = head.button((Drawable)(hidden ? Icon.eyeOffSmall : Icon.eyeSmall), Styles.grayi, () -> {
                group.setHidden(!group.hidden());
                Drawable drawable = image[1].getStyle().imageUp = group.hidden() ? Icon.eyeOffSmall : Icon.eyeSmall;
                if (group.hidden() && !this.showHidden) {
                    groupTable[0].remove();
                }
            }).size(40.0f).get();
            image[1].addListener(new Tooltip(t -> t.background(Styles.black6).margin(4.0f).label(() -> !group.hidden() ? "@server.shown" : "@server.hidden")));
        }).width(this.targetWidth() * (float)this.columns()).padBottom(-2.0f).row();
        groupTable[1] = groupTable[0].row().table().top().left().grow().get();
    }

    int columns() {
        return Mathf.clamp((int)((float)Core.graphics.getWidth() / Scl.scl() * 0.9f / this.targetWidth()), 1, 4);
    }

    void addCommunityHost(Host host, Table container) {
        this.global.background(null);
        String versionString = this.getVersionString(host);
        float w = this.targetWidth();
        container.left().top();
        Button[] button = new Button[]{null};
        button[0] = container.button((Button b) -> {}, (Button.ButtonStyle)this.style, () -> {
            if (button[0].childrenPressed()) {
                return;
            }
            Events.fire(new EventType.ClientPreConnectEvent(host));
            if (!Core.settings.getBool("server-disclaimer", false)) {
                Vars.ui.showCustomConfirm("@warning", "@servers.disclaimer", "@ok", "@back", () -> {
                    Core.settings.put("server-disclaimer", true);
                    this.safeConnect(host.address, host.port, host.version);
                }, () -> Core.settings.put("server-disclaimer", false));
            } else {
                this.safeConnect(host.address, host.port, host.version);
            }
        }).width(w).padBottom(7.0f).padRight(4.0f).top().left().growY().uniformY().get();
        Table inner = new Table(Tex.whiteui);
        inner.setColor(Pal.gray);
        button[0].clearChildren();
        button[0].add(inner).height(45.0f).growX();
        inner.add(host.name + "   " + versionString).left().padLeft(10.0f).wrap().style(Styles.outlineLabel).growX();
        inner.button((Drawable)Icon.add, Styles.emptyi, () -> {
            Server server = new Server();
            server.setIP(host.address + ":" + host.port);
            this.servers.add(server);
            this.saveServers();
            this.setupRemote();
            this.refreshRemote();
        }).margin(3.0f).pad(8.0f).padRight(4.0f).top().right();
        button[0].row();
        this.buildServer(host, button[0].table((Table t) -> {}).grow().get(), false, false);
        if (container.getChildren().size % this.columns() == 0) {
            container.row();
        }
    }

    void finishLocalHosts() {
        if (this.totalHosts == 0) {
            this.local.clear();
            this.local.background(Tex.button);
            this.local.add("@hosts.none").pad(10.0f);
            this.local.add().growX();
            this.local.button(Icon.refresh, this::refreshLocal).pad(-12.0f).padLeft(0.0f).size(70.0f);
        } else {
            this.local.background(null);
        }
    }

    void addLocalHost(Host host) {
        if (this.totalHosts == 0) {
            this.local.clear();
        }
        this.local.background(null);
        ++this.totalHosts;
        float w = this.targetWidth();
        if (this.local.getChildren().size % this.columns() == 0) {
            this.local.row();
        }
        this.local.button((Button b) -> this.buildServer(host, (Table)b, true, true), (Button.ButtonStyle)this.style, () -> {
            Events.fire(new EventType.ClientPreConnectEvent(host));
            this.safeConnect(host.address, host.port, host.version);
        }).width(w).top().left().growY();
    }

    public void connect(String ip, int port) {
        if (Vars.player.name.trim().isEmpty()) {
            Vars.ui.showInfo("@noname");
            return;
        }
        Vars.ui.loadfrag.show("@connecting");
        Vars.ui.loadfrag.setButton(() -> {
            Vars.ui.loadfrag.hide();
            Vars.netClient.disconnectQuietly();
        });
        if (Vars.net.client()) {
            Vars.netClient.disconnectQuietly();
        }
        Time.runTask(2.0f, () -> {
            Events.fire(new ARCEvents.Connect());
            Vars.logic.reset();
            Vars.net.reset();
            Vars.netClient.beginConnecting();
            this.lastIp = ip;
            this.lastPort = port;
            Vars.net.connect(this.lastIp, this.lastPort, () -> {
                if (Vars.net.client()) {
                    this.hide();
                    this.add.hide();
                }
            });
        });
    }

    public void reconnect() {
        if (this.lastIp == null || this.lastIp.isEmpty()) {
            return;
        }
        Vars.ui.loadfrag.show("@reconnecting");
        this.ping = Timer.schedule(() -> Vars.net.pingHost(this.lastIp, this.lastPort, host -> {
            if (this.ping == null) {
                return;
            }
            this.ping.cancel();
            this.ping = null;
            this.connect(this.lastIp, this.lastPort);
        }, exception -> {}), 1.0f, 1.0f);
        Vars.ui.loadfrag.setButton(() -> {
            Vars.ui.loadfrag.hide();
            if (this.ping == null) {
                return;
            }
            this.ping.cancel();
            this.ping = null;
        });
    }

    void safeConnect(String ip, int port, int version) {
        if (version != Version.build && Version.build != -1 && version != -1) {
            Vars.ui.showInfo("[scarlet]" + (Object)((Object)(version > Version.build ? Packets.KickReason.clientOutdated : Packets.KickReason.serverOutdated)) + "\n[]" + Core.bundle.format("server.versions", Version.build, version));
        } else {
            this.connect(ip, port);
        }
    }

    float targetWidth() {
        return Math.min((float)Core.graphics.getWidth() / Scl.scl() * 0.9f, 550.0f);
    }

    private void loadServers() {
        this.servers = Core.settings.getJson("servers", Seq.class, Server.class, Seq::new);
        if (Core.settings.has("server-list")) {
            this.servers = LegacyIO.readServers();
            Core.settings.remove("server-list");
        }
        JoinDialog.fetchServers();
    }

    public static void fetchServers() {
        String[] urls;
        String[] stringArray = urls = Version.type.equals("bleeding-edge") || Vars.forceBeServers ? Vars.serverJsonBeURLs : Vars.serverJsonURLs;
        if (Core.settings.getBool("communityservers", true)) {
            try {
                if (!Vars.loadedServerCache && Vars.serverCacheFile.exists()) {
                    Vars.loadedServerCache = true;
                    Vars.cachedServers.addAll(JoinDialog.parseServerString(Vars.serverCacheFile.readString()));
                }
            }
            catch (Exception e) {
                Log.err("Failed to load cached server file", e);
            }
            JoinDialog.fetchServers(urls, 0);
        }
    }

    private static void fetchServers(String[] urls, int index) {
        if (index >= urls.length) {
            return;
        }
        Http.get(urls[index]).error(t -> {
            if (Vars.fetchedServers) {
                return;
            }
            if (index < urls.length - 1) {
                JoinDialog.fetchServers(urls, index + 1);
            } else {
                Log.err("Failed to fetch community servers", t);
            }
        }).submit(result -> {
            if (Vars.fetchedServers) {
                return;
            }
            String text = result.getResultAsString();
            Seq<ServerGroup> servers = JoinDialog.parseServerString(text);
            Core.app.post(() -> {
                if (Vars.fetchedServers) {
                    return;
                }
                try {
                    Vars.serverCacheFile.writeString(text);
                }
                catch (Exception e) {
                    Log.err("Failed to write server cache", e);
                }
                Vars.defaultServers.addAll(servers);
                Vars.fetchedServers = true;
                Log.info("Fetched @ community servers.", Vars.defaultServers.sum(s -> s.addresses.length));
            });
        });
    }

    private static Seq<ServerGroup> parseServerString(String str) {
        Jval val = Jval.read(str);
        Seq<ServerGroup> servers = new Seq<ServerGroup>();
        val.asArray().each(child -> {
            String name = child.getString("name", "");
            boolean prioritized = child.getBool("prioritized", false);
            String[] addresses = child.has("addresses") || child.has("address") && child.get("address").isArray() ? (String[])(child.has("addresses") ? child.get("addresses") : child.get("address")).asArray().map(Jval::asString).toArray(String.class) : new String[]{child.getString("address", "<invalid>")};
            servers.add(new ServerGroup(name, addresses, prioritized));
        });
        servers.sort(s -> s.name == null ? 2.1474836E9f : (float)s.name.hashCode());
        return servers;
    }

    private void saveServers() {
        Core.settings.putJson("servers", Server.class, this.servers);
    }

    private String getVersionString(Host host) {
        return Core.bundle.format("server.version", host.version, host.versionType);
    }

    public static class Server {
        public String ip;
        public int port;
        transient Table content;
        transient Host lastHost;

        void setIP(String ip) {
            try {
                boolean isIpv6;
                boolean bl = isIpv6 = Strings.count((CharSequence)ip, ':') > 1;
                if (isIpv6 && ip.lastIndexOf("]:") != -1 && ip.lastIndexOf("]:") != ip.length() - 1) {
                    int idx = ip.indexOf("]:");
                    this.ip = ip.substring(1, idx);
                    this.port = Integer.parseInt(ip.substring(idx + 2));
                } else if (!isIpv6 && ip.lastIndexOf(58) != -1 && ip.lastIndexOf(58) != ip.length() - 1) {
                    int idx = ip.lastIndexOf(58);
                    this.ip = ip.substring(0, idx);
                    this.port = Integer.parseInt(ip.substring(idx + 1));
                } else {
                    this.ip = ip;
                    this.port = 6567;
                }
            }
            catch (Exception e) {
                this.ip = ip;
                this.port = 6567;
            }
        }

        String displayIP() {
            if (Strings.count((CharSequence)this.ip, ':') > 1) {
                return this.port != 6567 ? "[" + this.ip + "]:" + this.port : this.ip;
            }
            return this.ip + (this.port != 6567 ? ":" + this.port : "");
        }
    }
}

