/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.graphics.Color;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.scene.event.ClickListener;
import arc.scene.event.HandCursorListener;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.TextField;
import arc.scene.ui.Tooltip;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Structs;
import arc.util.Time;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.RFuncs;
import mindustry.arcModule.ui.AdvanceToolTable;
import mindustry.content.Planets;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.type.Planet;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class DatabaseDialog
extends BaseDialog {
    private TextField search;
    private Table all = new Table();
    @Nullable
    private Seq<UnlockableContent> allTabs;
    private UnlockableContent tab = Planets.sun;

    public DatabaseDialog() {
        super("@database");
        this.shouldPause = true;
        this.addCloseButton();
        this.shown(() -> {
            this.checkTabList();
            if (Vars.state.isCampaign() && this.allTabs.contains(Vars.state.getPlanet())) {
                this.tab = Vars.state.getPlanet();
            } else if (Vars.state.isGame() && Vars.state.rules.planet != null && this.allTabs.contains(Vars.state.rules.planet)) {
                this.tab = Vars.state.rules.planet;
            }
            this.rebuild();
        });
        this.onResize(this::rebuild);
        this.all.margin(20.0f).marginTop(0.0f).marginRight(30.0f);
        this.cont.top();
        this.cont.table((Table s) -> {
            s.image(Icon.zoom).padRight(8.0f);
            this.search = s.field(null, text -> this.rebuild()).growX().get();
            this.search.setMessageText("@players.search");
        }).fillX().padBottom(4.0f).row();
        this.cont.pane(this.all).scrollX(false);
        RFuncs.colorizeContent();
    }

    void checkTabList() {
        if (this.allTabs == null) {
            Seq<Content>[] allContent = Vars.content.getContentMap();
            ObjectSet<UnlockableContent> all = new ObjectSet<UnlockableContent>();
            for (Seq<Content> contents : allContent) {
                for (Content content : contents) {
                    if (!(content instanceof UnlockableContent)) continue;
                    UnlockableContent u = (UnlockableContent)content;
                    all.addAll(u.databaseTabs);
                }
            }
            this.allTabs = all.toSeq().sort();
            this.allTabs.insert(0, Planets.sun);
        }
    }

    void rebuild() {
        this.checkTabList();
        this.all.clear();
        String text = this.search.getText().toLowerCase();
        Seq<Content>[] allContent = Vars.content.getContentMap();
        this.all.table((Table t) -> {
            int i = 0;
            for (UnlockableContent content : this.allTabs) {
                Drawable drawable;
                if (content == Planets.sun) {
                    drawable = Icon.eyeSmall;
                } else if (content instanceof Planet) {
                    Planet p = (Planet)content;
                    drawable = Icon.icons.get(p.icon, Icon.commandRally);
                } else {
                    drawable = new TextureRegionDrawable(content.uiIcon);
                }
                t.button(drawable, Styles.clearNoneTogglei, 32.0f, () -> {
                    this.tab = content;
                    this.rebuild();
                }).size(50.0f).checked(b -> this.tab == content).tooltip(content == Planets.sun ? "@all" : content.localizedName).with(but -> {
                    Color color;
                    ImageButton.ImageButtonStyle imageButtonStyle = but.getStyle();
                    if (content instanceof Planet) {
                        Planet p = (Planet)content;
                        color = p.iconColor;
                    } else {
                        color = Color.white.cpy();
                    }
                    imageButtonStyle.imageUpColor = color;
                });
                if (++i % 10 != 0) continue;
                t.row();
            }
        }).row();
        for (int j = 0; j < allContent.length; ++j) {
            ContentType type = ContentType.all[j];
            Seq array = allContent[j].select(c -> {
                if (!(c instanceof UnlockableContent)) return false;
                UnlockableContent u = (UnlockableContent)c;
                if (!AdvanceToolTable.allBlocksReveal) {
                    if (u.isHidden()) return false;
                }
                if (text.isEmpty()) return true;
                if (!u.localizedName.toLowerCase().contains(text.toLowerCase())) return false;
                return true;
            }).as();
            if (array.size == 0) continue;
            if (Vars.state.isGame()) {
                array.sort(Structs.comps(Structs.comparingBool(UnlockableContent::isBanned), Structs.comparingInt(u -> u.id)));
            }
            this.all.add("@content." + type.name() + ".name").growX().left().color(ARCVars.getThemeColor());
            this.all.row();
            this.all.image().growX().pad(5.0f).padLeft(0.0f).padRight(0.0f).height(3.0f).color(ARCVars.getThemeColor());
            this.all.row();
            this.all.table((Table list) -> {
                list.left();
                int cols = (int)Mathf.clamp(((float)Core.graphics.getWidth() - Scl.scl(30.0f)) / Scl.scl(44.0f), 1.0f, 22.0f);
                int count = 0;
                for (UnlockableContent unlock : array) {
                    Image image;
                    Image image2 = this.unlocked(unlock) ? new Image((Drawable)new TextureRegionDrawable(unlock.uiIcon), Vars.mobile ? Color.white : Color.lightGray).setScaling(Scaling.fit) : (image = new Image((Drawable)Icon.lock, Pal.gray));
                    if (Vars.state.isGame() && unlock.isBanned()) {
                        list.stack(image, new Image(Icon.cancel){
                            {
                                this.setColor(Color.scarlet);
                                this.touchable = Touchable.disabled;
                            }
                        }).size(32.0f).pad(3.0f);
                    } else {
                        list.add(image).size(32.0f).pad(3.0f);
                    }
                    ClickListener listener = new ClickListener();
                    image.addListener(listener);
                    if (!Vars.mobile && this.unlocked(unlock)) {
                        image.addListener(new HandCursorListener());
                        image.update(() -> image.color.lerp(!listener.isOver() ? Color.lightGray : Color.white, Mathf.clamp(0.4f * Time.delta)));
                    }
                    if (this.unlocked(unlock)) {
                        image.clicked(() -> {
                            if (Core.input.keyDown(KeyCode.shiftLeft) && Fonts.getUnicode(unlock.name) != 0) {
                                Core.app.setClipboardText((char)Fonts.getUnicode(unlock.name) + "");
                                Vars.ui.showInfoFade("@copied");
                            } else {
                                Vars.ui.content.show(unlock);
                            }
                        });
                        image.addListener(new Tooltip(t -> t.background(Tex.button).add(unlock.localizedName + "\n[gray]" + unlock.name + (Vars.logicVars.lookupLogicId(unlock) != -1 ? " <#" + Vars.logicVars.lookupLogicId(unlock) + ">" : ""))));
                    }
                    if (++count % cols != 0) continue;
                    list.row();
                }
            }).growX().left().padBottom(10.0f);
            this.all.row();
        }
        if (this.all.getChildren().isEmpty()) {
            this.all.add("@none.found");
        }
    }

    boolean unlocked(UnlockableContent content) {
        return true;
    }
}

