/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.scene.Element;
import arc.scene.actions.Actions;
import arc.scene.style.Drawable;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.layout.Table;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import arc.util.Scaling;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.RFuncs;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Icon;
import mindustry.input.Binding;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatCat;
import mindustry.world.meta.StatValue;
import mindustry.world.meta.Stats;

public class ContentInfoDialog
extends BaseDialog {
    public ContentInfoDialog() {
        super("@info.title");
        this.addCloseButton();
        this.keyDown(key -> {
            if (key == Binding.blockInfo.value.key) {
                Core.app.post(this::hide);
            }
        });
    }

    public void show(UnlockableContent content) {
        this.cont.clear();
        Table table = new Table();
        table.margin(10.0f);
        content.checkStats();
        table.table((Table title1) -> {
            title1.image(content.uiIcon).size(48.0f).scaling(Scaling.fit).get().clicked(() -> Core.app.setClipboardText(content.emoji()));
            title1.add("[accent]" + content.localizedName + "\n[gray]" + content.name + (Vars.logicVars.lookupLogicId(content) != -1 ? " <#" + Vars.logicVars.lookupLogicId(content) + ">" : "")).padLeft(5.0f);
        });
        table.row();
        if (content.description != null) {
            boolean any;
            boolean bl = any = content.stats.toMap().size > 0;
            if (any) {
                table.add("@category.purpose").color(ARCVars.getThemeColor()).fillX().padTop(10.0f);
                table.row();
            }
            table.add("[lightgray]" + content.displayDescription()).wrap().fillX().padLeft(any ? 10.0f : 0.0f).width(500.0f).padTop(any ? 0.0f : 10.0f).left();
            table.row();
            if (!content.stats.useCategories && any) {
                table.add("@category.general").fillX().color(ARCVars.getThemeColor());
                table.row();
            }
        }
        Stats stats = content.stats;
        for (StatCat cat : stats.toMap().keys()) {
            OrderedMap map = (OrderedMap)stats.toMap().get(cat);
            if (map.size == 0) continue;
            if (stats.useCategories) {
                table.add("@category." + cat.name).color(ARCVars.getThemeColor()).fillX();
                table.row();
            }
            for (Stat stat : map.keys()) {
                table.table((Table inset) -> {
                    inset.left();
                    inset.add("[lightgray]" + stat.localized() + ":[] ").left().top();
                    Seq arr = (Seq)map.get(stat);
                    for (StatValue value : arr) {
                        value.display((Table)inset);
                        inset.add().size(10.0f);
                    }
                }).fillX().padLeft(10.0f);
                table.row();
            }
        }
        if (content.details != null) {
            table.add("[gray]" + content.details).pad(6.0f).padTop(20.0f).width(400.0f).wrap().fillX();
            table.row();
        }
        content.displayExtra(table);
        table.table((Table t) -> {
            t.row();
            t.table((Table tt) -> {
                tt.button(content.emoji(), Styles.cleart, () -> Core.app.setClipboardText(content.emoji())).width(60.0f).tooltip(content.emoji());
                tt.button((Drawable)Icon.info, Styles.clearNonei, () -> Core.app.setClipboardText(content.name)).width(50.0f).tooltip(content.name);
                tt.button((Drawable)Icon.book, Styles.clearNonei, () -> Core.app.setClipboardText(content.description)).width(50.0f).tooltip(content.description);
            });
            t.row();
            t.table((Table tt) -> {
                tt.add("\u2650");
                tt.button("\u7b80", Styles.cleart, () -> {
                    String message = this.arcItemInfo(content, false);
                    int seperator = 145;
                    int i = 0;
                    while ((float)i < (float)message.length() / (float)seperator) {
                        RFuncs.shareString(message.substring(i * seperator, Math.min(message.length(), (i + 1) * seperator)));
                        ++i;
                    }
                }).width(50.0f).disabled(!Core.settings.getBool("arcShareWaveInfo"));
                tt.button("\u8be6", Styles.cleart, () -> {
                    String message = this.arcItemInfo(content, true);
                    int seperator = 145;
                    int i = 0;
                    while ((float)i < (float)message.length() / (float)seperator) {
                        RFuncs.shareString(message.substring(i * seperator, Math.min(message.length(), (i + 1) * seperator)));
                        ++i;
                    }
                }).width(50.0f).disabled(!Core.settings.getBool("arcShareWaveInfo"));
            });
        }).fillX().padLeft(10.0f);
        ScrollPane pane = new ScrollPane((Element)table);
        table.marginRight(30.0f);
        this.cont.add(pane);
        if (this.isShown()) {
            this.show(Core.scene, Actions.fadeIn(0.0f));
        } else {
            this.show();
        }
    }

    private String arcItemInfo(UnlockableContent content, boolean description) {
        StringBuilder builder = RFuncs.getPrefix("sky", "Content");
        builder.append("\u6807\u8bb0\u4e86").append(content.localizedName).append(content.emoji());
        builder.append("(").append(content.name).append(")");
        if (content.description != null && description) {
            builder.append("\u3002\u4ecb\u7ecd: ").append(content.description);
        }
        return builder.toString();
    }
}

