/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.func.Boolc;
import arc.func.Boolp;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.CheckBox;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Table;
import mindustry.Vars;
import mindustry.game.CampaignRules;
import mindustry.game.Difficulty;
import mindustry.gen.Call;
import mindustry.gen.Tex;
import mindustry.type.Planet;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class CampaignRulesDialog
extends BaseDialog {
    Planet planet;
    Table current;

    public CampaignRulesDialog() {
        super("@campaign.difficulty");
        this.addCloseButton();
        this.hidden(() -> {
            if (this.planet != null) {
                this.planet.saveRules();
                if (Vars.state.isGame() && Vars.state.isCampaign() && Vars.state.getPlanet() == this.planet) {
                    this.planet.campaignRules.apply(this.planet, Vars.state.rules);
                    Call.setRules(Vars.state.rules);
                }
            }
        });
        this.onResize(() -> this.rebuild());
    }

    void rebuild() {
        CampaignRules rules = this.planet.campaignRules;
        this.cont.clear();
        this.cont.top().pane((Table inner) -> {
            inner.top().left().defaults().fillX().left().pad(5.0f);
            this.current = inner;
            this.current.table(Tex.button, t -> {
                t.margin(10.0f);
                ButtonGroup group = new ButtonGroup();
                TextButton.TextButtonStyle style = Styles.flatTogglet;
                t.defaults().size(140.0f, 50.0f);
                for (Difficulty diff : Difficulty.all) {
                    t.button(diff.localized(), style, () -> {
                        rules.difficulty = diff;
                    }).group(group).checked(b -> rules.difficulty == diff).tooltip(diff.info());
                    if (!Core.graphics.isPortrait() || diff.ordinal() % 2 != 1) continue;
                    t.row();
                }
            }).left().fill(false).expand(false, false).row();
            if (this.planet.allowSectorInvasion) {
                this.check("@rules.invasions", b -> {
                    rules.sectorInvasion = b;
                }, () -> rules.sectorInvasion);
            }
            this.check("@rules.fog", b -> {
                rules.fog = b;
            }, () -> rules.fog);
            this.check("@rules.showspawns", b -> {
                rules.showSpawns = b;
            }, () -> rules.showSpawns);
            this.check("@rules.randomwaveai", b -> {
                rules.randomWaveAI = b;
            }, () -> rules.randomWaveAI);
            if (this.planet.showRtsAIRule) {
                this.check("@rules.rtsai.campaign", b -> {
                    rules.rtsAI = b;
                }, () -> rules.rtsAI);
            }
            if (this.planet.allowLegacyLaunchPads) {
                // empty if block
            }
        }).growY();
    }

    public void show(Planet planet) {
        this.planet = planet;
        this.rebuild();
        this.show();
    }

    void check(String text, Boolc cons, Boolp prov) {
        this.check(text, cons, prov, () -> true);
    }

    void check(String text, Boolc cons, Boolp prov, Boolp condition) {
        String infoText = text.substring(1) + ".info";
        Cell<CheckBox> cell = this.current.check(text, cons).checked(prov.get()).update((T a) -> a.setDisabled(!condition.get()));
        if (Core.bundle.has(infoText)) {
            cell.tooltip(text + ".info");
        }
        cell.get().left();
        this.current.row();
    }
}

