/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.event.ClickListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.gen.Tex;
import mindustry.input.DesktopInput;
import mindustry.input.InputHandler;

public class Minimap
extends Table {
    private float size;
    private Element map;

    public Minimap() {
        this.background(Tex.pane);
        final float margin = 5.0f;
        this.touchable = Touchable.enabled;
        this.add(new Element(){
            {
                this.setSize(Scl.scl(140.0f));
                this.addListener(new ClickListener(KeyCode.mouseRight){

                    @Override
                    public void clicked(InputEvent event, float cx, float cy) {
                        TextureRegion region = Vars.renderer.minimap.getRegion();
                        if (region == null) {
                            return;
                        }
                        float sx = (cx - x) / width;
                        float sy = (cy - y) / height;
                        float scaledX = Mathf.lerp(region.u, region.u2, sx) * (float)Vars.world.width() * 8.0f;
                        float scaledY = Mathf.lerp(1.0f - region.v2, 1.0f - region.v, sy) * (float)Vars.world.height() * 8.0f;
                        Vars.control.input.panCamera(Tmp.v1.set(scaledX, scaledY));
                    }
                });
            }

            @Override
            public void act(float delta) {
                this.setPosition(Scl.scl(margin), Scl.scl(margin));
                super.act(delta);
            }

            @Override
            public void draw() {
                if (Vars.renderer.minimap.getRegion() == null) {
                    return;
                }
                if (!this.clipBegin()) {
                    return;
                }
                Draw.rect(Vars.renderer.minimap.getRegion(), this.x + this.width / 2.0f, this.y + this.height / 2.0f, this.width, this.height);
                if (Vars.renderer.minimap.getTexture() != null) {
                    Draw.alpha(this.parentAlpha);
                    Vars.renderer.minimap.drawEntities(this.x, this.y, this.width, this.height, Vars.renderer.minimap.getZoom(), false);
                }
                this.clipEnd();
            }
        }).size(140.0f);
        this.margin(margin);
        this.addListener(new InputListener(){

            @Override
            public boolean scrolled(InputEvent event, float x, float y, float amountx, float amounty) {
                Vars.renderer.minimap.zoomBy(amounty);
                return true;
            }
        });
        this.addListener(new ClickListener(){
            {
                this.tapSquareSize = Scl.scl(11.0f);
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                if (this.inTapSquare()) {
                    super.touchUp(event, x, y, pointer, button);
                } else {
                    this.pressed = false;
                    this.pressedPointer = -1;
                    this.pressedButton = null;
                    this.cancelled = false;
                }
            }

            @Override
            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                if (!this.inTapSquare(x, y)) {
                    this.invalidateTapSquare();
                }
                super.touchDragged(event, x, y, pointer);
                if (Vars.mobile) {
                    float max = (float)Math.min(Vars.world.width(), Vars.world.height()) / 16.0f / 2.0f;
                    Vars.renderer.minimap.setZoom(1.0f + y / Minimap.this.height * (max - 1.0f));
                }
            }

            @Override
            public void clicked(InputEvent event, float x, float y) {
                float sz = 16.0f * Vars.renderer.minimap.getZoom();
                float dx = Mathf.clamp(Core.camera.position.x / 8.0f, sz, (float)Vars.world.width() - sz);
                float dy = Mathf.clamp(Core.camera.position.y / 8.0f, sz, (float)Vars.world.height() - sz);
                float ptilex = sz * 2.0f / Minimap.this.width;
                float ptiley = sz * 2.0f / Minimap.this.height;
                Vec2 pos = Tmp.v1.set(dx, dy).sub(sz, sz).add(x * ptilex, y * ptiley).scl(8.0f);
                InputHandler inputHandler = Vars.control.input;
                if (inputHandler instanceof DesktopInput) {
                    DesktopInput input = (DesktopInput)inputHandler;
                    input.panning = true;
                }
                Core.camera.position.set(pos);
            }
        });
        this.update(() -> {
            Element e;
            if ((float)ARCVars.getMinimapSize() != this.size) {
                this.size = ARCVars.getMinimapSize();
                this.clearChildren();
                this.buildMap();
            }
            if ((e = Core.scene.getHoverElement()) != null && e.isDescendantOf(this)) {
                this.requestScroll();
            } else if (this.hasScroll()) {
                Core.scene.setScrollFocus(null);
            }
        });
    }

    private void buildMap() {
        final float margin = 5.0f;
        this.map = new Element(){
            {
                this.setSize(Scl.scl(Minimap.this.size));
            }

            @Override
            public void act(float delta) {
                this.setPosition(Scl.scl(margin), Scl.scl(margin));
                super.act(delta);
            }

            @Override
            public void draw() {
                if (Vars.renderer.minimap.getRegion() == null) {
                    return;
                }
                if (!this.clipBegin()) {
                    return;
                }
                Draw.rect(Vars.renderer.minimap.getRegion(), this.x + this.width / 2.0f, this.y + this.height / 2.0f, this.width, this.height);
                if (Vars.renderer.minimap.getTexture() != null) {
                    Draw.alpha(this.parentAlpha);
                    Vars.renderer.minimap.drawEntities(this.x, this.y, this.width, this.height, 3.0f / Vars.renderer.minimap.getZoom(), false);
                }
                this.clipEnd();
            }
        };
        this.add(this.map).size(this.size);
    }
}

