/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.Core;
import arc.audio.Sound;
import arc.func.Func;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ai.types.MissileAI;
import mindustry.arcModule.ARCVars;
import mindustry.audio.SoundLoop;
import mindustry.content.Bullets;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Effect;
import mindustry.entities.Mover;
import mindustry.entities.Predict;
import mindustry.entities.Sized;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.part.DrawPart;
import mindustry.entities.pattern.ShootPattern;
import mindustry.entities.units.UnitController;
import mindustry.entities.units.WeaponMount;
import mindustry.gen.Bullet;
import mindustry.gen.Player;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;

public class Weapon
implements Cloneable {
    public String name;
    public BulletType bullet = Bullets.placeholder;
    public Effect ejectEffect = Fx.none;
    public boolean display = true;
    public boolean useAmmo = true;
    public boolean mirror = true;
    public boolean flipSprite = false;
    public boolean alternate = true;
    public boolean rotate = false;
    public boolean showStatSprite = true;
    public float baseRotation = 0.0f;
    public boolean top = true;
    public boolean continuous;
    public boolean alwaysContinuous;
    public float aimChangeSpeed = Float.POSITIVE_INFINITY;
    public boolean controllable = true;
    public boolean aiControllable = true;
    public boolean alwaysShooting = false;
    public boolean autoTarget = false;
    public boolean predictTarget = true;
    public boolean useAttackRange = true;
    public float targetInterval = 40.0f;
    public float targetSwitchInterval = 70.0f;
    public float rotateSpeed = 20.0f;
    public float reload = 1.0f;
    public float inaccuracy = 0.0f;
    public float shake = 0.0f;
    public float recoil = 1.5f;
    public int recoils = -1;
    public float recoilTime = -1.0f;
    public float recoilPow = 1.8f;
    public float cooldownTime = 20.0f;
    public float shootX = 0.0f;
    public float shootY = 3.0f;
    public float x = 5.0f;
    public float y = 0.0f;
    public float xRand = 0.0f;
    public float yRand = 0.0f;
    public ShootPattern shoot = new ShootPattern();
    public float shadow = -1.0f;
    public float velocityRnd = 0.0f;
    public float extraVelocity = 0.0f;
    public float shootCone = 5.0f;
    public float rotationLimit = 361.0f;
    public float minWarmup = 0.0f;
    public float shootWarmupSpeed = 0.1f;
    public float smoothReloadSpeed = 0.15f;
    public boolean linearWarmup = false;
    public float soundPitchMin = 0.8f;
    public float soundPitchMax = 1.0f;
    public boolean ignoreRotation = false;
    public boolean noAttack = false;
    public float minShootVelocity = -1.0f;
    public boolean parentizeEffects;
    public int otherSide = -1;
    public float layerOffset = 0.0f;
    public Sound shootSound = Sounds.pew;
    public Sound chargeSound = Sounds.none;
    public Sound noAmmoSound = Sounds.noammo;
    public TextureRegion region;
    public TextureRegion heatRegion;
    public TextureRegion cellRegion;
    public TextureRegion outlineRegion;
    public Color heatColor = Pal.turretHeat;
    public StatusEffect shootStatus = StatusEffects.none;
    public Func<Weapon, WeaponMount> mountType = WeaponMount::new;
    public float shootStatusDuration = 300.0f;
    public boolean shootOnDeath = false;
    public Seq<DrawPart> parts = new Seq(DrawPart.class);

    public Weapon(String name) {
        this.name = name;
    }

    public Weapon() {
        this("");
    }

    public boolean hasStats(UnitType u) {
        return this.display;
    }

    public void addStats(UnitType u, Table t) {
        if (this.reload > 0.0f) {
            t.row();
            t.add("[lightgray]" + Stat.reload.localized() + ": " + (this.mirror ? "[stat]2 [lightgray]x " : "") + (this.shoot.totalShots() == 1 ? "" : "[stat]" + this.shoot.totalShots() + " [lightgray]x ") + "[stat]" + Strings.autoFixed(60.0f / this.reload, 2) + " []" + StatUnit.perSecond.localized());
        }
        t.row();
        t.add("[lightgray]\u6b66\u5668\u8303\u56f4: [stat]" + String.format("%.1f", Float.valueOf(this.bullet.range / 8.0f)) + " []\u683c");
        if (this.rotate) {
            t.row();
            t.add("[lightgray]\u65cb\u8f6c\u901f\u5ea6: [stat]" + String.format("%.0f", Float.valueOf(this.rotateSpeed * 60.0f)) + " []\u00b0/s");
            if (this.rotationLimit < 361.0f) {
                t.row();
                t.add("[lightgray]\u65cb\u8f6c\u8303\u56f4: [stat]" + String.format("%.0f", Float.valueOf(this.rotationLimit)) + " []" + StatUnit.degrees.localized());
            }
        }
        if (this.inaccuracy > 0.0f) {
            t.row();
            t.add("[lightgray]" + Stat.inaccuracy.localized() + ": [stat]" + (int)this.inaccuracy + " []" + StatUnit.degrees.localized());
        }
        if (!this.alwaysContinuous && this.reload > 0.0f && !this.bullet.killShooter) {
            t.row();
            t.add("[lightgray]" + Stat.reload.localized() + ": " + (this.mirror ? "2x " : "") + "[white]" + Strings.autoFixed(60.0f / this.reload * (float)this.shoot.shots, 2) + " " + StatUnit.perSecond.localized());
        }
        StatValues.ammo(ObjectMap.of(u, this.bullet)).display(t);
    }

    public float dps() {
        return this.bullet.estimateDPS() / this.reload * (float)this.shoot.shots * 60.0f;
    }

    public float shotsPerSec() {
        return (float)this.shoot.shots * 60.0f / this.reload;
    }

    public void drawOutline(Unit unit, WeaponMount mount) {
        if (!this.outlineRegion.found()) {
            return;
        }
        float rotation = unit.rotation - 90.0f;
        float realRecoil = Mathf.pow(mount.recoil, this.recoilPow) * this.recoil;
        float weaponRotation = rotation + (this.rotate ? mount.rotation : this.baseRotation);
        float wx = unit.x + Angles.trnsx(rotation, this.x, this.y) + Angles.trnsx(weaponRotation, 0.0f, -realRecoil);
        float wy = unit.y + Angles.trnsy(rotation, this.x, this.y) + Angles.trnsy(weaponRotation, 0.0f, -realRecoil);
        Draw.xscl = -Mathf.sign(this.flipSprite);
        Draw.alpha(0.5f);
        Draw.rect(this.outlineRegion, wx, wy, weaponRotation);
        Draw.xscl = 1.0f;
    }

    public void draw(Unit unit, WeaponMount mount) {
        boolean draw_minunithealthbar;
        float z = Draw.z();
        Draw.z(z + this.layerOffset);
        float unitTrans = (float)Core.settings.getInt("unitTransparency") / 100.0f;
        boolean draw_unit = unit.maxHealth + unit.shield > (float)Core.settings.getInt("minhealth_unitshown");
        boolean bl = draw_minunithealthbar = unit.maxHealth + unit.shield > (float)Core.settings.getInt("minhealth_unithealthbarshown");
        if (!draw_unit) {
            draw_minunithealthbar = false;
            unitTrans = 0.0f;
        }
        if (Core.settings.getBool("alwaysShowPlayerUnit") && unit.isPlayer()) {
            unitTrans = 100.0f;
            draw_minunithealthbar = true;
        }
        float rotation = unit.rotation - 90.0f;
        float realRecoil = Mathf.pow(mount.recoil, this.recoilPow) * this.recoil;
        float weaponRotation = rotation + (this.rotate ? mount.rotation : this.baseRotation);
        float wx = unit.x + Angles.trnsx(rotation, this.x, this.y) + Angles.trnsx(weaponRotation, 0.0f, -realRecoil);
        float wy = unit.y + Angles.trnsy(rotation, this.x, this.y) + Angles.trnsy(weaponRotation, 0.0f, -realRecoil);
        if (this.shadow > 0.0f) {
            Draw.alpha(unitTrans);
            Drawf.shadow(wx, wy, this.shadow, unitTrans);
        }
        if (this.top) {
            Draw.alpha(unitTrans);
            this.drawOutline(unit, mount);
        }
        if (this.parts.size > 0) {
            DrawPart.params.set(mount.warmup, mount.reload / this.reload, mount.smoothReload, mount.heat, mount.recoil, mount.charge, wx, wy, weaponRotation + 90.0f);
            DrawPart.params.sideMultiplier = this.flipSprite ? -1 : 1;
            for (int i = 0; i < this.parts.size; ++i) {
                DrawPart part = this.parts.get(i);
                DrawPart.params.setRecoil(part.recoilIndex >= 0 && mount.recoils != null ? mount.recoils[part.recoilIndex] : mount.recoil);
                if (!part.under) continue;
                unit.type.applyColor(unit);
                part.draw(DrawPart.params);
            }
        }
        float prev = Draw.xscl;
        Draw.xscl *= (float)(-Mathf.sign(this.flipSprite));
        unit.type.applyColor(unit);
        Draw.alpha(unitTrans);
        if (this.region.found()) {
            Draw.rect(this.region, wx, wy, weaponRotation);
        }
        if (this.cellRegion.found()) {
            Draw.color(unit.type.cellColor(unit));
            Draw.alpha(unitTrans);
            Draw.rect(this.cellRegion, wx, wy, weaponRotation);
            Draw.color();
        }
        if (this.heatRegion.found() && mount.heat > 0.0f) {
            Draw.alpha(unitTrans);
            Draw.color(this.heatColor, mount.heat);
            Draw.blend(Blending.additive);
            Draw.rect(this.heatRegion, wx, wy, weaponRotation);
            Draw.blend();
            Draw.color();
        }
        Draw.xscl = prev;
        if (this.parts.size > 0) {
            for (int i = 0; i < this.parts.size; ++i) {
                DrawPart part = this.parts.get(i);
                DrawPart.params.setRecoil(part.recoilIndex >= 0 && mount.recoils != null ? mount.recoils[part.recoilIndex] : mount.recoil);
                if (part.under) continue;
                unit.type.applyColor(unit);
                part.draw(DrawPart.params);
            }
        }
        Draw.xscl = 1.0f;
        if (draw_minunithealthbar && Core.settings.getBool("unitWeaponTargetLine") && mount.shoot && mount.aimX != 0.0f && mount.aimY != 0.0f && Mathf.len(mount.aimX - wx, mount.aimY - wy) <= 1200.0f) {
            Lines.stroke(1.0f);
            if (unit.controller() == Vars.player) {
                Draw.color(ARCVars.getPlayerEffectColor());
            } else {
                Draw.color(unit.team.color);
            }
            Draw.alpha(0.8f);
            Lines.line(wx, wy, mount.aimX, mount.aimY);
            if (Core.settings.getInt("unitTargetType") == 0 || !(unit.controller() instanceof Player)) {
                Lines.spikes(mount.aimX, mount.aimY, 4.0f, 4.0f, 4, (float)Math.atan((double)((mount.aimX - wx) / (mount.aimY - wy)) * 57.29577951308232) + 45.0f);
            }
            Draw.reset();
        }
        Draw.z(z);
    }

    public float range() {
        return this.bullet.range;
    }

    public void update(Unit unit, WeaponMount mount) {
        boolean can = unit.canShoot();
        float lastReload = mount.reload;
        mount.reload = Math.max(mount.reload - Time.delta * unit.reloadMultiplier, 0.0f);
        mount.recoil = Mathf.approachDelta(mount.recoil, 0.0f, unit.reloadMultiplier / this.recoilTime);
        if (this.recoils > 0) {
            if (mount.recoils == null) {
                mount.recoils = new float[this.recoils];
            }
            for (int i = 0; i < this.recoils; ++i) {
                mount.recoils[i] = Mathf.approachDelta(mount.recoils[i], 0.0f, unit.reloadMultiplier / this.recoilTime);
            }
        }
        mount.smoothReload = Mathf.lerpDelta(mount.smoothReload, mount.reload / this.reload, this.smoothReloadSpeed);
        mount.charge = mount.charging && this.shoot.firstShotDelay > 0.0f ? Mathf.approachDelta(mount.charge, 1.0f, 1.0f / this.shoot.firstShotDelay) : 0.0f;
        float warmupTarget = can && mount.shoot || this.continuous && mount.bullet != null || mount.charging ? 1.0f : 0.0f;
        mount.warmup = this.linearWarmup ? Mathf.approachDelta(mount.warmup, warmupTarget, this.shootWarmupSpeed) : Mathf.lerpDelta(mount.warmup, warmupTarget, this.shootWarmupSpeed);
        float mountX = unit.x + Angles.trnsx(unit.rotation - 90.0f, this.x, this.y);
        float mountY = unit.y + Angles.trnsy(unit.rotation - 90.0f, this.x, this.y);
        if (!this.controllable && this.autoTarget) {
            float f;
            mount.retarget -= Time.delta;
            if (f <= 0.0f) {
                mount.target = this.findTarget(unit, mountX, mountY, this.bullet.range, this.bullet.collidesAir, this.bullet.collidesGround);
                float f2 = mount.retarget = mount.target == null ? this.targetInterval : this.targetSwitchInterval;
            }
            if (mount.target != null && this.checkTarget(unit, mount.target, mountX, mountY, this.bullet.range)) {
                mount.target = null;
            }
            boolean shoot = false;
            if (mount.target != null) {
                float f3;
                Teamc teamc = mount.target;
                float f4 = this.bullet.range + Math.abs(this.shootY);
                Teamc teamc2 = mount.target;
                if (teamc2 instanceof Sized) {
                    Sized s = (Sized)((Object)teamc2);
                    f3 = s.hitSize() / 2.0f;
                } else {
                    f3 = 0.0f;
                }
                boolean bl = shoot = teamc.within(mountX, mountY, f4 + f3) && can;
                if (this.predictTarget) {
                    Vec2 to = Predict.intercept((Position)unit, mount.target, this.bullet.speed);
                    mount.aimX = to.x;
                    mount.aimY = to.y;
                } else {
                    mount.aimX = mount.target.x();
                    mount.aimY = mount.target.y();
                }
            }
            mount.shoot = mount.rotate = shoot;
        }
        if (this.rotate && (mount.rotate || mount.shoot) && can) {
            float dst;
            float axisX = unit.x + Angles.trnsx(unit.rotation - 90.0f, this.x, this.y);
            float axisY = unit.y + Angles.trnsy(unit.rotation - 90.0f, this.x, this.y);
            mount.targetRotation = Angles.angle(axisX, axisY, mount.aimX, mount.aimY) - unit.rotation;
            mount.rotation = Angles.moveToward(mount.rotation, mount.targetRotation, this.rotateSpeed * Time.delta);
            if (this.rotationLimit < 360.0f && (dst = Angles.angleDist(mount.rotation, this.baseRotation)) > this.rotationLimit / 2.0f) {
                mount.rotation = Angles.moveToward(mount.rotation, this.baseRotation, dst - this.rotationLimit / 2.0f);
            }
        } else if (!this.rotate) {
            mount.rotation = this.baseRotation;
            mount.targetRotation = unit.angleTo(mount.aimX, mount.aimY);
        }
        float weaponRotation = unit.rotation - 90.0f + (this.rotate ? mount.rotation : this.baseRotation);
        float bulletX = mountX + Angles.trnsx(weaponRotation, this.shootX, this.shootY);
        float bulletY = mountY + Angles.trnsy(weaponRotation, this.shootX, this.shootY);
        float shootAngle = this.bulletRotation(unit, mount, bulletX, bulletY);
        if (this.alwaysShooting) {
            mount.shoot = true;
        }
        if (this.continuous && mount.bullet != null) {
            if (!mount.bullet.isAdded() || mount.bullet.time >= mount.bullet.lifetime || mount.bullet.type != this.bullet) {
                mount.bullet = null;
            } else {
                float resultLength;
                mount.bullet.rotation(weaponRotation + 90.0f);
                mount.bullet.set(bulletX, bulletY);
                mount.reload = this.reload;
                mount.recoil = 1.0f;
                unit.vel.add(Tmp.v1.trns(mount.bullet.rotation() + 180.0f, mount.bullet.type.recoil * Time.delta));
                if (this.shootSound != Sounds.none && !Vars.headless) {
                    if (mount.sound == null) {
                        mount.sound = new SoundLoop(this.shootSound, 1.0f);
                    }
                    mount.sound.update(bulletX, bulletY, true);
                }
                float shootLength = Math.min(Mathf.dst(bulletX, bulletY, mount.aimX, mount.aimY), this.range());
                float curLength = Mathf.dst(bulletX, bulletY, mount.bullet.aimX, mount.bullet.aimY);
                mount.lastLength = resultLength = Mathf.approachDelta(curLength, shootLength, this.aimChangeSpeed);
                Tmp.v1.trns(shootAngle, mount.lastLength).add(bulletX, bulletY);
                mount.bullet.aimX = Tmp.v1.x;
                mount.bullet.aimY = Tmp.v1.y;
                if (this.alwaysContinuous && mount.shoot) {
                    mount.bullet.time = mount.bullet.lifetime * mount.bullet.type.optimalLifeFract * mount.warmup;
                    mount.bullet.keepAlive = true;
                    unit.apply(this.shootStatus, this.shootStatusDuration);
                }
            }
        } else {
            mount.heat = Math.max(mount.heat - Time.delta * unit.reloadMultiplier / this.cooldownTime, 0.0f);
            if (mount.sound != null) {
                mount.sound.update(bulletX, bulletY, false);
            }
        }
        boolean wasFlipped = mount.side;
        if (this.otherSide != -1 && this.alternate && mount.side == this.flipSprite && mount.reload <= this.reload / 2.0f && lastReload > this.reload / 2.0f) {
            unit.mounts[this.otherSide].side = !unit.mounts[this.otherSide].side;
            boolean bl = mount.side = !mount.side;
        }
        if (mount.shoot && can && (!this.bullet.killShooter || mount.totalShots <= 0) && (!this.useAmmo || unit.ammo > 0.0f || !Vars.state.rules.unitAmmo || unit.team.rules().infiniteAmmo) && (!this.alternate || wasFlipped == this.flipSprite) && mount.warmup >= this.minWarmup && unit.vel.len() >= this.minShootVelocity && (mount.reload <= 1.0E-4f || this.alwaysContinuous && mount.bullet == null) && (this.alwaysShooting || Angles.within(this.rotate ? mount.rotation : unit.rotation + this.baseRotation, mount.targetRotation, this.shootCone))) {
            this.shoot(unit, mount, bulletX, bulletY, shootAngle);
            mount.reload = this.reload;
            if (this.useAmmo) {
                unit.ammo -= 1.0f;
                if (unit.ammo < 0.0f) {
                    unit.ammo = 0.0f;
                }
            }
        }
    }

    protected Teamc findTarget(Unit unit, float x, float y, float range, boolean air, boolean ground) {
        return Units.closestTarget(unit.team, x, y, range + Math.abs(this.shootY), u -> u.checkTarget(air, ground), t -> ground && (unit.type.targetUnderBlocks || !t.block.underBullets));
    }

    protected boolean checkTarget(Unit unit, Teamc target, float x, float y, float range) {
        return Units.invalidateTarget(target, unit.team, x, y, range + Math.abs(this.shootY));
    }

    protected float bulletRotation(Unit unit, WeaponMount mount, float bulletX, float bulletY) {
        return this.rotate ? unit.rotation + mount.rotation : Angles.angle(bulletX, bulletY, mount.aimX, mount.aimY) + (unit.rotation - unit.angleTo(mount.aimX, mount.aimY)) + this.baseRotation;
    }

    protected void shoot(Unit unit, WeaponMount mount, float shootX, float shootY, float rotation) {
        unit.apply(this.shootStatus, this.shootStatusDuration);
        if (this.shoot.firstShotDelay > 0.0f) {
            mount.charging = true;
            this.chargeSound.at(shootX, shootY, Mathf.random(this.soundPitchMin, this.soundPitchMax));
            this.bullet.chargeEffect.at(shootX, shootY, rotation, this.bullet.keepVelocity || this.parentizeEffects ? unit : null);
        }
        this.shoot.shoot(mount.barrelCounter, (xOffset, yOffset, angle, delay, mover) -> {
            ++mount.totalShots;
            int barrel = mount.barrelCounter;
            if (delay > 0.0f) {
                Time.run(delay, () -> {
                    int prev = mount.barrelCounter;
                    mount.barrelCounter = barrel;
                    this.bullet(unit, mount, xOffset, yOffset, angle, mover);
                    mount.barrelCounter = prev;
                });
            } else {
                this.bullet(unit, mount, xOffset, yOffset, angle, mover);
            }
        }, () -> ++mount.barrelCounter);
    }

    protected void bullet(Unit unit, WeaponMount mount, float xOffset, float yOffset, float angleOffset, Mover mover) {
        Unit unit2;
        if (!unit.isAdded()) {
            return;
        }
        mount.charging = false;
        float xSpread = Mathf.range(this.xRand);
        float ySpread = Mathf.range(this.yRand);
        float weaponRotation = unit.rotation - 90.0f + (this.rotate ? mount.rotation : this.baseRotation);
        float mountX = unit.x + Angles.trnsx(unit.rotation - 90.0f, this.x, this.y);
        float mountY = unit.y + Angles.trnsy(unit.rotation - 90.0f, this.x, this.y);
        float bulletX = mountX + Angles.trnsx(weaponRotation, this.shootX + xOffset + xSpread, this.shootY + yOffset + ySpread);
        float bulletY = mountY + Angles.trnsy(weaponRotation, this.shootX + xOffset + xSpread, this.shootY + yOffset + ySpread);
        float shootAngle = this.bulletRotation(unit, mount, bulletX, bulletY) + angleOffset;
        float lifeScl = this.bullet.scaleLife ? Mathf.clamp(Mathf.dst(bulletX, bulletY, mount.aimX, mount.aimY) / this.bullet.range) : 1.0f;
        float angle = shootAngle + Mathf.range(this.inaccuracy + this.bullet.inaccuracy);
        UnitController unitController = unit.controller();
        if (unitController instanceof MissileAI) {
            MissileAI ai = (MissileAI)unitController;
            unit2 = ai.shooter;
        } else {
            unit2 = unit;
        }
        Unit shooter = unit2;
        mount.bullet = this.bullet.create(unit, shooter, unit.team, bulletX, bulletY, angle, -1.0f, 1.0f - this.velocityRnd + Mathf.random(this.velocityRnd) + this.extraVelocity, lifeScl, null, mover, mount.aimX, mount.aimY, mount.target);
        this.handleBullet(unit, mount, mount.bullet);
        if (!this.continuous) {
            this.shootSound.at(bulletX, bulletY, Mathf.random(this.soundPitchMin, this.soundPitchMax));
        }
        this.ejectEffect.at(mountX, mountY, angle * (float)Mathf.sign(this.x));
        this.bullet.shootEffect.at(bulletX, bulletY, angle, this.bullet.hitColor, unit);
        this.bullet.smokeEffect.at(bulletX, bulletY, angle, this.bullet.hitColor, unit);
        unit.vel.add(Tmp.v1.trns(shootAngle + 180.0f, this.bullet.recoil));
        Effect.shake(this.shake, this.shake, bulletX, bulletY);
        mount.recoil = 1.0f;
        if (this.recoils > 0) {
            mount.recoils[mount.barrelCounter % this.recoils] = 1.0f;
        }
        mount.heat = 1.0f;
    }

    protected void handleBullet(Unit unit, WeaponMount mount, Bullet bullet) {
        if (this.continuous) {
            float weaponRotation = unit.rotation - 90.0f + (this.rotate ? mount.rotation : this.baseRotation);
            float mountX = unit.x + Angles.trnsx(unit.rotation - 90.0f, this.x, this.y);
            float mountY = unit.y + Angles.trnsy(unit.rotation - 90.0f, this.x, this.y);
            float bulletX = mountX + Angles.trnsx(weaponRotation, this.shootX, this.shootY);
            float bulletY = mountY + Angles.trnsy(weaponRotation, this.shootX, this.shootY);
            Tmp.v1.trns(this.bulletRotation(unit, mount, bulletX, bulletY), this.shootY + mount.lastLength).add(bulletX, bulletY);
            bullet.aimX = Tmp.v1.x;
            bullet.aimY = Tmp.v1.y;
        }
    }

    public void flip() {
        this.x *= -1.0f;
        this.shootX *= -1.0f;
        this.baseRotation *= -1.0f;
        this.flipSprite = !this.flipSprite;
        this.shoot = this.shoot.copy();
        this.shoot.flip();
    }

    public Weapon copy() {
        try {
            return (Weapon)this.clone();
        }
        catch (CloneNotSupportedException suck) {
            throw new RuntimeException("very good language design", suck);
        }
    }

    public void init() {
        if (this.alwaysContinuous) {
            this.continuous = true;
        }
    }

    public void load() {
        this.region = Core.atlas.find(this.name);
        this.heatRegion = Core.atlas.find(this.name + "-heat");
        this.cellRegion = Core.atlas.find(this.name + "-cell");
        this.outlineRegion = Core.atlas.find(this.name + "-outline");
        for (DrawPart part : this.parts) {
            part.turretShading = false;
            part.load(this.name);
        }
    }

    public String toString() {
        return this.name == null || this.name.isEmpty() ? "Weapon" : "Weapon: " + this.name;
    }
}

