/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureRegion;
import arc.struct.Seq;
import arc.util.Time;
import mindustry.Vars;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.game.EventType;
import mindustry.graphics.MultiPacker;
import mindustry.logic.LAccess;
import mindustry.logic.Senseable;
import mindustry.type.Planet;
import mindustry.world.blocks.environment.OreBlock;
import mindustry.world.meta.Stat;

public class Item
extends UnlockableContent
implements Senseable {
    public Color color;
    public float explosiveness = 0.0f;
    public float flammability = 0.0f;
    public float radioactivity;
    public float charge = 0.0f;
    public int hardness = 0;
    public float cost = 1.0f;
    public float healthScaling = 0.0f;
    public boolean lowPriority;
    public int frames = 0;
    public int transitionFrames = 0;
    public float frameTime = 5.0f;
    public boolean buildable = true;
    public boolean hidden = false;

    public Item(String name, Color color) {
        super(name);
        this.color = color;
    }

    public Item(String name) {
        this(name, new Color(Color.black));
    }

    @Override
    public boolean isOnPlanet(Planet planet) {
        return super.isOnPlanet(planet) && !this.hidden;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void loadIcon() {
        super.loadIcon();
        if (this.frames > 0) {
            TextureRegion[] regions = new TextureRegion[this.frames * (this.transitionFrames + 1)];
            if (this.transitionFrames <= 0) {
                for (int i = 1; i <= this.frames; ++i) {
                    regions[i - 1] = Core.atlas.find(this.name + i);
                }
            } else {
                for (int i = 0; i < this.frames; ++i) {
                    regions[i * (this.transitionFrames + 1)] = Core.atlas.find(this.name + (i + 1));
                    for (int j = 1; j <= this.transitionFrames; ++j) {
                        int index = i * (this.transitionFrames + 1) + j;
                        regions[index] = Core.atlas.find(this.name + "-t" + index);
                    }
                }
            }
            this.fullIcon = new TextureRegion(this.fullIcon);
            this.uiIcon = new TextureRegion(this.uiIcon);
            Events.run((Object)EventType.Trigger.update, () -> {
                int frame = (int)(Time.globalTime / this.frameTime) % regions.length;
                this.fullIcon.set(regions[frame]);
                this.uiIcon.set(regions[frame]);
            });
        }
    }

    @Override
    public void setStats() {
        this.stats.addPercent(Stat.explosiveness, this.explosiveness);
        this.stats.addPercent(Stat.flammability, this.flammability);
        this.stats.addPercent(Stat.radioactivity, this.radioactivity);
        this.stats.addPercent(Stat.charge, this.charge);
        this.stats.add(Stat.cost, this.cost);
        this.stats.add(Stat.hardness, this.hardness);
        this.stats.add(Stat.healthScaling, this.healthScaling);
        this.stats.add(Stat.buildable, this.buildable);
    }

    @Override
    public String toString() {
        return this.localizedName;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.item;
    }

    @Override
    public void createIcons(MultiPacker packer) {
        super.createIcons(packer);
        if (this.frames > 0 && this.transitionFrames > 0) {
            int i;
            PixmapRegion[] pixmaps = new PixmapRegion[this.frames];
            for (i = 0; i < this.frames; ++i) {
                pixmaps[i] = Core.atlas.getPixmap(this.name + (i + 1));
            }
            for (i = 0; i < this.frames; ++i) {
                for (int j = 1; j <= this.transitionFrames; ++j) {
                    float f = (float)j / (float)(this.transitionFrames + 1);
                    int index = i * (this.transitionFrames + 1) + j;
                    Pixmap res = Pixmaps.blend(pixmaps[i], pixmaps[(i + 1) % this.frames], f);
                    packer.add(MultiPacker.PageType.main, this.name + "-t" + index, res);
                    res.dispose();
                }
            }
        }
    }

    @Override
    public double sense(LAccess sensor) {
        if (sensor == LAccess.color) {
            return this.color.toDoubleBits();
        }
        if (sensor == LAccess.id) {
            return this.getLogicId();
        }
        return Double.NaN;
    }

    @Override
    public Object senseObject(LAccess sensor) {
        if (sensor == LAccess.name) {
            return this.name;
        }
        return noSensed;
    }

    public static Seq<Item> getAllOres() {
        return Vars.content.blocks().select(b -> b instanceof OreBlock).map(b -> b.itemDrop);
    }
}

