/*
 * Decompiled with CFR 0.152.
 */
package mindustry.service;

import arc.util.OS;
import mindustry.Vars;
import mindustry.service.SStat;

public enum Achievement {
    kill1kEnemies(SStat.unitsDestroyed, 1000),
    kill100kEnemies(SStat.unitsDestroyed, 100000),
    launch100kItems(SStat.itemsLaunched, 100000),
    produce5kMin(SStat.maxProduction, 5000),
    produce50kMin(SStat.maxProduction, 50000),
    win10Attack(SStat.attacksWon, 10),
    win10PvP(SStat.pvpsWon, 10),
    defeatAttack5Waves,
    launch30Times(SStat.timesLaunched, 30),
    captureBackground,
    survive100Waves(SStat.maxWavesSurvived, 100),
    researchAll,
    shockWetEnemy,
    killEnemyPhaseWall,
    researchRouter,
    place10kBlocks(SStat.blocksBuilt, 10000),
    destroy1kBlocks(SStat.blocksDestroyed, 1000),
    overheatReactor(SStat.reactorsOverheated, 1),
    make10maps(SStat.mapsMade, 10),
    downloadMapWorkshop,
    publishMap(SStat.mapsPublished, 1),
    defeatBoss(SStat.bossesDefeated, 1),
    captureAllSectors,
    control10Sectors(SStat.sectorsControlled, 10),
    drop10kitems,
    powerupImpactReactor,
    obtainThorium,
    obtainTitanium,
    suicideBomb,
    buildGroundFactory,
    issueAttackCommand,
    active100Units(SStat.maxUnitActive, 100),
    build1000Units(SStat.unitsBuilt, 1000),
    buildAllUnits(SStat.unitTypesBuilt, 50),
    buildT5,
    pickupT5,
    active10Polys,
    dieExclusion,
    drown,
    fillCoreAllCampaign,
    hostServer10(SStat.maxPlayersServer, 10),
    buildMeltdownSpectre,
    launchItemPad,
    chainRouters,
    circleConveyor,
    becomeRouter,
    create20Schematics(SStat.schematicsCreated, 20),
    create500Schematics(SStat.schematicsCreated, 500),
    survive10WavesNoBlocks,
    captureNoBlocksBroken,
    useFlameAmmo,
    coolTurret,
    enablePixelation,
    openWiki,
    allTransportOneMap,
    buildOverdriveProjector,
    buildMendProjector,
    buildWexWater,
    have10mItems(SStat.totalCampaignItems, 10000000),
    killEclipseDuo,
    killMassDriver,
    completeErekir,
    completeSerpulo,
    launchCoreSchematic,
    nucleusGroundZero,
    neoplasmWater,
    blastFrozenUnit,
    allBlocksSerpulo,
    allBlocksErekir,
    breakForceProjector,
    researchLogic,
    negative10kPower,
    positive100kPower,
    store1milPower,
    blastGenerator,
    neoplasiaExplosion,
    installMod,
    routerLanguage,
    joinCommunityServer,
    openConsole,
    controlTurret,
    dropUnitsCoreZone,
    destroyScatterFlare,
    boostUnit,
    boostBuildingFloor,
    hoverUnitLiquid,
    break100Boulders(SStat.bouldersDeconstructed, 100),
    break10000Boulders(SStat.bouldersDeconstructed, 10000),
    shockwaveTowerUse,
    useAnimdustryEmoji;

    private final SStat stat;
    private final int statGoal;
    private boolean completed = false;
    public static final Achievement[] all;

    private Achievement(SStat stat, int goal) {
        this.stat = stat;
        this.statGoal = goal;
    }

    private Achievement() {
        this(null, 0);
    }

    public void complete() {
        if (!this.isAchieved()) {
            if (Vars.ui != null && Vars.ui.consolefrag != null && Vars.ui.consolefrag.shown() && !OS.username.equals("anuke") && this != openConsole) {
                return;
            }
            Vars.service.completeAchievement(this.name());
            Vars.service.storeStats();
        }
    }

    public void uncomplete() {
        if (this.isAchieved()) {
            Vars.service.clearAchievement(this.name());
            this.completed = false;
        }
    }

    public void removeAchieve() {
        if (Vars.service.isAchieved(this.name())) {
            Vars.service.clearAchievement(this.name());
            this.completed = false;
        }
    }

    public void checkCompletion() {
        if (!this.isAchieved() && this.stat != null && this.stat.get() >= this.statGoal) {
            this.complete();
        }
    }

    public boolean isAchieved() {
        if (this.completed) {
            return true;
        }
        this.completed = Vars.service.isAchieved(this.name());
        return this.completed;
    }

    static {
        all = Achievement.values();
    }
}

