/*
 * Decompiled with CFR 0.152.
 */
package mindustry.net;

import arc.Core;
import arc.Events;
import arc.files.Fi;
import arc.func.Boolc;
import arc.func.Boolp;
import arc.func.Cons;
import arc.func.Floatc;
import arc.func.Intc;
import arc.graphics.Color;
import arc.scene.ui.Dialog;
import arc.scene.ui.Label;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.util.Http;
import arc.util.Log;
import arc.util.OS;
import arc.util.Strings;
import arc.util.Threads;
import arc.util.Timer;
import arc.util.serialization.Jval;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.core.Version;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.io.SaveIO;
import mindustry.net.Administration;
import mindustry.net.Packets;
import mindustry.ui.Bar;
import mindustry.ui.dialogs.BaseDialog;

public class BeControl {
    private static final int updateInterval = 60;
    private boolean checkUpdates = true;
    private boolean updateAvailable = false;
    private String updateUrl;
    private String steamUrl;
    private String mobileUrl;
    private int updateBuild;
    public static String gitDownloadURL = "https://gh.tinylake.top/";
    private String patronURL = "https://afdian.net/a/Mindustry-CN-ARC";
    private String directDesktopURL;
    private String directMobileURL;
    private String directSteamURL;
    private Table beTable;
    private Table upTable;
    private TextField URLField;
    private TextField upField;
    private Label commitLabel;

    public boolean active() {
        return false;
    }

    public BeControl() {
        if (Version.arcBuild != -1) {
            this.checkUpdate(u -> {
                if (u && Core.settings.getBool("showUpdateDialog", true)) {
                    Events.on(EventType.ClientLoadEvent.class, e -> {
                        Vars.ui.showConfirm("\u68c0\u6d4b\u5230\u65b0\u7248\u5b66\u672f!\n\u6253\u5f00\u66f4\u65b0\u5217\u8868?", this::BeControlTable);
                        Timer.schedule(() -> ARCVars.arcui.LabelController.start("[violet]\u68c0\u6d4b\u5230\u65b0\u7248\u5b66\u672f!"), 5.0f);
                    });
                }
            });
        }
        if (this.active()) {
            Timer.schedule(() -> {
                if ((Vars.clientLoaded || Vars.headless) && this.checkUpdates && !Vars.mobile) {
                    this.checkUpdate(t -> {});
                }
            }, 60.0f, 60.0f);
        }
        if (OS.hasProp("becopy")) {
            try {
                Fi dest = Fi.get(OS.prop("becopy"));
                Fi self = Fi.get(BeControl.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                for (Fi file : self.parent().findAll(f -> !f.equals(self))) {
                    file.delete();
                }
                self.copyTo(dest);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void BeControlTable() {
        BaseDialog beDialog = new BaseDialog("\u81ea\u52a8\u66f4\u65b0\u8bbe\u7f6e");
        beDialog.cont.table(t -> {
            t.table(a -> {
                this.beTable = a;
            });
            if (!Vars.mobile || Core.graphics.isPortrait()) {
                t.table().width(20.0f);
                t.pane(tt -> {
                    tt.add("\u66f4\u65b0\u65e5\u5fd7").color(ARCVars.getThemeColor()).colspan(4).pad(10.0f).padTop(15.0f).padBottom(4.0f).row();
                    tt.image().color(ARCVars.getThemeColor()).fillX().height(3.0f).colspan(4).padTop(0.0f).padBottom(10.0f).row();
                    this.commitLabel = tt.labelWrap("\u52a0\u8f7d\u4e2d...").width(500.0f).get();
                });
            }
        });
        this.buildTable();
        beDialog.cont.row();
        beDialog.cont.button("\u652f\u6301\u4f5c\u8005", () -> this.donateDialog()).padTop(10.0f).width(200.0f);
        beDialog.addCloseButton();
        beDialog.show();
        if (!Vars.mobile || Core.graphics.isPortrait()) {
            this.getCommits();
        }
    }

    private void donateDialog() {
        BaseDialog dl = new BaseDialog("\u5b66\u672f\u652f\u6301\u677f");
        dl.cont.table(t -> {
            t.labelWrap("\u5f00\u53d1\u548c\u8fd0\u8425\u6211\u4eec\u7684mdt\u793e\u533a\u9700\u8981\u8d44\u91d1\uff0c\u5982\u679c\u89c9\u5f97\u5bf9\u4f60\u6709\u5e2e\u52a9\u7684\u8bdd\uff0c\u6b22\u8fce[orange]\u63d0\u4f9b\u8d5e\u52a9[]\u554a~~\n\ue805 \u63d0\u4f9b\u7684\u8d5e\u52a9\u5c06\u4f5c\u4e3a[orange]\u5b66\u672f\u7aef\u516c\u5171\u8d44\u91d1[] \ue805").width(400.0f).padBottom(10.0f).row();
            t.add("[violet]\u7528\u9014\u8bf4\u660e").padTop(10.0f).width(500.0f).row();
            t.image().color(Color.violet).width(500.0f).padTop(10.0f).padBottom(10.0f).row();
            t.labelWrap("\ue829 [acid]\u90e8\u5206\u5f00\u53d1\u4f7f\u7528\u7684\u5546\u4e1a\u8f6f\u4ef6\u53ca\u670d\u52a1[]PS.\u5982\u8bed\u97f3\u3001\u5b57\u4f53\u5305\u7b49\uff0c\u5982atri\u5305\u56e0\u4e3a\u97f3\u8d28\u4e0d\u597d\u653e\u5f03\u4e86\uff0c\u9700\u8981\u66f4\u6362\u8f83\u597d\u7684\u97f3\u8d28\u6765\u6e90\n\ue829 [acid]pvp\u8054\u8d5b\u7b56\u5212\u53ca\u5956\u54c1[]PS.\u597d\u5427\u6211\u627f\u8ba4\u4e86\uff0c\u4e4b\u524d\u8054\u8d5b\u56e0\u4e3a\u8d5e\u52a9\u4e0d\u591f\u6240\u4ee5\u4e00\u76f4\u6ca1\u5565\u5b9e\u9645\u5956\u54c1\u3002\u5982\u679c\u8d5e\u52a9\u591f\u7684\u8bdd\u4f1a\u8865\u53d1\u524d\u4e24\u5c4a\u7684\uff01\u6b3e\u5f0f\u6211\u5df2\u7ecf\u5927\u6982\u786e\u5b9a\u4e86\uff0c\u4e3a\u5b9a\u5236\u7684mdt\u5468\u8fb9\n\ue829 [acid]\u5c0f\u578b\u6d3b\u52a8\u6240\u9700[]PS.\u5982\u679c\u6709\u5269\u4f59\u7684\u8bdd\uff0c\u4f1a\u4e3e\u529e\u8d4f\u91d1\u5730\u56fe\u676f\u7b49\u5c0f\u8054\u8d5b\n\ue829 [acid]\u5176\u4ed6[]\nPS.\u5982\u679c\u91d1\u989d\u8f83\u5927\u4f1a\u5728\u7fa4\u91cc\u8bf4\u660e\n\n\u5982\u679c\u8d5e\u52a9\u7684\u91d1\u989d\u8f83\u5927\u4e5f\u53ef\u83b7\u5f97mdt\u5468\u8fb9\u54e6~").width(400.0f).left();
            t.row();
            t.add("[violet]\u652f\u6301\u8bf4\u660e").padTop(10.0f).width(500.0f).row();
            t.image().color(Color.violet).width(500.0f).padTop(10.0f).padBottom(10.0f).row();
            t.labelWrap(this.patronURL).width(400.0f).left();
            t.button("\u2650", () -> {
                if (!Core.app.openURI(this.patronURL)) {
                    Vars.ui.showErrorMessage("\u6253\u5f00\u5931\u8d25\uff0c\u7f51\u5740\u5df2\u590d\u5236\u5230\u7c98\u8d34\u677f\n\u8bf7\u81ea\u884c\u5728\u9605\u89c8\u5668\u6253\u5f00");
                    Core.app.setClipboardText(this.patronURL);
                }
            }).width(50.0f);
        }).width(400.0f);
        ((Dialog)dl).addCloseButton();
        dl.show();
    }

    private void buildTable() {
        this.beTable.clear();
        this.beTable.table(t -> t.add(this.updateAvailable ? "[violet]\uff01\uff01\uff01\u53d1\u73b0\u4e86\u65b0\u7248\u672c\uff1a" + this.updateBuild + "\uff0c\u4f60\u7684\u7248\u672c\u4e3a\uff1a" + ARCVars.arcVersion : "\u4f60\u5df2\u662f\u6700\u65b0\u7248\u672c\uff0c\u4e0d\u9700\u8981\u66f4\u65b0\uff01\u7248\u672c\u53f7" + ARCVars.arcVersion));
        this.beTable.row();
        this.beTable.add("\u955c\u50cf\u8bbe\u7f6e").color(ARCVars.getThemeColor()).colspan(4).pad(10.0f).padTop(15.0f).padBottom(4.0f).row();
        this.beTable.image().color(ARCVars.getThemeColor()).fillX().height(3.0f).colspan(4).padTop(0.0f).padBottom(10.0f).row();
        this.beTable.table(t -> {
            t.add("\u4e0b\u8f7d\u955c\u50cf\u7ad9\uff0c\u7559\u7a7a\u8868\u793a\u76f4\u8fdegithub(\u901a\u5e38\u9700\u8981\u68af\u5b50)\n\u4f60\u53ef\u9009\u62e9\u81ea\u884c\u8f93\u5165\u6216\u8005\u76f4\u63a5\u70b9\u4e0b\u9762\u7684\u53ef\u9009\u6309\u94ae\n\u8f93\u5165\u5b8c\u6210\u540e\u9700\u8981\u70b9\u51fb\u5237\u65b0\u6309\u94ae\u4ee5\u66f4\u65b0");
            t.row();
            t.table(tt -> {
                this.URLField = tt.field(gitDownloadURL, text -> {
                    gitDownloadURL = text;
                    this.updateUrl = gitDownloadURL + this.directDesktopURL;
                    this.steamUrl = gitDownloadURL + this.directSteamURL;
                    this.mobileUrl = gitDownloadURL + this.directMobileURL;
                }).width(250.0f).get();
                tt.button(Icon.refreshSmall, () -> this.buildTable());
            });
            t.row();
            t.table(tt -> {
                tt.button("wz\u955c\u50cf", () -> {
                    gitDownloadURL = "https://gh.tinylake.top/";
                    this.updateUrl = gitDownloadURL + this.directDesktopURL;
                    this.steamUrl = gitDownloadURL + this.directSteamURL;
                    this.mobileUrl = gitDownloadURL + this.directMobileURL;
                    this.buildTable();
                }).height(50.0f).width(150.0f);
                tt.button("A", () -> {
                    gitDownloadURL = "https://gh.api.99988866.xyz/";
                    this.updateUrl = gitDownloadURL + this.directDesktopURL;
                    this.steamUrl = gitDownloadURL + this.directSteamURL;
                    this.mobileUrl = gitDownloadURL + this.directMobileURL;
                    this.buildTable();
                }).height(50.0f).width(50.0f);
                tt.button("B", () -> {
                    gitDownloadURL = "https://ghproxy.com/";
                    this.updateUrl = gitDownloadURL + this.directDesktopURL;
                    this.steamUrl = gitDownloadURL + this.directSteamURL;
                    this.mobileUrl = gitDownloadURL + this.directMobileURL;
                    this.buildTable();
                }).height(50.0f).width(50.0f);
            });
        });
        if (!Vars.mobile || Core.graphics.isPortrait()) {
            this.beTable.row();
            this.beTable.add("PC\u7aef").color(ARCVars.getThemeColor()).colspan(4).pad(10.0f).padTop(15.0f).padBottom(4.0f).row();
            this.beTable.image().color(ARCVars.getThemeColor()).fillX().height(3.0f).colspan(4).padTop(0.0f).padBottom(10.0f).row();
            this.beTable.table(t -> {
                t.table(tt -> {
                    tt.field(this.updateUrl, text -> {
                        this.updateUrl = text;
                    }).width(300.0f);
                    tt.button("\u2650", () -> {
                        if (!Core.app.openURI(this.updateUrl)) {
                            Vars.ui.showErrorMessage("\u6253\u5f00\u5931\u8d25\uff0c\u7f51\u5740\u5df2\u590d\u5236\u5230\u7c98\u8d34\u677f\n\u8bf7\u81ea\u884c\u5728\u9605\u89c8\u5668\u6253\u5f00");
                            Core.app.setClipboardText(this.updateUrl);
                        }
                    }).width(50.0f);
                });
                t.row();
                t.button("PC-\u81ea\u52a8\u4e0b\u8f7d\u5b89\u88c5", () -> {
                    boolean[] cancel = new boolean[]{false};
                    float[] progress = new float[]{0.0f};
                    int[] length = new int[]{0};
                    Fi file = Vars.bebuildDirectory.child("Mindustry CN-ARC-" + this.updateBuild + ".jar");
                    Fi fileDest = OS.hasProp("becopy") ? Fi.get(OS.prop("becopy")) : Fi.get(BeControl.class.getProtectionDomain().getCodeSource().getLocation().getPath());
                    BaseDialog dialog = new BaseDialog("@be.updating");
                    this.download(this.updateUrl, file, i -> {
                        length[0] = i;
                    }, v -> {
                        progress[0] = v;
                    }, () -> cancel[0], () -> {
                        try {
                            String[] stringArray;
                            Runtime runtime = Runtime.getRuntime();
                            if (OS.isMac) {
                                String[] stringArray2 = new String[7];
                                stringArray2[0] = Vars.javaPath;
                                stringArray2[1] = "-XstartOnFirstThread";
                                stringArray2[2] = "-DlastBuild=" + Version.arcBuild;
                                stringArray2[3] = "-Dberestart";
                                stringArray2[4] = "-Dbecopy=" + fileDest.absolutePath();
                                stringArray2[5] = "-jar";
                                stringArray = stringArray2;
                                stringArray2[6] = file.absolutePath();
                            } else {
                                String[] stringArray3 = new String[6];
                                stringArray3[0] = Vars.javaPath;
                                stringArray3[1] = "-DlastBuild=" + Version.arcBuild;
                                stringArray3[2] = "-Dberestart";
                                stringArray3[3] = "-Dbecopy=" + fileDest.absolutePath();
                                stringArray3[4] = "-jar";
                                stringArray = stringArray3;
                                stringArray3[5] = file.absolutePath();
                            }
                            runtime.exec(stringArray);
                            System.exit(0);
                        }
                        catch (IOException e) {
                            Vars.ui.showException(e);
                        }
                    }, e -> {
                        dialog.hide();
                        Vars.ui.showException((Throwable)e);
                    });
                    dialog.cont.add(new Bar(() -> length[0] == 0 ? Core.bundle.get("be.updating") : (int)(progress[0] * (float)length[0]) / 1024 / 1024 + "/" + length[0] / 1024 / 1024 + " MB", () -> Pal.accent, () -> progress[0])).width(400.0f).height(70.0f);
                    dialog.buttons.button("@cancel", Icon.cancel, () -> {
                        cancel[0] = true;
                        dialog.hide();
                    }).size(210.0f, 64.0f);
                    dialog.setFillParent(false);
                    dialog.show();
                }).width(300.0f);
            });
            this.beTable.row();
            this.beTable.add("steam\u7aef").color(ARCVars.getThemeColor()).colspan(4).pad(10.0f).padTop(15.0f).padBottom(4.0f).row();
            this.beTable.image().color(ARCVars.getThemeColor()).fillX().height(3.0f).colspan(4).padTop(0.0f).padBottom(10.0f).row();
            this.beTable.table(t -> t.table(tt -> {
                tt.field(this.steamUrl, text -> {
                    this.steamUrl = text;
                }).width(300.0f);
                tt.button("\u2650", () -> {
                    if (!Core.app.openURI(this.steamUrl)) {
                        Vars.ui.showErrorMessage("\u6253\u5f00\u5931\u8d25\uff0c\u7f51\u5740\u5df2\u590d\u5236\u5230\u7c98\u8d34\u677f\n\u8bf7\u81ea\u884c\u5728\u9605\u89c8\u5668\u6253\u5f00");
                        Core.app.setClipboardText(this.steamUrl);
                    }
                }).width(50.0f);
            }));
        } else {
            this.beTable.row();
            this.beTable.add("\u68c0\u6d4b\u5230\u624b\u673a\u7ad6\u5c4f\u72b6\u6001\uff0c\u5df2\u9690\u85cf\u66f4\u65b0\u65e5\u5fd7\u53ca\u5176\u4ed6\u7aef\u4e0b\u8f7d\u94fe\u63a5\u3002\n\u5982\u9700\u663e\u793a\u8bf7\u6a2a\u5c4f\u540e\u91cd\u65b0\u6253\u5f00\u672c\u7a97\u53e3");
        }
        this.beTable.row();
        this.beTable.add("PE\u7aef").color(ARCVars.getThemeColor()).colspan(4).pad(10.0f).padTop(15.0f).padBottom(4.0f).row();
        this.beTable.image().color(ARCVars.getThemeColor()).fillX().height(3.0f).colspan(4).padTop(0.0f).padBottom(10.0f).row();
        this.beTable.table(t -> t.table(tt -> {
            tt.field(this.mobileUrl, text -> {
                this.mobileUrl = text;
            }).width(300.0f);
            tt.button("\u2650", () -> {
                if (!Core.app.openURI(this.mobileUrl)) {
                    Vars.ui.showErrorMessage("\u6253\u5f00\u5931\u8d25\uff0c\u7f51\u5740\u5df2\u590d\u5236\u5230\u7c98\u8d34\u677f\n\u8bf7\u81ea\u884c\u5728\u9605\u89c8\u5668\u6253\u5f00");
                    Core.app.setClipboardText(this.mobileUrl);
                }
            }).width(50.0f);
        }));
    }

    public void checkUpdate(Boolc done) {
        Http.get("https://api.github.com/repos/Jackson11500/Mindustry-CN-ARC-Builds/releases/latest").error(e -> Core.app.post(() -> done.get(false))).submit(res -> {
            Jval val = Jval.read(res.getResultAsString());
            int newBuild = Strings.parseInt(val.getString("tag_name", "0"));
            if (newBuild > Version.arcBuild) {
                Jval asset = val.get("assets").asArray().find(v -> v.getString("name", "").startsWith("Mindustry-CN-ARC-Desktop"));
                this.directDesktopURL = asset.getString("browser_download_url", "");
                String url = gitDownloadURL + "/" + asset.getString("browser_download_url", "");
                this.updateAvailable = true;
                this.updateBuild = newBuild;
                this.updateUrl = url;
                Jval steamAsset = val.get("assets").asArray().find(v -> v.getString("name", "").startsWith("Mindustry-CN-ARC-Steam"));
                this.directSteamURL = steamAsset.getString("browser_download_url", "");
                this.steamUrl = gitDownloadURL + "/" + asset.getString("browser_download_url", "");
                Jval mobileAsset = val.get("assets").asArray().find(v -> v.getString("name", "").startsWith("Mindustry-CN-ARC-Android"));
                this.directMobileURL = mobileAsset.getString("browser_download_url", "");
                this.mobileUrl = gitDownloadURL + "/" + mobileAsset.getString("browser_download_url", "");
                Core.app.post(() -> done.get(true));
            } else {
                Core.app.post(() -> done.get(false));
            }
        });
    }

    public void getCommits() {
        StringBuilder commits = new StringBuilder();
        Http.get("https://api.github.com/repos/CN-ARC/Mindustry-CN-ARC/commits").submit(res -> {
            Jval val = Jval.read(res.getResultAsString());
            Jval.JsonArray list = val.asArray();
            Core.app.post(() -> {
                list.each(commit -> {
                    String time = commit.get("commit").get("author").getString("date");
                    String author = commit.get("commit").get("author").getString("name");
                    String content = commit.get("commit").getString("message");
                    commits.append("[#008000]").append(time);
                    for (int i = time.length(); i < 30; ++i) {
                        commits.append(" ");
                    }
                    commits.append("[#1E90FF]").append(author);
                    commits.append("\n");
                    commits.append("[white]").append(content);
                    commits.append("\n");
                });
                this.commitLabel.setText(commits.toString());
            });
        });
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public void showUpdateDialog() {
        if (!this.updateAvailable) {
            return;
        }
        if (!Vars.headless) {
            this.checkUpdates = false;
            Vars.ui.showCustomConfirm("\uff01\uff01\uff01\u53d1\u73b0\u4e86\u65b0\u7248\u672c\uff1a" + this.updateBuild, "@be.update.confirm", "@ok", "@be.ignore", () -> {
                try {
                    if (Vars.mobile) {
                        if (!Core.app.openURI(this.mobileUrl)) {
                            Vars.ui.showErrorMessage("\u6253\u5f00\u5931\u8d25\uff0c\u7f51\u5740\u5df2\u590d\u5236\u5230\u7c98\u8d34\u677f\n\u8bf7\u81ea\u884c\u5728\u9605\u89c8\u5668\u6253\u5f00");
                            Core.app.setClipboardText(this.mobileUrl);
                        }
                        return;
                    }
                    boolean[] cancel = new boolean[]{false};
                    float[] progress = new float[]{0.0f};
                    int[] length = new int[]{0};
                    Fi file = Vars.bebuildDirectory.child("Mindustry CN-ARC-" + this.updateBuild + ".jar");
                    Fi fileDest = OS.hasProp("becopy") ? Fi.get(OS.prop("becopy")) : Fi.get(BeControl.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                    BaseDialog dialog = new BaseDialog("@be.updating");
                    this.download(this.updateUrl, file, i -> {
                        length[0] = i;
                    }, v -> {
                        progress[0] = v;
                    }, () -> cancel[0], () -> {
                        try {
                            String[] stringArray;
                            Runtime runtime = Runtime.getRuntime();
                            if (OS.isMac) {
                                String[] stringArray2 = new String[7];
                                stringArray2[0] = Vars.javaPath;
                                stringArray2[1] = "-XstartOnFirstThread";
                                stringArray2[2] = "-DlastBuild=" + Version.arcBuild;
                                stringArray2[3] = "-Dberestart";
                                stringArray2[4] = "-Dbecopy=" + fileDest.absolutePath();
                                stringArray2[5] = "-jar";
                                stringArray = stringArray2;
                                stringArray2[6] = file.absolutePath();
                            } else {
                                String[] stringArray3 = new String[6];
                                stringArray3[0] = Vars.javaPath;
                                stringArray3[1] = "-DlastBuild=" + Version.arcBuild;
                                stringArray3[2] = "-Dberestart";
                                stringArray3[3] = "-Dbecopy=" + fileDest.absolutePath();
                                stringArray3[4] = "-jar";
                                stringArray = stringArray3;
                                stringArray3[5] = file.absolutePath();
                            }
                            runtime.exec(stringArray);
                            System.exit(0);
                        }
                        catch (IOException e) {
                            Vars.ui.showException(e);
                        }
                    }, e -> {
                        dialog.hide();
                        Vars.ui.showException((Throwable)e);
                    });
                    dialog.cont.add(new Bar(() -> length[0] == 0 ? Core.bundle.get("be.updating") : (int)(progress[0] * (float)length[0]) / 1024 / 1024 + "/" + length[0] / 1024 / 1024 + " MB", () -> Pal.accent, () -> progress[0])).width(400.0f).height(70.0f);
                    dialog.buttons.button("@cancel", Icon.cancel, () -> {
                        cancel[0] = true;
                        dialog.hide();
                    }).size(210.0f, 64.0f);
                    dialog.setFillParent(false);
                    dialog.show();
                }
                catch (Exception e2) {
                    Vars.ui.showException(e2);
                }
            }, () -> {
                this.checkUpdates = false;
            });
        } else {
            Log.info("&lcA new update is available: &lyBleeding Edge build @", this.updateBuild);
            if (Administration.Config.autoUpdate.bool()) {
                Log.info("&lcAuto-downloading next version...");
                try {
                    Fi source = Fi.get(BeControl.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                    Fi dest = source.sibling("server-be-" + this.updateBuild + ".jar");
                    this.download(this.updateUrl, dest, len -> Core.app.post(() -> Log.info("&ly| Size: @ MB.", Strings.fixed((float)len / 1024.0f / 1024.0f, 2))), progress -> {}, () -> false, () -> Core.app.post(() -> {
                        Log.info("&lcSaving...");
                        SaveIO.save(Vars.saveDirectory.child("autosavebe.msav"));
                        Log.info("&lcAutosaved.");
                        Vars.netServer.kickAll(Packets.KickReason.serverRestarting);
                        Threads.sleep(32L);
                        Log.info("&lcVersion downloaded, exiting. Note that if you are not using a auto-restart script, the server will not restart automatically.");
                        dest.copyTo(source);
                        dest.delete();
                        System.exit(2);
                    }), Throwable::printStackTrace);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.checkUpdates = false;
        }
    }

    private void download(String furl, Fi dest, Intc length, Floatc progressor, Boolp canceled, Runnable done, Cons<Throwable> error) {
        Vars.mainExecutor.submit(() -> {
            try {
                int x;
                HttpURLConnection con = (HttpURLConnection)new URL(furl).openConnection();
                BufferedInputStream in = new BufferedInputStream(con.getInputStream());
                OutputStream out = dest.write(false, 4096);
                byte[] data = new byte[4096];
                long size = con.getContentLength();
                long counter = 0L;
                length.get((int)size);
                while ((x = in.read(data, 0, data.length)) >= 0 && !canceled.get()) {
                    progressor.get((float)(counter += (long)x) / (float)size);
                    out.write(data, 0, x);
                }
                out.close();
                in.close();
                if (!canceled.get()) {
                    done.run();
                }
            }
            catch (Throwable e) {
                error.get(e);
            }
        });
    }
}

