/*
 * Decompiled with CFR 0.152.
 */
package mindustry.net;

import arc.Core;
import arc.Events;
import arc.func.Cons;
import arc.func.Prov;
import arc.math.WindowedMean;
import arc.net.ArcNet;
import arc.net.Client;
import arc.net.Connection;
import arc.net.DcReason;
import arc.net.FrameworkMessage;
import arc.net.InputStreamSender;
import arc.net.NetListener;
import arc.net.NetSerializer;
import arc.net.Server;
import arc.net.dns.ArcDns;
import arc.net.dns.SRVRecord;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Threads;
import arc.util.Time;
import arc.util.io.ByteBufferInput;
import arc.util.io.ByteBufferOutput;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.util.concurrent.CopyOnWriteArrayList;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.game.EventType;
import mindustry.net.Administration;
import mindustry.net.Host;
import mindustry.net.Net;
import mindustry.net.NetConnection;
import mindustry.net.NetworkIO;
import mindustry.net.Packet;
import mindustry.net.Packets;
import mindustry.net.Streamable;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

public class ArcNetProvider
implements Net.NetProvider {
    final Client client;
    final Prov<DatagramPacket> packetSupplier = () -> new DatagramPacket(new byte[512], 512);
    final Server server;
    final CopyOnWriteArrayList<ArcConnection> connections = new CopyOnWriteArrayList();
    Thread serverThread;
    private static final LZ4FastDecompressor decompressor = LZ4Factory.fastestInstance().fastDecompressor();
    private static final LZ4Compressor compressor = LZ4Factory.fastestInstance().fastCompressor();
    private volatile int playerLimitCache;
    private volatile int packetSpamLimit;

    public ArcNetProvider() {
        ArcNet.errorHandler = e -> {
            Throwable finalCause;
            if (Log.level == Log.LogLevel.debug && !"Connection is closed.".equals((finalCause = Strings.getFinalCause(e)).getMessage())) {
                Log.debug(Strings.getStackTrace(e));
            }
        };
        Events.run((Object)EventType.Trigger.update, () -> {
            this.playerLimitCache = Vars.netServer.admins.getPlayerLimit();
            this.packetSpamLimit = Administration.Config.packetSpamLimit.num();
        });
        this.client = new Client(16384, 16384, new PacketSerializer());
        this.client.setDiscoveryPacket(this.packetSupplier);
        this.client.addListener(new NetListener(){

            @Override
            public void connected(Connection connection) {
                Packets.Connect c = new Packets.Connect();
                c.addressTCP = connection.getRemoteAddressTCP().getAddress().getHostAddress();
                if (connection.getRemoteAddressTCP() != null) {
                    c.addressTCP = connection.getRemoteAddressTCP().toString();
                }
                Core.app.post(() -> Vars.net.handleClientReceived(c));
            }

            @Override
            public void disconnected(Connection connection, DcReason reason) {
                if (connection.getLastProtocolError() != null) {
                    Vars.netClient.setQuiet();
                }
                Packets.Disconnect c = new Packets.Disconnect();
                c.reason = reason.toString();
                Core.app.post(() -> Vars.net.handleClientReceived(c));
            }

            @Override
            public void received(Connection connection, Object object) {
                if (!(object instanceof Packet)) {
                    return;
                }
                Packet p = (Packet)object;
                Core.app.post(() -> {
                    try {
                        Vars.net.handleClientReceived(p);
                    }
                    catch (Throwable e) {
                        Vars.net.handleException(e);
                    }
                });
            }
        });
        this.server = new Server(32768, 16384, new PacketSerializer());
        this.server.setMulticast("227.2.7.7", 20151);
        this.server.setDiscoveryHandler((address, handler) -> {
            ByteBuffer buffer = NetworkIO.writeServerData();
            int length = buffer.position();
            buffer.position(0);
            buffer.limit(length);
            handler.respond(buffer);
        });
        this.server.addListener(new NetListener(){

            @Override
            public void connected(Connection connection) {
                String ip = connection.getRemoteAddressTCP().getAddress().getHostAddress();
                if (ArcNetProvider.this.playerLimitCache > 0 && ArcNetProvider.this.server.getConnections().length > ArcNetProvider.this.playerLimitCache || Vars.netServer.admins.isDosBlacklisted(ip)) {
                    Log.info("Closing connection @ - IP marked as a potential DOS attack.", ip);
                    connection.close(DcReason.closed);
                    return;
                }
                ArcConnection kn = new ArcConnection(ip, connection);
                Packets.Connect c = new Packets.Connect();
                c.addressTCP = ip;
                Log.debug("&bReceived connection: @", c.addressTCP);
                connection.setArbitraryData(kn);
                ArcNetProvider.this.connections.add(kn);
                Core.app.post(() -> Vars.net.handleServerReceived(kn, c));
            }

            @Override
            public void disconnected(Connection connection, DcReason reason) {
                Object object = connection.getArbitraryData();
                if (!(object instanceof ArcConnection)) {
                    return;
                }
                ArcConnection k = (ArcConnection)object;
                Packets.Disconnect c = new Packets.Disconnect();
                c.reason = reason.toString();
                Core.app.post(() -> {
                    Vars.net.handleServerReceived(k, c);
                    ArcNetProvider.this.connections.remove(k);
                });
            }

            @Override
            public void received(Connection connection, Object object) {
                Object object2 = connection.getArbitraryData();
                if (!(object2 instanceof ArcConnection)) {
                    return;
                }
                ArcConnection k = (ArcConnection)object2;
                if (ArcNetProvider.this.packetSpamLimit > 0 && !k.packetRate.allow(3000L, ArcNetProvider.this.packetSpamLimit)) {
                    Log.warn("Blacklisting IP '@' as potential DOS attack - packet spam.", k.address);
                    connection.close(DcReason.closed);
                    Vars.netServer.admins.blacklistDos(k.address);
                    return;
                }
                if (!(object instanceof Packet)) {
                    return;
                }
                Packet pack = (Packet)object;
                Core.app.post(() -> {
                    try {
                        Vars.net.handleServerReceived(k, pack);
                    }
                    catch (Throwable e) {
                        Log.err(e);
                    }
                });
            }
        });
    }

    @Override
    public void setConnectFilter(Server.ServerConnectFilter connectFilter) {
        this.server.setConnectFilter(connectFilter);
    }

    @Override
    @Nullable
    public Server.ServerConnectFilter getConnectFilter() {
        return this.server.getConnectFilter();
    }

    private static boolean isLocal(InetAddress addr) {
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void connectClient(String ip, int port, Runnable success) {
        Threads.daemon(() -> {
            block2: {
                try {
                    this.client.stop();
                    Threads.daemon("Net Client", () -> {
                        block2: {
                            try {
                                this.client.run();
                            }
                            catch (Exception e) {
                                if (e instanceof ClosedSelectorException) break block2;
                                Vars.net.handleException(e);
                            }
                        }
                    });
                    this.client.connect(5000, ip, port, port);
                    success.run();
                }
                catch (Exception e) {
                    if (!Vars.netClient.isConnecting()) break block2;
                    Vars.net.handleException(e);
                }
            }
        });
    }

    @Override
    public void disconnectClient() {
        this.client.close();
    }

    @Override
    public void sendClient(Object object, boolean reliable) {
        if (ARCVars.replaying) {
            return;
        }
        try {
            if (reliable) {
                this.client.sendTCP(object);
            } else {
                this.client.sendUDP(object);
            }
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            Vars.net.showError(e);
        }
    }

    @Override
    public void pingHost(String address, int port, Cons<Host> valid, Cons<Exception> invalid) {
        try {
            Host host = this.pingHostImpl(address, port);
            Core.app.post(() -> valid.get(host));
        }
        catch (IOException e) {
            if (port == 6567) {
                for (SRVRecord record : ArcDns.getSrvRecords("_mindustry._tcp." + address)) {
                    try {
                        Host host = this.pingHostImpl(record.target, record.port);
                        Core.app.post(() -> valid.get(host));
                        return;
                    }
                    catch (IOException iOException) {
                    }
                }
            }
            Core.app.post(() -> invalid.get(e));
        }
    }

    private Host pingHostImpl(String address, int port) throws IOException {
        try (DatagramSocket socket = new DatagramSocket();){
            long time = Time.millis();
            socket.send(new DatagramPacket(new byte[]{-2, 1}, 2, InetAddress.getByName(address), port));
            socket.setSoTimeout(2000);
            DatagramPacket packet = this.packetSupplier.get();
            socket.receive(packet);
            ByteBuffer buffer = ByteBuffer.wrap(packet.getData());
            Host host = NetworkIO.readServerData((int)Time.timeSinceMillis(time), packet.getAddress().getHostAddress(), buffer);
            host.port = port;
            Host host2 = host;
            return host2;
        }
    }

    @Override
    public void discoverServers(Cons<Host> callback, Runnable done) {
        Seq foundAddresses = new Seq();
        long time = Time.millis();
        this.client.discoverHosts(6567, "227.2.7.7", 20151, 3000, packet -> {
            Seq seq = foundAddresses;
            synchronized (seq) {
                try {
                    if (foundAddresses.contains(address -> address.equals(packet.getAddress()) || ArcNetProvider.isLocal(address) && ArcNetProvider.isLocal(packet.getAddress()))) {
                        return;
                    }
                    ByteBuffer buffer = ByteBuffer.wrap(packet.getData());
                    Host host = NetworkIO.readServerData((int)Time.timeSinceMillis(time), packet.getAddress().getHostAddress(), buffer);
                    Core.app.post(() -> callback.get(host));
                    foundAddresses.add(packet.getAddress());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, () -> Core.app.post(done));
    }

    @Override
    public void dispose() {
        this.disconnectClient();
        this.closeServer();
        try {
            this.client.dispose();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Iterable<ArcConnection> getConnections() {
        return this.connections;
    }

    @Override
    public void hostServer(int port) throws IOException {
        this.connections.clear();
        this.server.bind(port, port);
        this.serverThread = new Thread(() -> {
            block2: {
                try {
                    this.server.run();
                }
                catch (Throwable e) {
                    if (e instanceof ClosedSelectorException) break block2;
                    Threads.throwAppException(e);
                }
            }
        }, "Net Server");
        this.serverThread.setDaemon(true);
        this.serverThread.start();
    }

    @Override
    public void closeServer() {
        this.connections.clear();
        Vars.mainExecutor.submit(this.server::stop);
    }

    public static class PacketSerializer
    implements NetSerializer {
        private static final boolean debug = false;
        ThreadLocal<ByteBuffer> decompressBuffer = Threads.local(() -> ByteBuffer.allocate(32768));
        ThreadLocal<Reads> reads = Threads.local(() -> new Reads(new ByteBufferInput(this.decompressBuffer.get())));
        ThreadLocal<Writes> writes = Threads.local(() -> new Writes(new ByteBufferOutput(this.decompressBuffer.get())));
        static WindowedMean upload = new WindowedMean(5);
        static WindowedMean download = new WindowedMean(5);
        static long lastUpload;
        static long lastDownload;
        static long uploadAccum;
        static long downloadAccum;
        static int lastPos;

        @Override
        public Object read(ByteBuffer byteBuffer) {
            byte id = byteBuffer.get();
            if (id == -2) {
                return this.readFramework(byteBuffer);
            }
            Object packet = Net.newPacket(id);
            ByteBuffer buffer = this.decompressBuffer.get();
            int length = byteBuffer.getShort() & 0xFFFF;
            byte compression = byteBuffer.get();
            if (compression == 0) {
                buffer.position(0).limit(length);
                buffer.put(byteBuffer.array(), byteBuffer.position(), length);
                buffer.position(0);
                ((Packet)packet).read(this.reads.get(), length);
                byteBuffer.position(byteBuffer.position() + buffer.position());
            } else {
                int read = decompressor.decompress(byteBuffer, byteBuffer.position(), buffer, 0, length);
                buffer.position(0);
                buffer.limit(length);
                ((Packet)packet).read(this.reads.get(), length);
                byteBuffer.position(byteBuffer.position() + read);
            }
            return packet;
        }

        @Override
        public void write(ByteBuffer byteBuffer, Object o) {
            if (o instanceof ByteBuffer) {
                ByteBuffer raw = (ByteBuffer)o;
                byteBuffer.put(raw);
            } else if (o instanceof FrameworkMessage) {
                FrameworkMessage msg = (FrameworkMessage)o;
                byteBuffer.put((byte)-2);
                this.writeFramework(byteBuffer, msg);
            } else {
                if (!(o instanceof Packet)) {
                    throw new RuntimeException("All sent objects must extend Packet! Class: " + o.getClass());
                }
                Packet pack = (Packet)o;
                byte id = Net.getPacketId(pack);
                byteBuffer.put(id);
                ByteBuffer temp = this.decompressBuffer.get();
                temp.position(0);
                temp.limit(temp.capacity());
                pack.write(this.writes.get());
                short length = (short)temp.position();
                byteBuffer.putShort(length);
                if (length < 36 || pack instanceof Packets.StreamChunk) {
                    byteBuffer.put((byte)0);
                    byteBuffer.put(temp.array(), 0, length);
                } else {
                    byteBuffer.put((byte)1);
                    int written = compressor.compress(temp, 0, temp.position(), byteBuffer, byteBuffer.position(), byteBuffer.remaining());
                    byteBuffer.position(byteBuffer.position() + written);
                }
            }
        }

        public void writeFramework(ByteBuffer buffer, FrameworkMessage message) {
            if (message instanceof FrameworkMessage.Ping) {
                FrameworkMessage.Ping p = (FrameworkMessage.Ping)message;
                buffer.put((byte)0);
                buffer.putInt(p.id);
                buffer.put(p.isReply ? (byte)1 : 0);
            } else if (message instanceof FrameworkMessage.DiscoverHost) {
                buffer.put((byte)1);
            } else if (message instanceof FrameworkMessage.KeepAlive) {
                buffer.put((byte)2);
            } else if (message instanceof FrameworkMessage.RegisterUDP) {
                FrameworkMessage.RegisterUDP p = (FrameworkMessage.RegisterUDP)message;
                buffer.put((byte)3);
                buffer.putInt(p.connectionID);
            } else if (message instanceof FrameworkMessage.RegisterTCP) {
                FrameworkMessage.RegisterTCP p = (FrameworkMessage.RegisterTCP)message;
                buffer.put((byte)4);
                buffer.putInt(p.connectionID);
            }
        }

        public FrameworkMessage readFramework(ByteBuffer buffer) {
            byte id = buffer.get();
            if (id == 0) {
                FrameworkMessage.Ping p = new FrameworkMessage.Ping();
                p.id = buffer.getInt();
                p.isReply = buffer.get() == 1;
                return p;
            }
            if (id == 1) {
                return FrameworkMessage.discoverHost;
            }
            if (id == 2) {
                return FrameworkMessage.keepAlive;
            }
            if (id == 3) {
                FrameworkMessage.RegisterUDP p = new FrameworkMessage.RegisterUDP();
                p.connectionID = buffer.getInt();
                return p;
            }
            if (id == 4) {
                FrameworkMessage.RegisterTCP p = new FrameworkMessage.RegisterTCP();
                p.connectionID = buffer.getInt();
                return p;
            }
            throw new RuntimeException("Unknown framework message!");
        }
    }

    class ArcConnection
    extends NetConnection {
        public final Connection connection;

        public ArcConnection(String address, Connection connection) {
            super(address);
            this.connection = connection;
        }

        @Override
        public boolean isConnected() {
            return this.connection.isConnected();
        }

        @Override
        public void sendStream(final Streamable stream) {
            this.connection.addListener(new InputStreamSender(stream.stream, 1024){
                int id;

                @Override
                protected void start() {
                    Packets.StreamBegin begin = new Packets.StreamBegin();
                    begin.total = stream.stream.available();
                    begin.type = Net.getPacketId(stream);
                    ArcConnection.this.connection.sendTCP(begin);
                    this.id = begin.id;
                }

                @Override
                protected Object next(byte[] bytes) {
                    Packets.StreamChunk chunk = new Packets.StreamChunk();
                    chunk.id = this.id;
                    chunk.data = bytes;
                    return chunk;
                }
            });
        }

        @Override
        public void send(Object object, boolean reliable) {
            block5: {
                try {
                    if (this.connection.isConnected()) {
                        if (reliable) {
                            this.connection.sendTCP(object);
                        } else {
                            this.connection.sendUDP(object);
                        }
                    }
                }
                catch (Exception e) {
                    Log.err(e);
                    Log.info("Error sending packet. Disconnecting invalid client!");
                    this.connection.close(DcReason.error);
                    Object object2 = this.connection.getArbitraryData();
                    if (!(object2 instanceof ArcConnection)) break block5;
                    ArcConnection k = (ArcConnection)object2;
                    ArcNetProvider.this.connections.remove(k);
                }
            }
        }

        @Override
        public void close() {
            if (this.connection.isConnected()) {
                this.connection.close(DcReason.closed);
            }
        }
    }
}

