/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.generators;

import arc.Core;
import arc.func.Boolf;
import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Vec3;
import arc.struct.ObjectIntMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.noise.Simplex;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Liquids;
import mindustry.content.Weathers;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Rules;
import mindustry.graphics.g3d.HexMesher;
import mindustry.maps.generators.BasicGenerator;
import mindustry.type.Liquid;
import mindustry.type.Sector;
import mindustry.type.Weather;
import mindustry.ui.Fonts;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.TileGen;
import mindustry.world.Tiles;
import mindustry.world.blocks.environment.Floor;

public abstract class PlanetGenerator
extends BasicGenerator
implements HexMesher {
    public int baseSeed = 0;
    public int seed = 0;
    @Nullable
    protected Sector sector;

    public void generateSector(Sector sector) {
    }

    public void onSectorCaptured(Sector sector) {
    }

    public void onSectorLost(Sector sector) {
    }

    public void beforeSaveWrite(Sector sector) {
    }

    public void getLockedText(Sector hovered, StringBuilder out) {
        out.append("[gray]").append('\ue88d').append(" ").append(Core.bundle.get("locked"));
    }

    @Nullable
    public TextureRegion getLockedIcon(Sector hovered) {
        return hovered.preset == null && !hovered.planet.allowLaunchToNumbered ? null : Fonts.getLargeIcon("lock");
    }

    public boolean allowLanding(Sector sector) {
        return sector.planet.allowLaunchToNumbered && (sector.hasBase() || sector.near().contains((Sector)((Object)((Boolf<Sector>)Sector::hasBase))));
    }

    public boolean allowAcceleratorLanding(Sector sector) {
        return sector.planet.allowLaunchToNumbered;
    }

    public void addWeather(Sector sector, Rules rules) {
        boolean hasSpores;
        ObjectIntMap<Floor> floorc = new ObjectIntMap<Floor>();
        ObjectSet<UnlockableContent> content = new ObjectSet<UnlockableContent>();
        for (Tile tile : Vars.world.tiles) {
            if (Vars.world.getDarkness(tile.x, tile.y) >= 3.0f) continue;
            Liquid liquid = tile.floor().liquidDrop;
            if (tile.floor().itemDrop != null) {
                content.add(tile.floor().itemDrop);
            }
            if (tile.overlay().itemDrop != null) {
                content.add(tile.overlay().itemDrop);
            }
            if (liquid != null) {
                content.add(liquid);
            }
            if (tile.block().isStatic()) continue;
            floorc.increment(tile.floor());
            if (tile.overlay() == Blocks.air) continue;
            floorc.increment(tile.overlay());
        }
        Seq entries = floorc.entries().toArray();
        entries.sort(e -> -e.value);
        entries.removeAll(e -> e.value < 30);
        Block[] floors = new Block[entries.size];
        for (int i = 0; i < entries.size; ++i) {
            floors[i] = (Block)entries.get((int)i).key;
        }
        boolean hasSnow = floors.length > 0 && (floors[0].name.contains("ice") || floors[0].name.contains("snow"));
        boolean hasRain = floors.length > 0 && !hasSnow && content.contains(Liquids.water) && !floors[0].name.contains("sand");
        boolean hasDesert = floors.length > 0 && !hasSnow && !hasRain && floors[0] == Blocks.sand;
        boolean bl = hasSpores = floors.length > 0 && (floors[0].name.contains("spore") || floors[0].name.contains("moss") || floors[0].name.contains("tainted"));
        if (hasSnow) {
            rules.weather.add(new Weather.WeatherEntry(Weathers.snow));
        }
        if (hasRain) {
            rules.weather.add(new Weather.WeatherEntry(Weathers.rain));
            rules.weather.add(new Weather.WeatherEntry(Weathers.fog));
        }
        if (hasDesert) {
            rules.weather.add(new Weather.WeatherEntry(Weathers.sandstorm));
        }
        if (hasSpores) {
            rules.weather.add(new Weather.WeatherEntry(Weathers.sporestorm));
        }
    }

    protected void genTile(Vec3 position, TileGen tile) {
    }

    @Override
    protected float noise(float x, float y, double octaves, double falloff, double scl, double mag) {
        Vec3 v = this.sector.rect.project(x, y);
        return Simplex.noise3d(0, octaves, falloff, 1.0 / scl, v.x, v.y, v.z) * (float)mag;
    }

    public float getSizeScl() {
        return 3200.0f;
    }

    public int getSectorSize(Sector sector) {
        int res = (int)(sector.rect.radius * this.getSizeScl());
        return res % 2 == 0 ? res : res + 1;
    }

    public void generate(Tiles tiles, Sector sec, int seed) {
        this.tiles = tiles;
        this.seed = seed + this.baseSeed;
        this.sector = sec;
        this.width = tiles.width;
        this.height = tiles.height;
        this.rand.setSeed(sec.id + seed + this.baseSeed);
        TileGen gen = new TileGen();
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                gen.reset();
                Vec3 position = this.sector.rect.project((float)x / (float)tiles.width, (float)y / (float)tiles.height);
                this.genTile(position, gen);
                tiles.set(x, y, new Tile(x, y, gen.floor, gen.overlay, gen.block));
            }
        }
        this.generate(tiles);
    }
}

