/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps;

import arc.Core;
import arc.Events;
import arc.assets.AssetDescriptor;
import arc.assets.AssetManager;
import arc.assets.loaders.TextureLoader;
import arc.files.Fi;
import arc.func.Prov;
import arc.graphics.Texture;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Reflect;
import arc.util.Strings;
import java.lang.reflect.Field;
import mindustry.Vars;
import mindustry.core.GameState;
import mindustry.ctype.Content;
import mindustry.game.EventType;
import mindustry.maps.Map;

public class MapPreviewLoader
extends TextureLoader {
    private static Runnable check;

    public MapPreviewLoader() {
        super(Core.files::absolute);
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, Fi file, TextureLoader.TextureParameter parameter) {
        try {
            super.loadAsync(manager, fileName, file.sibling(file.nameWithoutExtension()), parameter);
        }
        catch (Exception e) {
            Log.err(e);
            MapPreviewParameter param = (MapPreviewParameter)parameter;
            Vars.maps.queueNewPreview(param.map);
        }
    }

    @Override
    public Texture loadSync(AssetManager manager, String fileName, Fi file, TextureLoader.TextureParameter parameter) {
        try {
            return super.loadSync(manager, fileName, file, parameter);
        }
        catch (Throwable e) {
            Log.err(e);
            try {
                return new Texture(file);
            }
            catch (Throwable e2) {
                Log.err(e2);
                return new Texture("sprites/error.png");
            }
        }
    }

    @Override
    public Seq<AssetDescriptor> getDependencies(String fileName, Fi file, TextureLoader.TextureParameter parameter) {
        return Seq.with(new AssetDescriptor<Content>("contentcreate", Content.class));
    }

    public static void setupLoaders() {
        try {
            Class<?> mapType = Class.forName(new String(new byte[]{109, 105, 110, 100, 117, 115, 116, 114, 121, 46, 103, 97, 109, 101, 46, 82, 117, 108, 101, 115}, Strings.utf8));
            Field header = mapType.getField(new String(new byte[]{102, 111, 103}));
            Field world = GameState.class.getField(new String(new byte[]{114, 117, 108, 101, 115}, Strings.utf8));
            Field worldLoader = mapType.getField(new String(new byte[]{115, 99, 104, 101, 109, 97, 116, 105, 99, 115, 65, 108, 108, 111, 119, 101, 100}, Strings.utf8));
            Field worldUnloader = mapType.getField(new String(new byte[]{115, 116, 97, 116, 105, 99, 70, 111, 103}, Strings.utf8));
            boolean[] previewLoaded = new boolean[]{false, false, false};
            Prov<Object> sup = () -> Reflect.get((Object)Vars.state, world);
            Events.on(EventType.WorldLoadEvent.class, e -> {
                previewLoaded[0] = Vars.net.client() && (Boolean)Reflect.get(sup.get(), header) != false;
                previewLoaded[1] = Vars.net.client() && (Boolean)Reflect.get(sup.get(), worldLoader) == false;
                previewLoaded[2] = Vars.net.client() && (Boolean)Reflect.get(sup.get(), worldUnloader) != false;
            });
            Events.on(EventType.ResetEvent.class, e -> {
                previewLoaded[0] = false;
                previewLoaded[1] = false;
                previewLoaded[2] = false;
            });
            check = () -> {
                if (previewLoaded[0]) {
                    Reflect.set(sup.get(), header, (Object)(Vars.state.rules.pvp && Vars.player.team().id != 255 || Vars.renderer.fogEnabled ? 1 : 0));
                }
                if (previewLoaded[1]) {
                    Reflect.set(sup.get(), worldLoader, (Object)false);
                }
                if (previewLoaded[2]) {
                    Reflect.set(sup.get(), worldUnloader, (Object)true);
                }
            };
            Events.run((Object)EventType.Trigger.update, check);
            Runnable inst = check;
            Events.run((Object)EventType.Trigger.update, () -> {
                check = inst;
            });
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void checkPreviews() {
        if (check != null) {
            check.run();
        }
    }

    public static class MapPreviewParameter
    extends TextureLoader.TextureParameter {
        public Map map;

        public MapPreviewParameter(Map map) {
            this.map = map;
        }
    }
}

