/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.Core;
import arc.func.Cons;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.math.geom.Intersector;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.Scene;
import arc.scene.event.ClickListener;
import arc.scene.event.ElementGestureListener;
import arc.scene.event.EventListener;
import arc.scene.event.HandCursorListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.ui.ImageButton;
import arc.scene.ui.Label;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextButton;
import arc.scene.ui.Tooltip;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.scene.ui.layout.WidgetGroup;
import arc.struct.Bits;
import arc.struct.IntMap;
import arc.struct.Seq;
import arc.struct.SnapshotSeq;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.gen.Icon;
import mindustry.gen.LogicIO;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.logic.LAssembler;
import mindustry.logic.LCategory;
import mindustry.logic.LExecutor;
import mindustry.logic.LStatement;
import mindustry.logic.LStatements;
import mindustry.logic.LogicDialog;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class LCanvas
extends Table {
    private static final Seq<JumpCurve> tmpOccupiers1 = new Seq();
    private static final Seq<JumpCurve> tmpOccupiers2 = new Seq();
    private static final Bits tmpBits1 = new Bits();
    private static final Bits tmpBits2 = new Bits();
    private static final int invalidJump = Integer.MAX_VALUE;
    static LCanvas canvas;
    private static final boolean dynamicJumpHeights = true;
    public DragLayout statements;
    public ScrollPane pane;
    StatementElem dragging;
    StatementElem hovered;
    float targetWidth;
    boolean privileged;
    Seq<Tooltip> tooltips = new Seq();

    public LCanvas() {
        canvas = this;
        Core.scene.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                for (Tooltip t : LCanvas.this.tooltips) {
                    t.container.toFront();
                }
                Core.app.post(() -> {
                    LCanvas.this.tooltips.each(Tooltip::hide);
                    LCanvas.this.tooltips.clear();
                });
                return super.touchDown(event, x, y, pointer, button);
            }
        });
        this.rebuild();
    }

    public static boolean useRows() {
        return (float)Core.graphics.getWidth() - (Core.settings.getBool("logicSupport") ? 400.0f : 0.0f) < Scl.scl(900.0f) * 1.2f;
    }

    public static void tooltip(final Cell<?> cell, String key) {
        String lkey = key.toLowerCase().replace(" ", "");
        if (Core.settings.getBool("logichints", true) && Core.bundle.has(lkey)) {
            final Tooltip tip = new Tooltip(t -> t.background(Styles.black8).margin(4.0f).add("[lightgray]" + Core.bundle.get(lkey)).style(Styles.outlineLabel));
            if (Vars.mobile) {
                ((Element)cell.get()).addListener(new ElementGestureListener(20.0f, 0.4f, 0.43f, 0.15f){

                    @Override
                    public boolean longPress(Element element, float x, float y) {
                        tip.show(element, x, y);
                        LCanvas.canvas.tooltips.add(tip);
                        for (EventListener list : ((Element)cell.get()).getListeners()) {
                            if (!(list instanceof ClickListener)) continue;
                            ClickListener cl = (ClickListener)list;
                            cl.cancel();
                        }
                        return true;
                    }
                });
            } else {
                ((Element)cell.get()).addListener(tip);
            }
        }
    }

    public static void tooltip(Cell<?> cell, Enum<?> key) {
        String cl = key.getClass().getSimpleName().toLowerCase() + "." + key.name().toLowerCase();
        if (Core.bundle.has(cl)) {
            LCanvas.tooltip(cell, cl);
        } else {
            LCanvas.tooltip(cell, "lenum." + key.name());
        }
    }

    public void rebuild() {
        this.targetWidth = LCanvas.useRows() ? 400.0f : 900.0f;
        float s = this.pane != null ? this.pane.getVisualScrollY() : 0.0f;
        String toLoad = this.statements != null ? this.save() : null;
        this.clear();
        this.statements = new DragLayout();
        this.pane = this.pane((Table t) -> {
            t.center();
            t.add(this.statements).pad(2.0f).center().width(this.targetWidth);
            t.addChild(this.statements.jumps);
            this.statements.jumps.touchable = Touchable.disabled;
            this.statements.jumps.update(() -> this.statements.jumps.setCullingArea(t.getCullingArea()));
            this.statements.jumps.cullable = false;
        }).grow().get();
        this.pane.setFlickScroll(false);
        this.pane.setScrollYForce(s);
        if (toLoad != null) {
            this.load(toLoad);
        }
    }

    public void add(LStatement statement) {
        this.statements.addChild(new StatementElem(statement));
    }

    public String save() {
        Seq<LStatement> st = this.statements.getChildren().as().map(s -> s.st);
        st.each(LStatement::saveUI);
        return LAssembler.write(st);
    }

    public void load(String asm) {
        this.statements.jumps.clear();
        Seq<LStatement> statements = LAssembler.read(asm, this.privileged);
        statements.truncate(LExecutor.maxInstructions);
        this.statements.clearChildren();
        for (LStatement st : statements) {
            this.add(st);
        }
        for (LStatement st : statements) {
            st.setupUI();
        }
        this.statements.updateJumpHeights = true;
    }

    public void clearAll() {
        if (this.statements == null) {
            return;
        }
        this.statements.clear();
        this.rebuild();
    }

    public void clearStatements() {
        this.statements.jumps.clear();
        this.statements.clearChildren();
    }

    StatementElem checkHovered() {
        Element e = Core.scene.getHoverElement();
        if (e != null) {
            while (e != null && !(e instanceof StatementElem)) {
                e = e.parent;
            }
        }
        if (e == null || this.isDescendantOf(e)) {
            return null;
        }
        return (StatementElem)e;
    }

    @Override
    public void act(float delta) {
        float y;
        float dst;
        super.act(delta);
        this.hovered = this.checkHovered();
        if (Core.input.isTouched() && (dst = Math.min((y = (float)Core.input.mouseY()) - this.y, (float)Core.graphics.getHeight() - y)) < Scl.scl(100.0f)) {
            int sign = Mathf.sign((float)Core.graphics.getHeight() / 2.0f - y);
            this.pane.setScrollY(this.pane.getScrollY() + (float)sign * Scl.scl(15.0f) * Time.delta);
        }
    }

    public class DragLayout
    extends WidgetGroup {
        float space = Scl.scl(10.0f);
        float prefWidth;
        float prefHeight;
        Seq<Element> seq = new Seq();
        int insertPosition = 0;
        boolean invalidated;
        public Group jumps = new WidgetGroup();
        private Seq<JumpCurve> processedJumps = new Seq();
        private IntMap<JumpCurve> reprBefore = new IntMap();
        private IntMap<JumpCurve> reprAfter = new IntMap();
        public boolean updateJumpHeights = true;

        public DragLayout() {
            this.setTransform(true);
        }

        @Override
        public void layout() {
            this.invalidated = true;
            float cy = 0.0f;
            this.seq.clear();
            float totalHeight = this.getChildren().sumf(e -> e.getPrefHeight() + this.space);
            if (this.height != totalHeight || this.width != Scl.scl(LCanvas.this.targetWidth)) {
                this.height = this.prefHeight = totalHeight;
                this.width = this.prefWidth = Scl.scl(LCanvas.this.targetWidth);
                this.invalidateHierarchy();
            }
            for (int i = 0; i < this.getChildren().size; ++i) {
                Element e2 = (Element)this.getChildren().get(i);
                if (LCanvas.this.dragging == e2) continue;
                e2.setSize(this.width, e2.getPrefHeight());
                e2.setPosition(0.0f, totalHeight - cy, 10);
                ((StatementElem)e2).updateAddress(i);
                cy += e2.getPrefHeight() + this.space;
                this.seq.add(e2);
            }
            if (LCanvas.this.dragging != null) {
                float realY = LCanvas.this.dragging.getY(2) + LCanvas.this.dragging.translation.y;
                this.insertPosition = 0;
                for (int i = 0; i < this.seq.size; ++i) {
                    Element cur = this.seq.get(i);
                    if (!(realY < cur.y) || i != this.seq.size - 1 && !(realY > this.seq.get((int)(i + 1)).y)) continue;
                    this.insertPosition = i + 1;
                    break;
                }
                float shiftAmount = LCanvas.this.dragging.getHeight() + this.space;
                for (int i = this.insertPosition; i < this.seq.size; ++i) {
                    this.seq.get((int)i).y -= shiftAmount;
                }
            }
            if (this.updateJumpHeights) {
                this.setJumpHeights();
            }
            this.updateJumpHeights = false;
            if (this.parent != null && this.parent instanceof Table) {
                this.setCullingArea(this.parent.getCullingArea());
            }
        }

        private void setJumpHeights() {
            SnapshotSeq<Element> jumpsChildren = this.jumps.getChildren();
            this.processedJumps.clear();
            this.reprBefore.clear();
            this.reprAfter.clear();
            jumpsChildren.each(e -> {
                if (!(e instanceof JumpCurve)) {
                    return;
                }
                JumpCurve e2 = (JumpCurve)e;
                e2.prepareHeight();
                if (e2.jumpUIBegin == Integer.MAX_VALUE) {
                    return;
                }
                if (e2.flipped) {
                    JumpCurve prev = this.reprAfter.get(e2.jumpUIBegin);
                    if (prev != null && prev.jumpUIEnd >= e2.jumpUIEnd) {
                        return;
                    }
                    this.reprAfter.put(e2.jumpUIBegin, e2);
                } else {
                    JumpCurve prev = this.reprBefore.get(e2.jumpUIEnd);
                    if (prev != null && prev.jumpUIBegin <= e2.jumpUIBegin) {
                        return;
                    }
                    this.reprBefore.put(e2.jumpUIEnd, e2);
                }
            });
            this.processedJumps.add(this.reprBefore.values().toArray());
            this.processedJumps.add(this.reprAfter.values().toArray());
            this.processedJumps.sort((a, b) -> a.jumpUIBegin - b.jumpUIBegin);
            Seq occupiers = tmpOccupiers1;
            Bits occupied = tmpBits1;
            occupiers.clear();
            occupied.clear();
            for (int i = 0; i < this.processedJumps.size; ++i) {
                JumpCurve cur = this.processedJumps.get(i);
                occupiers.retainAll(e -> {
                    if (e.jumpUIEnd > cur.jumpUIBegin) {
                        return true;
                    }
                    occupied.clear(e.predHeight);
                    return false;
                });
                int h = this.getJumpHeight(i, occupiers, occupied);
                occupiers.add(cur);
                occupied.set(h);
            }
            occupiers.clear();
            jumpsChildren.each(e -> {
                if (!(e instanceof JumpCurve)) {
                    return;
                }
                JumpCurve e2 = (JumpCurve)e;
                if (e2.jumpUIBegin == Integer.MAX_VALUE) {
                    return;
                }
                e2.predHeight = e2.flipped ? this.reprAfter.get((int)e2.jumpUIBegin).predHeight : this.reprBefore.get((int)e2.jumpUIEnd).predHeight;
                e2.markedDone = true;
            });
        }

        private int getJumpHeight(int index, Seq<JumpCurve> occupiers, Bits occupied) {
            JumpCurve jmp = this.processedJumps.get(index);
            if (jmp.markedDone) {
                return jmp.predHeight;
            }
            Seq tmpOccupiers = tmpOccupiers2;
            Bits tmpOccupied = tmpBits2;
            tmpOccupiers.set(occupiers);
            tmpOccupied.set(occupied);
            int max = -1;
            for (int i = index + 1; i < this.processedJumps.size; ++i) {
                JumpCurve cur = this.processedJumps.get(i);
                if (cur.jumpUIEnd > jmp.jumpUIEnd) continue;
                tmpOccupiers.retainAll(e -> {
                    if (e.jumpUIEnd > cur.jumpUIBegin) {
                        return true;
                    }
                    tmpOccupied.clear(e.predHeight);
                    return false;
                });
                int h = this.getJumpHeight(i, tmpOccupiers, tmpOccupied);
                tmpOccupiers.add(cur);
                tmpOccupied.set(h);
                max = Math.max(max, h);
            }
            jmp.predHeight = occupied.nextClearBit(max + 1);
            jmp.markedDone = true;
            tmpOccupiers.clear();
            return jmp.predHeight;
        }

        @Override
        public float getPrefWidth() {
            return this.prefWidth;
        }

        @Override
        public float getPrefHeight() {
            return this.prefHeight;
        }

        @Override
        public void draw() {
            Draw.alpha(this.parentAlpha);
            if (LCanvas.this.dragging != null && this.insertPosition <= this.seq.size) {
                float shiftAmount = LCanvas.this.dragging.getHeight();
                float lastX = this.x;
                float lastY = this.insertPosition == 0 ? this.height + this.y : this.seq.get((int)(this.insertPosition - 1)).y + this.y - this.space;
                Tex.pane.draw(lastX, lastY - shiftAmount, this.width, LCanvas.this.dragging.getHeight());
            }
            if (this.invalidated) {
                this.children.each(c -> {
                    c.cullable = false;
                });
            }
            super.draw();
            if (this.invalidated) {
                this.children.each(c -> {
                    c.cullable = true;
                });
                this.invalidated = false;
            }
        }

        void finishLayout() {
            if (LCanvas.this.dragging != null) {
                int i;
                for (Element child : this.getChildren()) {
                    child.setTranslation(0.0f, 0.0f);
                }
                this.clearChildren();
                for (i = 0; i <= this.insertPosition - 1 && i < this.seq.size; ++i) {
                    this.addChild(this.seq.get(i));
                }
                this.addChild(LCanvas.this.dragging);
                for (i = this.insertPosition; i < this.seq.size; ++i) {
                    this.addChild(this.seq.get(i));
                }
                LCanvas.this.dragging = null;
                this.invalidateHierarchy();
            }
            this.updateJumpHeights = true;
        }
    }

    public class StatementElem
    extends Table {
        public LStatement st;
        public int index;
        Label addressLabel;

        public StatementElem(LStatement st) {
            this.st = st;
            st.elem = this;
            this.background(Tex.whitePane);
            this.setColor(st.category().color);
            this.margin(0.0f);
            this.touchable = Touchable.enabled;
            this.table(Tex.whiteui, t -> {
                t.color.set(this.color);
                t.addListener(new HandCursorListener());
                t.margin(6.0f);
                t.touchable = Touchable.enabled;
                t.add(st.name()).style(Styles.outlineLabel).name("statement-name").color(this.color).padRight(8.0f);
                t.add().growX();
                this.addressLabel = t.add(this.index + "").style(Styles.outlineLabel).color(this.color).padRight(8.0f).get();
                t.button((Drawable)Icon.add, Styles.logici, () -> {}).size(24.0f).padRight(6.0f).get().tapped(this::arcAppend);
                t.button((Drawable)Icon.download, Styles.logici, () -> {}).size(24.0f).padRight(6.0f).get().tapped(this::arcImport);
                t.button((Drawable)Icon.copy, Styles.logici, () -> {}).size(24.0f).padRight(6.0f).get().tapped(this::copy);
                t.button((Drawable)(st instanceof LStatements.PrintStatement ? Icon.fileText : Icon.pencil), Styles.logici, () -> this.arcTrans()).size(24.0f).padRight(6.0f).get().tapped(() -> {});
                t.button((Drawable)Icon.cancel, Styles.logici, () -> {
                    this.remove();
                    LCanvas.this.dragging = null;
                    LCanvas.this.statements.updateJumpHeights = true;
                }).size(24.0f).padLeft(Vars.mobile ? 48.0f : 0.0f);
                t.addListener(new InputListener(){
                    float lastx;
                    float lasty;

                    @Override
                    public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                        if (button == KeyCode.mouseMiddle) {
                            StatementElem.this.copy();
                            return false;
                        }
                        Vec2 v = StatementElem.this.localToParentCoordinates(Tmp.v1.set(x, y));
                        this.lastx = v.x;
                        this.lasty = v.y;
                        LCanvas.this.dragging = StatementElem.this;
                        StatementElem.this.toFront();
                        LCanvas.this.statements.updateJumpHeights = true;
                        LCanvas.this.statements.invalidate();
                        return true;
                    }

                    @Override
                    public void touchDragged(InputEvent event, float x, float y, int pointer) {
                        Vec2 v = StatementElem.this.localToParentCoordinates(Tmp.v1.set(x, y));
                        StatementElem.this.translation.add(v.x - this.lastx, v.y - this.lasty);
                        this.lastx = v.x;
                        this.lasty = v.y;
                        LCanvas.this.statements.invalidate();
                    }

                    @Override
                    public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                        LCanvas.this.statements.finishLayout();
                    }
                });
            }).growX().height(38.0f);
            this.row();
            this.table((Table t) -> {
                t.left();
                t.marginLeft(4.0f);
                t.setColor(this.color);
                st.build((Table)t);
            }).pad(4.0f).padTop(2.0f).left().grow();
            this.marginBottom(7.0f);
        }

        public void updateAddress(int index) {
            this.index = index;
            this.addressLabel.setText(index + "");
        }

        public void copy() {
            this.st.saveUI();
            LStatement copy = this.st.copy();
            if (copy instanceof LStatements.JumpStatement) {
                int index;
                LStatements.JumpStatement st = (LStatements.JumpStatement)copy;
                if (st.destIndex != -1 && (index = LCanvas.this.statements.getChildren().indexOf(this)) != -1 && index < st.destIndex) {
                    ++st.destIndex;
                }
            }
            if (copy != null) {
                StatementElem s = new StatementElem(copy);
                LCanvas.this.statements.addChildAfter(this, s);
                copy.elem = s;
                copy.setupUI();
                LCanvas.this.statements.updateJumpHeights = true;
            }
        }

        public void arcAppend() {
            BaseDialog dialog = new BaseDialog("@add");
            dialog.cont.table((Table table) -> {
                table.background(Tex.button);
                table.pane((Table t) -> {
                    for (Prov<LStatement> prov : LogicIO.allStatements) {
                        LStatement example = prov.get();
                        if (example instanceof LStatements.InvalidStatement || example.hidden() || example.privileged() && !LCanvas.this.privileged || example.nonPrivileged() && LCanvas.this.privileged) continue;
                        LCategory category = example.category();
                        Table cat = (Table)t.find(category.name);
                        if (cat == null) {
                            t.table((Table s) -> {
                                if (category.icon != null) {
                                    s.image(category.icon, Pal.darkishGray).left().size(15.0f).padRight(10.0f);
                                }
                                s.add(category.localized()).color(Pal.darkishGray).left().tooltip(category.description());
                                s.image(Tex.whiteui, Pal.darkishGray).left().height(5.0f).growX().padLeft(10.0f);
                            }).growX().pad(5.0f).padTop(10.0f);
                            t.row();
                            cat = t.table((Table c) -> c.top().left()).name(category.name).top().left().growX().fillY().get();
                            t.row();
                        }
                        TextButton.TextButtonStyle style = new TextButton.TextButtonStyle(Styles.flatt);
                        style.fontColor = category.color;
                        style.font = Fonts.outline;
                        cat.button(example.name(), style, () -> {
                            LCanvas.this.statements.addChildAt(LCanvas.this.statements.getChildren().indexOf(this) + 1, new StatementElem((LStatement)prov.get()));
                            LCanvas.this.statements.layout();
                            dialog.hide();
                        }).size(130.0f, 50.0f).self(c -> LCanvas.tooltip(c, "lst." + example.name())).top().left();
                        if (cat.getChildren().size % 3 != 0) continue;
                        cat.row();
                    }
                }).grow();
            }).fill().maxHeight((float)Core.graphics.getHeight() * 0.8f);
            dialog.addCloseButton();
            dialog.show();
        }

        public void arcImport() {
            String replace = Core.app.getClipboardText().replace("\r\n", "\n");
            Seq<LStatement> read = LAssembler.read(replace, LCanvas.this.privileged);
            int lineNum = LCanvas.this.statements.getChildren().indexOf(this) + 1;
            for (int i = 0; i < read.size; ++i) {
                LCanvas.this.statements.addChildAt(lineNum + i, new StatementElem(read.get(i)));
            }
            LCanvas.this.statements.layout();
        }

        public void arcTrans() {
            LStatement stNew;
            int child = LCanvas.this.statements.getChildren().indexOf(this) + 1;
            LStatement lStatement = this.st;
            if (lStatement instanceof LStatements.PrintStatement) {
                LStatements.PrintStatement pst = (LStatements.PrintStatement)lStatement;
                Seq<LStatement> lsStatement = LAssembler.read(pst.value.replace("_", " "), LCanvas.this.privileged);
                stNew = lsStatement.first();
                if (stNew instanceof LStatements.InvalidStatement) {
                    ARCVars.arcui.arcInfo("[orange]\u8b66\u544a\uff1a\u8f6c\u6362\u5931\u8d25\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u683c\u5f0f\n[cyan]" + LogicDialog.transText);
                } else if (stNew instanceof LStatements.JumpStatement) {
                    LStatements.JumpStatement jst = (LStatements.JumpStatement)stNew;
                    if (jst.destIndex != -1) {
                        jst.dest = (StatementElem)LCanvas.this.statements.getChildren().get(jst.destIndex);
                    }
                }
            } else if (this.st instanceof LStatements.InvalidStatement) {
                stNew = LogicIO.read(new String[]{"print", LogicDialog.transText}, 2);
            } else {
                StringBuilder thisText = new StringBuilder();
                LogicIO.write(this.st, thisText);
                LogicDialog.transText = thisText.toString();
                stNew = LogicIO.read(new String[]{"print", LogicDialog.transText}, 2);
            }
            StatementElem stNewElem = new StatementElem(stNew);
            LCanvas.this.statements.addChildAt(child, stNewElem);
            this.remove();
            for (Element ste : LCanvas.this.statements.seq) {
                LStatement lStatement2 = ((StatementElem)ste).st;
                if (!(lStatement2 instanceof LStatements.JumpStatement)) continue;
                LStatements.JumpStatement jst = (LStatements.JumpStatement)lStatement2;
                if (jst.dest != this.st.elem) continue;
                jst.dest = stNewElem;
            }
            LCanvas.this.statements.layout();
        }

        @Override
        public void draw() {
            float pad = 5.0f;
            Fill.dropShadow(this.x + this.width / 2.0f, this.y + this.height / 2.0f, this.width + pad, this.height + pad, 10.0f, 0.9f * this.parentAlpha);
            Draw.color(0.0f, 0.0f, 0.0f, 0.3f * this.parentAlpha);
            Fill.crect(this.x, this.y, this.width, this.height);
            Draw.reset();
            super.draw();
        }
    }

    public static class JumpCurve
    extends Element {
        public JumpButton button;
        private boolean invertedHeight;
        public int predHeight = 0;
        public boolean markedDone = false;
        public int jumpUIBegin = 0;
        public int jumpUIEnd = 0;
        public boolean flipped = false;
        private float uiHeight = 60.0f;

        public JumpCurve(JumpButton button) {
            this.button = button;
        }

        @Override
        public void setSize(float width, float height) {
            if (height < 0.0f) {
                this.y += height;
                height = -height;
                this.invertedHeight = true;
            }
            super.setSize(width, height);
        }

        @Override
        public void act(float delta) {
            Element hover;
            super.act(delta);
            this.invertedHeight = false;
            Group desc = LCanvas.canvas.statements.jumps.parent;
            Vec2 t = Tmp.v1.set(this.button.getWidth() / 2.0f, this.button.getHeight() / 2.0f);
            this.button.localToAscendantCoordinates(desc, t);
            this.setPosition(t.x, t.y);
            Element element = hover = this.button.to.get() == null && this.button.selecting ? LCanvas.canvas.hovered : (Element)this.button.to.get();
            if (hover != null) {
                t.set(hover.getWidth(), hover.getHeight() / 2.0f);
                hover.localToAscendantCoordinates(desc, t);
                this.setSize(t.x - this.x, t.y - this.y);
            } else if (this.button.selecting) {
                this.setSize(this.button.mx, this.button.my);
            } else {
                this.setSize(0.0f, 0.0f);
            }
            if (this.button.listener.isOver()) {
                this.toFront();
            }
        }

        @Override
        public void draw() {
            if (this.height == 0.0f) {
                return;
            }
            Vec2 t = Tmp.v1.set(this.width, !this.invertedHeight ? this.height : 0.0f);
            Vec2 r = Tmp.v2.set(0.0f, !this.invertedHeight ? 0.0f : this.height);
            ScrollPane desc = LCanvas.canvas.pane;
            this.localToAscendantCoordinates(desc, r);
            this.localToAscendantCoordinates(desc, t);
            this.drawCurve(r.x, r.y, t.x, t.y);
            float s = this.button.getWidth();
            Draw.color(this.button.color, this.parentAlpha);
            Tex.logicNode.draw(t.x + s * 0.75f, t.y - s / 2.0f, -s, s);
            Draw.reset();
        }

        public void drawCurve(float x, float y, float x2, float y2) {
            Lines.stroke(Scl.scl(4.0f), this.button.color);
            Draw.alpha(this.parentAlpha);
            this.uiHeight = Mathf.lerp(Scl.scl(Core.graphics.isPortrait() ? 20.0f : 40.0f) + Scl.scl(Core.graphics.isPortrait() ? 8.0f : 10.0f) * (float)this.predHeight, this.uiHeight, Mathf.pow(0.9f, Time.delta));
            float dy = (y2 == y ? 0.0f : (y2 > y ? 1.0f : -1.0f)) * this.uiHeight * 0.5f;
            if (Intersector.intersectSegments(x, y, x + this.uiHeight, y + dy, x2, y2, x + this.uiHeight, y2 - dy, Tmp.v3)) {
                Lines.beginLine();
                Lines.linePoint(x, y);
                Lines.linePoint(Tmp.v3.x, Tmp.v3.y);
                Lines.linePoint(x2, y2);
                Lines.endLine();
            } else {
                Lines.beginLine();
                Lines.linePoint(x, y);
                Lines.linePoint(x + this.uiHeight, y + dy);
                Lines.linePoint(x + this.uiHeight, y2 - dy);
                Lines.linePoint(x2, y2);
                Lines.endLine();
            }
        }

        public void prepareHeight() {
            if (this.button.to.get() == null) {
                this.markedDone = true;
                this.predHeight = 0;
                this.flipped = false;
                this.jumpUIEnd = Integer.MAX_VALUE;
                this.jumpUIBegin = Integer.MAX_VALUE;
            } else {
                this.markedDone = false;
                int i = this.button.elem.index;
                int j = this.button.to.get().index;
                this.flipped = i >= j;
                this.jumpUIBegin = Math.min(i, j);
                this.jumpUIEnd = Math.max(i, j);
            }
        }
    }

    public static class JumpButton
    extends ImageButton {
        Color hoverColor = Pal.place;
        Prov<StatementElem> to;
        boolean selecting;
        float mx;
        float my;
        ClickListener listener;
        public JumpCurve curve;
        public StatementElem elem;

        public JumpButton(Prov<StatementElem> getter, final Cons<StatementElem> setter, StatementElem elem) {
            super(Tex.logicNode, new ImageButton.ImageButtonStyle(){
                {
                    this.imageUpColor = Color.white;
                }
            });
            this.elem = elem;
            this.to = getter;
            this.listener = new ClickListener();
            this.addListener(this.listener);
            this.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode code) {
                    selecting = true;
                    setter.get(null);
                    mx = x;
                    my = y;
                    LCanvas.canvas.statements.updateJumpHeights = true;
                    return true;
                }

                @Override
                public void touchDragged(InputEvent event, float x, float y, int pointer) {
                    mx = x;
                    my = y;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode code) {
                    this.localToStageCoordinates(Tmp.v1.set(x, y));
                    StatementElem elem = LCanvas.canvas.hovered;
                    if (elem != null && !this.isDescendantOf(elem)) {
                        setter.get(elem);
                    } else {
                        setter.get(null);
                    }
                    selecting = false;
                    LCanvas.canvas.statements.updateJumpHeights = true;
                }
            });
            this.update(() -> {
                if (this.to.get() != null && this.to.get().parent == null) {
                    setter.get(null);
                }
                this.setColor(this.listener.isOver() ? this.hoverColor : Color.white);
                this.getStyle().imageUpColor = this.color;
            });
            this.curve = new JumpCurve(this);
        }

        @Override
        protected void setScene(Scene stage) {
            super.setScene(stage);
            if (stage == null) {
                this.curve.remove();
            } else {
                LCanvas.canvas.statements.jumps.addChild(this.curve);
            }
        }
    }
}

