/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.Events;
import arc.assets.Loadable;
import arc.audio.Music;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.util.Log;
import arc.util.Scaling;
import arc.util.Time;
import arc.util.Timer;
import mindustry.game.EventType;
import mindustry.graphics.LoadRenderer;

public class YuanShenLoadRenderer
extends LoadRenderer {
    private static Music fadeIn;
    private static Music loop;
    private static Music fadeOut;
    private static Pixmap pixmap;
    private static TextureRegion YuanShen;
    private static final Color draw;
    private static final Color bg;
    private static boolean loaded;
    private static boolean loadEnd;
    private static int status;
    private static long time;
    public static boolean shouldPlay;

    public YuanShenLoadRenderer() {
        try {
            fadeIn = new Music(Core.files.internal("music/yuanshen_in.ogg"));
            loop = new Music(Core.files.internal("music/yuanshen_loop.ogg"));
            fadeOut = new Music(Core.files.internal("music/yuanshen_out.ogg"));
            pixmap = new Pixmap(Core.files.internal("icons/yuanshen1.png"));
            YuanShen = new TextureRegion(new Texture(pixmap));
            loaded = true;
            loop.setLooping(true);
        }
        catch (Exception e) {
            Log.err(e);
        }
    }

    @Override
    public void dispose() {
        fadeIn.dispose();
        YuanShenLoadRenderer.YuanShen.texture.dispose();
        fadeIn = null;
        pixmap = null;
        YuanShen = null;
        super.dispose();
        loaded = false;
    }

    @Override
    public void draw() {
        if (!loaded) {
            super.draw();
            return;
        }
        int width = Core.graphics.getWidth();
        int height = Core.graphics.getHeight();
        Vec2 size = Scaling.fit.apply(pixmap.getWidth(), pixmap.getHeight(), width, height);
        Core.graphics.clear(Color.white);
        Draw.color(bg);
        Fill.crect(((float)width - size.x) / 2.0f, 0.0f, size.x, size.y);
        Draw.color(draw);
        Fill.crect(((float)width - size.x) / 2.0f, 0.0f, status == 3 ? size.x * 0.93f : (status >= 4 ? size.x : size.x * Core.assets.getProgress()), size.y);
        Draw.color(Color.white);
        Draw.rect(YuanShen, (float)width / 2.0f, size.y / 2.0f, size.x, size.y);
        if (status >= 4) {
            Draw.alpha(Mathf.clamp((float)(Time.millis() - time) / 1000.0f, 0.0f, 1.0f));
            Fill.rect((float)width / 2.0f, size.y / 2.0f, size.x, size.y);
        }
        Draw.flush();
        switch (status) {
            case 0: {
                fadeIn.play();
                ++status;
                break;
            }
            case 1: {
                if (fadeIn.getPosition() == 0.0f) break;
                ++status;
                break;
            }
            case 2: {
                if (fadeIn.getPosition() != 0.0f) break;
                loop.play();
                ++status;
                break;
            }
            case 3: {
                if (Core.assets.getCurrentLoading() != null && Core.assets.getCurrentLoading().type != LoadLock.class) break;
                time = Time.millis();
                ++status;
                break;
            }
            case 4: {
                if (Time.millis() - time <= 1000L) break;
                ++status;
                loadEnd = true;
            }
        }
        Events.on(EventType.ClientLoadEvent.class, e -> loop.setLooping(false));
        Events.run((Object)EventType.Trigger.update, () -> {
            if (loop != null && !loop.isLooping() && loop.getPosition() == 0.0f) {
                fadeOut.play();
                Timer.schedule(() -> {
                    shouldPlay = true;
                }, 8.0f);
                Timer.schedule(() -> {
                    fadeOut.dispose();
                    fadeOut = null;
                }, 20.0f);
                loop.dispose();
                loop = null;
            }
        });
    }

    static {
        draw = new Color(0x646464FF);
        bg = new Color(-202116097);
        loaded = false;
        loadEnd = false;
        status = 0;
        time = 0L;
        shouldPlay = false;
    }

    public static class LoadLock
    implements Loadable {
        @Override
        public void loadAsync() {
            while (!loadEnd) {
                Thread.yield();
            }
        }
    }
}

