/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Angles;
import arc.math.Mathf;
import arc.struct.FloatSeq;
import arc.util.Time;

public class Trail {
    public int length;
    protected FloatSeq points;
    protected float lastX = -1.0f;
    protected float lastY = -1.0f;
    protected float lastAngle = -1.0f;
    protected float counter = 0.0f;
    protected float lastW = 0.0f;

    public Trail(int length) {
        this.length = length;
        this.points = new FloatSeq(length * 3);
    }

    public Trail copy() {
        Trail out = new Trail(this.length);
        out.points.addAll(this.points);
        out.lastX = this.lastX;
        out.lastY = this.lastY;
        out.lastAngle = this.lastAngle;
        return out;
    }

    public float width() {
        return this.lastW;
    }

    public void clear() {
        this.points.clear();
    }

    public int size() {
        return this.points.size / 3;
    }

    public void drawCap(Color color, float width) {
        if (this.points.size > 0) {
            Draw.color(color);
            float[] items = this.points.items;
            int i = this.points.size - 3;
            float x1 = items[i];
            float y1 = items[i + 1];
            float w1 = items[i + 2];
            float w = w1 * width / (float)(this.points.size / 3) * (float)i / 3.0f * 2.0f;
            if (w1 <= 0.001f) {
                return;
            }
            Draw.rect("hcircle", x1, y1, w, w, -57.295776f * this.lastAngle + 180.0f);
            Draw.reset();
        }
    }

    public void draw(Color color, float width) {
        Draw.color(color);
        float[] items = this.points.items;
        float lastAngle = this.lastAngle;
        float size = width / (float)(this.points.size / 3);
        for (int i = 0; i < this.points.size; i += 3) {
            float z1;
            float w2;
            float y2;
            float x2;
            float x1 = items[i];
            float y1 = items[i + 1];
            float w1 = items[i + 2];
            if (i < this.points.size - 3) {
                x2 = items[i + 3];
                y2 = items[i + 4];
                w2 = items[i + 5];
                if (i == 0 && this.points.size >= (this.length - 1) * 3) {
                    x1 = Mathf.lerp(x1, x2, this.counter);
                    y1 = Mathf.lerp(y1, y2, this.counter);
                    w1 = Mathf.lerp(w1, w2, this.counter);
                }
            } else {
                x2 = this.lastX;
                y2 = this.lastY;
                w2 = this.lastW;
            }
            float z2 = -Angles.angleRad(x1, y1, x2, y2);
            float f = z1 = i == 0 ? z2 : lastAngle;
            if (w1 <= 0.001f || w2 <= 0.001f) continue;
            float cx = Mathf.sin(z1) * (float)i / 3.0f * size * w1;
            float cy = Mathf.cos(z1) * (float)i / 3.0f * size * w1;
            float nx = Mathf.sin(z2) * ((float)i / 3.0f + 1.0f) * size * w2;
            float ny = Mathf.cos(z2) * ((float)i / 3.0f + 1.0f) * size * w2;
            Fill.quad(x1 - cx, y1 - cy, x1 + cx, y1 + cy, x2 + nx, y2 + ny, x2 - nx, y2 - ny);
            lastAngle = z2;
        }
        Draw.reset();
    }

    public void shorten() {
        int count = (int)(this.counter += Time.delta);
        this.counter -= (float)count;
        if (count > 0 && this.points.size > 0) {
            this.points.removeRange(0, Math.min(count * 3 - 1, this.points.size - 1));
        }
    }

    public void update(float x, float y) {
        this.update(x, y, 1.0f);
    }

    public void update(float x, float y, float width) {
        int count = (int)(this.counter += Time.delta);
        this.counter -= (float)count;
        if (count > 0) {
            int toRemove = this.points.size + (count - 1 - this.length) * 3;
            if (toRemove > 0 && this.points.size > 0) {
                this.points.removeRange(0, Math.min(toRemove - 1, this.points.size - 1));
            }
            if (count == 1 || this.lastX == -1.0f) {
                this.points.add(x, y, width);
            } else {
                for (int i = 0; i < count; ++i) {
                    float f = ((float)i + 1.0f) / (float)count;
                    this.points.add(Mathf.lerp(this.lastX, x, f), Mathf.lerp(this.lastY, y, f), Mathf.lerp(this.lastW, width, f));
                }
            }
        }
        this.lastAngle = -Angles.angleRad(x, y, this.lastX, this.lastY);
        this.lastX = x;
        this.lastY = y;
        this.lastW = width;
    }
}

