/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.func.Floatc2;
import arc.graphics.Camera;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Batch;
import arc.graphics.g2d.CacheBatch;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.SpriteCache;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.FrameBuffer;
import arc.math.Angles;
import arc.math.Mat;
import arc.math.Mathf;
import arc.scene.ui.layout.Scl;
import arc.struct.Seq;
import arc.util.Disposable;
import arc.util.Log;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.noise.Ridged;
import arc.util.noise.Simplex;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.content.Blocks;
import mindustry.game.Team;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;
import mindustry.world.Block;
import mindustry.world.CachedTile;
import mindustry.world.Tile;
import mindustry.world.Tiles;

public class MenuRenderer
implements Disposable {
    private static final float darkness = 0.3f;
    private final int width = !Vars.mobile ? 100 : 60;
    private final int height = !Vars.mobile ? 50 : 40;
    private int cacheFloor;
    private int cacheWall;
    private Camera camera = new Camera();
    private Mat mat = new Mat();
    private FrameBuffer shadows;
    private CacheBatch batch;
    private float time = 0.0f;
    private float flyerRot = 45.0f;
    private int flyers = Mathf.chance(0.2) ? Mathf.random(45) : Mathf.random(25);
    private UnitType flyerType = Vars.content.units().select(u -> !u.isHidden() && u.hitSize >= 10.0f && u.onTitleScreen && u.region.found()).random();
    private UnitType followType = Vars.content.units().select(u -> !u.isHidden() && u.hitSize < this.flyerType.hitSize * 0.8f && u.onTitleScreen && u.region.found()).random();

    public MenuRenderer() {
        Time.mark();
        this.generate();
        this.cache();
        Log.debug("Time to generate menu: @", Float.valueOf(Time.elapsed()));
    }

    private void generate() {
        int offset;
        Vars.world.setGenerating(true);
        Tiles tiles = Vars.world.resize(this.width, this.height);
        Seq<Block> ores = Seq.with(Blocks.oreCopper, Blocks.oreLead, Blocks.oreScrap, Blocks.oreCoal, Blocks.oreTitanium, Blocks.oreThorium);
        this.shadows = new FrameBuffer(this.width, this.height);
        int s1 = offset = Mathf.random(100000);
        int s2 = offset + 1;
        int s3 = offset + 2;
        Block[] selected = (Block[])Structs.random({Blocks.sand, Blocks.sandWall}, {Blocks.shale, Blocks.shaleWall}, {Blocks.ice, Blocks.iceWall}, {Blocks.sand, Blocks.sandWall}, {Blocks.shale, Blocks.shaleWall}, {Blocks.ice, Blocks.iceWall}, {Blocks.moss, Blocks.sporePine}, {Blocks.dirt, Blocks.dirtWall}, {Blocks.dacite, Blocks.daciteWall});
        Block[] selected2 = (Block[])Structs.random({Blocks.basalt, Blocks.duneWall}, {Blocks.basalt, Blocks.duneWall}, {Blocks.stone, Blocks.stoneWall}, {Blocks.stone, Blocks.stoneWall}, {Blocks.moss, Blocks.sporeWall}, {Blocks.salt, Blocks.saltWall});
        Block ore1 = ores.random();
        ores.remove(ore1);
        Block ore2 = ores.random();
        double tr1 = Mathf.random(0.65f, 0.85f);
        double tr2 = Mathf.random(0.65f, 0.85f);
        boolean doheat = Mathf.chance(0.25);
        boolean tendrils = Mathf.chance(0.25);
        boolean tech = Mathf.chance(0.25);
        int secSize = 10;
        Block floord = selected[0];
        Block walld = selected[1];
        Block floord2 = selected2[0];
        Block walld2 = selected2[1];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                double base;
                double heat;
                Block floor = floord;
                Block ore = Blocks.air;
                Block wall = Blocks.air;
                if ((double)Simplex.noise2d(s1, 3.0, 0.5, 0.05, x, y) > 0.5) {
                    wall = walld;
                }
                if ((double)Simplex.noise2d(s3, 3.0, 0.5, 0.05, x, y) > 0.5) {
                    floor = floord2;
                    if (wall != Blocks.air) {
                        wall = walld2;
                    }
                }
                if ((double)Simplex.noise2d(s2, 3.0, 0.3, 0.03333333333333333, x, y) > tr1) {
                    ore = ore1;
                }
                if ((double)Simplex.noise2d(s2, 2.0, 0.2, 0.06666666666666667, x, y + 99999) > tr2) {
                    ore = ore2;
                }
                if (doheat && (heat = (double)Simplex.noise2d(s3, 4.0, 0.6, 0.02, x, y + 9999)) > (base = 0.65)) {
                    ore = Blocks.air;
                    wall = Blocks.air;
                    floor = Blocks.basalt;
                    if (heat > base + 0.1) {
                        floor = Blocks.hotrock;
                        if (heat > base + 0.15) {
                            floor = Blocks.magmarock;
                        }
                    }
                }
                if (tech) {
                    int mx = x % secSize;
                    int my = y % secSize;
                    int sclx = x / secSize;
                    int scly = y / secSize;
                    if (Simplex.noise2d(s1, 2.0, 0.1f, 0.5, sclx, scly) > 0.4f && (mx == 0 || my == 0 || mx == secSize - 1 || my == secSize - 1)) {
                        floor = Blocks.darkPanel3;
                        if (Mathf.dst(mx, my, secSize / 2, secSize / 2) > (float)secSize / 2.0f + 1.0f) {
                            floor = Blocks.darkPanel4;
                        }
                        if (wall != Blocks.air && Mathf.chance(0.7)) {
                            wall = Blocks.darkMetal;
                        }
                    }
                }
                if (tendrils && Ridged.noise2d(1 + offset, x, y, 0.05882352963089943) > 0.0f) {
                    Block block = floor = Mathf.chance(0.2) ? Blocks.sporeMoss : Blocks.moss;
                    if (wall != Blocks.air) {
                        wall = Blocks.sporeWall;
                    }
                }
                CachedTile tile = new CachedTile();
                tiles.set(x, y, tile);
                tile.x = (short)x;
                tile.y = (short)y;
                tile.setFloor(floor.asFloor());
                tile.setBlock(wall);
                tile.setOverlay(ore);
            }
        }
        Vars.world.setGenerating(false);
    }

    private void cache() {
        Draw.proj().setOrtho(0.0f, 0.0f, this.shadows.getWidth(), this.shadows.getHeight());
        this.shadows.begin(Color.clear);
        Draw.color(Color.black);
        for (Tile tile : Vars.world.tiles) {
            if (tile.block() == Blocks.air) continue;
            Fill.rect((float)tile.x + 0.5f, (float)tile.y + 0.5f, 1.0f, 1.0f);
        }
        Draw.color();
        this.shadows.end();
        Batch prev = Core.batch;
        this.batch = new CacheBatch(new SpriteCache(this.width * this.height * 6, false));
        Core.batch = this.batch;
        this.batch.beginCache();
        for (Tile tile : Vars.world.tiles) {
            tile.floor().drawBase(tile);
        }
        for (Tile tile : Vars.world.tiles) {
            tile.overlay().drawBase(tile);
        }
        this.cacheFloor = this.batch.endCache();
        this.batch.beginCache();
        for (Tile tile : Vars.world.tiles) {
            tile.block().drawBase(tile);
        }
        this.cacheWall = this.batch.endCache();
        Core.batch = prev;
    }

    public void render() {
        this.time += Time.delta;
        float scaling = Math.max(Scl.scl(4.0f), Math.max((float)Core.graphics.getWidth() / (((float)this.width - 1.0f) * 8.0f), (float)Core.graphics.getHeight() / (((float)this.height - 1.0f) * 8.0f)));
        this.camera.position.set((float)(this.width * 8) / 2.0f, (float)(this.height * 8) / 2.0f);
        this.camera.resize((float)Core.graphics.getWidth() / scaling, (float)Core.graphics.getHeight() / scaling);
        this.mat.set(Draw.proj());
        Draw.flush();
        Draw.proj(this.camera);
        this.batch.setProjection(this.camera.mat);
        this.batch.beginDraw();
        this.batch.drawCache(this.cacheFloor);
        this.batch.endDraw();
        Draw.color();
        Draw.rect(Draw.wrap((Texture)this.shadows.getTexture()), (float)(this.width * 8) / 2.0f - 4.0f, (float)(this.height * 8) / 2.0f - 4.0f, (float)(this.width * 8), (float)(-this.height * 8));
        Draw.flush();
        this.batch.beginDraw();
        this.batch.drawCache(this.cacheWall);
        this.batch.endDraw();
        if (Core.settings.getBool("menuFlyersFollower")) {
            this.drawFollowFlyers();
        } else {
            this.drawFlyers();
        }
        Draw.proj(this.mat);
        Draw.color(0.0f, 0.0f, 0.0f, 0.3f);
        Fill.crect(0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
        Draw.color();
    }

    private void drawFollowFlyers() {
        Draw.color(0.0f, 0.0f, 0.0f, 0.4f);
        TextureRegion icon = this.flyerType.fullIcon;
        float size = (float)Math.max(icon.width, icon.height) * Draw.scl * 1.6f;
        float sizebehind = (float)Math.max(icon.width, icon.height) * Draw.scl * 1.6f;
        TextureRegion followcion = this.followType.fullIcon;
        float followsize = (float)Math.max(icon.width, icon.height) * Draw.scl * 1.6f;
        this.flyers((x, y) -> {
            Draw.rect(icon, x - 12.0f, y - 13.0f, this.flyerRot - 90.0f);
            Draw.rect(followcion, x - 12.0f - sizebehind / 2.0f, y - 13.0f - sizebehind / 3.0f, this.flyerRot - 90.0f);
            Draw.rect(followcion, x - 12.0f - sizebehind / 3.0f, y - 13.0f - sizebehind / 2.0f, this.flyerRot - 90.0f);
        });
        this.flyers((x, y) -> {
            Draw.rect("circle-shadow", x, y, size, size);
            Draw.rect("circle-shadow", x - sizebehind / 3.0f, y - sizebehind / 2.0f, followsize, followsize);
            Draw.rect("circle-shadow", x - sizebehind / 2.0f, y - sizebehind / 3.0f, followsize, followsize);
        });
        Draw.color();
        this.flyers((x, y) -> {
            float engineOffset = this.flyerType.engineOffset;
            float engineSize = this.flyerType.engineSize;
            float rotation = this.flyerRot;
            Draw.color(Pal.engine);
            Fill.circle(x + Angles.trnsx(rotation + 180.0f, engineOffset), y + Angles.trnsy(rotation + 180.0f, engineOffset), engineSize + Mathf.absin(Time.time, 2.0f, engineSize / 4.0f));
            Draw.color(Color.white);
            Fill.circle(x + Angles.trnsx(rotation + 180.0f, engineOffset - 1.0f), y + Angles.trnsy(rotation + 180.0f, engineOffset - 1.0f), (engineSize + Mathf.absin(Time.time, 2.0f, engineSize / 4.0f)) / 2.0f);
            Draw.color();
            Draw.rect(icon, x, y, this.flyerRot - 90.0f);
            Draw.rect(followcion, x - sizebehind / 3.0f, y - sizebehind / 2.0f, this.flyerRot - 90.0f);
            Draw.rect(followcion, x - sizebehind / 2.0f, y - sizebehind / 3.0f, this.flyerRot - 90.0f);
            if (Core.settings.getBool("menuFlyersRange")) {
                float curStroke = (float)Core.settings.getInt("playerEffectCurStroke") / 10.0f;
                Color effectcolor = ARCVars.getThemeColor();
                float sectorRad = 0.14f;
                float rotateSpeed = 0.5f;
                int sectors = 5;
                Lines.stroke(Lines.getStroke() * curStroke);
                Draw.z(131.5f);
                Draw.color(effectcolor);
                float rx = Tmp.v1.x;
                float ry = Tmp.v1.y;
                if (curStroke > 0.0f) {
                    for (int i = 0; i < sectors; ++i) {
                        float rot = (float)i * 360.0f / (float)sectors + Time.time * rotateSpeed;
                        Lines.arc(x, y, this.flyerType.maxRange, sectorRad, rot);
                    }
                }
                Draw.reset();
            }
        });
    }

    private void drawFlyers() {
        this.flyerType.sample.elevation = 1.0f;
        this.flyerType.sample.team = Team.sharded;
        this.flyerType.sample.rotation = this.flyerRot;
        this.flyerType.sample.heal();
        this.flyers((x, y) -> {
            this.flyerType.sample.set(x, y);
            this.flyerType.drawShadow(this.flyerType.sample);
            this.flyerType.draw(this.flyerType.sample);
            if (Core.settings.getBool("menuFlyersRange")) {
                float curStroke = (float)Core.settings.getInt("playerEffectCurStroke") / 10.0f;
                Color effectcolor = ARCVars.getThemeColor();
                float sectorRad = 0.14f;
                float rotateSpeed = 0.5f;
                int sectors = 5;
                Lines.stroke(Lines.getStroke() * curStroke);
                Draw.z(131.5f);
                Draw.color(effectcolor);
                float rx = Tmp.v1.x;
                float ry = Tmp.v1.y;
                if (curStroke > 0.0f) {
                    for (int i = 0; i < sectors; ++i) {
                        float rot = (float)i * 360.0f / (float)sectors + Time.time * rotateSpeed;
                        Lines.arc(x, y, this.flyerType.maxRange, sectorRad, rot);
                    }
                }
                Draw.reset();
            }
        });
    }

    private void flyers(Floatc2 cons) {
        float tw = (float)(this.width * 8) * 1.0f + 8.0f;
        float th = (float)(this.height * 8) * 1.0f + 8.0f;
        float range = 500.0f;
        float offset = -100.0f;
        int flyersCount = this.flyers + Core.settings.getInt("menuFlyersCount");
        for (int i = 0; i < flyersCount; ++i) {
            Tmp.v1.trns(this.flyerRot, this.time * this.flyerType.speed);
            cons.get((Mathf.randomSeedRange(i, range) + Tmp.v1.x + Mathf.absin(this.time + Mathf.randomSeedRange(i + 2, 500.0f), 10.0f, 3.4f) + offset) % (tw + (float)Mathf.randomSeed((long)(i + 5), 0, 500)), (Mathf.randomSeedRange(i + 1, range) + Tmp.v1.y + Mathf.absin(this.time + Mathf.randomSeedRange(i + 3, 500.0f), 10.0f, 3.4f) + offset) % th);
        }
    }

    @Override
    public void dispose() {
        this.batch.dispose();
        this.shadows.dispose();
    }
}

