/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.Events;
import arc.graphics.Blending;
import arc.graphics.Camera;
import arc.graphics.Gl;
import arc.graphics.Mesh;
import arc.graphics.Texture;
import arc.graphics.VertexAttribute;
import arc.graphics.g2d.Batch;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.IndexBufferObject;
import arc.graphics.gl.IndexData;
import arc.graphics.gl.Shader;
import arc.math.Mat;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.math.geom.Rect;
import arc.struct.IntSeq;
import arc.struct.IntSet;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Pack;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.graphics.CacheLayer;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;

public class FloorRenderer {
    private static final VertexAttribute[] attributes = new VertexAttribute[]{VertexAttribute.packedPosition, VertexAttribute.color, VertexAttribute.packedTexCoords};
    private static final int chunksize = 30;
    private static final int chunkunits = 240;
    private static final int vertexSize = 3;
    private static final int spriteSize = 12;
    private static final int maxSprites = 8100;
    private static final float packPad = 64.0f;
    private static final float pad = 4.0f;
    private static final boolean dynamic = false;
    private float[] vertices = new float[97200];
    private int vidx;
    private FloorRenderBatch batch = new FloorRenderBatch();
    private Shader shader;
    private Mat combinedMat = new Mat();
    private Texture texture;
    private TextureRegion error;
    private IndexData indexData;
    private ChunkMesh[][][] cache;
    private IntSet drawnLayerSet = new IntSet();
    private IntSet recacheSet = new IntSet();
    private IntSeq drawnLayers = new IntSeq();
    private ObjectSet<CacheLayer> used = new ObjectSet();
    private float packWidth;
    private float packHeight;
    private Seq<Runnable> underwaterDraw = new Seq(Runnable.class);
    private Blending underwaterBlend = new Blending(770, 771, 772, 771);

    public FloorRenderer() {
        short j = 0;
        short[] indices = new short[48600];
        int i = 0;
        while (i < indices.length) {
            indices[i] = j;
            indices[i + 1] = (short)(j + 1);
            indices[i + 2] = (short)(j + 2);
            indices[i + 3] = (short)(j + 2);
            indices[i + 4] = (short)(j + 3);
            indices[i + 5] = j;
            i += 6;
            j = (short)(j + 4);
        }
        this.indexData = new IndexBufferObject(true, indices.length){

            @Override
            public void dispose() {
            }
        };
        this.indexData.set(indices, 0, indices.length);
        this.shader = new Shader("attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\n\nuniform mat4 u_projectionViewMatrix;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main(){\n   v_color = a_color;\n   v_color.a = v_color.a * (255.0/254.0);\n   v_texCoords = a_texCoord0;\n   gl_Position =  u_projectionViewMatrix * a_position;\n}\n", "varying vec4 v_color;\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\n\nvoid main(){\n  gl_FragColor = v_color * texture2D(u_texture, v_texCoords);\n}\n");
        Events.on(EventType.WorldLoadEvent.class, event -> this.clearTiles());
    }

    public IndexData getIndexData() {
        return this.indexData;
    }

    public float[] getVertexBuffer() {
        return this.vertices;
    }

    public void recacheTile(Tile tile) {
        this.recacheTile(tile.x, tile.y);
    }

    public void recacheTile(int x, int y) {
        this.recacheSet.add(Point2.pack(x / 30, y / 30));
    }

    public void drawFloor() {
        if (this.cache == null) {
            return;
        }
        Camera camera = Core.camera;
        float pad = 4.0f;
        int minx = Math.max((int)((camera.position.x - camera.width / 2.0f - pad) / 240.0f), 0);
        int miny = Math.max((int)((camera.position.y - camera.height / 2.0f - pad) / 240.0f), 0);
        int maxx = Math.min(Mathf.ceil((camera.position.x + camera.width / 2.0f + pad) / 240.0f), this.cache.length);
        int maxy = Math.min(Mathf.ceil((camera.position.y + camera.height / 2.0f + pad) / 240.0f), this.cache[0].length);
        int layers = CacheLayer.all.length;
        this.drawnLayers.clear();
        this.drawnLayerSet.clear();
        Rect bounds = camera.bounds(Tmp.r3);
        for (int x = minx; x <= maxx; ++x) {
            for (int y = miny; y <= maxy; ++y) {
                if (!Structs.inBounds(x, y, this.cache)) continue;
                if (this.cache[x][y].length == 0) {
                    this.cacheChunk(x, y);
                }
                ChunkMesh[] chunk = this.cache[x][y];
                for (int i = 0; i < layers; ++i) {
                    if (chunk[i] == null || i == CacheLayer.walls.id || !chunk[i].bounds.overlaps(bounds)) continue;
                    this.drawnLayerSet.add(i);
                }
            }
        }
        IntSet.IntSetIterator it = this.drawnLayerSet.iterator();
        while (it.hasNext) {
            this.drawnLayers.add(it.next());
        }
        this.drawnLayers.sort();
        this.beginDraw();
        for (int i = 0; i < this.drawnLayers.size; ++i) {
            this.drawLayer(CacheLayer.all[this.drawnLayers.get(i)]);
        }
        this.underwaterDraw.clear();
    }

    public void checkChanges() {
        if (this.recacheSet.size > 0) {
            IntSet.IntSetIterator iterator = this.recacheSet.iterator();
            while (iterator.hasNext) {
                int chunk = iterator.next();
                this.cacheChunk(Point2.x(chunk), Point2.y(chunk));
            }
            this.recacheSet.clear();
        }
    }

    public void drawUnderwater(Runnable run) {
        this.underwaterDraw.add(run);
    }

    public void beginDraw() {
        if (this.cache == null) {
            return;
        }
        Draw.flush();
        this.shader.bind();
        this.shader.setUniformMatrix4("u_projectionViewMatrix", this.combinedMat.set(Core.camera.mat).translate(-64.0f, -64.0f).scale(this.packWidth, this.packHeight));
        this.texture.bind(0);
        Gl.enable(3042);
    }

    public void drawLayer(CacheLayer layer) {
        if (this.cache == null) {
            return;
        }
        Camera camera = Core.camera;
        int minx = Math.max((int)((camera.position.x - camera.width / 2.0f - 4.0f) / 240.0f), 0);
        int miny = Math.max((int)((camera.position.y - camera.height / 2.0f - 4.0f) / 240.0f), 0);
        int maxx = Math.min(Mathf.ceil((camera.position.x + camera.width / 2.0f + 4.0f) / 240.0f), this.cache.length);
        int maxy = Math.min(Mathf.ceil((camera.position.y + camera.height / 2.0f + 4.0f) / 240.0f), this.cache[0].length);
        layer.begin();
        Rect bounds = camera.bounds(Tmp.r3);
        for (int x = minx; x <= maxx; ++x) {
            for (int y = miny; y <= maxy; ++y) {
                ChunkMesh mesh;
                if (!Structs.inBounds(x, y, this.cache) || this.cache[x][y].length == 0 || (mesh = this.cache[x][y][layer.id]) == null || !mesh.bounds.overlaps(bounds)) continue;
                mesh.render(this.shader, 4, 0, mesh.getMaxVertices() * 6 / 4);
            }
        }
        if (layer.liquid && this.underwaterDraw.size > 0) {
            Draw.blend(this.underwaterBlend);
            Runnable[] items = (Runnable[])this.underwaterDraw.items;
            int len = this.underwaterDraw.size;
            for (int i = 0; i < len; ++i) {
                items[i].run();
            }
            Draw.flush();
            Draw.blend(Blending.normal);
            Blending.normal.apply();
            this.beginDraw();
        }
        layer.end();
    }

    private void cacheChunk(int cx, int cy) {
        this.used.clear();
        for (int tilex = Math.max(cx * 30 - 1, 0); tilex < (cx + 1) * 30 + 1 && tilex < Vars.world.width(); ++tilex) {
            for (int tiley = Math.max(cy * 30 - 1, 0); tiley < (cy + 1) * 30 + 1 && tiley < Vars.world.height(); ++tiley) {
                boolean wall;
                Tile tile = Vars.world.rawTile(tilex, tiley);
                boolean bl = wall = tile.block().cacheLayer != CacheLayer.normal;
                if (wall) {
                    this.used.add(tile.block().cacheLayer);
                }
                if (wall && !Vars.world.isAccessible(tilex, tiley)) continue;
                this.used.add(tile.floor().cacheLayer);
            }
        }
        if (this.cache[cx][cy].length == 0) {
            this.cache[cx][cy] = new ChunkMesh[CacheLayer.all.length];
        }
        ChunkMesh[] meshes = this.cache[cx][cy];
        for (CacheLayer layer : CacheLayer.all) {
            if (meshes[layer.id] != null) {
                meshes[layer.id].dispose();
            }
            meshes[layer.id] = null;
        }
        for (CacheLayer layer : this.used) {
            meshes[layer.id] = this.cacheChunkLayer(cx, cy, layer);
        }
    }

    private ChunkMesh cacheChunkLayer(int cx, int cy, CacheLayer layer) {
        this.vidx = 0;
        Batch current = Core.batch;
        Core.batch = this.batch;
        for (int tilex = cx * 30; tilex < (cx + 1) * 30; ++tilex) {
            for (int tiley = cy * 30; tiley < (cy + 1) * 30; ++tiley) {
                Tile tile = Vars.world.tile(tilex, tiley);
                if (tile == null) continue;
                Floor floor = tile.floor();
                if (!(tile.block().cacheLayer != layer || layer != CacheLayer.walls || tile.isDarkened() && tile.data >= 5)) {
                    tile.block().drawBase(tile);
                    continue;
                }
                if (floor.cacheLayer == layer && (Vars.world.isAccessible(tile.x, tile.y) || tile.block().cacheLayer != CacheLayer.walls || !tile.block().fillsTile)) {
                    floor.drawBase(tile);
                    continue;
                }
                if (floor.cacheLayer == layer || layer == CacheLayer.walls) continue;
                floor.drawNonLayer(tile, layer);
            }
        }
        Core.batch = current;
        int floats = this.vidx;
        ChunkMesh mesh = new ChunkMesh(true, floats / 3, 0, attributes, (float)(cx * 8 * 30) - 4.0f, (float)(cy * 8 * 30) - 4.0f, (float)((cx + 1) * 8 * 30) + 4.0f, (float)((cy + 1) * 8 * 30) + 4.0f);
        mesh.setVertices(this.vertices, 0, this.vidx);
        mesh.indices = this.indexData;
        return mesh;
    }

    public void clearTiles() {
        if (this.cache != null) {
            ChunkMesh[][][] chunkMeshArray = this.cache;
            int n = chunkMeshArray.length;
            for (int i = 0; i < n; ++i) {
                ChunkMesh[][] x;
                ChunkMesh[][] chunkMeshArray2 = x = chunkMeshArray[i];
                int n2 = chunkMeshArray2.length;
                for (int j = 0; j < n2; ++j) {
                    ChunkMesh[] y;
                    for (ChunkMesh mesh : y = chunkMeshArray2[j]) {
                        if (mesh == null) continue;
                        mesh.dispose();
                    }
                }
            }
        }
        this.recacheSet.clear();
        int chunksx = Mathf.ceil((float)Vars.world.width() / 30.0f);
        int chunksy = Mathf.ceil((float)Vars.world.height() / 30.0f);
        this.cache = new ChunkMesh[chunksx][chunksy][CacheLayer.all.length];
        this.texture = Core.atlas.find((String)"grass1").texture;
        this.error = Core.atlas.find("env-error");
        this.packWidth = (float)Vars.world.unitWidth() + 128.0f;
        this.packHeight = (float)Vars.world.unitHeight() + 128.0f;
        Time.mark();
        for (int x = 0; x < chunksx; ++x) {
            for (int y = 0; y < chunksy; ++y) {
                this.cacheChunk(x, y);
            }
        }
        Log.debug("Generated world mesh: @ms", Float.valueOf(Time.elapsed()));
    }

    class FloorRenderBatch
    extends Batch {
        FloorRenderBatch() {
        }

        @Override
        protected void draw(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float rotation) {
            if (region.texture != FloorRenderer.this.texture && region != FloorRenderer.this.error) {
                this.draw(FloorRenderer.this.error, x, y, originX, originY, width, height, rotation);
                return;
            }
            float[] verts = FloorRenderer.this.vertices;
            int idx = FloorRenderer.this.vidx;
            FloorRenderer.this.vidx += 12;
            if (!Mathf.zero(rotation)) {
                float worldOriginX = x + originX;
                float worldOriginY = y + originY;
                float fx = -originX;
                float fy = -originY;
                float fx2 = width - originX;
                float fy2 = height - originY;
                float cos = Mathf.cosDeg(rotation);
                float sin = Mathf.sinDeg(rotation);
                float x1 = cos * fx - sin * fy + worldOriginX;
                float y1 = sin * fx + cos * fy + worldOriginY;
                float x2 = cos * fx - sin * fy2 + worldOriginX;
                float y2 = sin * fx + cos * fy2 + worldOriginY;
                float x3 = cos * fx2 - sin * fy2 + worldOriginX;
                float y3 = sin * fx2 + cos * fy2 + worldOriginY;
                float x4 = x1 + (x3 - x2);
                float y4 = y3 - (y2 - y1);
                float u = region.u;
                float v = region.v2;
                float u2 = region.u2;
                float v2 = region.v;
                float color = this.colorPacked;
                verts[idx] = this.pack(x1, y1);
                verts[idx + 1] = color;
                verts[idx + 2] = Pack.packUv(u, v);
                verts[idx + 3] = this.pack(x2, y2);
                verts[idx + 4] = color;
                verts[idx + 5] = Pack.packUv(u, v2);
                verts[idx + 6] = this.pack(x3, y3);
                verts[idx + 7] = color;
                verts[idx + 8] = Pack.packUv(u2, v2);
                verts[idx + 9] = this.pack(x4, y4);
                verts[idx + 10] = color;
                verts[idx + 11] = Pack.packUv(u2, v);
            } else {
                float fx2 = x + width;
                float fy2 = y + height;
                float u = region.u;
                float v = region.v2;
                float u2 = region.u2;
                float v2 = region.v;
                float color = this.colorPacked;
                verts[idx] = this.pack(x, y);
                verts[idx + 1] = color;
                verts[idx + 2] = Pack.packUv(u, v);
                verts[idx + 3] = this.pack(x, fy2);
                verts[idx + 4] = color;
                verts[idx + 5] = Pack.packUv(u, v2);
                verts[idx + 6] = this.pack(fx2, fy2);
                verts[idx + 7] = color;
                verts[idx + 8] = Pack.packUv(u2, v2);
                verts[idx + 9] = this.pack(fx2, y);
                verts[idx + 10] = color;
                verts[idx + 11] = Pack.packUv(u2, v);
            }
        }

        float pack(float x, float y) {
            return Pack.packUv((x + 64.0f) / FloorRenderer.this.packWidth, (y + 64.0f) / FloorRenderer.this.packHeight);
        }

        @Override
        public void flush() {
        }

        @Override
        public void setShader(Shader shader, boolean apply) {
            throw new IllegalArgumentException("cache shader unsupported");
        }

        @Override
        protected void draw(Texture texture, float[] spriteVertices, int offset, int count) {
            if (spriteVertices.length != 20) {
                throw new IllegalArgumentException("cached vertices must be in non-mixcolor format (20 per sprite, 5 per vertex)");
            }
            float[] verts = FloorRenderer.this.vertices;
            float[] src = spriteVertices;
            int idx = FloorRenderer.this.vidx;
            int sidx = offset;
            for (int i = 0; i < 4; ++i) {
                verts[idx++] = this.pack(src[sidx++], src[sidx++]);
                verts[idx++] = src[sidx++];
                verts[idx++] = Pack.packUv(src[sidx++], src[sidx++]);
            }
            FloorRenderer.this.vidx += 12;
        }
    }

    static class ChunkMesh
    extends Mesh {
        Rect bounds = new Rect();

        ChunkMesh(boolean isStatic, int maxVertices, int maxIndices, VertexAttribute[] attributes, float minX, float minY, float maxX, float maxY) {
            super(isStatic, maxVertices, maxIndices, attributes);
            this.bounds.set(minX, minY, maxX - minX, maxY - minY);
        }
    }
}

